/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.service;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.util.JsonFormat;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.AIDatabase;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.CollectionView;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.DocumentSet;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collection.Embedding;
import com.tencent.tcvectordb.model.param.collection.FieldElementType;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import com.tencent.tcvectordb.model.param.collection.FilterIndexConfig;
import com.tencent.tcvectordb.model.param.collection.HNSWParams;
import com.tencent.tcvectordb.model.param.collection.IVFFLATParams;
import com.tencent.tcvectordb.model.param.collection.IVFPQParams;
import com.tencent.tcvectordb.model.param.collection.IVFSQ8Params;
import com.tencent.tcvectordb.model.param.collection.IndexField;
import com.tencent.tcvectordb.model.param.collection.IndexType;
import com.tencent.tcvectordb.model.param.collection.MetricType;
import com.tencent.tcvectordb.model.param.collection.TTLConfig;
import com.tencent.tcvectordb.model.param.collection.UploadFileParam;
import com.tencent.tcvectordb.model.param.collectionView.CreateCollectionViewParam;
import com.tencent.tcvectordb.model.param.collectionView.LoadAndSplitTextParam;
import com.tencent.tcvectordb.model.param.database.ConnectParam;
import com.tencent.tcvectordb.model.param.dml.DeleteParam;
import com.tencent.tcvectordb.model.param.dml.GeneralParams;
import com.tencent.tcvectordb.model.param.dml.HNSWSearchParams;
import com.tencent.tcvectordb.model.param.dml.HybridSearchParam;
import com.tencent.tcvectordb.model.param.dml.Params;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.RRFRerankParam;
import com.tencent.tcvectordb.model.param.dml.SearchByEmbeddingItemsParam;
import com.tencent.tcvectordb.model.param.dml.SearchByIdParam;
import com.tencent.tcvectordb.model.param.dml.SearchByVectorParam;
import com.tencent.tcvectordb.model.param.dml.SearchParam;
import com.tencent.tcvectordb.model.param.dml.UpdateParam;
import com.tencent.tcvectordb.model.param.dml.WeightRerankParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.model.param.entity.DataBaseType;
import com.tencent.tcvectordb.model.param.entity.DataBaseTypeRes;
import com.tencent.tcvectordb.model.param.entity.GetChunksRes;
import com.tencent.tcvectordb.model.param.entity.GetDocumentSetRes;
import com.tencent.tcvectordb.model.param.entity.GetImageUrlRes;
import com.tencent.tcvectordb.model.param.entity.HybridSearchRes;
import com.tencent.tcvectordb.model.param.entity.SearchContentRes;
import com.tencent.tcvectordb.model.param.entity.SearchRes;
import com.tencent.tcvectordb.model.param.enums.DataBaseTypeEnum;
import com.tencent.tcvectordb.model.param.enums.EmbeddingModelEnum;
import com.tencent.tcvectordb.model.param.user.PrivilegeParam;
import com.tencent.tcvectordb.model.param.user.UserChangePasswordParam;
import com.tencent.tcvectordb.model.param.user.UserCreateParam;
import com.tencent.tcvectordb.model.param.user.UserDescribeParam;
import com.tencent.tcvectordb.model.param.user.UserDescribeRes;
import com.tencent.tcvectordb.model.param.user.UserDropParam;
import com.tencent.tcvectordb.model.param.user.UserGrantParam;
import com.tencent.tcvectordb.model.param.user.UserInfo;
import com.tencent.tcvectordb.model.param.user.UserListRes;
import com.tencent.tcvectordb.model.param.user.UserRevokeParam;
import com.tencent.tcvectordb.rpc.Interceptor.BackendServiceInterceptor;
import com.tencent.tcvectordb.rpc.pool.ChannelPool;
import com.tencent.tcvectordb.rpc.proto.Olama;
import com.tencent.tcvectordb.rpc.proto.SearchEngineGrpc;
import com.tencent.tcvectordb.service.HttpStub;
import com.tencent.tcvectordb.service.param.AddIndexParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewDeleteParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewQueryParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewUpdateParamInner;
import com.tencent.tcvectordb.service.param.DeleteParamInner;
import com.tencent.tcvectordb.service.param.DropIndexParamInner;
import com.tencent.tcvectordb.service.param.GetImageUrlParamInner;
import com.tencent.tcvectordb.service.param.HybridSearchParamInner;
import com.tencent.tcvectordb.service.param.InsertParamInner;
import com.tencent.tcvectordb.service.param.ModifyIndexParamInner;
import com.tencent.tcvectordb.service.param.QueryCountParamInner;
import com.tencent.tcvectordb.service.param.QueryParamInner;
import com.tencent.tcvectordb.service.param.RebuildIndexParamInner;
import com.tencent.tcvectordb.service.param.SearchDocParamInner;
import com.tencent.tcvectordb.service.param.SearchParamInner;
import com.tencent.tcvectordb.service.param.UpdateParamInner;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcStub
extends HttpStub {
    private final int maxReceiveMessageSize = 0x6400000;
    private String authorization;
    private int timeout = 10;
    private static final Logger logger = LoggerFactory.getLogger((String)GrpcStub.class.getName());
    private ConnectParam connectParam;
    private final ChannelPool channelPool;

    public GrpcStub(ConnectParam param) {
        this.connectParam = param;
        this.authorization = String.format("Bearer account=%s&api_key=%s", param.getUsername(), param.getKey());
        if (param.getTimeout() > 0) {
            this.timeout = param.getTimeout();
        }
        this.channelPool = new ChannelPool(param, 0x6400000, this.authorization);
    }

    @Override
    public synchronized void close() {
        super.close();
        if (this.channelPool != null) {
            this.channelPool.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDatabase(Database database) {
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            Olama.DatabaseRequest.Builder databaseRequest = Olama.DatabaseRequest.newBuilder();
            if (database.getDatabaseName() != null) {
                databaseRequest.setDatabase(database.getDatabaseName());
            }
            GrpcStub.logQuery("database/create", databaseRequest);
            Olama.DatabaseResponse response = ((SearchEngineGrpc.SearchEngineBlockingStub)((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withInterceptors(new ClientInterceptor[]{new BackendServiceInterceptor(false)})).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).createDatabase(databaseRequest.build());
            GrpcStub.logResponse("database/create", response);
            if (response.getCode() != 0) {
                throw new VectorDBException(String.format("VectorDBServer create Database error: not Successful, body code=%s, message=%s", response.getCode(), response.getMsg()));
            }
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDatabase(Database database) {
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            Olama.DatabaseRequest.Builder databaseRequest = Olama.DatabaseRequest.newBuilder();
            if (database.getDatabaseName() != null) {
                databaseRequest.setDatabase(database.getDatabaseName());
            }
            GrpcStub.logQuery("database/drop", databaseRequest.build());
            Olama.DatabaseResponse response = ((SearchEngineGrpc.SearchEngineBlockingStub)((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withInterceptors(new ClientInterceptor[]{new BackendServiceInterceptor(false)})).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).dropDatabase(databaseRequest.build());
            GrpcStub.logResponse("database/drop", response);
            if (response.getCode() != 0) {
                throw new VectorDBException(String.format("VectorDBServer drop Database error: not Successful, body code=%s, message=%s", response.getCode(), response.getMsg()));
            }
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
    }

    @Override
    public AffectRes createAIDatabase(AIDatabase aiDatabase) {
        super.initHttpStub(this.connectParam);
        return super.createAIDatabase(aiDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataBaseTypeRes describeDatabase(Database database) {
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            Olama.DescribeDatabaseRequest.Builder databaseRequest = Olama.DescribeDatabaseRequest.newBuilder();
            if (database.getDatabaseName() != null) {
                databaseRequest.setDatabase(database.getDatabaseName());
            }
            GrpcStub.logQuery("database/describe", databaseRequest.build());
            Olama.DescribeDatabaseResponse response = ((SearchEngineGrpc.SearchEngineBlockingStub)((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withInterceptors(new ClientInterceptor[]{new BackendServiceInterceptor(false)})).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).describeDatabase(databaseRequest.build());
            GrpcStub.logResponse("database/describe", response);
            if (response.getCode() != 0) {
                throw new VectorDBException(String.format("VectorDBServer describeDatabase error: not Successful, body code=%s, message=%s", response.getCode(), response.getMsg()));
            }
            Date date = new Date(response.getDatabase().getCreateTime());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DataBaseType dataBaseType = new DataBaseType();
            dataBaseType.setCreateTime(sdf.format(date));
            dataBaseType.setDbType(response.getDatabase().getDbType().toString());
            DataBaseTypeRes dataBaseTypeRes = new DataBaseTypeRes(response.getCode(), response.getMsg(), "", dataBaseType);
            return dataBaseTypeRes;
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
    }

    @Override
    public AffectRes dropAIDatabase(AIDatabase aiDatabase) {
        super.initHttpStub(this.connectParam);
        return super.dropAIDatabase(aiDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listDatabases() {
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            Olama.DatabaseRequest request = Olama.DatabaseRequest.newBuilder().build();
            GrpcStub.logQuery("database/list", request);
            Olama.DatabaseResponse response = ((SearchEngineGrpc.SearchEngineBlockingStub)((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withInterceptors(new ClientInterceptor[]{new BackendServiceInterceptor(false)})).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).listDatabases(request);
            GrpcStub.logResponse("database/list", response);
            if (response.getCode() != 0) {
                throw new VectorDBException(String.format("VectorDBServer list Database error: not Successful, body code=%s, message=%s", response.getCode(), response.getMsg()));
            }
            ProtocolStringList protocolStringList = response.getDatabasesList();
            return protocolStringList;
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DataBaseType> listDatabaseInfos() {
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            Olama.DatabaseRequest request = Olama.DatabaseRequest.newBuilder().build();
            GrpcStub.logQuery("database/list", request);
            Olama.DatabaseResponse response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).listDatabases(request);
            GrpcStub.logResponse("database/list", response);
            if (response.getCode() != 0) {
                throw new VectorDBException(String.format("VectorDBServer list Database error: not Successful, body code=%s, message=%s", response.getCode(), response.getMsg()));
            }
            HashMap<String, DataBaseType> dataBaseTypeMap = new HashMap<String, DataBaseType>();
            response.getInfoMap().entrySet().forEach(entry -> {
                DataBaseType dataBaseType = new DataBaseType();
                dataBaseType.setDbType((String)entry.getKey());
                Date date = new Date(((Olama.DatabaseItem)entry.getValue()).getCreateTime());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dataBaseType.setCreateTime(sdf.format(date));
                dataBaseTypeMap.put((String)entry.getKey(), dataBaseType);
            });
            HashMap<String, DataBaseType> hashMap = dataBaseTypeMap;
            return hashMap;
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCollection(CreateCollectionParam params) {
        Olama.CreateCollectionResponse response;
        Olama.CreateCollectionRequest.Builder requestOrBuilder = Olama.CreateCollectionRequest.newBuilder();
        if (params.getDatabase() != null) {
            requestOrBuilder.setDatabase(params.getDatabase());
        }
        if (params.getCollection() != null) {
            requestOrBuilder.setCollection(params.getCollection());
        }
        requestOrBuilder.setShardNum(params.getShardNum()).setReplicaNum(params.getReplicaNum()).setDescription(params.getDescription());
        if (params.getAlias() != null) {
            requestOrBuilder.addAllAliasList(params.getAlias());
        }
        if (params.getEmbedding() != null) {
            Olama.EmbeddingParams.Builder embeddingBuilder = Olama.EmbeddingParams.newBuilder().setField(params.getEmbedding().getField()).setVectorField(params.getEmbedding().getVectorField());
            if (params.getEmbedding().getModel() != null) {
                embeddingBuilder.setModelName(params.getEmbedding().getModel().getModelName());
            } else {
                embeddingBuilder.setModelName(params.getEmbedding().getModelName());
            }
            requestOrBuilder.setEmbeddingParams(embeddingBuilder.build());
        }
        if (params.getTtlConfig() != null) {
            requestOrBuilder.setTtlConfig(Olama.TTLConfig.newBuilder().setEnable(params.getTtlConfig().isEnable()).setTimeField(params.getTtlConfig().getTimeField()).build());
        }
        if (params.getFilterIndexConfig() != null) {
            Olama.FilterIndexConfig.Builder filterBuilder = Olama.FilterIndexConfig.newBuilder().setFilterAll(params.getFilterIndexConfig().isFilterAll());
            if (params.getFilterIndexConfig().getFieldsWithoutIndex() != null) {
                filterBuilder.addAllFieldsWithoutIndex(params.getFilterIndexConfig().getFieldsWithoutIndex());
            }
            if (params.getFilterIndexConfig().getMaxStrLen() != null) {
                filterBuilder.setMaxStrLen(params.getFilterIndexConfig().getMaxStrLen());
            }
            requestOrBuilder.setFilterIndexConfig(filterBuilder.build());
        }
        if (params.getIndexes() != null && !params.getIndexes().isEmpty()) {
            for (IndexField index : params.getIndexes()) {
                Olama.IndexColumn.Builder indexBuilder = GrpcStub.getRpcIndexBuilder(index);
                requestOrBuilder.putIndexes(index.getFieldName(), indexBuilder.build());
            }
        }
        GrpcStub.logQuery("collection/create", requestOrBuilder);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).createCollection(requestOrBuilder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("collection/create", response);
        if (response == null) {
            throw new VectorDBException("VectorDBServer error: CreateCollectionResponse not response");
        }
        if (response.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: not Successful, body code=%s, message=%s", response.getCode(), response.getMsg()));
        }
    }

    private static Olama.IndexColumn.Builder getRpcIndexBuilder(IndexField index) {
        Olama.IndexColumn.Builder indexBuilder = Olama.IndexColumn.newBuilder().setFieldName(index.getFieldName()).setFieldType(index.getFieldType().getValue());
        if (index.getIndexType() != null) {
            indexBuilder.setIndexType(index.getIndexType().getValue());
        }
        if (index.isVectorField()) {
            if (index.getDimension() != null) {
                indexBuilder.setDimension(index.getDimension());
            }
            if (index.getMetricType() != null) {
                indexBuilder.setMetricType(index.getMetricType().getValue());
            }
            if (index.getParams() != null) {
                if (index.getParams() instanceof HNSWParams) {
                    HNSWParams hnswParams = (HNSWParams)index.getParams();
                    indexBuilder.setParams(Olama.IndexParams.newBuilder().setM(hnswParams.getM()).setEfConstruction(hnswParams.getEfConstruction()).build());
                } else if (index.getParams() instanceof IVFFLATParams) {
                    IVFFLATParams ivfflatParams = (IVFFLATParams)index.getParams();
                    indexBuilder.setParams(Olama.IndexParams.newBuilder().setNlist(ivfflatParams.getNList()).build());
                } else if (index.getParams() instanceof IVFPQParams) {
                    IVFPQParams ivfpqParams = (IVFPQParams)index.getParams();
                    indexBuilder.setParams(Olama.IndexParams.newBuilder().setNlist(ivfpqParams.getNList()).setM(ivfpqParams.getM()).build());
                } else if (index.getParams() instanceof IVFSQ8Params) {
                    IVFSQ8Params ivfsq8Params = (IVFSQ8Params)index.getParams();
                    indexBuilder.setParams(Olama.IndexParams.newBuilder().setNlist(ivfsq8Params.getNList()).build());
                }
            }
        }
        if (index.isSparseVectorField()) {
            indexBuilder.setMetricType(index.getMetricType().getValue());
        }
        if (index.getFieldType() == FieldType.Array) {
            indexBuilder.setFieldElementType(FieldElementType.String.getValue());
        }
        if (index.getAutoId() != null) {
            indexBuilder.setAutoId(index.getAutoId());
        }
        return indexBuilder;
    }

    @Override
    public void createCollectionView(CreateCollectionViewParam params) {
        super.initHttpStub(this.connectParam);
        super.createCollectionView(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Collection> listCollections(String databaseName) {
        Olama.ListCollectionsResponse response;
        Olama.ListCollectionsRequest.Builder requestBuilder = Olama.ListCollectionsRequest.newBuilder().setTransfer(false);
        if (databaseName != null) {
            requestBuilder.setDatabase(databaseName);
        }
        GrpcStub.logQuery("collection/list", requestBuilder.build());
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).listCollections(requestBuilder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("collection/list", response);
        ArrayList<Collection> collections = new ArrayList<Collection>();
        response.getCollectionsList().forEach(collection -> {
            Collection collectionRpc = GrpcStub.convertRpcToCollection(collection);
            collectionRpc.setStub(this);
            collections.add(collectionRpc);
        });
        return collections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection describeCollection(String databaseName, String collectionName) {
        Olama.DescribeCollectionResponse describeCollectionResponse;
        Olama.DescribeCollectionRequest.Builder requestBuilder = Olama.DescribeCollectionRequest.newBuilder();
        if (databaseName != null) {
            requestBuilder.setDatabase(databaseName);
        }
        if (collectionName != null) {
            requestBuilder.setCollection(collectionName);
        }
        GrpcStub.logQuery("collection/describe", requestBuilder.build());
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            describeCollectionResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).describeCollection(requestBuilder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("collection/describe", describeCollectionResponse);
        if (describeCollectionResponse == null) {
            throw new VectorDBException("VectorDBServer error: describeCollection not response");
        }
        if (describeCollectionResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: not Successful, body code=%s, message=%s", describeCollectionResponse.getCode(), describeCollectionResponse.getMsg()));
        }
        return GrpcStub.convertRpcToCollection(describeCollectionResponse.getCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffectRes truncateCollection(String databaseName, String collectionName, DataBaseTypeEnum dbType) {
        Olama.TruncateCollectionResponse truncateCollectionResponse;
        Olama.TruncateCollectionRequest.Builder requestBuilder = Olama.TruncateCollectionRequest.newBuilder();
        if (databaseName != null) {
            requestBuilder.setDatabase(databaseName);
        }
        if (collectionName != null) {
            requestBuilder.setCollection(collectionName);
        }
        GrpcStub.logQuery("collection/truncate", requestBuilder.build());
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            truncateCollectionResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).truncateCollection(requestBuilder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("collection/truncate", truncateCollectionResponse);
        if (truncateCollectionResponse == null) {
            throw new VectorDBException("VectorDBServer error: truncateCollectionResponse not response");
        }
        if (truncateCollectionResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: not Successful, body code=%s, message=%s", truncateCollectionResponse.getCode(), truncateCollectionResponse.getMsg()));
        }
        return new AffectRes(truncateCollectionResponse.getCode(), truncateCollectionResponse.getMsg(), "", truncateCollectionResponse.getAffectedCount());
    }

    @Override
    public AffectRes truncateCollectionView(String databaseName, String collectionName, DataBaseTypeEnum dbType) {
        super.initHttpStub(this.connectParam);
        return super.truncateCollectionView(databaseName, collectionName, dbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropCollection(String databaseName, String collectionName) {
        Olama.DropCollectionResponse dropCollectionResponse;
        Olama.DropCollectionRequest.Builder requestBuilder = Olama.DropCollectionRequest.newBuilder();
        if (databaseName != null) {
            requestBuilder.setDatabase(databaseName);
        }
        if (collectionName != null) {
            requestBuilder.setCollection(collectionName);
        }
        GrpcStub.logQuery("collection/drop", requestBuilder.build());
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            dropCollectionResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).dropCollection(requestBuilder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("collection/drop", dropCollectionResponse);
        if (dropCollectionResponse == null) {
            throw new VectorDBException("VectorDBServer error: dropCollection not response");
        }
        if (dropCollectionResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: dropCollection not Success, body code=%s, message=%s", dropCollectionResponse.getCode(), dropCollectionResponse.getMsg()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffectRes setAlias(String databaseName, String collectionName, String aliasName) {
        Olama.UpdateAliasResponse setAliasResponse;
        Olama.AddAliasRequest.Builder requestBuilder = Olama.AddAliasRequest.newBuilder();
        if (databaseName != null) {
            requestBuilder.setDatabase(databaseName);
        }
        if (collectionName != null) {
            requestBuilder.setCollection(collectionName);
        }
        if (aliasName != null) {
            requestBuilder.setAlias(aliasName);
        }
        GrpcStub.logQuery("ai/alias/set", requestBuilder.build());
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            setAliasResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).setAlias(requestBuilder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("ai/alias/set", setAliasResponse);
        if (setAliasResponse == null) {
            throw new VectorDBException("VectorDBServer error: dropCollection not response");
        }
        if (setAliasResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: setAlias not Success, body code=%s, message=%s", setAliasResponse.getCode(), setAliasResponse.getMsg()));
        }
        return new AffectRes(setAliasResponse.getCode(), setAliasResponse.getMsg(), "", setAliasResponse.getAffectedCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffectRes deleteAlias(String databaseName, String aliasName) {
        Olama.UpdateAliasResponse deleteAliasResponse;
        Olama.RemoveAliasRequest.Builder requestBuilder = Olama.RemoveAliasRequest.newBuilder();
        if (databaseName != null) {
            requestBuilder.setDatabase(databaseName);
        }
        if (aliasName != null) {
            requestBuilder.setAlias(aliasName);
        }
        Olama.RemoveAliasRequest request = requestBuilder.build();
        GrpcStub.logQuery("ai/alias/delete", request);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            deleteAliasResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).deleteAlias(request);
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logQuery("ai/alias/delete", request);
        if (deleteAliasResponse == null) {
            throw new VectorDBException("VectorDBServer error: dropCollection not response");
        }
        if (deleteAliasResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: deleteAlias not Success, body code=%s, message=%s", deleteAliasResponse.getCode(), deleteAliasResponse.getMsg()));
        }
        return new AffectRes(deleteAliasResponse.getCode(), deleteAliasResponse.getMsg(), "", deleteAliasResponse.getAffectedCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffectRes upsertDocument(InsertParamInner param, boolean ai) {
        Olama.UpsertResponse response;
        Olama.UpsertRequest.Builder builder = Olama.UpsertRequest.newBuilder();
        if (param.getDatabase() != null) {
            builder.setDatabase(param.getDatabase());
        }
        if (param.getCollection() != null) {
            builder.setCollection(param.getCollection());
        }
        if (param.getBuildIndex() == null) {
            builder.setBuildIndex(true);
        } else {
            builder.setBuildIndex(param.getBuildIndex());
        }
        if (param.getDocuments() != null && !param.getDocuments().isEmpty()) {
            for (Object document : param.getDocuments()) {
                Olama.Document doc;
                if (document instanceof Document) {
                    doc = GrpcStub.convertDocument2OlamaDoc((Document)document);
                    builder.addDocuments(doc);
                    continue;
                }
                if (document instanceof JSONObject) {
                    doc = this.convertDocumentJSON2OlamaDoc((JSONObject)document);
                    builder.addDocuments(doc);
                    continue;
                }
                throw new VectorDBException("upsert failed, because of incorrect documents type, which must be []Document or []JSONObject");
            }
        }
        GrpcStub.logQuery("document/upsert", builder);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).withInterceptors(new ClientInterceptor[]{new BackendServiceInterceptor(ai)})).upsert(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("document/upsert", response);
        if (response.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer upsert data error: not Successful, code=%s, message=%s", response.getCode(), response.getMsg()));
        }
        return new AffectRes(response.getCode(), response.getMsg(), response.getWarning(), response.getAffectedCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Document> queryDocument(QueryParamInner param, boolean ai) {
        Olama.QueryResponse queryResponse;
        QueryParam queryParam;
        Olama.QueryRequest.Builder queryBuilder = Olama.QueryRequest.newBuilder().setReadConsistency(param.getReadConsistency().getReadConsistency());
        if (param.getDatabase() != null) {
            queryBuilder.setDatabase(param.getDatabase());
        }
        if (param.getCollection() != null) {
            queryBuilder.setCollection(param.getCollection());
        }
        if ((queryParam = param.getQuery()) == null) {
            throw new VectorDBException("VectorDBServer error: query param is null");
        }
        Olama.QueryCond.Builder queryCondBuilder = Olama.QueryCond.newBuilder().setRetrieveVector(queryParam.isRetrieveVector()).setLimit(queryParam.getLimit()).setOffset(queryParam.getOffset());
        if (queryParam.getDocumentIds() != null) {
            queryCondBuilder.addAllDocumentIds(queryParam.getDocumentIds());
        }
        if (queryParam.getOutputFields() != null) {
            queryCondBuilder.addAllOutputFields(queryParam.getOutputFields());
        }
        if (queryParam.getFilter() != null) {
            queryCondBuilder.setFilter(queryParam.getFilter());
        }
        if (queryParam.getSort() != null && queryParam.getSort().size() > 0) {
            queryCondBuilder.addAllSort(queryParam.getSort().stream().map(sort -> Olama.OrderRule.newBuilder().setFieldName(sort.getFieldName()).setDesc(sort.getDirection().equals("desc")).build()).collect(Collectors.toList()));
        }
        queryBuilder.setQuery(queryCondBuilder.build());
        GrpcStub.logQuery("document/query", queryBuilder);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            queryResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).withInterceptors(new ClientInterceptor[]{new BackendServiceInterceptor(ai)})).query(queryBuilder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("document/query", queryResponse);
        if (queryResponse == null) {
            throw new VectorDBException("VectorDBServer error: query not response");
        }
        if (queryResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: query not Success, body code=%s, message=%s", queryResponse.getCode(), queryResponse.getMsg()));
        }
        List<Olama.Document> documentsList = queryResponse.getDocumentsList();
        return documentsList.stream().map(document -> GrpcStub.convertDocument(document)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchRes searchDocument(SearchParamInner param, DataBaseTypeEnum dbType) {
        Olama.SearchResponse searchResponse;
        if (dbType.equals((Object)DataBaseTypeEnum.AI_DB)) {
            super.initHttpStub(this.connectParam);
            return super.searchDocument(param, dbType);
        }
        Olama.SearchRequest.Builder builder = Olama.SearchRequest.newBuilder().setReadConsistency(param.getReadConsistency().getReadConsistency());
        if (param.getDatabase() != null) {
            builder.setDatabase(param.getDatabase());
        }
        if (param.getCollection() != null) {
            builder.setCollection(param.getCollection());
        }
        SearchParam searchParam = param.getSearch();
        Olama.SearchCond.Builder searchConBuilder = Olama.SearchCond.newBuilder().setRetrieveVector(searchParam.isRetrieveVector()).setLimit(searchParam.getLimit());
        if (searchParam.getOutputFields() != null) {
            searchConBuilder.addAllOutputfields(searchParam.getOutputFields());
        }
        if (searchParam.getFilter() != null) {
            searchConBuilder.setFilter(searchParam.getFilter());
        }
        if (searchParam instanceof SearchByVectorParam) {
            ((SearchByVectorParam)searchParam).getVectors().forEach(vector -> {
                Olama.VectorArray.Builder vectorArrayBuilder = Olama.VectorArray.newBuilder();
                vector.forEach(ele -> vectorArrayBuilder.addVector(Float.valueOf(ele.toString()).floatValue()));
                searchConBuilder.addVectors(vectorArrayBuilder.build());
            });
        }
        if (searchParam instanceof SearchByIdParam) {
            searchConBuilder.addAllDocumentIds(((SearchByIdParam)searchParam).getDocumentIds());
        }
        if (searchParam instanceof SearchByEmbeddingItemsParam) {
            searchConBuilder.addAllEmbeddingItems(((SearchByEmbeddingItemsParam)searchParam).getEmbeddingItems());
        }
        if (searchParam.getParams() != null) {
            Params params;
            if (searchParam.getParams() instanceof GeneralParams) {
                params = (GeneralParams)searchParam.getParams();
                searchConBuilder.setParams(Olama.SearchParams.newBuilder().setEf(((GeneralParams)params).getEf()).setNprobe(((GeneralParams)params).getNProbe()).setRadius((float)((GeneralParams)params).getRadius()).build());
            } else if (searchParam.getParams() instanceof HNSWSearchParams) {
                params = (HNSWSearchParams)searchParam.getParams();
                searchConBuilder.setParams(Olama.SearchParams.newBuilder().setEf(((HNSWSearchParams)params).getEf()).build());
            }
        }
        if (searchParam.getRadius() != null) {
            searchConBuilder.setRange(true);
            searchConBuilder.getParamsBuilder().setRadius(searchParam.getRadius().floatValue());
        }
        builder.setSearch(searchConBuilder.build());
        GrpcStub.logQuery("document/search", builder);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            searchResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).search(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("document/search", searchResponse);
        if (searchResponse == null) {
            throw new VectorDBException("VectorDBServer error: search not response");
        }
        if (searchResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: search not Success, body code=%s, message=%s", searchResponse.getCode(), searchResponse.getMsg()));
        }
        ArrayList<List<Document>> documentsList = new ArrayList<List<Document>>();
        for (Olama.SearchResult searchResult : searchResponse.getResultsList()) {
            documentsList.add(searchResult.getDocumentsList().stream().map(GrpcStub::convertDocument).collect(Collectors.toList()));
        }
        return new SearchRes(searchResponse.getCode(), searchResponse.getMsg(), searchResponse.getWarning(), documentsList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HybridSearchRes hybridSearchDocument(HybridSearchParamInner param, boolean ai) {
        Olama.SearchResponse searchResponse;
        Olama.SearchRequest.Builder builder = Olama.SearchRequest.newBuilder().setReadConsistency(param.getReadConsistency().getReadConsistency());
        if (param.getDatabase() != null) {
            builder.setDatabase(param.getDatabase());
        }
        if (param.getCollection() != null) {
            builder.setCollection(param.getCollection());
        }
        HybridSearchParam searchParam = param.getSearch();
        Olama.SearchCond.Builder searchConBuilder = Olama.SearchCond.newBuilder().setRetrieveVector(searchParam.isRetrieveVector()).setLimit(searchParam.getLimit());
        if (searchParam.getOutputFields() != null) {
            searchConBuilder.addAllOutputfields(searchParam.getOutputFields());
        }
        if (searchParam.getFilter() != null) {
            searchConBuilder.setFilter(searchParam.getFilter());
        }
        if (searchParam.getAnn() != null && !searchParam.getAnn().isEmpty()) {
            searchConBuilder.addAllAnn(searchParam.getAnn().stream().map(annOption -> {
                Olama.AnnData.Builder annBuilder = Olama.AnnData.newBuilder().setFieldName(annOption.getFieldName());
                if (annOption.getDocumentIds() != null) {
                    annBuilder.addAllDocumentIds(annOption.getDocumentIds());
                }
                if (annOption.getData() != null) {
                    if (annOption.getData().get(0) instanceof String) {
                        annBuilder.addAllEmbeddingItems(annOption.getData().stream().map(item -> (String)item).collect(Collectors.toList()));
                    }
                    if (annOption.getData().get(0) instanceof List) {
                        annBuilder.addAllData(annOption.getData().stream().map(item -> Olama.VectorArray.newBuilder().addAllVector(((List)item).stream().map(ele -> Float.valueOf(Float.parseFloat(ele.toString()))).collect(Collectors.toList())).build()).collect(Collectors.toList()));
                    }
                }
                if (annOption.getLimit() != null) {
                    annBuilder.setLimit(annOption.getLimit());
                }
                if (annOption.getParams() != null) {
                    if (annOption.getParams() instanceof GeneralParams) {
                        GeneralParams params = (GeneralParams)annOption.getParams();
                        annBuilder.setParams(Olama.SearchParams.newBuilder().setEf(params.getEf()).setNprobe(params.getNProbe()).setRadius((float)params.getRadius()).build());
                    } else if (annOption.getParams() instanceof HNSWSearchParams) {
                        HNSWSearchParams params = (HNSWSearchParams)annOption.getParams();
                        annBuilder.setParams(Olama.SearchParams.newBuilder().setEf(params.getEf()).build());
                    }
                }
                return annBuilder.build();
            }).collect(Collectors.toList()));
        }
        if (searchParam.getMatch() != null && !searchParam.getMatch().isEmpty()) {
            searchConBuilder.addAllSparse(searchParam.getMatch().stream().map(matchOption -> {
                Olama.SparseData.Builder sparseBuilder = Olama.SparseData.newBuilder().setFieldName(matchOption.getFieldName());
                matchOption.getData().forEach(sparseVectors -> sparseBuilder.addData(Olama.SparseVectorArray.newBuilder().addAllSpVector(sparseVectors.stream().map(vectors -> Olama.SparseVecItem.newBuilder().setTermId((Long)vectors.get(0)).setScore(Float.parseFloat(vectors.get(1).toString())).build()).collect(Collectors.toList())).build()));
                if (matchOption.getLimit() != null) {
                    sparseBuilder.setLimit(matchOption.getLimit());
                }
                if (matchOption.getCutoffFrequency() != null || matchOption.getTerminateAfter() != null) {
                    Olama.SparseSearchParams.Builder sparseSearchParamsBuilder = Olama.SparseSearchParams.newBuilder();
                    if (matchOption.getCutoffFrequency() != null) {
                        sparseSearchParamsBuilder.setCutoffFrequency(matchOption.getCutoffFrequency());
                    }
                    if (matchOption.getTerminateAfter() != null) {
                        sparseSearchParamsBuilder.setTerminateAfter(matchOption.getTerminateAfter());
                    }
                    sparseBuilder.setParams(sparseSearchParamsBuilder.build()).build();
                }
                return sparseBuilder.build();
            }).collect(Collectors.toList()));
        }
        if (searchParam.getRerank() != null) {
            Olama.RerankParams.Builder rerankBuilder = Olama.RerankParams.newBuilder().setMethod(searchParam.getRerank().getMethod());
            if (searchParam.getRerank() instanceof WeightRerankParam) {
                WeightRerankParam weightRerankParam = (WeightRerankParam)searchParam.getRerank();
                HashMap<String, Float> weightMap = new HashMap<String, Float>();
                for (int i = 0; i < weightRerankParam.getFieldList().size(); ++i) {
                    weightMap.put(weightRerankParam.getFieldList().get(i), Float.valueOf(weightRerankParam.getWeight().get(i).floatValue()));
                }
                rerankBuilder.putAllWeights(weightMap);
            } else if (searchParam.getRerank() instanceof RRFRerankParam) {
                RRFRerankParam rrfRerankParam = (RRFRerankParam)searchParam.getRerank();
                rerankBuilder.setRrfK(rrfRerankParam.getRrfK());
            }
            searchConBuilder.setRerankParams(rerankBuilder.build());
        }
        builder.setSearch(searchConBuilder);
        GrpcStub.logQuery("document/hybridSearch", builder);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            SearchEngineGrpc.SearchEngineBlockingStub searchEngineBlockingStub = (SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withInterceptors(new ClientInterceptor[]{new BackendServiceInterceptor(ai)});
            searchResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)searchEngineBlockingStub.withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).hybridSearch(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("document/hybridSearch", searchResponse);
        if (searchResponse == null) {
            throw new VectorDBException("VectorDBServer error: search not response");
        }
        if (searchResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: search not Success, body code=%s, message=%s", searchResponse.getCode(), searchResponse.getMsg()));
        }
        ArrayList documentsList = new ArrayList();
        for (Olama.SearchResult searchResult : searchResponse.getResultsList()) {
            List documents = searchResult.getDocumentsList().stream().map(GrpcStub::convertDocument).collect(Collectors.toList());
            if (!searchParam.getIsArrayParam().booleanValue()) {
                return new HybridSearchRes(searchResponse.getCode(), searchResponse.getMsg(), searchResponse.getWarning(), Collections.unmodifiableList(documents));
            }
            documentsList.add(documents);
        }
        return new HybridSearchRes(searchResponse.getCode(), searchResponse.getMsg(), searchResponse.getWarning(), Collections.unmodifiableList(documentsList));
    }

    private static void logQuery(String url, MessageOrBuilder messageOrBuilder) {
        try {
            logger.debug("Query {}, request body={}", (Object)url, (Object)JsonFormat.printer().print(messageOrBuilder));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private static void logResponse(String url, MessageOrBuilder messageOrBuilder) {
        try {
            logger.debug("Query {}, response={}", (Object)url, (Object)JsonFormat.printer().print(messageOrBuilder));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffectRes deleteDocument(DeleteParamInner param) {
        Olama.DeleteResponse deleteResponse;
        Olama.QueryCond.Builder queryCondBuilder = Olama.QueryCond.newBuilder();
        DeleteParam paramQuery = param.getQuery();
        if (paramQuery.getDocumentIds() != null && !paramQuery.getDocumentIds().isEmpty()) {
            queryCondBuilder.addAllDocumentIds(paramQuery.getDocumentIds());
        }
        if (paramQuery.getFilter() != null && !paramQuery.getFilter().isEmpty()) {
            queryCondBuilder.setFilter(paramQuery.getFilter());
        }
        if (param.getQuery().getLimit() != null) {
            queryCondBuilder.setLimit(param.getQuery().getLimit().intValue());
        }
        Olama.DeleteRequest.Builder deleteRequestBuilder = Olama.DeleteRequest.newBuilder();
        if (param.getDatabase() != null) {
            deleteRequestBuilder.setDatabase(param.getDatabase());
        }
        if (param.getCollection() != null) {
            deleteRequestBuilder.setCollection(param.getCollection());
        }
        Olama.DeleteRequest deleteRequest = deleteRequestBuilder.setQuery(queryCondBuilder.build()).build();
        GrpcStub.logQuery("document/delete", deleteRequest);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            deleteResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).dele(deleteRequest);
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("document/delete", deleteResponse);
        if (deleteResponse == null) {
            throw new VectorDBException("VectorDBServer error: deleteResponse not response");
        }
        if (deleteResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: delete not Success, body code=%s, message=%s", deleteResponse.getCode(), deleteResponse.getMsg()));
        }
        return new AffectRes(deleteResponse.getCode(), deleteResponse.getMsg(), "", deleteResponse.getAffectedCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffectRes updateDocument(UpdateParamInner param, boolean ai) {
        Olama.QueryCond.Builder queryCondBuilder = Olama.QueryCond.newBuilder();
        UpdateParam paramQuery = param.getQuery();
        if (paramQuery.getDocumentIds() != null && !paramQuery.getDocumentIds().isEmpty()) {
            queryCondBuilder.addAllDocumentIds(paramQuery.getDocumentIds());
        }
        if (paramQuery.getFilter() != null && !paramQuery.getFilter().isEmpty()) {
            queryCondBuilder.setFilter(paramQuery.getFilter());
        }
        Olama.UpdateRequest.Builder updateRequestBuilder = Olama.UpdateRequest.newBuilder();
        if (param.getDatabase() != null) {
            updateRequestBuilder.setDatabase(param.getDatabase());
        }
        if (param.getCollection() != null) {
            updateRequestBuilder.setCollection(param.getCollection());
        }
        if (param.getUpdate() != null) {
            updateRequestBuilder.setQuery(queryCondBuilder.build()).setUpdate(GrpcStub.convertDocument2OlamaDoc(param.getUpdate()));
        } else if (param.getUpdateData() != null) {
            updateRequestBuilder.setQuery(queryCondBuilder.build()).setUpdate(this.convertDocumentJSON2OlamaDoc(param.getUpdateData()));
        }
        GrpcStub.logQuery("document/update", updateRequestBuilder.build());
        Olama.UpdateResponse updateResponse = null;
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            SearchEngineGrpc.SearchEngineBlockingStub searchEngineBlockingStub = (SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withInterceptors(new ClientInterceptor[]{new BackendServiceInterceptor(ai)});
            updateResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)searchEngineBlockingStub.withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).update(updateRequestBuilder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("document/update", updateResponse);
        if (updateResponse == null) {
            throw new VectorDBException("VectorDBServer error: update not response");
        }
        if (updateResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: update not Success, body code=%s, message=%s", updateResponse.getCode(), updateResponse.getMsg()));
        }
        return new AffectRes(updateResponse.getCode(), updateResponse.getMsg(), updateResponse.getWarning(), updateResponse.getAffectedCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseRes rebuildIndex(RebuildIndexParamInner param) {
        Olama.RebuildIndexResponse rebuildIndexResponse;
        Olama.RebuildIndexRequest.Builder builder = Olama.RebuildIndexRequest.newBuilder();
        if (param.getDatabase() != null) {
            builder.setDatabase(param.getDatabase());
        }
        if (param.getCollection() != null) {
            builder.setCollection(param.getCollection());
        }
        Olama.RebuildIndexRequest rebuildIndexRequest = builder.setThrottle(param.getThrottle()).setDropBeforeRebuild(param.isDropBeforeRebuild()).build();
        GrpcStub.logQuery("index/rebuild", rebuildIndexRequest);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            rebuildIndexResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).rebuildIndex(rebuildIndexRequest);
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("index/rebuild", rebuildIndexResponse);
        if (rebuildIndexResponse == null) {
            throw new VectorDBException("VectorDBServer error: rebuildIndex not response");
        }
        if (rebuildIndexResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: search not Success, body code=%s, message=%s", rebuildIndexResponse.getCode(), rebuildIndexResponse.getMsg()));
        }
        return new BaseRes(rebuildIndexResponse.getCode(), rebuildIndexResponse.getMsg(), "");
    }

    @Override
    public AffectRes setAIAlias(String databaseName, String collectionName, String aliasName) {
        super.initHttpStub(this.connectParam);
        return super.setAIAlias(databaseName, collectionName, aliasName);
    }

    @Override
    public AffectRes deleteAIAlias(String databaseName, String aliasName) {
        super.initHttpStub(this.connectParam);
        return super.deleteAIAlias(databaseName, aliasName);
    }

    @Override
    public List<CollectionView> listCollectionView(String databaseName) {
        super.initHttpStub(this.connectParam);
        return super.listCollectionView(databaseName);
    }

    @Override
    public CollectionView describeCollectionView(String databaseName, String collectionName) {
        super.initHttpStub(this.connectParam);
        return super.describeCollectionView(databaseName, collectionName);
    }

    @Override
    public AffectRes dropCollectionView(String databaseName, String collectionName) {
        super.initHttpStub(this.connectParam);
        return super.dropCollectionView(databaseName, collectionName);
    }

    @Override
    public List<DocumentSet> queryAIDocument(CollectionViewQueryParamInner queryParamInner) {
        super.initHttpStub(this.connectParam);
        return super.queryAIDocument(queryParamInner);
    }

    @Override
    public AffectRes deleteAIDocument(CollectionViewDeleteParamInner deleteParamInner) {
        super.initHttpStub(this.connectParam);
        return super.deleteAIDocument(deleteParamInner);
    }

    @Override
    public SearchContentRes searchAIDocument(SearchDocParamInner searchDocParamInner) {
        super.initHttpStub(this.connectParam);
        return super.searchAIDocument(searchDocParamInner);
    }

    @Override
    public AffectRes updateAIDocument(CollectionViewUpdateParamInner updateParamInner) {
        super.initHttpStub(this.connectParam);
        return super.updateAIDocument(updateParamInner);
    }

    @Override
    public void upload(String databaseName, String collectionName, LoadAndSplitTextParam loadAndSplitTextParam, Map<String, Object> metaDataMap) throws Exception {
        super.initHttpStub(this.connectParam);
        super.upload(databaseName, collectionName, loadAndSplitTextParam, metaDataMap);
    }

    @Override
    public void collectionUpload(String databaseName, String collectionName, UploadFileParam loadAndSplitTextParam, Map<String, Object> metaDataMap) throws Exception {
        super.initHttpStub(this.connectParam);
        super.collectionUpload(databaseName, collectionName, loadAndSplitTextParam, metaDataMap);
    }

    @Override
    public GetDocumentSetRes getFile(String databaseName, String collectionName, String fileName, String fileId) {
        super.initHttpStub(this.connectParam);
        return super.getFile(databaseName, collectionName, fileName, fileId);
    }

    @Override
    public GetChunksRes getChunks(String databaseName, String collectionName, String documentSetName, String documentSetId, Integer limit, Integer offset) {
        super.initHttpStub(this.connectParam);
        return super.getChunks(databaseName, collectionName, documentSetName, documentSetId, limit, offset);
    }

    @Override
    public GetImageUrlRes GetImageUrl(GetImageUrlParamInner param) {
        super.initHttpStub(this.connectParam);
        return super.GetImageUrl(param);
    }

    @Override
    public BaseRes rebuildAIIndex(RebuildIndexParamInner param) {
        super.initHttpStub(this.connectParam);
        return super.rebuildAIIndex(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseRes countDocument(QueryCountParamInner param, boolean ai) {
        Olama.CountResponse countResponse;
        Olama.CountRequest.Builder countCondBuilder = Olama.CountRequest.newBuilder();
        if (param.getDatabase() != null) {
            countCondBuilder.setDatabase(param.getDatabase());
        }
        if (param.getCollection() != null) {
            countCondBuilder.setCollection(param.getCollection());
        }
        if (param.getQuery() != null) {
            Olama.QueryCond.Builder queryBuilder = Olama.QueryCond.newBuilder();
            if (param.getQuery().getFilter() != null) {
                queryBuilder.setFilter(param.getQuery().getFilter());
            }
            countCondBuilder.setQuery(queryBuilder.build());
        }
        if (param.getReadConsistency() != null) {
            countCondBuilder.setReadConsistency(param.getReadConsistency().getReadConsistency());
        }
        Olama.CountRequest countRequest = countCondBuilder.build();
        GrpcStub.logQuery("document/count", countCondBuilder);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            countResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).count(countRequest);
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("document/count", countResponse);
        if (countResponse == null) {
            throw new VectorDBException("VectorDBServer error: count not response");
        }
        if (countResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: count not Success, body code=%s, message=%s", countResponse.getCode(), countResponse.getMsg()));
        }
        return new BaseRes(countResponse.getCode(), countResponse.getMsg(), "", countResponse.getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseRes modifyVectorIndex(ModifyIndexParamInner param, boolean ai) {
        Olama.ModifyVectorIndexResponse modifyVectorIndexResponse;
        Olama.ModifyVectorIndexRequest.Builder builder = Olama.ModifyVectorIndexRequest.newBuilder();
        if (param.getDatabase() != null) {
            builder.setDatabase(param.getDatabase());
        }
        if (param.getCollection() != null) {
            builder.setCollection(param.getCollection());
        }
        if (param.getRebuildRules() != null) {
            builder.setRebuildRules(Olama.RebuildIndexRequest.newBuilder().setDropBeforeRebuild(param.getRebuildRules().getDropBeforeRebuild()).setThrottle(param.getRebuildRules().getThrottle()).build());
        }
        if (param.getVectorIndexes() != null && !param.getVectorIndexes().isEmpty()) {
            builder.putAllVectorIndexes(param.getVectorIndexes().stream().map(indexField -> GrpcStub.getRpcIndexBuilder(indexField).build()).collect(Collectors.toMap(index -> index.getFieldName(), index -> index)));
        }
        GrpcStub.logQuery("index/modifyVectorIndex", builder);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            modifyVectorIndexResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).modifyVectorIndex(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("index/modifyVectorIndex", modifyVectorIndexResponse);
        if (modifyVectorIndexResponse == null) {
            throw new VectorDBException("VectorDBServer error: modifyVectorIndex not response");
        }
        if (modifyVectorIndexResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: modifyVectorIndex not Success, body code=%s, message=%s", modifyVectorIndexResponse.getCode(), modifyVectorIndexResponse.getMsg()));
        }
        return new BaseRes(modifyVectorIndexResponse.getCode(), modifyVectorIndexResponse.getMsg(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseRes addIndex(AddIndexParamInner addIndexParamInner) {
        Olama.AddIndexResponse addIndexResponse;
        Olama.AddIndexRequest.Builder builder = Olama.AddIndexRequest.newBuilder();
        if (addIndexParamInner.getDatabase() != null) {
            builder.setDatabase(addIndexParamInner.getDatabase());
        }
        if (addIndexParamInner.getCollection() != null) {
            builder.setCollection(addIndexParamInner.getCollection());
        }
        Olama.AddIndexRequest addIndexRequest = builder.setBuildExistedData(addIndexParamInner.isBuildExistedData()).putAllIndexes(addIndexParamInner.getIndexes().stream().map(indexField -> GrpcStub.getRpcIndexBuilder(indexField).build()).collect(Collectors.toMap(index -> index.getFieldName(), index -> index))).build();
        GrpcStub.logQuery("index/add", addIndexRequest);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            addIndexResponse = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).addIndex(addIndexRequest);
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("index/rebuild", addIndexResponse);
        if (addIndexResponse == null) {
            throw new VectorDBException("VectorDBServer error: addIndex not response");
        }
        if (addIndexResponse.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: search not Success, body code=%s, message=%s", addIndexResponse.getCode(), addIndexResponse.getMsg()));
        }
        return new BaseRes(addIndexResponse.getCode(), addIndexResponse.getMsg(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseRes createUser(UserCreateParam userCreateParam) {
        Olama.UserAccountResponse response;
        Olama.UserAccountRequest.Builder builder = Olama.UserAccountRequest.newBuilder();
        if (userCreateParam.getUser() != null) {
            builder.setUser(userCreateParam.getUser());
        }
        if (userCreateParam.getPassword() != null) {
            builder.setPassword(userCreateParam.getPassword()).build();
        }
        GrpcStub.logQuery("user/create", builder.build());
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).userCreate(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("user/create", response);
        if (response.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: create user account error, body code=%s, message=%s", response.getCode(), response.getMsg()));
        }
        return new BaseRes(response.getCode(), response.getMsg(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseRes grantToUser(UserGrantParam param) {
        Olama.UserPrivilegesResponse response;
        Olama.UserPrivilegesRequest.Builder builder = Olama.UserPrivilegesRequest.newBuilder();
        if (param.getUser() != null) {
            builder.setUser(param.getUser());
        }
        if (param.getPrivileges() != null) {
            builder.addAllPrivileges(param.getPrivileges().stream().map(privilege -> Olama.Privilege.newBuilder().setResource(privilege.getResource()).addAllActions(privilege.getActions()).build()).collect(Collectors.toList()));
        }
        GrpcStub.logQuery("user/grant", builder);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).userGrant(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("user/grant", response);
        if (response.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: grant user account error, body code=%s, message=%s", response.getCode(), response.getMsg()));
        }
        return new BaseRes(response.getCode(), response.getMsg(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseRes revokeFromUser(UserRevokeParam param) {
        Olama.UserPrivilegesResponse response;
        Olama.UserPrivilegesRequest.Builder builder = Olama.UserPrivilegesRequest.newBuilder();
        if (param.getUser() != null) {
            builder.setUser(param.getUser());
        }
        if (param.getPrivileges() != null) {
            builder.addAllPrivileges(param.getPrivileges().stream().map(privilege -> Olama.Privilege.newBuilder().setResource(privilege.getResource()).addAllActions(privilege.getActions()).build()).collect(Collectors.toList()));
        }
        GrpcStub.logQuery("user/revoke", builder);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).userRevoke(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("user/revoke", response);
        if (response.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: revoke user error, body code=%s, message=%s", response.getCode(), response.getMsg()));
        }
        return new BaseRes(response.getCode(), response.getMsg(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDescribeRes describeUser(UserDescribeParam userDescribeParam) {
        Olama.UserDescribeResponse response;
        Olama.UserDescribeRequest.Builder builder = Olama.UserDescribeRequest.newBuilder();
        if (userDescribeParam.getUser() != null) {
            builder.setUser(userDescribeParam.getUser());
        }
        GrpcStub.logQuery("user/describe", builder.build());
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).userDescribe(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("user/describe", response);
        if (response.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: revoke user error, body code=%s, message=%s", response.getCode(), response.getMsg()));
        }
        UserDescribeRes res = new UserDescribeRes(response.getCode(), response.getMsg(), "");
        if (response.hasUser()) {
            res.setUser(response.getUser().getName());
            res.setPrivileges(response.getUser().getPrivilegesList().stream().map(privilege -> PrivilegeParam.newBuilder().withResource(privilege.getResource()).withActions((List<String>)privilege.getActionsList()).build()).collect(Collectors.toList()));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserListRes listUser() {
        Olama.UserListResponse response;
        Olama.UserListRequest request = Olama.UserListRequest.newBuilder().build();
        GrpcStub.logQuery("user/list", request);
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).userList(request);
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("user/list", response);
        if (response.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: list user error, body code=%s, message=%s", response.getCode(), response.getMsg()));
        }
        UserListRes res = new UserListRes(response.getCode(), response.getMsg(), "");
        if (response.getUsersList() != null && !response.getUsersList().isEmpty()) {
            res.setUsers(response.getUsersList().stream().map(user -> {
                UserInfo userInfo = new UserInfo();
                userInfo.setUser(user.getName());
                userInfo.setPrivileges(user.getPrivilegesList().stream().map(privilege -> PrivilegeParam.newBuilder().withResource(privilege.getResource()).withActions((List<String>)privilege.getActionsList()).build()).collect(Collectors.toList()));
                return userInfo;
            }).collect(Collectors.toList()));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseRes dropUser(UserDropParam userDropParam) {
        Olama.UserAccountResponse response;
        Olama.UserAccountRequest.Builder builder = Olama.UserAccountRequest.newBuilder();
        if (userDropParam.getUser() != null) {
            builder.setUser(userDropParam.getUser());
        }
        GrpcStub.logQuery("user/drop", builder.build());
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).userDrop(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("user/drop", response);
        if (response.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: drop user error, body code=%s, message=%s", response.getCode(), response.getMsg()));
        }
        return new BaseRes(response.getCode(), response.getMsg(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseRes changeUserPassword(UserChangePasswordParam param) {
        Olama.UserAccountResponse response;
        Olama.UserAccountRequest.Builder builder = Olama.UserAccountRequest.newBuilder();
        if (param.getUser() != null) {
            builder.setUser(param.getUser());
        }
        if (param.getPassword() != null) {
            builder.setPassword(param.getPassword()).build();
        }
        GrpcStub.logQuery("user/changePassword", builder.build());
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).userChangePassword(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("user/changePassword", response);
        if (response.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: change user password error, body code=%s, message=%s", response.getCode(), response.getMsg()));
        }
        return new BaseRes(response.getCode(), response.getMsg(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseRes dropIndex(DropIndexParamInner dropIndexParamInner) {
        Olama.DropIndexResponse response;
        Olama.DropIndexRequest.Builder builder = Olama.DropIndexRequest.newBuilder();
        if (dropIndexParamInner.getDatabase() != null) {
            builder.setDatabase(dropIndexParamInner.getDatabase());
        }
        if (dropIndexParamInner.getCollection() != null) {
            builder.setCollection(dropIndexParamInner.getCollection());
        }
        if (dropIndexParamInner.getFieldNames() != null && !dropIndexParamInner.getFieldNames().isEmpty()) {
            builder.addAllFieldNames(dropIndexParamInner.getFieldNames());
        }
        GrpcStub.logQuery("index/drop", builder.build());
        ManagedChannel channel = this.channelPool.getChannel();
        try {
            response = ((SearchEngineGrpc.SearchEngineBlockingStub)SearchEngineGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).dropIndex(builder.build());
        }
        finally {
            this.channelPool.returnChannel(channel);
        }
        GrpcStub.logResponse("user/changePassword", response);
        if (response.getCode() != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: drop user index error, body code=%s, message=%s", response.getCode(), response.getMsg()));
        }
        return new BaseRes(response.getCode(), response.getMsg(), "");
    }

    private static Collection convertRpcToCollection(Olama.CreateCollectionRequest collection) {
        Collection collectionInner = new Collection();
        collectionInner.setDatabase(collection.getDatabase());
        collectionInner.setCollection(collection.getCollection());
        if (!collection.getEmbeddingParams().getField().isEmpty()) {
            collectionInner.setEmbedding(Embedding.newBuilder().withField(collection.getEmbeddingParams().getField()).withModel(EmbeddingModelEnum.find(collection.getEmbeddingParams().getModelName())).withVectorField(collection.getEmbeddingParams().getVectorField()).build());
        }
        collectionInner.setDescription(collection.getDescription());
        collectionInner.setAlias((List<String>)collection.getAliasListList());
        collectionInner.setCreateTime(collection.getCreateTime());
        collectionInner.setShardNum(collection.getShardNum());
        collectionInner.setReplicaNum(collection.getReplicaNum());
        collectionInner.setIndexStatus(new Collection.IndexStatus(collection.getIndexStatus().getStatus(), collection.getIndexStatus().getStartTime()));
        if (collection.hasTtlConfig()) {
            collectionInner.setTtlConfig(TTLConfig.newBuilder().WithEnable(collection.getTtlConfig().getEnable()).WithTimeField(collection.getTtlConfig().getTimeField()).build());
        }
        if (collection.hasFilterIndexConfig()) {
            collectionInner.setFilterIndexConfig(FilterIndexConfig.newBuilder().withFieldWithoutFilterIndex((List<String>)collection.getFilterIndexConfig().getFieldsWithoutIndexList()).withFilterAll(collection.getFilterIndexConfig().getFilterAll()).build());
        }
        collectionInner.setIndexes(collection.getIndexesMap().entrySet().stream().map(entry -> {
            IndexField indexField = new IndexField();
            indexField.setFieldName(((Olama.IndexColumn)entry.getValue()).getFieldName());
            indexField.setFieldType(FieldType.fromValue(((Olama.IndexColumn)entry.getValue()).getFieldType()));
            indexField.setIndexType(IndexType.fromValue(((Olama.IndexColumn)entry.getValue()).getIndexType()));
            if (indexField.isVectorField()) {
                indexField.setMetricType(MetricType.fromValue(((Olama.IndexColumn)entry.getValue()).getMetricType()));
                indexField.setDimension(((Olama.IndexColumn)entry.getValue()).getDimension());
                if (((Olama.IndexColumn)entry.getValue()).hasParams()) {
                    switch (indexField.getIndexType()) {
                        case HNSW: {
                            indexField.setParams(new HNSWParams(((Olama.IndexColumn)entry.getValue()).getParams().getM(), ((Olama.IndexColumn)entry.getValue()).getParams().getEfConstruction()));
                            break;
                        }
                        case IVF_FLAT: {
                            indexField.setParams(new IVFFLATParams(((Olama.IndexColumn)entry.getValue()).getParams().getNlist()));
                            break;
                        }
                        case IVF_PQ: {
                            indexField.setParams(new IVFPQParams(((Olama.IndexColumn)entry.getValue()).getParams().getNlist(), ((Olama.IndexColumn)entry.getValue()).getParams().getM()));
                            break;
                        }
                        case IVF_SQ8: {
                            indexField.setParams(new IVFSQ8Params(((Olama.IndexColumn)entry.getValue()).getParams().getNlist()));
                        }
                    }
                }
            }
            if (indexField.isSparseVectorField()) {
                indexField.setMetricType(MetricType.fromValue(((Olama.IndexColumn)entry.getValue()).getMetricType()));
            }
            if (indexField.getFieldType() == FieldType.Array) {
                indexField.setFieldElementType(FieldElementType.fromValue(((Olama.IndexColumn)entry.getValue()).getFieldElementType()));
            }
            if (((Olama.IndexColumn)entry.getValue()).getAutoId() != null && !((Olama.IndexColumn)entry.getValue()).getAutoId().equals("")) {
                indexField.setAutoId(((Olama.IndexColumn)entry.getValue()).getAutoId());
            }
            return indexField;
        }).collect(Collectors.toList()));
        return collectionInner;
    }

    private static Olama.Document convertDocument2OlamaDoc(Document document) {
        Olama.Document.Builder docBuilder = Olama.Document.newBuilder();
        if (document.getId() != null) {
            docBuilder.setId(document.getId());
        }
        if (document.getVector() != null) {
            if (document.getVector() instanceof List) {
                docBuilder.addAllVector(((List)document.getVector()).stream().map(ele -> Float.valueOf(ele.floatValue())).collect(Collectors.toList()));
            } else if (document.getVector() instanceof String) {
                docBuilder.setDataExpr((String)document.getVector());
            }
        }
        if (document.getSparseVector() != null) {
            docBuilder.addAllSparseVector(document.getSparseVector().stream().map(pair -> Olama.SparseVecItem.newBuilder().setTermId((Long)pair.getKey()).setScore(((Float)pair.getValue()).floatValue()).build()).collect(Collectors.toList()));
        }
        document.getDocFields().forEach(docField -> {
            Olama.Field.Builder fieldBuilder = Olama.Field.newBuilder();
            if (docField.getValue() instanceof Integer || docField.getValue() instanceof Long) {
                fieldBuilder.setValU64(Long.parseLong(docField.getValue().toString()));
            } else if (docField.getValue() instanceof Double || docField.getValue() instanceof Float) {
                fieldBuilder.setValDouble(Double.parseDouble(docField.getValue().toString()));
            } else if (docField.getValue() instanceof String) {
                fieldBuilder.setValStr(ByteString.copyFromUtf8((String)docField.getValue().toString()));
            } else if (docField.getValue() instanceof List && ((List)docField.getValue()).get(0) instanceof String) {
                fieldBuilder.setValStrArr(Olama.Field.StringArray.newBuilder().addAllStrArr(((List)docField.getValue()).stream().map(ele -> ByteString.copyFromUtf8((String)((String)ele))).collect(Collectors.toList())));
            } else if (docField.getValue() instanceof JSONObject) {
                fieldBuilder.setValJson(ByteString.copyFromUtf8((String)docField.getValue().toString()));
            } else {
                throw new VectorDBException("Unsupported field type,  field key:" + docField.getName() + " type:" + docField.getValue().getClass() + "\nsupported field type is:  Integer,Long,Double,Float,String,List<String>,JSONObject");
            }
            docBuilder.putFields(docField.getName(), fieldBuilder.build());
        });
        return docBuilder.build();
    }

    private Olama.Document convertDocumentJSON2OlamaDoc(JSONObject document) {
        Olama.Document.Builder docBuilder = Olama.Document.newBuilder();
        document.keySet().forEach(key -> {
            if (key.equals("id")) {
                docBuilder.setId(document.get(key).toString());
            } else if (key.equals("vector")) {
                docBuilder.addAllVector(((JSONArray)document.get(key)).toList().stream().map(vecEle -> Float.valueOf(Float.parseFloat(vecEle.toString()))).collect(Collectors.toList()));
            } else if (key.equals("sparse_vector")) {
                List sparseVectors = (List)document.get("sparse_vector");
                docBuilder.addAllSparseVector(sparseVectors.stream().map(pair -> Olama.SparseVecItem.newBuilder().setTermId((Long)((List)pair).get(0)).setScore(((Float)((List)pair).get(1)).floatValue()).build()).collect(Collectors.toList()));
            } else {
                Olama.Field.Builder fieldBuilder = Olama.Field.newBuilder();
                if (document.get(key) instanceof Integer || document.get(key) instanceof Long) {
                    fieldBuilder.setValU64(Long.parseLong(document.get(key).toString()));
                } else if (document.get(key) instanceof Double || document.get(key) instanceof Float) {
                    fieldBuilder.setValDouble(Double.parseDouble(document.get(key).toString()));
                } else if (document.get(key) instanceof String) {
                    fieldBuilder.setValStr(ByteString.copyFromUtf8((String)document.get(key).toString()));
                } else if (document.get(key) instanceof JSONArray && ((JSONArray)document.get(key)).get(0) instanceof String) {
                    fieldBuilder.setValStrArr(Olama.Field.StringArray.newBuilder().addAllStrArr(((JSONArray)document.get(key)).toList().stream().map(ele -> ByteString.copyFromUtf8((String)((String)ele))).collect(Collectors.toList())));
                } else if (document.get(key) instanceof JSONObject) {
                    fieldBuilder.setValJson(ByteString.copyFromUtf8((String)document.get(key).toString()));
                } else {
                    throw new VectorDBException("Unsupported field type, field:+" + key + " type:" + document.get(key).getClass() + "\nsupported field type is:  Integer,Long,Double,Float,String,JSONArray<String>,JSONObject");
                }
                docBuilder.putFields((String)key, fieldBuilder.build());
            }
        });
        return docBuilder.build();
    }

    private static Document convertDocument(Olama.Document document) {
        Document.Builder builder = Document.newBuilder().withId(document.getId());
        builder.withScore(Double.valueOf(document.getScore()));
        if (document.getVectorCount() > 0) {
            builder.withVector(document.getVectorList().stream().map(ele -> ele.doubleValue()).collect(Collectors.toList()));
        }
        if (document.getSparseVectorCount() > 0) {
            builder.withSparseVector(document.getSparseVectorList().stream().map(sparseVecItem -> Pair.of((Object)sparseVecItem.getTermId(), (Object)Float.valueOf(sparseVecItem.getScore()))).collect(Collectors.toList()));
        }
        if (document.getFieldsMap() != null && document.getFieldsMap().size() > 0) {
            for (Map.Entry<String, Olama.Field> stringFieldEntry : document.getFieldsMap().entrySet()) {
                if (stringFieldEntry.getValue().hasValDouble()) {
                    builder.addDocField(new DocField(stringFieldEntry.getKey(), stringFieldEntry.getValue().getValDouble()));
                }
                if (stringFieldEntry.getValue().hasValU64()) {
                    builder.addDocField(new DocField(stringFieldEntry.getKey(), stringFieldEntry.getValue().getValU64()));
                }
                if (stringFieldEntry.getValue().hasValStr()) {
                    builder.addDocField(new DocField(stringFieldEntry.getKey(), stringFieldEntry.getValue().getValStr().toString(StandardCharsets.UTF_8)));
                }
                if (stringFieldEntry.getValue().hasValJson()) {
                    builder.addDocField(new DocField(stringFieldEntry.getKey(), new JSONObject(stringFieldEntry.getValue().getValJson().toString(StandardCharsets.UTF_8))));
                }
                if (!stringFieldEntry.getValue().hasValStrArr()) continue;
                builder.addDocField(new DocField(stringFieldEntry.getKey(), stringFieldEntry.getValue().getValStrArr().getStrArrList().stream().map(ele -> ele.toString(StandardCharsets.UTF_8)).collect(Collectors.toList())));
            }
        }
        return builder.build();
    }
}

