/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicSessionCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import com.tencent.tcvectordb.enums.Code;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.AIDatabase;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.CollectionView;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.DocumentSet;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collection.UploadFileParam;
import com.tencent.tcvectordb.model.param.collectionView.CreateCollectionViewParam;
import com.tencent.tcvectordb.model.param.collectionView.FileType;
import com.tencent.tcvectordb.model.param.collectionView.LoadAndSplitTextParam;
import com.tencent.tcvectordb.model.param.collectionView.ParsingProcessParam;
import com.tencent.tcvectordb.model.param.collectionView.SplitterPreprocessParams;
import com.tencent.tcvectordb.model.param.database.ConnectParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.model.param.entity.CollectionUploadUrlRes;
import com.tencent.tcvectordb.model.param.entity.ContentInfo;
import com.tencent.tcvectordb.model.param.entity.DataBaseType;
import com.tencent.tcvectordb.model.param.entity.DataBaseTypeRes;
import com.tencent.tcvectordb.model.param.entity.DocumentFileContent;
import com.tencent.tcvectordb.model.param.entity.DocumentSetInfo;
import com.tencent.tcvectordb.model.param.entity.GetChunksRes;
import com.tencent.tcvectordb.model.param.entity.GetDocumentSetRes;
import com.tencent.tcvectordb.model.param.entity.GetImageUrlRes;
import com.tencent.tcvectordb.model.param.entity.HybridSearchRes;
import com.tencent.tcvectordb.model.param.entity.SearchContentInfo;
import com.tencent.tcvectordb.model.param.entity.SearchContentRes;
import com.tencent.tcvectordb.model.param.entity.SearchDocumentSetInfo;
import com.tencent.tcvectordb.model.param.entity.SearchRes;
import com.tencent.tcvectordb.model.param.entity.UploadUrlRes;
import com.tencent.tcvectordb.model.param.enums.DataBaseTypeEnum;
import com.tencent.tcvectordb.model.param.user.UserChangePasswordParam;
import com.tencent.tcvectordb.model.param.user.UserCreateParam;
import com.tencent.tcvectordb.model.param.user.UserDescribeParam;
import com.tencent.tcvectordb.model.param.user.UserDescribeRes;
import com.tencent.tcvectordb.model.param.user.UserDropParam;
import com.tencent.tcvectordb.model.param.user.UserGrantParam;
import com.tencent.tcvectordb.model.param.user.UserListRes;
import com.tencent.tcvectordb.model.param.user.UserRevokeParam;
import com.tencent.tcvectordb.service.Stub;
import com.tencent.tcvectordb.service.param.AddIndexParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewDeleteParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewQueryParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewUpdateParamInner;
import com.tencent.tcvectordb.service.param.CosEndpointBuilder;
import com.tencent.tcvectordb.service.param.DeleteParamInner;
import com.tencent.tcvectordb.service.param.DropIndexParamInner;
import com.tencent.tcvectordb.service.param.GetImageUrlParamInner;
import com.tencent.tcvectordb.service.param.HybridSearchParamInner;
import com.tencent.tcvectordb.service.param.InsertParamInner;
import com.tencent.tcvectordb.service.param.ModifyIndexParamInner;
import com.tencent.tcvectordb.service.param.QueryCountParamInner;
import com.tencent.tcvectordb.service.param.QueryParamInner;
import com.tencent.tcvectordb.service.param.RebuildIndexParamInner;
import com.tencent.tcvectordb.service.param.SearchDocParamInner;
import com.tencent.tcvectordb.service.param.SearchParamInner;
import com.tencent.tcvectordb.service.param.UpdateParamInner;
import com.tencent.tcvectordb.utils.FileUtils;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStub
implements Stub {
    private ConnectParam connectParam;
    private OkHttpClient client;
    private Headers.Builder headersBuilder;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Logger logger = LoggerFactory.getLogger((String)HttpStub.class.getName());

    public HttpStub() {
    }

    public HttpStub(ConnectParam connectParam) {
        this.initHttpStub(connectParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initHttpStub(ConnectParam connectParam) {
        if (this.client == null) {
            HttpStub httpStub = this;
            synchronized (httpStub) {
                if (this.client == null) {
                    this.connectParam = connectParam;
                    String authorization = String.format("Bearer account=%s&api_key=%s", connectParam.getUsername(), connectParam.getKey());
                    this.headersBuilder = new Headers.Builder().add("Authorization", authorization);
                    logger.debug("header: {}", (Object)authorization);
                    this.client = new OkHttpClient.Builder().connectTimeout(this.connectParam.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)connectParam.getTimeout(), TimeUnit.SECONDS).connectionPool(new ConnectionPool(this.connectParam.getMaxIdleConnections(), (long)this.connectParam.getKeepAliveDuration(), TimeUnit.SECONDS)).build();
                }
            }
        }
    }

    @Override
    public void createDatabase(Database database) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "database/create");
        this.post(url, database.toString(), false);
    }

    @Override
    public void dropDatabase(Database database) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "database/drop");
        this.post(url, database.toString(), false);
    }

    @Override
    public AffectRes createAIDatabase(AIDatabase aiDatabase) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/database/create");
        JsonNode jsonNode = this.post(url, aiDatabase.toString(), false);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public DataBaseTypeRes describeDatabase(Database database) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "database/describe");
        String body = String.format("{\"database\":\"%s\"}", database.getDatabaseName());
        JsonNode jsonNode = this.post(url, body, false);
        return JsonUtils.parseObject(jsonNode.toString(), DataBaseTypeRes.class);
    }

    @Override
    public AffectRes dropAIDatabase(AIDatabase aiDatabase) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/database/drop");
        JsonNode jsonNode = this.post(url, aiDatabase.toString(), false);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public List<String> listDatabases() {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "database/list");
        JsonNode jsonNode = this.get(url, false);
        JsonNode dbsJson = jsonNode.get("databases");
        if (dbsJson == null) {
            return new ArrayList<String>();
        }
        return JsonUtils.collectionDeserializer(dbsJson.toString(), new TypeReference<List<String>>(){});
    }

    @Override
    public Map<String, DataBaseType> listDatabaseInfos() {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "database/list");
        JsonNode jsonNode = this.get(url, false);
        JsonNode dbsJson = jsonNode.get("info");
        if (dbsJson == null) {
            return new HashMap<String, DataBaseType>();
        }
        return JsonUtils.collectionDeserializer(dbsJson.toString(), new TypeReference<Map<String, DataBaseType>>(){});
    }

    @Override
    public void createCollection(CreateCollectionParam param) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "collection/create");
        this.post(url, param.toString(), false);
    }

    @Override
    public void createCollectionView(CreateCollectionViewParam params) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/collectionView/create");
        this.post(url, params.toString(), true);
    }

    @Override
    public List<Collection> listCollections(String databaseName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "collection/list");
        JsonNode jsonNode = this.post(url, String.format("{\"database\":\"%s\"}", databaseName), false);
        JsonNode closJson = jsonNode.get("collections");
        if (closJson == null) {
            return new ArrayList<Collection>();
        }
        return JsonUtils.collectionDeserializer(closJson.toString(), new TypeReference<List<Collection>>(){});
    }

    @Override
    public Collection describeCollection(String databaseName, String collectionName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "collection/describe");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body, false);
        JsonNode dbsJson = jsonNode.get("collection");
        if (dbsJson == null) {
            return null;
        }
        return JsonUtils.collectionDeserializer(dbsJson.toString(), new TypeReference<Collection>(){});
    }

    @Override
    public AffectRes truncateCollection(String databaseName, String collectionName, DataBaseTypeEnum dbType) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "collection/truncate");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body, false);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes truncateCollectionView(String databaseName, String collectionName, DataBaseTypeEnum dbType) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/collectionView/truncate");
        String body = String.format("{\"database\":\"%s\",\"collectionView\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body, true);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public void dropCollection(String databaseName, String collectionName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "collection/drop");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\"}", databaseName, collectionName);
        this.post(url, body, false);
    }

    @Override
    public AffectRes setAlias(String databaseName, String collectionName, String aliasName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "alias/set");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\",\"alias\":\"%s\"}", databaseName, collectionName, aliasName);
        JsonNode jsonNode = this.post(url, body, false);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes deleteAlias(String databaseName, String aliasName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "alias/delete");
        String body = String.format("{\"database\":\"%s\",\"alias\":\"%s\"}", databaseName, aliasName);
        JsonNode jsonNode = this.post(url, body, false);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes upsertDocument(InsertParamInner param, boolean ai) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "document/upsert");
        JsonNode jsonNode = this.post(url, param.toString(), ai);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public List<Document> queryDocument(QueryParamInner param, boolean ai) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "document/query");
        JsonNode jsonNode = this.post(url, param.toString(), ai);
        JsonNode docsNode = jsonNode.get("documents");
        ArrayList<Document> dosc = new ArrayList<Document>();
        if (docsNode == null) {
            return dosc;
        }
        try {
            Iterator iterator = docsNode.elements();
            while (iterator.hasNext()) {
                JsonNode node = (JsonNode)iterator.next();
                Document doc = this.node2Doc(node);
                dosc.add(doc);
            }
            return dosc;
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from query error: can't parse documents=%s", docsNode));
        }
    }

    @Override
    public SearchRes searchDocument(SearchParamInner param, DataBaseTypeEnum dbType) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "document/search");
        if (DataBaseTypeEnum.isAIDataBase(dbType)) {
            url = String.format("%s/%s", this.connectParam.getUrl(), "ai/documentSet/search");
        }
        JsonNode jsonNode = this.post(url, param.toString(), false);
        JsonNode multiDocsNode = jsonNode.get("documents");
        int code = 0;
        if (jsonNode.get("code") != null) {
            code = jsonNode.get("code").asInt();
        }
        String msg = "";
        if (jsonNode.get("msg") != null) {
            msg = jsonNode.get("msg").asText();
        }
        String warning = "";
        if (jsonNode.get("warning") != null) {
            warning = jsonNode.get("warning").asText();
        }
        if (multiDocsNode == null) {
            return new SearchRes(code, msg, warning, Collections.emptyList());
        }
        try {
            ArrayList multiDosc = new ArrayList();
            Iterator multiIter = multiDocsNode.elements();
            while (multiIter.hasNext()) {
                JsonNode docNode = (JsonNode)multiIter.next();
                Iterator iter = docNode.elements();
                ArrayList<Document> docs = new ArrayList<Document>();
                while (iter.hasNext()) {
                    JsonNode node = (JsonNode)iter.next();
                    Document doc = this.node2Doc(node);
                    docs.add(doc);
                }
                multiDosc.add(docs);
            }
            return new SearchRes(code, msg, warning, Collections.unmodifiableList(multiDosc));
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from search error: can't parse documents=%s", multiDocsNode));
        }
    }

    @Override
    public HybridSearchRes hybridSearchDocument(HybridSearchParamInner param, boolean ai) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "document/hybridSearch");
        JsonNode jsonNode = this.post(url, param.toString(), ai);
        JsonNode multiDocsNode = jsonNode.get("documents");
        int code = 0;
        if (jsonNode.get("code") != null) {
            code = jsonNode.get("code").asInt();
        }
        String msg = "";
        if (jsonNode.get("msg") != null) {
            msg = jsonNode.get("msg").asText();
        }
        String warning = "";
        if (jsonNode.get("warning") != null) {
            warning = jsonNode.get("warning").asText();
        }
        if (multiDocsNode == null) {
            return new HybridSearchRes(code, msg, warning, Collections.emptyList());
        }
        try {
            ArrayList multiDosc = new ArrayList();
            Iterator multiIter = multiDocsNode.elements();
            while (multiIter.hasNext()) {
                JsonNode docNode = (JsonNode)multiIter.next();
                Iterator iter = docNode.elements();
                ArrayList<Document> docs = new ArrayList<Document>();
                while (iter.hasNext()) {
                    JsonNode node = (JsonNode)iter.next();
                    Document doc = this.node2Doc(node);
                    docs.add(doc);
                }
                multiDosc.add(docs);
            }
            if (!param.getSearch().getIsArrayParam().booleanValue()) {
                return new HybridSearchRes(code, msg, warning, Collections.unmodifiableList((List)multiDosc.get(0)));
            }
            return new HybridSearchRes(code, msg, warning, Collections.unmodifiableList(multiDosc));
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from hybrid search error: can't parse documents=%s", multiDocsNode));
        }
    }

    @Override
    public AffectRes deleteDocument(DeleteParamInner param) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "document/delete");
        JsonNode jsonNode = this.post(url, param.toString(), false);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes updateDocument(UpdateParamInner param, boolean ai) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "document/update");
        JsonNode jsonNode = this.post(url, param.toString(), ai);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public BaseRes countDocument(QueryCountParamInner param, boolean ai) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "document/count");
        JsonNode jsonNode = this.post(url, param.toString(), ai);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public BaseRes modifyVectorIndex(ModifyIndexParamInner param, boolean ai) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "index/modifyVectorIndex");
        JsonNode jsonNode = this.post(url, param.toString(), ai);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public BaseRes rebuildIndex(RebuildIndexParamInner param) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "index/rebuild");
        JsonNode jsonNode = this.post(url, param.toString(), false);
        return JsonUtils.parseObject(jsonNode.toString(), BaseRes.class);
    }

    @Override
    public BaseRes rebuildAIIndex(RebuildIndexParamInner param) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/index/rebuild");
        JsonNode jsonNode = this.post(url, param.toString(), true);
        return JsonUtils.parseObject(jsonNode.toString(), BaseRes.class);
    }

    @Override
    public BaseRes addIndex(AddIndexParamInner addIndexParamInner) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "index/add");
        JsonNode jsonNode = this.post(url, addIndexParamInner.toString(), true);
        return JsonUtils.parseObject(jsonNode.toString(), BaseRes.class);
    }

    @Override
    public synchronized void close() {
        if (this.client != null) {
            this.client.dispatcher().executorService().shutdown();
        }
    }

    @Override
    public AffectRes setAIAlias(String databaseName, String collectionName, String aliasName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/alias/set");
        String body = String.format("{\"database\":\"%s\",\"collectionView\":\"%s\",\"alias\":\"%s\"}", databaseName, collectionName, aliasName);
        JsonNode jsonNode = this.post(url, body, true);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes deleteAIAlias(String databaseName, String aliasName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/alias/delete");
        String body = String.format("{\"database\":\"%s\",\"alias\":\"%s\"}", databaseName, aliasName);
        JsonNode jsonNode = this.post(url, body, true);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public List<CollectionView> listCollectionView(String databaseName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/collectionView/list");
        JsonNode jsonNode = this.post(url, String.format("{\"database\":\"%s\"}", databaseName), true);
        JsonNode closJson = jsonNode.get("collectionViews");
        if (closJson == null) {
            return new ArrayList<CollectionView>();
        }
        return JsonUtils.collectionDeserializer(closJson.toString(), new TypeReference<List<CollectionView>>(){});
    }

    @Override
    public CollectionView describeCollectionView(String databaseName, String collectionName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/collectionView/describe");
        String body = String.format("{\"database\":\"%s\",\"collectionView\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body, true);
        JsonNode dbsJson = jsonNode.get("collectionView");
        if (dbsJson == null) {
            return null;
        }
        return JsonUtils.collectionDeserializer(dbsJson.toString(), new TypeReference<CollectionView>(){});
    }

    @Override
    public AffectRes dropCollectionView(String databaseName, String collectionName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/collectionView/drop");
        String body = String.format("{\"database\":\"%s\",\"collectionView\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body, true);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public List<DocumentSet> queryAIDocument(CollectionViewQueryParamInner queryParamInner) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/documentSet/query");
        JsonNode jsonNode = this.post(url, queryParamInner.toString(), true);
        JsonNode docsNode = jsonNode.get("documentSets");
        ArrayList<DocumentSet> dosc = new ArrayList<DocumentSet>();
        if (docsNode == null) {
            return dosc;
        }
        try {
            Iterator iterator = docsNode.elements();
            while (iterator.hasNext()) {
                JsonNode node = (JsonNode)iterator.next();
                DocumentSet doc = this.node2DocmentSet(node);
                dosc.add(doc);
            }
            return dosc;
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from query error: can't parse documents=%s", docsNode));
        }
    }

    @Override
    public AffectRes deleteAIDocument(CollectionViewDeleteParamInner deleteParamInner) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/documentSet/delete");
        JsonNode jsonNode = this.post(url, deleteParamInner.toString(), true);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public SearchContentRes searchAIDocument(SearchDocParamInner searchDocParamInner) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/documentSet/search");
        JsonNode jsonNode = this.post(url, searchDocParamInner.toString(), true);
        JsonNode multiDocsNode = jsonNode.get("documents");
        int code = 0;
        if (jsonNode.get("code") != null) {
            code = jsonNode.get("code").asInt();
        }
        String msg = "";
        if (jsonNode.get("msg") != null) {
            msg = jsonNode.get("msg").asText();
        }
        String warning = "";
        if (jsonNode.get("warning") != null) {
            warning = jsonNode.get("warning").asText();
        }
        if (multiDocsNode == null) {
            return new SearchContentRes(code, msg, warning, Collections.emptyList());
        }
        try {
            ArrayList<SearchContentInfo> multiDosc = new ArrayList<SearchContentInfo>();
            Iterator multiIter = multiDocsNode.elements();
            while (multiIter.hasNext()) {
                JsonNode docNode = (JsonNode)multiIter.next();
                SearchContentInfo doc = this.node2SearchDoc(docNode);
                multiDosc.add(doc);
            }
            return new SearchContentRes(code, msg, warning, multiDosc);
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from search error: can't parse documents=%s", multiDocsNode));
        }
    }

    @Override
    public AffectRes updateAIDocument(CollectionViewUpdateParamInner updateParamInner) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/documentSet/update");
        JsonNode jsonNode = this.post(url, updateParamInner.toString(), true);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    public UploadUrlRes getUploadUrl(String databaseName, String collectionViewName, LoadAndSplitTextParam loadAndSplitTextParam, String fileName) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/documentSet/uploadUrl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("database", databaseName);
        params.put("collectionView", collectionViewName);
        if (loadAndSplitTextParam.getDocumentSetName() != null) {
            params.put("documentSetName", loadAndSplitTextParam.getDocumentSetName());
        } else if (fileName != null) {
            params.put("documentSetName", fileName);
        }
        if (loadAndSplitTextParam.getParsingProcess() != null) {
            params.put("parsingProcess", loadAndSplitTextParam.getParsingProcess());
        }
        if (loadAndSplitTextParam.getByteLength() != null) {
            params.put("byteLength", loadAndSplitTextParam.getByteLength());
        }
        String body = JsonUtils.toJsonString(params);
        JsonNode jsonNode = this.post(url, body, true);
        return JsonUtils.parseObject(jsonNode.toString(), UploadUrlRes.class);
    }

    public CollectionUploadUrlRes getCollectionUploadUrl(String databaseName, String collection, UploadFileParam loadAndSplitTextParam) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/document/uploadUrl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("database", databaseName);
        params.put("collection", collection);
        if (loadAndSplitTextParam.getFileName() != null) {
            params.put("fileName", loadAndSplitTextParam.getFileName());
        }
        if (loadAndSplitTextParam.getParsingProcess() != null) {
            params.put("parsingProcess", loadAndSplitTextParam.getParsingProcess());
        }
        if (loadAndSplitTextParam.getSplitterProcess() != null) {
            params.put("splitterPreprocess", loadAndSplitTextParam.getSplitterProcess());
        }
        if (loadAndSplitTextParam.getEmbeddingModel() != null) {
            params.put("embeddingModel", loadAndSplitTextParam.getEmbeddingModel());
        }
        if (loadAndSplitTextParam.getFieldMappings() != null) {
            params.put("fieldMappings", loadAndSplitTextParam.getFieldMappings());
        }
        if (loadAndSplitTextParam.getByteLength() != null) {
            params.put("byteLength", loadAndSplitTextParam.getByteLength());
        }
        String body = JsonUtils.toJsonString(params);
        JsonNode jsonNode = this.post(url, body, true);
        return JsonUtils.parseObject(jsonNode.toString(), CollectionUploadUrlRes.class);
    }

    @Override
    public void collectionUpload(String databaseName, String collectionName, UploadFileParam loadAndSplitTextParam, Map<String, Object> metaDataMap) throws Exception {
        File file = null;
        if (loadAndSplitTextParam.getLocalFilePath() != null) {
            file = new File(loadAndSplitTextParam.getLocalFilePath());
            if (!file.exists() || !file.isFile()) {
                throw new VectorDBException("file is not existed");
            }
            if (file.length() <= 0L) {
                throw new VectorDBException("file is empty");
            }
            loadAndSplitTextParam.setByteLength(file.length());
        } else if (loadAndSplitTextParam.getFileInputStream() != null) {
            if (loadAndSplitTextParam.getFileName() == null || loadAndSplitTextParam.getInputStreamSize() == null) {
                throw new VectorDBException("use input stream, fileName and inputStreamSize  can not be null");
            }
            loadAndSplitTextParam.setByteLength(loadAndSplitTextParam.getInputStreamSize());
        }
        CollectionUploadUrlRes uploadUrlRes = this.getCollectionUploadUrl(databaseName, collectionName, loadAndSplitTextParam);
        if (Code.isFailed(uploadUrlRes.getCode()) || uploadUrlRes.getCredentials() == null || uploadUrlRes.getCredentials().getTmpSecretId().equals("") || uploadUrlRes.getUploadCondition() == null || uploadUrlRes.getUploadCondition().getMaxSupportContentLength() == 0) {
            String msg = StringUtils.isNotBlank((CharSequence)uploadUrlRes.getMsg()) ? ", " + uploadUrlRes.getMsg() : "";
            throw new VectorDBException("get file upload url failed" + msg);
        }
        String filePath = loadAndSplitTextParam.getLocalFilePath();
        int maxLength = uploadUrlRes.getUploadCondition().getMaxSupportContentLength();
        if (file != null && file.length() > (long)maxLength) {
            throw new ParamException(String.format("%s file is too large, max size is %d bytes", filePath, maxLength));
        }
        String uploadPath = uploadUrlRes.getUploadPath();
        String bucket = uploadUrlRes.getCosBucket();
        String region = uploadUrlRes.getCosRegion();
        BasicSessionCredentials cred = new BasicSessionCredentials(uploadUrlRes.getCredentials().getTmpSecretId(), uploadUrlRes.getCredentials().getTmpSecretKey(), uploadUrlRes.getCredentials().getToken());
        ClientConfig cosClientConfig = new ClientConfig(new Region(region));
        String cosEndPoint = uploadUrlRes.getCosEndpoint().split("\\.", 2)[1];
        cosClientConfig.setEndpointBuilder((EndpointBuilder)new CosEndpointBuilder(cosEndPoint));
        COSClient cosClient = new COSClient((COSCredentials)cred, cosClientConfig);
        PutObjectRequest putObjectRequest = null;
        ObjectMetadata metadata = new ObjectMetadata();
        if (file != null && file.exists()) {
            putObjectRequest = new PutObjectRequest(bucket, uploadPath, file);
        } else if (loadAndSplitTextParam.getFileInputStream() != null) {
            metadata.setContentLength(loadAndSplitTextParam.getInputStreamSize().longValue());
            putObjectRequest = new PutObjectRequest(bucket, uploadPath, loadAndSplitTextParam.getFileInputStream(), null);
        } else {
            throw new VectorDBException("file or inputStream not exist ");
        }
        if (metaDataMap == null || metaDataMap.isEmpty()) {
            metaDataMap = new HashMap<String, Object>();
        }
        String metaJson = URLEncoder.encode(Base64.getEncoder().encodeToString(JsonUtils.toJsonString(metaDataMap).getBytes(StandardCharsets.UTF_8)), String.valueOf(StandardCharsets.UTF_8));
        metadata.addUserMetadata("data", metaJson);
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (loadAndSplitTextParam.getSplitterProcess() != null) {
            config.put("appendTitleToChunk", loadAndSplitTextParam.getSplitterProcess().isAppendTitleToChunk());
            config.put("appendKeywordsToChunk", loadAndSplitTextParam.getSplitterProcess().isAppendKeywordsToChunk());
            if (loadAndSplitTextParam.getSplitterProcess().getChunkSplitter() != null) {
                config.put("chunkSplitter", loadAndSplitTextParam.getSplitterProcess().getChunkSplitter());
            }
        }
        if (loadAndSplitTextParam.getParsingProcess() != null) {
            config.put("parsingProcess", loadAndSplitTextParam.getParsingProcess());
        }
        if (config.size() > 0) {
            metadata.addUserMetadata("config", URLEncoder.encode(Base64.getEncoder().encodeToString(JsonUtils.toJsonString(config).getBytes(StandardCharsets.UTF_8)), String.valueOf(StandardCharsets.UTF_8)));
        }
        if (JsonUtils.toJsonString(metadata).length() > 2048) {
            throw new VectorDBException("cos header for param MetaData is too large, it can not be more than 2k");
        }
        putObjectRequest.withMetadata(metadata);
        putObjectRequest.withKey(uploadPath);
        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        logger.debug("upload file, response:%s", (Object)JsonUtils.toJsonString(putObjectResult));
        cosClient.shutdown();
    }

    @Override
    public void upload(String databaseName, String collectionViewName, LoadAndSplitTextParam loadAndSplitTextParam, Map<String, Object> metaDataMap) throws Exception {
        File file = null;
        String fileName = "";
        String fileType = "";
        if (loadAndSplitTextParam.getLocalFilePath() != null) {
            file = new File(loadAndSplitTextParam.getLocalFilePath());
            if (!file.exists() || !file.isFile()) {
                throw new VectorDBException("file is not existed");
            }
            if (file.length() <= 0L) {
                throw new VectorDBException("file is empty");
            }
            fileName = file.getName();
            fileType = FileUtils.getFileType(file);
            loadAndSplitTextParam.setByteLength(file.length());
        } else if (loadAndSplitTextParam.getFileInputStream() != null) {
            if (loadAndSplitTextParam.getDocumentSetName() == null || loadAndSplitTextParam.getFileType() == null || loadAndSplitTextParam.getInputStreamSize() == null) {
                throw new VectorDBException("use input stream, documentSetName\u3001inputStreamSize and file type can not be null");
            }
            fileType = loadAndSplitTextParam.getFileType();
            loadAndSplitTextParam.setByteLength(loadAndSplitTextParam.getInputStreamSize());
        }
        UploadUrlRes uploadUrlRes = this.getUploadUrl(databaseName, collectionViewName, loadAndSplitTextParam, fileName);
        if (Code.isFailed(uploadUrlRes.getCode()) || uploadUrlRes.getCredentials() == null || uploadUrlRes.getCredentials().getTmpSecretId().equals("") || uploadUrlRes.getUploadCondition() == null || uploadUrlRes.getUploadCondition().getMaxSupportContentLength() == 0) {
            String msg = StringUtils.isNotBlank((CharSequence)uploadUrlRes.getMsg()) ? ", " + uploadUrlRes.getMsg() : "";
            throw new VectorDBException("get file upload url failed" + msg);
        }
        String filePath = loadAndSplitTextParam.getLocalFilePath();
        int maxLength = uploadUrlRes.getUploadCondition().getMaxSupportContentLength();
        if (file != null && file.length() > (long)maxLength) {
            throw new ParamException(String.format("%s file is too large, max size is %d bytes", filePath, maxLength));
        }
        String uploadPath = uploadUrlRes.getUploadPath();
        String bucket = uploadUrlRes.getCosBucket();
        String region = uploadUrlRes.getCosRegion();
        BasicSessionCredentials cred = new BasicSessionCredentials(uploadUrlRes.getCredentials().getTmpSecretId(), uploadUrlRes.getCredentials().getTmpSecretKey(), uploadUrlRes.getCredentials().getToken());
        ClientConfig cosClientConfig = new ClientConfig(new Region(region));
        String cosEndPoint = uploadUrlRes.getCosEndpoint().split("\\.", 2)[1];
        cosClientConfig.setEndpointBuilder((EndpointBuilder)new CosEndpointBuilder(cosEndPoint));
        COSClient cosClient = new COSClient((COSCredentials)cred, cosClientConfig);
        PutObjectRequest putObjectRequest = null;
        ObjectMetadata metadata = new ObjectMetadata();
        if (file != null && file.exists()) {
            putObjectRequest = new PutObjectRequest(bucket, uploadPath, file);
        } else if (loadAndSplitTextParam.getFileInputStream() != null) {
            metadata.setContentLength(loadAndSplitTextParam.getInputStreamSize().longValue());
            putObjectRequest = new PutObjectRequest(bucket, uploadPath, loadAndSplitTextParam.getFileInputStream(), null);
        } else {
            throw new VectorDBException("file or inputStream not exist ");
        }
        if (!Arrays.asList(FileType.MD, FileType.WORD).contains(fileType) && Objects.nonNull(loadAndSplitTextParam.getSplitterProcess()) && StringUtils.isNotEmpty((CharSequence)loadAndSplitTextParam.getSplitterProcess().getChunkSplitter())) {
            logger.warn("only markdown files are allowed to use chunkSplitter");
        }
        metadata.addUserMetadata("fileType", fileType);
        metadata.addUserMetadata("id", uploadUrlRes.getDocumentSetId());
        if (metaDataMap == null || metaDataMap.isEmpty()) {
            metaDataMap = new HashMap<String, Object>();
        }
        String metaJson = URLEncoder.encode(Base64.getEncoder().encodeToString(JsonUtils.toJsonString(metaDataMap).getBytes(StandardCharsets.UTF_8)), String.valueOf(StandardCharsets.UTF_8));
        metadata.addUserMetadata("data", metaJson);
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (loadAndSplitTextParam.getSplitterProcess() != null) {
            config.put("appendTitleToChunk", loadAndSplitTextParam.getSplitterProcess().isAppendTitleToChunk());
            config.put("appendKeywordsToChunk", loadAndSplitTextParam.getSplitterProcess().isAppendKeywordsToChunk());
            if (loadAndSplitTextParam.getSplitterProcess().getChunkSplitter() != null) {
                config.put("chunkSplitter", loadAndSplitTextParam.getSplitterProcess().getChunkSplitter());
            }
        }
        if (loadAndSplitTextParam.getParsingProcess() != null) {
            config.put("parsingProcess", loadAndSplitTextParam.getParsingProcess());
        }
        if (config.size() > 0) {
            metadata.addUserMetadata("config", URLEncoder.encode(Base64.getEncoder().encodeToString(JsonUtils.toJsonString(config).getBytes(StandardCharsets.UTF_8)), String.valueOf(StandardCharsets.UTF_8)));
        }
        if (JsonUtils.toJsonString(metadata).length() > 2048) {
            throw new VectorDBException("cos header for param MetaData is too large, it can not be more than 2k");
        }
        putObjectRequest.withMetadata(metadata);
        putObjectRequest.withKey(uploadPath);
        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        logger.debug("upload file, response:%s", (Object)JsonUtils.toJsonString(putObjectResult));
        cosClient.shutdown();
    }

    @Override
    public GetDocumentSetRes getFile(String databaseName, String collectionName, String documentSetName, String documentSetId) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/documentSet/get");
        String body = String.format("{\"database\":\"%s\",\"collectionView\":\"%s\",\"documentSetName\":\"%s\",\"documentSetId\":\"%s\"}", databaseName, collectionName, documentSetName, documentSetId);
        JsonNode jsonNode = this.post(url, body, true);
        int code = 0;
        if (jsonNode.get("code") != null) {
            code = jsonNode.get("code").asInt();
        }
        String msg = "";
        if (jsonNode.get("msg") != null) {
            msg = jsonNode.get("msg").asText();
        }
        String warning = "";
        if (jsonNode.get("warning") != null) {
            warning = jsonNode.get("warning").asText();
        }
        int count = 0;
        if (jsonNode.get("count") != null) {
            count = jsonNode.get("count").asInt();
        }
        GetDocumentSetRes res = new GetDocumentSetRes(code, msg, warning, count);
        JsonNode multiDocsNode = jsonNode.get("documentSet");
        if (multiDocsNode == null) {
            return res;
        }
        try {
            res.setDocumentSet(this.node2DocumentFileContent(multiDocsNode));
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from search error: can't parse documents=%s", multiDocsNode));
        }
        return res;
    }

    @Override
    public GetChunksRes getChunks(String databaseName, String collectionName, String documentSetName, String documentSetId, Integer limit, Integer offset) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/documentSet/getChunks");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("database", databaseName);
        params.put("collectionView", collectionName);
        if (documentSetName != null) {
            params.put("documentSetName", documentSetName);
        }
        if (documentSetId != null) {
            params.put("documentSetId", documentSetId);
        }
        if (limit != null) {
            params.put("limit", limit);
        }
        if (offset != null) {
            params.put("offset", offset);
        }
        String body = JsonUtils.toJsonString(params);
        JsonNode jsonNode = this.post(url, body, true);
        return JsonUtils.collectionDeserializer(jsonNode.toString(), new TypeReference<GetChunksRes>(){});
    }

    @Override
    public BaseRes createUser(UserCreateParam userCreateParam) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "user/create");
        JsonNode jsonNode = this.post(url, userCreateParam.toString(), false);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public BaseRes grantToUser(UserGrantParam param) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "user/grant");
        JsonNode jsonNode = this.post(url, param.toString(), false);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public BaseRes revokeFromUser(UserRevokeParam param) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "user/revoke");
        JsonNode jsonNode = this.post(url, param.toString(), false);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public UserDescribeRes describeUser(UserDescribeParam userDescribeParam) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "user/describe");
        JsonNode jsonNode = this.post(url, userDescribeParam.toString(), false);
        return JsonUtils.parseObject(jsonNode.toString(), UserDescribeRes.class);
    }

    @Override
    public UserListRes listUser() {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "user/list");
        JsonNode jsonNode = this.get(url, false);
        return JsonUtils.parseObject(jsonNode.toString(), UserListRes.class);
    }

    @Override
    public BaseRes dropUser(UserDropParam userDropParam) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "user/drop");
        JsonNode jsonNode = this.post(url, userDropParam.toString(), false);
        return JsonUtils.parseObject(jsonNode.toString(), BaseRes.class);
    }

    @Override
    public BaseRes changeUserPassword(UserChangePasswordParam build) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "user/changePassword");
        JsonNode jsonNode = this.post(url, build.toString(), false);
        return JsonUtils.parseObject(jsonNode.toString(), BaseRes.class);
    }

    @Override
    public GetImageUrlRes GetImageUrl(GetImageUrlParamInner param) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "ai/document/getImageUrl");
        JsonNode jsonNode = this.post(url, JsonUtils.toJsonString(param), false);
        return JsonUtils.parseObject(jsonNode.toString(), GetImageUrlRes.class);
    }

    @Override
    public BaseRes dropIndex(DropIndexParamInner dropIndexParamInner) {
        String url = String.format("%s/%s", this.connectParam.getUrl(), "index/drop");
        JsonNode jsonNode = this.post(url, JsonUtils.toJsonString(dropIndexParamInner), false);
        return JsonUtils.parseObject(jsonNode.toString(), BaseRes.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode get(String url, boolean ai) {
        Request request = new Request.Builder().url(url).headers(this.get_headers(ai)).build();
        try (Response response = this.client.newCall(request).execute();){
            JsonNode jsonNode = this.parseResponse(response);
            return jsonNode;
        }
        catch (IOException ex) {
            throw new VectorDBException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode post(String url, String json, boolean ai) {
        logger.debug("Query {}, body={}", (Object)url, (Object)json);
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        Request request = new Request.Builder().url(url).headers(this.get_headers(ai)).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            JsonNode jsonNode = this.parseResponse(response);
            return jsonNode;
        }
        catch (IOException ex) {
            logger.error("VectorDBServer IOException", (Throwable)ex);
            throw new VectorDBException(String.format("VectorDBServer IOException: %s", ex.getMessage()));
        }
    }

    private Headers get_headers(boolean ai) {
        Headers.Builder headersTmp = new Headers.Builder();
        String backend = "vdb";
        if (ai) {
            backend = "ai";
        }
        headersTmp.add("backend-service", backend);
        headersTmp.add("Authorization", this.headersBuilder.get("Authorization"));
        logger.debug("Backend: {}", (Object)backend);
        return this.headersBuilder.build();
    }

    private JsonNode parseResponse(Response response) throws IOException {
        ResponseBody resBody = response.body();
        if (resBody == null) {
            throw new VectorDBException(String.format("VectorDBServer error: ResponseBody null, http code=%s, message=%s", response.code(), response.message()));
        }
        String resStr = resBody.string();
        logger.debug("Query {}, code={}, msg={}, result={}", new Object[]{response.request().url(), response.code(), response.message(), resStr});
        if (StringUtils.isEmpty((CharSequence)resStr)) {
            throw new VectorDBException(String.format("VectorDBServer error: ResponseBody empty, http code=%s, message=%s", response.code(), response.message()));
        }
        if (!response.isSuccessful()) {
            throw new VectorDBException(String.format("VectorDBServer error: not Successful, http code=%s, message=%s, result=%s", response.code(), response.message(), resStr));
        }
        JsonNode jsonNode = JsonUtils.parseToJsonNode(resStr);
        int code = jsonNode.get("code").asInt();
        if (code != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: not Successful, body code=%s, message=%s", code, jsonNode.get("msg").asText()));
        }
        return jsonNode;
    }

    private SearchContentInfo node2SearchDoc(JsonNode node) throws JsonProcessingException {
        SearchContentInfo.Builder builder = SearchContentInfo.newBuilder();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"score", (CharSequence)name)) {
                builder.withScore(ele.asDouble());
                continue;
            }
            if (StringUtils.equals((CharSequence)"data", (CharSequence)name)) {
                builder.withSearchContentInfo(JsonUtils.parseObject(ele.toString(), ContentInfo.class));
                continue;
            }
            if (!StringUtils.equals((CharSequence)"documentSet", (CharSequence)name)) continue;
            builder.withSearchDocumentSetInfo(this.node2SearchDocumentSet(ele));
        }
        return builder.build();
    }

    private SearchDocumentSetInfo node2SearchDocumentSet(JsonNode node) throws JsonProcessingException {
        SearchDocumentSetInfo.Builder builder = SearchDocumentSetInfo.newBuilder();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"documentSetName", (CharSequence)name)) {
                builder.withDocumentSetName(ele.toString());
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSetId", (CharSequence)name)) {
                builder.withDocumentSetId(ele.toString());
                continue;
            }
            if (ele.isInt()) {
                builder.addDocField(new DocField(name, ele.asInt()));
                continue;
            }
            if (ele.isLong()) {
                builder.addDocField(new DocField(name, ele.asLong()));
                continue;
            }
            if (ele.isArray()) {
                List values = JsonUtils.parseObject(ele.toString(), List.class);
                builder.addDocField(new DocField(name, values));
                continue;
            }
            builder.addDocField(new DocField(name, ele.asText()));
        }
        return builder.build();
    }

    private Document node2Doc(JsonNode node) throws JsonProcessingException {
        Document.Builder builder = Document.newBuilder();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"id", (CharSequence)name)) {
                builder.withId(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"vector", (CharSequence)name)) {
                List vector = JsonUtils.parseObject(ele.toString(), List.class);
                builder.withVector(vector);
                continue;
            }
            if (StringUtils.equals((CharSequence)"sparse_vector", (CharSequence)name)) {
                builder.withSparseVectorList(JsonUtils.parseObject(ele.toString(), List.class));
                continue;
            }
            if (StringUtils.equals((CharSequence)"doc", (CharSequence)name)) {
                builder.withDoc(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"score", (CharSequence)name)) {
                builder.withScore(ele.asDouble());
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSet", (CharSequence)name)) {
                builder.addFilterField(new DocField(name, this.node2Doc(ele)));
                continue;
            }
            if (ele.isInt()) {
                builder.addFilterField(new DocField(name, ele.asInt()));
                continue;
            }
            if (ele.isLong()) {
                builder.addFilterField(new DocField(name, ele.asLong()));
                continue;
            }
            if (ele.isArray()) {
                List values = JsonUtils.parseObject(ele.toString(), List.class);
                builder.addFilterField(new DocField(name, values));
                continue;
            }
            if (ele.isObject()) {
                builder.addFilterField(new DocField(name, new JSONObject(ele.toString())));
                continue;
            }
            if (ele.isDouble() || ele.isFloat()) {
                builder.addFilterField(new DocField(name, ele.asDouble()));
                continue;
            }
            builder.addFilterField(new DocField(name, ele.asText()));
        }
        return builder.build();
    }

    private DocumentSet node2DocmentSet(JsonNode node) throws JsonProcessingException {
        DocumentSet.Builder builder = DocumentSet.newBuilder();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"documentSetId", (CharSequence)name)) {
                builder.withDocumentSetId(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSetInfo", (CharSequence)name)) {
                DocumentSetInfo documentSetInfo = JsonUtils.parseObject(ele.toString(), DocumentSetInfo.class);
                builder.withDocumentSetInfo(documentSetInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSetName", (CharSequence)name)) {
                builder.withDocumnetSetName(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"textPrefix", (CharSequence)name)) {
                builder.withTextPrefix(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"splitterPreprocess", (CharSequence)name)) {
                SplitterPreprocessParams splitterPreprocess = JsonUtils.parseObject(ele.toString(), SplitterPreprocessParams.class);
                builder.withSplitProcess(splitterPreprocess);
                continue;
            }
            if (StringUtils.equals((CharSequence)"parsingProcess", (CharSequence)name)) {
                ParsingProcessParam parsingProcessParam = JsonUtils.parseObject(ele.toString(), ParsingProcessParam.class);
                builder.withParsingProcess(parsingProcessParam);
                continue;
            }
            if (ele.isInt()) {
                builder.addFilterField(new DocField(name, ele.asInt()));
                continue;
            }
            if (ele.isLong()) {
                builder.addFilterField(new DocField(name, ele.asLong()));
                continue;
            }
            if (ele.isArray()) {
                List values = JsonUtils.parseObject(ele.toString(), List.class);
                builder.addFilterField(new DocField(name, values));
                continue;
            }
            if (ele.isDouble() || ele.isFloat()) {
                builder.addFilterField(new DocField(name, ele.asDouble()));
                continue;
            }
            if (ele.isObject()) {
                builder.addFilterField(new DocField(name, new JSONObject(ele.toString())));
                continue;
            }
            builder.addFilterField(new DocField(name, ele.asText()));
        }
        return builder.build();
    }

    private DocumentFileContent node2DocumentFileContent(JsonNode node) throws JsonProcessingException {
        DocumentFileContent documentFileContent = new DocumentFileContent();
        documentFileContent.setDocFields(new ArrayList<DocField>());
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"documentSetId", (CharSequence)name)) {
                documentFileContent.setDocumentSetId(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSetInfo", (CharSequence)name)) {
                DocumentSetInfo documentSetInfo = JsonUtils.parseObject(ele.toString(), DocumentSetInfo.class);
                documentFileContent.setDocumentSetInfo(documentSetInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSetName", (CharSequence)name)) {
                documentFileContent.setDocumentSetName(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"text", (CharSequence)name)) {
                documentFileContent.setText(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"splitterPreprocess", (CharSequence)name)) {
                SplitterPreprocessParams splitterPreprocess = JsonUtils.parseObject(ele.toString(), SplitterPreprocessParams.class);
                documentFileContent.setSplitterPreprocess(splitterPreprocess);
                continue;
            }
            if (ele.isInt()) {
                documentFileContent.addFilterField(new DocField(name, ele.asInt()));
                continue;
            }
            if (ele.isLong()) {
                documentFileContent.addFilterField(new DocField(name, ele.asLong()));
                continue;
            }
            if (ele.isArray()) {
                List values = JsonUtils.parseObject(ele.toString(), List.class);
                documentFileContent.addFilterField(new DocField(name, values));
                continue;
            }
            documentFileContent.addFilterField(new DocField(name, ele.asText()));
        }
        return documentFileContent;
    }
}

