/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.service.param;

import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.internal.BucketNameUtils;
import com.qcloud.cos.internal.UrlComponentUtils;

public class CosEndpointBuilder
implements EndpointBuilder {
    private String cosEndpoint;
    private String cosGetServiceEndpoint = "service.cos.tencentcos.cn";

    public CosEndpointBuilder(String endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint must not be null");
        }
        while (endpoint.startsWith(".")) {
            endpoint = endpoint.substring(1);
        }
        UrlComponentUtils.validateEndPointSuffix((String)endpoint);
        this.cosEndpoint = endpoint.trim();
    }

    public String buildGeneralApiEndpoint(String bucketName) {
        BucketNameUtils.validateBucketName((String)bucketName);
        return String.format("%s.%s", bucketName, this.cosEndpoint);
    }

    public String buildGetServiceApiEndpoint() {
        return this.cosGetServiceEndpoint;
    }
}

