/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dex;

import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.util.CompareUtils;
import com.tencent.tinker.android.dex.util.HashCodeHelper;

public class AnnotationsDirectory
extends TableOfContents.Section.Item<AnnotationsDirectory> {
    public int classAnnotationsOffset;
    public int[][] fieldAnnotations;
    public int[][] methodAnnotations;
    public int[][] parameterAnnotations;

    public AnnotationsDirectory(int off, int classAnnotationsOffset, int[][] fieldAnnotations, int[][] methodAnnotations, int[][] parameterAnnotations) {
        super(off);
        this.classAnnotationsOffset = classAnnotationsOffset;
        this.fieldAnnotations = fieldAnnotations;
        this.methodAnnotations = methodAnnotations;
        this.parameterAnnotations = parameterAnnotations;
    }

    @Override
    public int compareTo(AnnotationsDirectory other) {
        int othMethodIdx;
        int methodIdx;
        int othAnnotationOffset;
        int annotationOffset;
        int i;
        if (this.classAnnotationsOffset != other.classAnnotationsOffset) {
            return CompareUtils.uCompare(this.classAnnotationsOffset, other.classAnnotationsOffset);
        }
        int fieldsSize = this.fieldAnnotations.length;
        int methodsSize = this.methodAnnotations.length;
        int parameterListSize = this.parameterAnnotations.length;
        int oFieldsSize = other.fieldAnnotations.length;
        int oMethodsSize = other.methodAnnotations.length;
        int oParameterListSize = other.parameterAnnotations.length;
        if (fieldsSize != oFieldsSize) {
            return CompareUtils.sCompare(fieldsSize, oFieldsSize);
        }
        if (methodsSize != oMethodsSize) {
            return CompareUtils.sCompare(methodsSize, oMethodsSize);
        }
        if (parameterListSize != oParameterListSize) {
            return CompareUtils.sCompare(parameterListSize, oParameterListSize);
        }
        for (i = 0; i < fieldsSize; ++i) {
            int fieldIdx = this.fieldAnnotations[i][0];
            annotationOffset = this.fieldAnnotations[i][1];
            int othFieldIdx = other.fieldAnnotations[i][0];
            othAnnotationOffset = other.fieldAnnotations[i][1];
            if (fieldIdx != othFieldIdx) {
                return CompareUtils.uCompare(fieldIdx, othFieldIdx);
            }
            if (annotationOffset == othAnnotationOffset) continue;
            return CompareUtils.sCompare(annotationOffset, othAnnotationOffset);
        }
        for (i = 0; i < methodsSize; ++i) {
            methodIdx = this.methodAnnotations[i][0];
            annotationOffset = this.methodAnnotations[i][1];
            othMethodIdx = other.methodAnnotations[i][0];
            othAnnotationOffset = other.methodAnnotations[i][1];
            if (methodIdx != othMethodIdx) {
                return CompareUtils.uCompare(methodIdx, othMethodIdx);
            }
            if (annotationOffset == othAnnotationOffset) continue;
            return CompareUtils.sCompare(annotationOffset, othAnnotationOffset);
        }
        for (i = 0; i < parameterListSize; ++i) {
            methodIdx = this.parameterAnnotations[i][0];
            annotationOffset = this.parameterAnnotations[i][1];
            othMethodIdx = other.parameterAnnotations[i][0];
            othAnnotationOffset = other.parameterAnnotations[i][1];
            if (methodIdx != othMethodIdx) {
                return CompareUtils.uCompare(methodIdx, othMethodIdx);
            }
            if (annotationOffset == othAnnotationOffset) continue;
            return CompareUtils.sCompare(annotationOffset, othAnnotationOffset);
        }
        return 0;
    }

    @Override
    public int hashCode() {
        return HashCodeHelper.hash(new Object[]{this.classAnnotationsOffset, this.fieldAnnotations, this.methodAnnotations, this.parameterAnnotations});
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationsDirectory)) {
            return false;
        }
        return this.compareTo((AnnotationsDirectory)obj) == 0;
    }

    @Override
    public int byteCountInDex() {
        return 4 * (4 + 2 * (this.fieldAnnotations.length + this.methodAnnotations.length + this.parameterAnnotations.length));
    }
}

