/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dex;

import com.tencent.tinker.android.dex.Annotation;
import com.tencent.tinker.android.dex.AnnotationSet;
import com.tencent.tinker.android.dex.AnnotationSetRefList;
import com.tencent.tinker.android.dex.AnnotationsDirectory;
import com.tencent.tinker.android.dex.CallSiteId;
import com.tencent.tinker.android.dex.ClassData;
import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Code;
import com.tencent.tinker.android.dex.DebugInfoItem;
import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dex.EncodedValue;
import com.tencent.tinker.android.dex.FieldId;
import com.tencent.tinker.android.dex.MethodHandle;
import com.tencent.tinker.android.dex.MethodId;
import com.tencent.tinker.android.dex.ProtoId;
import com.tencent.tinker.android.dex.StringData;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.TypeList;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.android.dex.util.FileUtils;
import com.tencent.tinker.android.dx.util.Hex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.zip.Adler32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class Dex {
    static final short[] EMPTY_SHORT_ARRAY = new short[0];
    private static final int CHECKSUM_OFFSET = 8;
    private static final int SIGNATURE_OFFSET = 12;
    private final TableOfContents tableOfContents;
    private final StringTable strings;
    private final TypeIndexToDescriptorIndexTable typeIds;
    private final TypeIndexToDescriptorTable typeNames;
    private final ProtoIdTable protoIds;
    private final FieldIdTable fieldIds;
    private final MethodIdTable methodIds;
    private final CallSiteIdTable callsiteIds;
    private final MethodHandleTable methodHandles;
    private final ClassDefTable classDefs;
    private ByteBuffer data;
    private int nextSectionStart;
    private byte[] signature;

    public Dex(byte[] data) throws IOException {
        this(ByteBuffer.wrap(data));
    }

    private Dex(ByteBuffer data) throws IOException {
        this.tableOfContents = new TableOfContents();
        this.strings = new StringTable();
        this.typeIds = new TypeIndexToDescriptorIndexTable();
        this.typeNames = new TypeIndexToDescriptorTable();
        this.protoIds = new ProtoIdTable();
        this.fieldIds = new FieldIdTable();
        this.methodIds = new MethodIdTable();
        this.callsiteIds = new CallSiteIdTable();
        this.methodHandles = new MethodHandleTable();
        this.classDefs = new ClassDefTable();
        this.nextSectionStart = 0;
        this.signature = null;
        this.data = data;
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.tableOfContents.readFrom(this);
    }

    public Dex(int byteCount) {
        this.tableOfContents = new TableOfContents();
        this.strings = new StringTable();
        this.typeIds = new TypeIndexToDescriptorIndexTable();
        this.typeNames = new TypeIndexToDescriptorTable();
        this.protoIds = new ProtoIdTable();
        this.fieldIds = new FieldIdTable();
        this.methodIds = new MethodIdTable();
        this.callsiteIds = new CallSiteIdTable();
        this.methodHandles = new MethodHandleTable();
        this.classDefs = new ClassDefTable();
        this.nextSectionStart = 0;
        this.signature = null;
        this.data = ByteBuffer.wrap(new byte[byteCount]);
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.tableOfContents.fileSize = byteCount;
    }

    public Dex(InputStream in) throws IOException {
        this.tableOfContents = new TableOfContents();
        this.strings = new StringTable();
        this.typeIds = new TypeIndexToDescriptorIndexTable();
        this.typeNames = new TypeIndexToDescriptorTable();
        this.protoIds = new ProtoIdTable();
        this.fieldIds = new FieldIdTable();
        this.methodIds = new MethodIdTable();
        this.callsiteIds = new CallSiteIdTable();
        this.methodHandles = new MethodHandleTable();
        this.classDefs = new ClassDefTable();
        this.nextSectionStart = 0;
        this.signature = null;
        this.loadFrom(in);
    }

    public Dex(InputStream in, int initSize) throws IOException {
        this.tableOfContents = new TableOfContents();
        this.strings = new StringTable();
        this.typeIds = new TypeIndexToDescriptorIndexTable();
        this.typeNames = new TypeIndexToDescriptorTable();
        this.protoIds = new ProtoIdTable();
        this.fieldIds = new FieldIdTable();
        this.methodIds = new MethodIdTable();
        this.callsiteIds = new CallSiteIdTable();
        this.methodHandles = new MethodHandleTable();
        this.classDefs = new ClassDefTable();
        this.nextSectionStart = 0;
        this.signature = null;
        this.loadFrom(in, initSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dex(File file) throws IOException {
        block26: {
            this.tableOfContents = new TableOfContents();
            this.strings = new StringTable();
            this.typeIds = new TypeIndexToDescriptorIndexTable();
            this.typeNames = new TypeIndexToDescriptorTable();
            this.protoIds = new ProtoIdTable();
            this.fieldIds = new FieldIdTable();
            this.methodIds = new MethodIdTable();
            this.callsiteIds = new CallSiteIdTable();
            this.methodHandles = new MethodHandleTable();
            this.classDefs = new ClassDefTable();
            this.nextSectionStart = 0;
            this.signature = null;
            if (file == null) {
                throw new IllegalArgumentException("file is null.");
            }
            if (FileUtils.hasArchiveSuffix(file.getName())) {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(file);
                    ZipEntry entry = zipFile.getEntry("classes.dex");
                    if (entry != null) {
                        try (InputStream inputStream = null;){
                            inputStream = zipFile.getInputStream(entry);
                            this.loadFrom(inputStream, (int)entry.getSize());
                            break block26;
                        }
                    }
                    throw new DexException("Expected classes.dex in " + file);
                }
                finally {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Exception entry) {}
                    }
                }
            }
            if (file.getName().endsWith(".dex")) {
                InputStream in = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(file));
                    this.loadFrom(in, (int)file.length());
                }
                catch (Exception e) {
                    throw new DexException(e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            throw new DexException("unknown output extension: " + file);
        }
    }

    private static void checkBounds(int index, int length) {
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("index:" + index + ", length=" + length);
        }
    }

    private void loadFrom(InputStream in) throws IOException {
        this.loadFrom(in, 0);
    }

    private void loadFrom(InputStream in, int initSize) throws IOException {
        byte[] rawData = FileUtils.readStream(in, initSize);
        this.data = ByteBuffer.wrap(rawData);
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.tableOfContents.readFrom(this);
    }

    public void writeTo(OutputStream out) throws IOException {
        byte[] rawData = this.data.array();
        out.write(rawData);
        out.flush();
    }

    public void writeTo(File dexOut) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(dexOut));
            this.writeTo(out);
        }
        catch (Exception e) {
            throw new DexException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public TableOfContents getTableOfContents() {
        return this.tableOfContents;
    }

    public Section openSection(int position) {
        if (position < 0 || position >= this.data.capacity()) {
            throw new IllegalArgumentException("position=" + position + " length=" + this.data.capacity());
        }
        ByteBuffer sectionData = this.data.duplicate();
        sectionData.order(ByteOrder.LITTLE_ENDIAN);
        sectionData.position(position);
        sectionData.limit(this.data.capacity());
        return new Section("temp-section", sectionData);
    }

    public Section openSection(TableOfContents.Section tocSec) {
        int position = tocSec.off;
        if (position < 0 || position >= this.data.capacity()) {
            throw new IllegalArgumentException("position=" + position + " length=" + this.data.capacity());
        }
        ByteBuffer sectionData = this.data.duplicate();
        sectionData.order(ByteOrder.LITTLE_ENDIAN);
        sectionData.position(position);
        sectionData.limit(position + tocSec.byteCount);
        return new Section("section", sectionData);
    }

    public Section appendSection(int maxByteCount, String name) {
        int limit = this.nextSectionStart + maxByteCount;
        ByteBuffer sectionData = this.data.duplicate();
        sectionData.order(ByteOrder.LITTLE_ENDIAN);
        sectionData.position(this.nextSectionStart);
        sectionData.limit(limit);
        Section result = new Section(name, sectionData);
        this.nextSectionStart = limit;
        return result;
    }

    public int getLength() {
        return this.data.capacity();
    }

    public int getNextSectionStart() {
        return this.nextSectionStart;
    }

    public byte[] getBytes() {
        ByteBuffer data = this.data.duplicate();
        byte[] result = new byte[data.capacity()];
        data.position(0);
        data.get(result);
        return result;
    }

    public List<String> strings() {
        return this.strings;
    }

    public List<Integer> typeIds() {
        return this.typeIds;
    }

    public List<String> typeNames() {
        return this.typeNames;
    }

    public List<ProtoId> protoIds() {
        return this.protoIds;
    }

    public List<FieldId> fieldIds() {
        return this.fieldIds;
    }

    public List<MethodId> methodIds() {
        return this.methodIds;
    }

    public List<CallSiteId> callsiteIds() {
        return this.callsiteIds;
    }

    public List<MethodHandle> methodHandles() {
        return this.methodHandles;
    }

    public List<ClassDef> classDefs() {
        return this.classDefs;
    }

    public Iterable<ClassDef> classDefIterable() {
        return new ClassDefIterable();
    }

    public ClassData readClassData(ClassDef classDef) {
        int offset = classDef.classDataOffset;
        if (offset == 0) {
            throw new IllegalArgumentException("offset == 0");
        }
        return this.openSection(offset).readClassData();
    }

    public Code readCode(ClassData.Method method) {
        int offset = method.codeOffset;
        if (offset == 0) {
            throw new IllegalArgumentException("offset == 0");
        }
        return this.openSection(offset).readCode();
    }

    public byte[] computeSignature(boolean forceRecompute) {
        MessageDigest digest;
        if (this.signature != null && !forceRecompute) {
            return this.signature;
        }
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        byte[] buffer = new byte[8192];
        ByteBuffer data = this.data.duplicate();
        data.limit(data.capacity());
        data.position(32);
        while (data.hasRemaining()) {
            int count = Math.min(buffer.length, data.remaining());
            data.get(buffer, 0, count);
            digest.update(buffer, 0, count);
        }
        this.signature = digest.digest();
        return this.signature;
    }

    private String bytesToHexString(byte[] bytes) {
        StringBuilder strBuilder = new StringBuilder(bytes.length << 1);
        for (byte b : bytes) {
            strBuilder.append(Hex.u1(b));
        }
        return strBuilder.toString();
    }

    public int computeChecksum() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] buffer = new byte[8192];
        ByteBuffer data = this.data.duplicate();
        data.limit(data.capacity());
        data.position(12);
        while (data.hasRemaining()) {
            int count = Math.min(buffer.length, data.remaining());
            data.get(buffer, 0, count);
            adler32.update(buffer, 0, count);
        }
        return (int)adler32.getValue();
    }

    public void writeHashes() throws IOException {
        this.openSection(12).write(this.computeSignature(true));
        this.openSection(8).writeInt(this.computeChecksum());
    }

    public int nameIndexFromFieldIndex(int fieldIndex) {
        Dex.checkBounds(fieldIndex, this.tableOfContents.fieldIds.size);
        int position = this.tableOfContents.fieldIds.off + 8 * fieldIndex;
        position += 2;
        return this.data.getInt(position += 2);
    }

    public int findStringIndex(String s) {
        return Collections.binarySearch(this.strings, s);
    }

    public int findTypeIndex(String descriptor) {
        return Collections.binarySearch(this.typeNames, descriptor);
    }

    public int findFieldIndex(FieldId fieldId) {
        return Collections.binarySearch(this.fieldIds, fieldId);
    }

    public int findMethodIndex(MethodId methodId) {
        return Collections.binarySearch(this.methodIds, methodId);
    }

    public int findClassDefIndexFromTypeIndex(int typeIndex) {
        Dex.checkBounds(typeIndex, this.tableOfContents.typeIds.size);
        if (!this.tableOfContents.classDefs.exists()) {
            return -1;
        }
        for (int i = 0; i < this.tableOfContents.classDefs.size; ++i) {
            if (this.typeIndexFromClassDefIndex(i) != typeIndex) continue;
            return i;
        }
        return -1;
    }

    public int typeIndexFromFieldIndex(int fieldIndex) {
        Dex.checkBounds(fieldIndex, this.tableOfContents.fieldIds.size);
        int position = this.tableOfContents.fieldIds.off + 8 * fieldIndex;
        return this.data.getShort(position += 2) & 0xFFFF;
    }

    public int declaringClassIndexFromMethodIndex(int methodIndex) {
        Dex.checkBounds(methodIndex, this.tableOfContents.methodIds.size);
        int position = this.tableOfContents.methodIds.off + 8 * methodIndex;
        return this.data.getShort(position) & 0xFFFF;
    }

    public int nameIndexFromMethodIndex(int methodIndex) {
        Dex.checkBounds(methodIndex, this.tableOfContents.methodIds.size);
        int position = this.tableOfContents.methodIds.off + 8 * methodIndex;
        position += 2;
        return this.data.getInt(position += 2);
    }

    public short[] parameterTypeIndicesFromMethodIndex(int methodIndex) {
        Dex.checkBounds(methodIndex, this.tableOfContents.methodIds.size);
        int position = this.tableOfContents.methodIds.off + 8 * methodIndex;
        int protoIndex = this.data.getShort(position += 2) & 0xFFFF;
        Dex.checkBounds(protoIndex, this.tableOfContents.protoIds.size);
        position = this.tableOfContents.protoIds.off + 12 * protoIndex;
        position += 4;
        int parametersOffset = this.data.getInt(position += 4);
        if (parametersOffset == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        position = parametersOffset;
        int size = this.data.getInt(position);
        if (size <= 0) {
            throw new AssertionError((Object)("Unexpected parameter type list size: " + size));
        }
        position += 4;
        short[] types = new short[size];
        for (int i = 0; i < size; ++i) {
            types[i] = this.data.getShort(position);
            position += 2;
        }
        return types;
    }

    public short[] parameterTypeIndicesFromMethodId(MethodId methodId) {
        int protoIndex = methodId.protoIndex & 0xFFFF;
        Dex.checkBounds(protoIndex, this.tableOfContents.protoIds.size);
        int position = this.tableOfContents.protoIds.off + 12 * protoIndex;
        position += 4;
        int parametersOffset = this.data.getInt(position += 4);
        if (parametersOffset == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        position = parametersOffset;
        int size = this.data.getInt(position);
        if (size <= 0) {
            throw new AssertionError((Object)("Unexpected parameter type list size: " + size));
        }
        position += 4;
        short[] types = new short[size];
        for (int i = 0; i < size; ++i) {
            types[i] = this.data.getShort(position);
            position += 2;
        }
        return types;
    }

    public int returnTypeIndexFromMethodIndex(int methodIndex) {
        Dex.checkBounds(methodIndex, this.tableOfContents.methodIds.size);
        int position = this.tableOfContents.methodIds.off + 8 * methodIndex;
        int protoIndex = this.data.getShort(position += 2) & 0xFFFF;
        Dex.checkBounds(protoIndex, this.tableOfContents.protoIds.size);
        position = this.tableOfContents.protoIds.off + 12 * protoIndex;
        return this.data.getInt(position += 4);
    }

    public int descriptorIndexFromTypeIndex(int typeIndex) {
        Dex.checkBounds(typeIndex, this.tableOfContents.typeIds.size);
        int position = this.tableOfContents.typeIds.off + 4 * typeIndex;
        return this.data.getInt(position);
    }

    public int typeIndexFromClassDefIndex(int classDefIndex) {
        Dex.checkBounds(classDefIndex, this.tableOfContents.classDefs.size);
        int position = this.tableOfContents.classDefs.off + 32 * classDefIndex;
        return this.data.getInt(position);
    }

    public int annotationDirectoryOffsetFromClassDefIndex(int classDefIndex) {
        Dex.checkBounds(classDefIndex, this.tableOfContents.classDefs.size);
        int position = this.tableOfContents.classDefs.off + 32 * classDefIndex;
        position += 4;
        position += 4;
        position += 4;
        position += 4;
        return this.data.getInt(position += 4);
    }

    public short[] interfaceTypeIndicesFromClassDefIndex(int classDefIndex) {
        Dex.checkBounds(classDefIndex, this.tableOfContents.classDefs.size);
        int position = this.tableOfContents.classDefs.off + 32 * classDefIndex;
        position += 4;
        position += 4;
        int interfacesOffset = this.data.getInt(position += 4);
        if (interfacesOffset == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        position = interfacesOffset;
        int size = this.data.getInt(position);
        if (size <= 0) {
            throw new AssertionError((Object)("Unexpected interfaces list size: " + size));
        }
        position += 4;
        short[] types = new short[size];
        for (int i = 0; i < size; ++i) {
            types[i] = this.data.getShort(position);
            position += 2;
        }
        return types;
    }

    public short[] interfaceTypeIndicesFromClassDef(ClassDef classDef) {
        int position = classDef.off;
        position += 4;
        position += 4;
        int interfacesOffset = this.data.getInt(position += 4);
        if (interfacesOffset == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        position = interfacesOffset;
        int size = this.data.getInt(position);
        if (size <= 0) {
            throw new AssertionError((Object)("Unexpected interfaces list size: " + size));
        }
        position += 4;
        short[] types = new short[size];
        for (int i = 0; i < size; ++i) {
            types[i] = this.data.getShort(position);
            position += 2;
        }
        return types;
    }

    private final class ClassDefIterable
    implements Iterable<ClassDef> {
        private ClassDefIterable() {
        }

        @Override
        public Iterator<ClassDef> iterator() {
            return !((Dex)Dex.this).tableOfContents.classDefs.exists() ? Collections.emptySet().iterator() : new ClassDefIterator();
        }
    }

    private final class ClassDefIterator
    implements Iterator<ClassDef> {
        private final Section in;
        private int count;

        private ClassDefIterator() {
            this.in = Dex.this.openSection(((Dex)Dex.this).tableOfContents.classDefs);
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            return this.count < ((Dex)Dex.this).tableOfContents.classDefs.size;
        }

        @Override
        public ClassDef next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            return this.in.readClassDef();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ClassDefTable
    extends AbstractList<ClassDef>
    implements RandomAccess {
        private ClassDefTable() {
        }

        @Override
        public ClassDef get(int index) {
            Dex.checkBounds(index, ((Dex)Dex.this).tableOfContents.classDefs.size);
            return Dex.this.openSection(((Dex)Dex.this).tableOfContents.classDefs.off + 32 * index).readClassDef();
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.classDefs.size;
        }
    }

    private final class MethodHandleTable
    extends AbstractList<MethodHandle>
    implements RandomAccess {
        private MethodHandleTable() {
        }

        @Override
        public MethodHandle get(int index) {
            Dex.checkBounds(index, ((Dex)Dex.this).tableOfContents.methodHandles.size);
            return Dex.this.openSection(((Dex)Dex.this).tableOfContents.methodHandles.off + 8 * index).readMethodHandle();
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.methodHandles.size;
        }
    }

    private final class CallSiteIdTable
    extends AbstractList<CallSiteId>
    implements RandomAccess {
        private CallSiteIdTable() {
        }

        @Override
        public CallSiteId get(int index) {
            Dex.checkBounds(index, ((Dex)Dex.this).tableOfContents.callSiteIds.size);
            return Dex.this.openSection(((Dex)Dex.this).tableOfContents.callSiteIds.off + 4 * index).readCallSiteId();
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.callSiteIds.size;
        }
    }

    private final class MethodIdTable
    extends AbstractList<MethodId>
    implements RandomAccess {
        private MethodIdTable() {
        }

        @Override
        public MethodId get(int index) {
            Dex.checkBounds(index, ((Dex)Dex.this).tableOfContents.methodIds.size);
            return Dex.this.openSection(((Dex)Dex.this).tableOfContents.methodIds.off + 8 * index).readMethodId();
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.methodIds.size;
        }
    }

    private final class FieldIdTable
    extends AbstractList<FieldId>
    implements RandomAccess {
        private FieldIdTable() {
        }

        @Override
        public FieldId get(int index) {
            Dex.checkBounds(index, ((Dex)Dex.this).tableOfContents.fieldIds.size);
            return Dex.this.openSection(((Dex)Dex.this).tableOfContents.fieldIds.off + 8 * index).readFieldId();
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.fieldIds.size;
        }
    }

    private final class ProtoIdTable
    extends AbstractList<ProtoId>
    implements RandomAccess {
        private ProtoIdTable() {
        }

        @Override
        public ProtoId get(int index) {
            Dex.checkBounds(index, ((Dex)Dex.this).tableOfContents.protoIds.size);
            return Dex.this.openSection(((Dex)Dex.this).tableOfContents.protoIds.off + 12 * index).readProtoId();
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.protoIds.size;
        }
    }

    private final class TypeIndexToDescriptorTable
    extends AbstractList<String>
    implements RandomAccess {
        private TypeIndexToDescriptorTable() {
        }

        @Override
        public String get(int index) {
            return Dex.this.strings.get(Dex.this.descriptorIndexFromTypeIndex(index));
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.typeIds.size;
        }
    }

    private final class TypeIndexToDescriptorIndexTable
    extends AbstractList<Integer>
    implements RandomAccess {
        private TypeIndexToDescriptorIndexTable() {
        }

        @Override
        public Integer get(int index) {
            return Dex.this.descriptorIndexFromTypeIndex(index);
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.typeIds.size;
        }
    }

    private final class StringTable
    extends AbstractList<String>
    implements RandomAccess {
        private StringTable() {
        }

        @Override
        public String get(int index) {
            Dex.checkBounds(index, ((Dex)Dex.this).tableOfContents.stringIds.size);
            int stringOff = Dex.this.openSection(((Dex)Dex.this).tableOfContents.stringIds.off + index * 4).readInt();
            return Dex.this.openSection((int)stringOff).readStringData().value;
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.stringIds.size;
        }
    }

    public final class Section
    extends DexDataBuffer {
        private final String name;

        private Section(String name, ByteBuffer data) {
            super(data);
            this.name = name;
        }

        @Override
        public StringData readStringData() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.stringDatas, false);
            return super.readStringData();
        }

        @Override
        public TypeList readTypeList() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.typeLists, false);
            return super.readTypeList();
        }

        @Override
        public FieldId readFieldId() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.fieldIds, false);
            return super.readFieldId();
        }

        @Override
        public MethodId readMethodId() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.methodIds, false);
            return super.readMethodId();
        }

        @Override
        public ProtoId readProtoId() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.protoIds, false);
            return super.readProtoId();
        }

        @Override
        public ClassDef readClassDef() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.classDefs, false);
            return super.readClassDef();
        }

        @Override
        public Code readCode() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.codes, false);
            return super.readCode();
        }

        @Override
        public DebugInfoItem readDebugInfoItem() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.debugInfos, false);
            return super.readDebugInfoItem();
        }

        @Override
        public ClassData readClassData() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.classDatas, false);
            return super.readClassData();
        }

        @Override
        public Annotation readAnnotation() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.annotations, false);
            return super.readAnnotation();
        }

        @Override
        public AnnotationSet readAnnotationSet() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.annotationSets, false);
            return super.readAnnotationSet();
        }

        @Override
        public AnnotationSetRefList readAnnotationSetRefList() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.annotationSetRefLists, false);
            return super.readAnnotationSetRefList();
        }

        @Override
        public AnnotationsDirectory readAnnotationsDirectory() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.annotationsDirectories, false);
            return super.readAnnotationsDirectory();
        }

        @Override
        public EncodedValue readEncodedArray() {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.encodedArrays, false);
            return super.readEncodedArray();
        }

        private void ensureFourBytesAligned(TableOfContents.Section tocSec, boolean isFillWithZero) {
            if (tocSec.isElementFourByteAligned) {
                if (isFillWithZero) {
                    this.alignToFourBytesWithZeroFill();
                } else {
                    this.alignToFourBytes();
                }
            }
        }

        @Override
        public int writeStringData(StringData stringData) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.stringDatas, true);
            return super.writeStringData(stringData);
        }

        @Override
        public int writeTypeList(TypeList typeList) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.typeLists, true);
            return super.writeTypeList(typeList);
        }

        @Override
        public int writeFieldId(FieldId fieldId) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.fieldIds, true);
            return super.writeFieldId(fieldId);
        }

        @Override
        public int writeMethodId(MethodId methodId) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.methodIds, true);
            return super.writeMethodId(methodId);
        }

        @Override
        public int writeProtoId(ProtoId protoId) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.protoIds, true);
            return super.writeProtoId(protoId);
        }

        @Override
        public int writeClassDef(ClassDef classDef) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.classDefs, true);
            return super.writeClassDef(classDef);
        }

        @Override
        public int writeCode(Code code) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.codes, true);
            return super.writeCode(code);
        }

        @Override
        public int writeDebugInfoItem(DebugInfoItem debugInfoItem) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.debugInfos, true);
            return super.writeDebugInfoItem(debugInfoItem);
        }

        @Override
        public int writeClassData(ClassData classData) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.classDatas, true);
            return super.writeClassData(classData);
        }

        @Override
        public int writeAnnotation(Annotation annotation) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.annotations, true);
            return super.writeAnnotation(annotation);
        }

        @Override
        public int writeAnnotationSet(AnnotationSet annotationSet) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.annotationSets, true);
            return super.writeAnnotationSet(annotationSet);
        }

        @Override
        public int writeAnnotationSetRefList(AnnotationSetRefList annotationSetRefList) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.annotationSetRefLists, true);
            return super.writeAnnotationSetRefList(annotationSetRefList);
        }

        @Override
        public int writeAnnotationsDirectory(AnnotationsDirectory annotationsDirectory) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.annotationsDirectories, true);
            return super.writeAnnotationsDirectory(annotationsDirectory);
        }

        @Override
        public int writeEncodedArray(EncodedValue encodedValue) {
            this.ensureFourBytesAligned(((Dex)Dex.this).tableOfContents.encodedArrays, true);
            return super.writeEncodedArray(encodedValue);
        }
    }
}

