/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dex;

import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.util.CompareUtils;

public class MethodHandle
extends TableOfContents.Section.Item<MethodHandle> {
    public MethodHandleType methodHandleType;
    public int unused1;
    public int fieldOrMethodId;
    public int unused2;

    public MethodHandle(int off, MethodHandleType methodHandleType, int unused1, int fieldOrMethodId, int unused2) {
        super(off);
        this.methodHandleType = methodHandleType;
        this.unused1 = unused1;
        this.fieldOrMethodId = fieldOrMethodId;
        this.unused2 = unused2;
    }

    @Override
    public int byteCountInDex() {
        return 8;
    }

    @Override
    public int compareTo(MethodHandle o) {
        if (this.methodHandleType != o.methodHandleType) {
            return this.methodHandleType.compareTo(o.methodHandleType);
        }
        return CompareUtils.uCompare(this.fieldOrMethodId, o.fieldOrMethodId);
    }

    public void writeTo(Dex.Section out) {
        out.writeUnsignedShort(this.methodHandleType.value);
        out.writeUnsignedShort(this.unused1);
        out.writeUnsignedShort(this.fieldOrMethodId);
        out.writeUnsignedShort(this.unused2);
    }

    public static enum MethodHandleType {
        METHOD_HANDLE_TYPE_STATIC_PUT(0),
        METHOD_HANDLE_TYPE_STATIC_GET(1),
        METHOD_HANDLE_TYPE_INSTANCE_PUT(2),
        METHOD_HANDLE_TYPE_INSTANCE_GET(3),
        METHOD_HANDLE_TYPE_INVOKE_STATIC(4),
        METHOD_HANDLE_TYPE_INVOKE_INSTANCE(5),
        METHOD_HANDLE_TYPE_INVOKE_DIRECT(6),
        METHOD_HANDLE_TYPE_INVOKE_CONSTRUCTOR(7),
        METHOD_HANDLE_TYPE_INVOKE_INTERFACE(8);

        public final int value;

        private MethodHandleType(int value) {
            this.value = value;
        }

        public static MethodHandleType fromValue(int value) {
            for (MethodHandleType methodHandleType : MethodHandleType.values()) {
                if (methodHandleType.value != value) continue;
                return methodHandleType;
            }
            throw new IllegalArgumentException(String.valueOf(value));
        }

        public boolean isField() {
            switch (this) {
                case METHOD_HANDLE_TYPE_STATIC_PUT: 
                case METHOD_HANDLE_TYPE_STATIC_GET: 
                case METHOD_HANDLE_TYPE_INSTANCE_PUT: 
                case METHOD_HANDLE_TYPE_INSTANCE_GET: {
                    return true;
                }
            }
            return false;
        }
    }
}

