/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dx.instruction;

import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dx.instruction.InstructionVisitor;
import com.tencent.tinker.android.dx.instruction.InstructionWriter;
import com.tencent.tinker.android.dx.instruction.Opcodes;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeInput;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeOutput;
import com.tencent.tinker.android.dx.util.Hex;
import java.io.EOFException;
import java.util.Arrays;

public final class InstructionCodec {
    public static final int INDEX_TYPE_UNKNOWN = 0;
    public static final int INDEX_TYPE_NONE = 1;
    public static final int INDEX_TYPE_TYPE_REF = 2;
    public static final int INDEX_TYPE_STRING_REF = 3;
    public static final int INDEX_TYPE_METHOD_REF = 4;
    public static final int INDEX_TYPE_FIELD_REF = 5;
    public static final int INDEX_TYPE_METHOD_AND_PROTO_REF = 6;
    public static final int INDEX_TYPE_CALL_SITE_REF = 7;
    public static final int INDEX_TYPE_METHOD_HANDLE_REF = 8;
    public static final int INDEX_TYPE_PROTO_REF = 9;
    public static final int INSN_FORMAT_UNKNOWN = 0;
    public static final int INSN_FORMAT_00X = 1;
    public static final int INSN_FORMAT_10T = 2;
    public static final int INSN_FORMAT_10X = 3;
    public static final int INSN_FORMAT_11N = 4;
    public static final int INSN_FORMAT_11X = 5;
    public static final int INSN_FORMAT_12X = 6;
    public static final int INSN_FORMAT_20T = 7;
    public static final int INSN_FORMAT_21C = 8;
    public static final int INSN_FORMAT_21H = 9;
    public static final int INSN_FORMAT_21S = 10;
    public static final int INSN_FORMAT_21T = 11;
    public static final int INSN_FORMAT_22B = 12;
    public static final int INSN_FORMAT_22C = 13;
    public static final int INSN_FORMAT_22S = 14;
    public static final int INSN_FORMAT_22T = 15;
    public static final int INSN_FORMAT_22X = 16;
    public static final int INSN_FORMAT_23X = 17;
    public static final int INSN_FORMAT_30T = 18;
    public static final int INSN_FORMAT_31C = 19;
    public static final int INSN_FORMAT_31I = 20;
    public static final int INSN_FORMAT_31T = 21;
    public static final int INSN_FORMAT_32X = 22;
    public static final int INSN_FORMAT_35C = 23;
    public static final int INSN_FORMAT_3RC = 24;
    public static final int INSN_FORMAT_51L = 25;
    public static final int INSN_FORMAT_45CC = 26;
    public static final int INSN_FORMAT_4RCC = 27;
    public static final int INSN_FORMAT_PACKED_SWITCH_PAYLOAD = 28;
    public static final int INSN_FORMAT_SPARSE_SWITCH_PAYLOAD = 29;
    public static final int INSN_FORMAT_FILL_ARRAY_DATA_PAYLOAD = 30;

    private InstructionCodec() {
        throw new UnsupportedOperationException();
    }

    public static void decode(ShortArrayCodeInput in, InstructionVisitor iv) throws EOFException {
        in.reset();
        block49: while (in.hasMore()) {
            int currentAddress = in.cursor();
            int opcodeUnit = in.read();
            int opcode = Opcodes.extractOpcodeFromUnit(opcodeUnit);
            int insnFormat = InstructionCodec.getInstructionFormat(opcode);
            switch (insnFormat) {
                case 1: {
                    iv.visitZeroRegisterInsn(currentAddress, opcode, 0, 1, 0, 0L);
                    continue block49;
                }
                case 3: {
                    int literal = InstructionCodec.byte1(opcodeUnit);
                    iv.visitZeroRegisterInsn(currentAddress, opcode, 0, 1, 0, literal);
                    continue block49;
                }
                case 6: {
                    int a = InstructionCodec.nibble2(opcodeUnit);
                    int b = InstructionCodec.nibble3(opcodeUnit);
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, 0, 0L, a, b);
                    continue block49;
                }
                case 4: {
                    int a = InstructionCodec.nibble2(opcodeUnit);
                    int literal = InstructionCodec.nibble3(opcodeUnit) << 28 >> 28;
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a);
                    continue block49;
                }
                case 5: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, 0L, a);
                    continue block49;
                }
                case 2: {
                    int target = currentAddress + (byte)InstructionCodec.byte1(opcodeUnit);
                    iv.visitZeroRegisterInsn(currentAddress, opcode, 0, 1, target, 0L);
                    continue block49;
                }
                case 7: {
                    int literal = InstructionCodec.byte1(opcodeUnit);
                    int target = currentAddress + (short)in.read();
                    iv.visitZeroRegisterInsn(currentAddress, opcode, 0, 1, target, literal);
                    continue block49;
                }
                case 16: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int b = in.read();
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, 0, 0L, a, b);
                    continue block49;
                }
                case 11: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int target = currentAddress + (short)in.read();
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, target, 0L, a);
                    continue block49;
                }
                case 10: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    short literal = (short)in.read();
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a);
                    continue block49;
                }
                case 9: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    long literal = (short)in.read();
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, literal <<= opcode == 21 ? 16 : 48, a);
                    continue block49;
                }
                case 8: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int index = in.read();
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    iv.visitOneRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a);
                    continue block49;
                }
                case 17: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int bc = in.read();
                    int b = InstructionCodec.byte0(bc);
                    int c = InstructionCodec.byte1(bc);
                    iv.visitThreeRegisterInsn(currentAddress, opcode, 0, 1, 0, 0L, a, b, c);
                    continue block49;
                }
                case 12: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int bc = in.read();
                    int b = InstructionCodec.byte0(bc);
                    byte literal = (byte)InstructionCodec.byte1(bc);
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a, b);
                    continue block49;
                }
                case 15: {
                    int a = InstructionCodec.nibble2(opcodeUnit);
                    int b = InstructionCodec.nibble3(opcodeUnit);
                    int target = currentAddress + (short)in.read();
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, target, 0L, a, b);
                    continue block49;
                }
                case 14: {
                    int a = InstructionCodec.nibble2(opcodeUnit);
                    int b = InstructionCodec.nibble3(opcodeUnit);
                    short literal = (short)in.read();
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a, b);
                    continue block49;
                }
                case 13: {
                    int a = InstructionCodec.nibble2(opcodeUnit);
                    int b = InstructionCodec.nibble3(opcodeUnit);
                    int index = in.read();
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    iv.visitTwoRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a, b);
                    continue block49;
                }
                case 18: {
                    int literal = InstructionCodec.byte1(opcodeUnit);
                    int target = currentAddress + in.readInt();
                    iv.visitZeroRegisterInsn(currentAddress, opcode, 0, 1, target, literal);
                    continue block49;
                }
                case 22: {
                    int literal = InstructionCodec.byte1(opcodeUnit);
                    int a = in.read();
                    int b = in.read();
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a, b);
                    continue block49;
                }
                case 20: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int literal = in.readInt();
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a);
                    continue block49;
                }
                case 21: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int target = currentAddress + in.readInt();
                    switch (opcode) {
                        case 43: 
                        case 44: {
                            in.setBaseAddress(target + 1, currentAddress);
                            break;
                        }
                    }
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, target, 0L, a);
                    continue block49;
                }
                case 19: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int index = in.readInt();
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    iv.visitOneRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a);
                    continue block49;
                }
                case 23: {
                    int e = InstructionCodec.nibble2(opcodeUnit);
                    int registerCount = InstructionCodec.nibble3(opcodeUnit);
                    int index = in.read();
                    int abcd = in.read();
                    int a = InstructionCodec.nibble0(abcd);
                    int b = InstructionCodec.nibble1(abcd);
                    int c = InstructionCodec.nibble2(abcd);
                    int d = InstructionCodec.nibble3(abcd);
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    switch (registerCount) {
                        case 0: {
                            iv.visitZeroRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L);
                            continue block49;
                        }
                        case 1: {
                            iv.visitOneRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a);
                            continue block49;
                        }
                        case 2: {
                            iv.visitTwoRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a, b);
                            continue block49;
                        }
                        case 3: {
                            iv.visitThreeRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a, b, c);
                            continue block49;
                        }
                        case 4: {
                            iv.visitFourRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a, b, c, d);
                            continue block49;
                        }
                        case 5: {
                            iv.visitFiveRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a, b, c, d, e);
                            continue block49;
                        }
                    }
                    throw new DexException("bogus registerCount: " + Hex.uNibble(registerCount));
                }
                case 24: {
                    int registerCount = InstructionCodec.byte1(opcodeUnit);
                    int index = in.read();
                    int a = in.read();
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    iv.visitRegisterRangeInsn(currentAddress, opcode, index, indexType, 0, 0L, a, registerCount);
                    continue block49;
                }
                case 25: {
                    int a = InstructionCodec.byte1(opcodeUnit);
                    long literal = in.readLong();
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a);
                    continue block49;
                }
                case 26: {
                    if (opcode != 250) {
                        throw new UnsupportedOperationException(String.valueOf(opcode));
                    }
                    int g = InstructionCodec.nibble2(opcodeUnit);
                    int registerCount = InstructionCodec.nibble3(opcodeUnit);
                    int methodIndex = in.read();
                    int cdef = in.read();
                    int c = InstructionCodec.nibble0(cdef);
                    int d = InstructionCodec.nibble1(cdef);
                    int e = InstructionCodec.nibble2(cdef);
                    int f = InstructionCodec.nibble3(cdef);
                    int protoIndex = in.read();
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    if (registerCount < 1 || registerCount > 5) {
                        throw new DexException("bogus registerCount: " + Hex.uNibble(registerCount));
                    }
                    int[] registers = Arrays.copyOfRange(new int[]{c, d, e, f, g}, 0, registerCount);
                    iv.visitInvokePolymorphicInstruction(currentAddress, opcode, methodIndex, indexType, protoIndex, registers);
                    continue block49;
                }
                case 27: {
                    if (opcode != 251) {
                        throw new UnsupportedOperationException(String.valueOf(opcode));
                    }
                    int registerCount = InstructionCodec.byte1(opcodeUnit);
                    int methodIndex = in.read();
                    int c = in.read();
                    int protoIndex = in.read();
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    iv.visitInvokePolymorphicRangeInstruction(currentAddress, opcode, methodIndex, indexType, c, registerCount, protoIndex);
                    continue block49;
                }
                case 28: {
                    int i;
                    int baseAddress = in.baseAddressForCursor();
                    int size = in.read();
                    int firstKey = in.readInt();
                    int[] targets = new int[size];
                    for (i = 0; i < size; ++i) {
                        targets[i] = baseAddress + in.readInt();
                    }
                    iv.visitPackedSwitchPayloadInsn(currentAddress, opcodeUnit, firstKey, targets);
                    continue block49;
                }
                case 29: {
                    int i;
                    int baseAddress = in.baseAddressForCursor();
                    int size = in.read();
                    int[] keys = new int[size];
                    int[] targets = new int[size];
                    for (i = 0; i < size; ++i) {
                        keys[i] = in.readInt();
                    }
                    for (i = 0; i < size; ++i) {
                        targets[i] = baseAddress + in.readInt();
                    }
                    iv.visitSparseSwitchPayloadInsn(currentAddress, opcodeUnit, keys, targets);
                    continue block49;
                }
                case 30: {
                    int i;
                    int elementWidth = in.read();
                    int size = in.readInt();
                    switch (elementWidth) {
                        case 1: {
                            byte[] array = new byte[size];
                            boolean even = true;
                            int value = 0;
                            for (i = 0; i < size; ++i) {
                                if (even) {
                                    value = in.read();
                                }
                                array[i] = (byte)(value & 0xFF);
                                value >>= 8;
                                even = !even;
                            }
                            iv.visitFillArrayDataPayloadInsn(currentAddress, opcodeUnit, array, array.length, 1);
                            continue block49;
                        }
                        case 2: {
                            short[] array = new short[size];
                            for (int i2 = 0; i2 < size; ++i2) {
                                array[i2] = (short)in.read();
                            }
                            iv.visitFillArrayDataPayloadInsn(currentAddress, opcodeUnit, array, array.length, 2);
                            continue block49;
                        }
                        case 4: {
                            int[] array = new int[size];
                            for (int i3 = 0; i3 < size; ++i3) {
                                array[i3] = in.readInt();
                            }
                            iv.visitFillArrayDataPayloadInsn(currentAddress, opcodeUnit, array, array.length, 4);
                            continue block49;
                        }
                        case 8: {
                            long[] array = new long[size];
                            for (int i4 = 0; i4 < size; ++i4) {
                                array[i4] = in.readLong();
                            }
                            iv.visitFillArrayDataPayloadInsn(currentAddress, opcodeUnit, array, array.length, 8);
                            continue block49;
                        }
                    }
                    throw new DexException("bogus element_width: " + Hex.u2(elementWidth));
                }
            }
            throw new DexException("Unknown instruction format: " + insnFormat);
        }
    }

    public static void encode(ShortArrayCodeOutput out, InstructionWriter iw) {
        int opcode = iw.currOpcode;
        int insnFormat = InstructionCodec.getInstructionFormat(opcode);
        block0 : switch (insnFormat) {
            case 1: 
            case 3: {
                out.write((short)opcode);
                break;
            }
            case 6: {
                out.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(iw.currRegA, iw.currRegB)));
                break;
            }
            case 4: {
                out.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(iw.currRegA, InstructionCodec.getLiteralNibble(iw.currLiteral))));
                break;
            }
            case 5: {
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA));
                break;
            }
            case 2: {
                int relativeTarget = InstructionCodec.getTargetByte(iw.currTarget, out.cursor());
                out.write(InstructionCodec.codeUnit(opcode, relativeTarget));
                break;
            }
            case 7: {
                short relativeTarget = InstructionCodec.getTargetUnit(iw.currTarget, out.cursor());
                out.write((short)opcode, relativeTarget);
                break;
            }
            case 16: {
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), InstructionCodec.getBUnit(iw.currRegB));
                break;
            }
            case 11: {
                short relativeTarget = InstructionCodec.getTargetUnit(iw.currTarget, out.cursor());
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), relativeTarget);
                break;
            }
            case 10: {
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), InstructionCodec.getLiteralUnit(iw.currLiteral));
                break;
            }
            case 9: {
                int shift = opcode == 21 ? 16 : 48;
                short literal = (short)(iw.currLiteral >> shift);
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), literal);
                break;
            }
            case 8: {
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), (short)iw.currIndex);
                break;
            }
            case 17: {
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), InstructionCodec.codeUnit(iw.currRegB, iw.currRegC));
                break;
            }
            case 12: {
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), InstructionCodec.codeUnit(iw.currRegB, InstructionCodec.getLiteralByte(iw.currLiteral)));
                break;
            }
            case 15: {
                short relativeTarget = InstructionCodec.getTargetUnit(iw.currTarget, out.cursor());
                out.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(iw.currRegA, iw.currRegB)), relativeTarget);
                break;
            }
            case 14: {
                out.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(iw.currRegA, iw.currRegB)), InstructionCodec.getLiteralUnit(iw.currLiteral));
                break;
            }
            case 13: {
                out.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(iw.currRegA, iw.currRegB)), (short)iw.currIndex);
                break;
            }
            case 18: {
                int relativeTarget = InstructionCodec.getTarget(iw.currTarget, out.cursor());
                out.write((short)opcode, InstructionCodec.unit0(relativeTarget), InstructionCodec.unit1(relativeTarget));
                break;
            }
            case 22: {
                out.write((short)opcode, InstructionCodec.getAUnit(iw.currRegA), InstructionCodec.getBUnit(iw.currRegB));
                break;
            }
            case 20: {
                int literal = InstructionCodec.getLiteralInt(iw.currLiteral);
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), InstructionCodec.unit0(literal), InstructionCodec.unit1(literal));
                break;
            }
            case 21: {
                switch (opcode) {
                    case 43: 
                    case 44: {
                        out.setBaseAddress(iw.currTarget, out.cursor());
                        break;
                    }
                }
                int relativeTarget = InstructionCodec.getTarget(iw.currTarget, out.cursor());
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), InstructionCodec.unit0(relativeTarget), InstructionCodec.unit1(relativeTarget));
                break;
            }
            case 19: {
                int index = iw.currIndex;
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), InstructionCodec.unit0(index), InstructionCodec.unit1(index));
                break;
            }
            case 23: {
                out.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(iw.currRegE, iw.currRegisterCount)), (short)iw.currIndex, InstructionCodec.codeUnit(iw.currRegA, iw.currRegB, iw.currRegC, iw.currRegD));
                break;
            }
            case 24: {
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegisterCount), (short)iw.currIndex, InstructionCodec.getAUnit(iw.currRegA));
                break;
            }
            case 25: {
                long literal = iw.currLiteral;
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegA), InstructionCodec.unit0(literal), InstructionCodec.unit1(literal), InstructionCodec.unit2(literal), InstructionCodec.unit3(literal));
                break;
            }
            case 26: {
                out.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(iw.currRegG, iw.currRegisterCount)), (short)iw.currIndex, InstructionCodec.codeUnit(iw.currRegC, iw.currRegD, iw.currRegE, iw.currRegF), (short)iw.currProtoIndex);
                break;
            }
            case 27: {
                out.write(InstructionCodec.codeUnit(opcode, iw.currRegisterCount), (short)iw.currIndex, InstructionCodec.getCUnit(iw.currRegC), (short)iw.currProtoIndex);
                break;
            }
            case 28: {
                int[] targets = iw.currTargets;
                int baseAddress = out.baseAddressForCursor();
                out.write((short)opcode);
                out.write(InstructionCodec.asUnsignedUnit(targets.length));
                out.writeInt(iw.currFirstKey);
                for (int target : targets) {
                    out.writeInt(target - baseAddress);
                }
                break;
            }
            case 29: {
                int[] keys = iw.currKeys;
                int[] targets = iw.currTargets;
                int baseAddress = out.baseAddressForCursor();
                out.write((short)opcode);
                out.write(InstructionCodec.asUnsignedUnit(targets.length));
                for (int key : keys) {
                    out.writeInt(key);
                }
                for (int target : targets) {
                    out.writeInt(target - baseAddress);
                }
                break;
            }
            case 30: {
                short elementWidth = (short)iw.currElementWidth;
                out.write((short)opcode);
                out.write(elementWidth);
                out.writeInt(iw.currSize);
                Object data = iw.currData;
                switch (elementWidth) {
                    case 1: {
                        out.write((byte[])data);
                        break block0;
                    }
                    case 2: {
                        out.write((short[])data);
                        break block0;
                    }
                    case 4: {
                        out.write((int[])data);
                        break block0;
                    }
                    case 8: {
                        out.write((long[])data);
                        break block0;
                    }
                }
                throw new DexException("bogus element_width: " + Hex.u2(elementWidth));
            }
            default: {
                throw new DexException("Unknown instruction format: " + insnFormat);
            }
        }
    }

    public static short codeUnit(int lowByte, int highByte) {
        if ((lowByte & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("bogus lowByte");
        }
        if ((highByte & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("bogus highByte");
        }
        return (short)(lowByte | highByte << 8);
    }

    public static short codeUnit(int nibble0, int nibble1, int nibble2, int nibble3) {
        if ((nibble0 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus nibble0");
        }
        if ((nibble1 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus nibble1");
        }
        if ((nibble2 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus nibble2");
        }
        if ((nibble3 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus nibble3");
        }
        return (short)(nibble0 | nibble1 << 4 | nibble2 << 8 | nibble3 << 12);
    }

    public static int makeByte(int lowNibble, int highNibble) {
        if ((lowNibble & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus lowNibble");
        }
        if ((highNibble & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus highNibble");
        }
        return lowNibble | highNibble << 4;
    }

    public static short asUnsignedUnit(int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("bogus unsigned code unit");
        }
        return (short)value;
    }

    public static short unit0(int value) {
        return (short)value;
    }

    public static short unit1(int value) {
        return (short)(value >> 16);
    }

    public static short unit0(long value) {
        return (short)value;
    }

    public static short unit1(long value) {
        return (short)(value >> 16);
    }

    public static short unit2(long value) {
        return (short)(value >> 32);
    }

    public static short unit3(long value) {
        return (short)(value >> 48);
    }

    private static int byte0(int value) {
        return value & 0xFF;
    }

    private static int byte1(int value) {
        return value >> 8 & 0xFF;
    }

    private static int nibble0(int value) {
        return value & 0xF;
    }

    private static int nibble1(int value) {
        return value >> 4 & 0xF;
    }

    private static int nibble2(int value) {
        return value >> 8 & 0xF;
    }

    private static int nibble3(int value) {
        return value >> 12 & 0xF;
    }

    public static int getTargetByte(int target, int baseAddress) {
        int relativeTarget = InstructionCodec.getTarget(target, baseAddress);
        if (relativeTarget != (byte)relativeTarget) {
            throw new DexException("Target out of range: " + Hex.s4(relativeTarget) + ", perhaps you need to enable force jumbo mode.");
        }
        return relativeTarget & 0xFF;
    }

    public static short getTargetUnit(int target, int baseAddress) {
        int relativeTarget = InstructionCodec.getTarget(target, baseAddress);
        if (relativeTarget != (short)relativeTarget) {
            throw new DexException("Target out of range: " + Hex.s4(relativeTarget) + ", perhaps you need to enable force jumbo mode.");
        }
        return (short)relativeTarget;
    }

    public static int getTarget(int target, int baseAddress) {
        return target - baseAddress;
    }

    public static int getLiteralByte(long literal) {
        if (literal != (long)((byte)literal)) {
            throw new DexException("Literal out of range: " + Hex.u8(literal));
        }
        return (int)literal & 0xFF;
    }

    public static short getLiteralUnit(long literal) {
        if (literal != (long)((short)literal)) {
            throw new DexException("Literal out of range: " + Hex.u8(literal));
        }
        return (short)literal;
    }

    public static int getLiteralInt(long literal) {
        if (literal != (long)((int)literal)) {
            throw new DexException("Literal out of range: " + Hex.u8(literal));
        }
        return (int)literal;
    }

    public static int getLiteralNibble(long literal) {
        if (literal < -8L || literal > 7L) {
            throw new DexException("Literal out of range: " + Hex.u8(literal));
        }
        return (int)literal & 0xF;
    }

    public static short getAUnit(int a) {
        if ((a & 0xFFFF0000) != 0) {
            throw new DexException("Register A out of range: " + Hex.u8(a));
        }
        return (short)a;
    }

    public static short getBUnit(int b) {
        if ((b & 0xFFFF0000) != 0) {
            throw new DexException("Register B out of range: " + Hex.u8(b));
        }
        return (short)b;
    }

    public static short getCUnit(int c) {
        if ((c & 0xFFFF0000) != 0) {
            throw new DexException("Register C out of range: " + Hex.u8(c));
        }
        return (short)c;
    }

    public static int getInstructionIndexType(int opcode) {
        switch (opcode) {
            case 26: 
            case 27: {
                return 3;
            }
            case 254: {
                return 8;
            }
            case 255: {
                return 9;
            }
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return 2;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                return 5;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                return 4;
            }
            case 250: 
            case 251: {
                return 6;
            }
            case 252: 
            case 253: {
                return 7;
            }
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 256: 
            case 512: 
            case 768: {
                return 1;
            }
        }
        return 0;
    }

    public static int getInstructionFormat(int opcode) {
        switch (opcode) {
            case -1: {
                return 1;
            }
            case 0: 
            case 14: {
                return 3;
            }
            case 1: 
            case 4: 
            case 7: 
            case 33: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return 6;
            }
            case 2: 
            case 5: 
            case 8: {
                return 16;
            }
            case 3: 
            case 6: 
            case 9: {
                return 22;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 29: 
            case 30: 
            case 39: {
                return 5;
            }
            case 18: {
                return 4;
            }
            case 19: 
            case 22: {
                return 10;
            }
            case 20: 
            case 23: {
                return 20;
            }
            case 21: 
            case 25: {
                return 9;
            }
            case 24: {
                return 25;
            }
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 254: 
            case 255: {
                return 8;
            }
            case 27: {
                return 19;
            }
            case 32: 
            case 35: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return 13;
            }
            case 36: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 252: {
                return 23;
            }
            case 37: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 253: {
                return 24;
            }
            case 38: 
            case 43: 
            case 44: {
                return 21;
            }
            case 40: {
                return 2;
            }
            case 41: {
                return 7;
            }
            case 42: {
                return 18;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                return 17;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return 15;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                return 11;
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                return 14;
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: {
                return 12;
            }
            case 250: {
                return 26;
            }
            case 251: {
                return 27;
            }
            case 256: {
                return 28;
            }
            case 512: {
                return 29;
            }
            case 768: {
                return 30;
            }
        }
        return 0;
    }
}

