/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dx.instruction;

import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dex.util.CompareUtils;
import com.tencent.tinker.android.dx.instruction.InstructionCodec;
import com.tencent.tinker.android.dx.instruction.InstructionReader;
import com.tencent.tinker.android.dx.instruction.InstructionVisitor;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeInput;
import com.tencent.tinker.android.dx.util.Hex;
import java.io.EOFException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class InstructionComparator {
    private final InstructionHolder[] insnHolders1;
    private final InstructionHolder[] insnHolders2;
    private final Set<String> visitedInsnAddrPairs;
    private final short[] insns1;
    private final short[] insns2;

    public InstructionComparator(short[] insns1, short[] insns2) {
        this.insns1 = insns1;
        this.insns2 = insns2;
        if (insns1 != null) {
            ShortArrayCodeInput codeIn1 = new ShortArrayCodeInput(insns1);
            this.insnHolders1 = this.readInstructionsIntoHolders(codeIn1, insns1.length);
        } else {
            this.insnHolders1 = null;
        }
        if (insns2 != null) {
            ShortArrayCodeInput codeIn2 = new ShortArrayCodeInput(insns2);
            this.insnHolders2 = this.readInstructionsIntoHolders(codeIn2, insns2.length);
        } else {
            this.insnHolders2 = null;
        }
        this.visitedInsnAddrPairs = new HashSet<String>();
    }

    private InstructionHolder[] readInstructionsIntoHolders(ShortArrayCodeInput in, int length) {
        in.reset();
        final InstructionHolder[] result = new InstructionHolder[length];
        InstructionReader ir = new InstructionReader(in);
        try {
            ir.accept(new InstructionVisitor(null){

                @Override
                public void visitZeroRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal) {
                    if (opcode != 0) {
                        InstructionHolder insnHolder = new InstructionHolder();
                        insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                        insnHolder.address = currentAddress;
                        insnHolder.opcode = opcode;
                        insnHolder.index = index;
                        insnHolder.target = target;
                        insnHolder.literal = literal;
                        result[currentAddress] = insnHolder;
                    }
                }

                @Override
                public void visitOneRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a) {
                    InstructionHolder insnHolder = new InstructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.index = index;
                    insnHolder.target = target;
                    insnHolder.literal = literal;
                    insnHolder.registerCount = 1;
                    insnHolder.a = a;
                    result[currentAddress] = insnHolder;
                }

                @Override
                public void visitTwoRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b) {
                    InstructionHolder insnHolder = new InstructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.index = index;
                    insnHolder.target = target;
                    insnHolder.literal = literal;
                    insnHolder.registerCount = 2;
                    insnHolder.a = a;
                    insnHolder.b = b;
                    result[currentAddress] = insnHolder;
                }

                @Override
                public void visitThreeRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c) {
                    InstructionHolder insnHolder = new InstructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.index = index;
                    insnHolder.target = target;
                    insnHolder.literal = literal;
                    insnHolder.registerCount = 3;
                    insnHolder.a = a;
                    insnHolder.b = b;
                    insnHolder.c = c;
                    result[currentAddress] = insnHolder;
                }

                @Override
                public void visitFourRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d) {
                    InstructionHolder insnHolder = new InstructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.index = index;
                    insnHolder.target = target;
                    insnHolder.literal = literal;
                    insnHolder.registerCount = 4;
                    insnHolder.a = a;
                    insnHolder.b = b;
                    insnHolder.c = c;
                    insnHolder.d = d;
                    result[currentAddress] = insnHolder;
                }

                @Override
                public void visitFiveRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d, int e) {
                    InstructionHolder insnHolder = new InstructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.index = index;
                    insnHolder.target = target;
                    insnHolder.literal = literal;
                    insnHolder.registerCount = 5;
                    insnHolder.a = a;
                    insnHolder.b = b;
                    insnHolder.c = c;
                    insnHolder.d = d;
                    insnHolder.e = e;
                    result[currentAddress] = insnHolder;
                }

                @Override
                public void visitRegisterRangeInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int registerCount) {
                    InstructionHolder insnHolder = new InstructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.index = index;
                    insnHolder.target = target;
                    insnHolder.literal = literal;
                    insnHolder.registerCount = registerCount;
                    insnHolder.a = a;
                    result[currentAddress] = insnHolder;
                }

                @Override
                public void visitInvokePolymorphicInstruction(int currentAddress, int opcode, int methodIndex, int indexType, int protoIndex, int[] registers) {
                    InstructionHolder insnHolder = new InstructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.index = methodIndex;
                    insnHolder.registerCount = registers.length;
                    insnHolder.protoIndex = protoIndex;
                    insnHolder.registers = registers;
                    result[currentAddress] = insnHolder;
                }

                @Override
                public void visitInvokePolymorphicRangeInstruction(int currentAddress, int opcode, int methodIndex, int indexType, int c, int registerCount, int protoIndex) {
                    InstructionHolder insnHolder = new InstructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.index = methodIndex;
                    insnHolder.c = c;
                    insnHolder.registerCount = registerCount;
                    insnHolder.protoIndex = protoIndex;
                    result[currentAddress] = insnHolder;
                }

                @Override
                public void visitSparseSwitchPayloadInsn(int currentAddress, int opcode, int[] keys, int[] targets) {
                    SparseSwitchPayloadInsntructionHolder insnHolder = new SparseSwitchPayloadInsntructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.keys = keys;
                    insnHolder.targets = targets;
                    result[currentAddress] = insnHolder;
                }

                @Override
                public void visitPackedSwitchPayloadInsn(int currentAddress, int opcode, int firstKey, int[] targets) {
                    PackedSwitchPayloadInsntructionHolder insnHolder = new PackedSwitchPayloadInsntructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.firstKey = firstKey;
                    insnHolder.targets = targets;
                    result[currentAddress] = insnHolder;
                }

                @Override
                public void visitFillArrayDataPayloadInsn(int currentAddress, int opcode, Object data, int size, int elementWidth) {
                    FillArrayDataPayloadInstructionHolder insnHolder = new FillArrayDataPayloadInstructionHolder();
                    insnHolder.insnFormat = InstructionCodec.getInstructionFormat(opcode);
                    insnHolder.address = currentAddress;
                    insnHolder.opcode = opcode;
                    insnHolder.data = data;
                    insnHolder.size = size;
                    insnHolder.elementWidth = elementWidth;
                    result[currentAddress] = insnHolder;
                }
            });
        }
        catch (EOFException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compare() {
        try {
            if (this.insnHolders1 == null && this.insnHolders2 == null) {
                boolean bl = true;
                return bl;
            }
            if (this.insnHolders1 == null || this.insnHolders2 == null) {
                boolean bl = false;
                return bl;
            }
            int currAddress1 = 0;
            int currAddress2 = 0;
            int insnHolderCount1 = 0;
            int insnHolderCount2 = 0;
            while (currAddress1 < this.insnHolders1.length && currAddress2 < this.insnHolders2.length) {
                InstructionHolder insnHolder1 = null;
                InstructionHolder insnHolder2 = null;
                while (currAddress1 < this.insnHolders1.length && insnHolder1 == null) {
                    insnHolder1 = this.insnHolders1[currAddress1++];
                }
                if (insnHolder1 == null) break;
                ++insnHolderCount1;
                while (currAddress2 < this.insnHolders2.length && insnHolder2 == null) {
                    insnHolder2 = this.insnHolders2[currAddress2++];
                }
                if (insnHolder2 == null) break;
                ++insnHolderCount2;
                if (this.isSameInstruction(insnHolder1, insnHolder2)) continue;
                boolean bl = false;
                return bl;
            }
            while (currAddress1 < this.insnHolders1.length) {
                if (this.insnHolders1[currAddress1++] == null) continue;
                boolean bl = false;
                return bl;
            }
            while (currAddress2 < this.insnHolders2.length) {
                if (this.insnHolders2[currAddress2++] == null) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = insnHolderCount1 == insnHolderCount2;
            return bl;
        }
        finally {
            this.visitedInsnAddrPairs.clear();
        }
    }

    private int getPromotedOpCodeOnDemand(InstructionHolder insn) {
        int opcode = insn.opcode;
        if (opcode == 26 || opcode == 27) {
            return 27;
        }
        if (opcode == 40 || opcode == 41 || opcode == 42) {
            return 42;
        }
        return opcode;
    }

    public boolean isSameInstruction(int insnAddress1, int insnAddress2) {
        InstructionHolder insnHolder1 = insnAddress1 < this.insnHolders1.length ? this.insnHolders1[insnAddress1] : null;
        InstructionHolder insnHolder2 = insnAddress2 < this.insnHolders2.length ? this.insnHolders2[insnAddress2] : null;
        return this.isSameInstruction(insnHolder1, insnHolder2);
    }

    public boolean isSameInstruction(InstructionHolder insnHolder1, InstructionHolder insnHolder2) {
        if (insnHolder1 == null && insnHolder2 == null) {
            return true;
        }
        if (insnHolder1 == null || insnHolder2 == null) {
            return false;
        }
        if (this.getPromotedOpCodeOnDemand(insnHolder1) != this.getPromotedOpCodeOnDemand(insnHolder2)) {
            return false;
        }
        int opcode = insnHolder1.opcode;
        int insnFormat = insnHolder1.insnFormat;
        switch (insnFormat) {
            case 2: 
            case 7: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                String addrPairStr = insnHolder1.address + "-" + insnHolder2.address;
                if (this.visitedInsnAddrPairs.add(addrPairStr)) {
                    return this.isSameInstruction(insnHolder1.target, insnHolder2.target);
                }
                return true;
            }
            case 8: 
            case 13: 
            case 19: 
            case 23: 
            case 24: {
                if (!this.compareIndex(opcode, insnHolder1.index, insnHolder2.index)) {
                    return false;
                }
                if (insnHolder1.a != insnHolder2.a) {
                    return false;
                }
                if (insnHolder1.b != insnHolder2.b) {
                    return false;
                }
                if (insnHolder1.c != insnHolder2.c) {
                    return false;
                }
                return insnHolder1.d == insnHolder2.d;
            }
            case 26: {
                if (!this.compareMethod(insnHolder1.index, insnHolder2.index)) {
                    return false;
                }
                if (!this.compareProto(insnHolder1.protoIndex, insnHolder2.protoIndex)) {
                    return false;
                }
                return Arrays.equals(insnHolder1.registers, insnHolder2.registers);
            }
            case 27: {
                if (!this.compareMethod(insnHolder1.index, insnHolder2.index)) {
                    return false;
                }
                if (!this.compareProto(insnHolder1.protoIndex, insnHolder2.protoIndex)) {
                    return false;
                }
                return insnHolder1.c == insnHolder2.c;
            }
            case 28: {
                PackedSwitchPayloadInsntructionHolder specInsnHolder1 = (PackedSwitchPayloadInsntructionHolder)insnHolder1;
                PackedSwitchPayloadInsntructionHolder specInsnHolder2 = (PackedSwitchPayloadInsntructionHolder)insnHolder2;
                if (specInsnHolder1.firstKey != specInsnHolder2.firstKey) {
                    return false;
                }
                if (specInsnHolder1.targets.length != specInsnHolder2.targets.length) {
                    return false;
                }
                int targetCount = specInsnHolder1.targets.length;
                for (int i = 0; i < targetCount; ++i) {
                    if (this.isSameInstruction(specInsnHolder1.targets[i], specInsnHolder2.targets[i])) continue;
                    return false;
                }
                return true;
            }
            case 29: {
                SparseSwitchPayloadInsntructionHolder specInsnHolder1 = (SparseSwitchPayloadInsntructionHolder)insnHolder1;
                SparseSwitchPayloadInsntructionHolder specInsnHolder2 = (SparseSwitchPayloadInsntructionHolder)insnHolder2;
                if (CompareUtils.uArrCompare(specInsnHolder1.keys, specInsnHolder2.keys) != 0) {
                    return false;
                }
                if (specInsnHolder1.targets.length != specInsnHolder2.targets.length) {
                    return false;
                }
                int targetCount = specInsnHolder1.targets.length;
                for (int i = 0; i < targetCount; ++i) {
                    if (this.isSameInstruction(specInsnHolder1.targets[i], specInsnHolder2.targets[i])) continue;
                    return false;
                }
                return true;
            }
            case 30: {
                FillArrayDataPayloadInstructionHolder specInsnHolder1 = (FillArrayDataPayloadInstructionHolder)insnHolder1;
                FillArrayDataPayloadInstructionHolder specInsnHolder2 = (FillArrayDataPayloadInstructionHolder)insnHolder2;
                if (specInsnHolder1.elementWidth != specInsnHolder2.elementWidth) {
                    return false;
                }
                if (specInsnHolder1.size != specInsnHolder2.size) {
                    return false;
                }
                int elementWidth = specInsnHolder1.elementWidth;
                switch (elementWidth) {
                    case 1: {
                        byte[] array1 = (byte[])specInsnHolder1.data;
                        byte[] array2 = (byte[])specInsnHolder2.data;
                        return CompareUtils.uArrCompare(array1, array2) == 0;
                    }
                    case 2: {
                        short[] array1 = (short[])specInsnHolder1.data;
                        short[] array2 = (short[])specInsnHolder2.data;
                        return CompareUtils.uArrCompare(array1, array2) == 0;
                    }
                    case 4: {
                        int[] array1 = (int[])specInsnHolder1.data;
                        int[] array2 = (int[])specInsnHolder2.data;
                        return CompareUtils.uArrCompare(array1, array2) == 0;
                    }
                    case 8: {
                        long[] array1 = (long[])specInsnHolder1.data;
                        long[] array2 = (long[])specInsnHolder2.data;
                        return CompareUtils.sArrCompare(array1, array2) == 0;
                    }
                }
                throw new DexException("bogus element_width: " + Hex.u2(elementWidth));
            }
        }
        if (insnHolder1.literal != insnHolder2.literal) {
            return false;
        }
        if (insnHolder1.registerCount != insnHolder2.registerCount) {
            return false;
        }
        if (insnHolder1.a != insnHolder2.a) {
            return false;
        }
        if (insnHolder1.b != insnHolder2.b) {
            return false;
        }
        if (insnHolder1.c != insnHolder2.c) {
            return false;
        }
        if (insnHolder1.d != insnHolder2.d) {
            return false;
        }
        if (insnHolder1.e != insnHolder2.e) {
            return false;
        }
        return Arrays.equals(insnHolder1.registers, insnHolder2.registers);
    }

    private boolean compareIndex(int opcode, int index1, int index2) {
        int indexType = InstructionCodec.getInstructionIndexType(opcode);
        switch (indexType) {
            case 3: {
                return this.compareString(index1, index2);
            }
            case 2: {
                return this.compareType(index1, index2);
            }
            case 5: {
                return this.compareField(index1, index2);
            }
            case 4: {
                return this.compareMethod(index1, index2);
            }
            case 7: {
                return this.compareCallSite(index1, index2);
            }
            case 8: {
                return this.compareMethodHandle(index1, index2);
            }
            case 9: {
                return this.compareProto(index1, index2);
            }
        }
        throw new IllegalArgumentException("Unknown index type " + indexType + " for opcode " + Hex.u1(opcode));
    }

    protected abstract boolean compareString(int var1, int var2);

    protected abstract boolean compareType(int var1, int var2);

    protected abstract boolean compareField(int var1, int var2);

    protected abstract boolean compareMethod(int var1, int var2);

    protected abstract boolean compareCallSite(int var1, int var2);

    protected abstract boolean compareMethodHandle(int var1, int var2);

    protected abstract boolean compareProto(int var1, int var2);

    private static class FillArrayDataPayloadInstructionHolder
    extends InstructionHolder {
        Object data = null;
        int size = 0;
        int elementWidth = 0;

        private FillArrayDataPayloadInstructionHolder() {
        }
    }

    private static class PackedSwitchPayloadInsntructionHolder
    extends InstructionHolder {
        int firstKey = 0;
        int[] targets = null;

        private PackedSwitchPayloadInsntructionHolder() {
        }
    }

    private static class SparseSwitchPayloadInsntructionHolder
    extends InstructionHolder {
        int[] keys = null;
        int[] targets = null;

        private SparseSwitchPayloadInsntructionHolder() {
        }
    }

    private static class InstructionHolder {
        int insnFormat = 0;
        int address = -1;
        int opcode = -1;
        int index = 0;
        int target = 0;
        long literal = 0L;
        int registerCount = 0;
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int e = 0;
        int protoIndex = 0;
        int[] registers = null;

        private InstructionHolder() {
        }
    }
}

