/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dx.instruction;

import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dx.instruction.InstructionCodec;
import com.tencent.tinker.android.dx.instruction.InstructionPromoter;
import com.tencent.tinker.android.dx.instruction.InstructionVisitor;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeOutput;
import com.tencent.tinker.android.dx.util.Hex;

public final class InstructionWriter
extends InstructionVisitor {
    private final ShortArrayCodeOutput codeOut;
    private final InstructionPromoter insnPromoter;
    private final boolean hasPromoter;
    int currOpcode = 0;
    int currIndex = 0;
    int currTarget = 0;
    long currLiteral = 0L;
    int currRegisterCount = 0;
    int currRegA = 0;
    int currRegB = 0;
    int currRegC = 0;
    int currRegD = 0;
    int currRegE = 0;
    int currRegF = 0;
    int currRegG = 0;
    int currProtoIndex = 0;
    int[] currKeys = null;
    int[] currTargets = null;
    int currFirstKey = 0;
    int currElementWidth = 0;
    Object currData = null;
    int currSize = 0;

    public InstructionWriter(ShortArrayCodeOutput codeOut, InstructionPromoter ipmo) {
        super(null);
        this.codeOut = codeOut;
        this.insnPromoter = ipmo;
        this.hasPromoter = ipmo != null;
    }

    @Override
    public void visitZeroRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal) {
        if (this.hasPromoter) {
            target = this.insnPromoter.getPromotedAddress(target);
            switch (opcode) {
                case 40: {
                    int relativeTarget = InstructionCodec.getTarget(target, this.codeOut.cursor());
                    if (relativeTarget == (byte)relativeTarget) break;
                    if (relativeTarget == (short)relativeTarget) {
                        opcode = 41;
                        break;
                    }
                    opcode = 42;
                    break;
                }
                case 41: {
                    int relativeTarget = InstructionCodec.getTarget(target, this.codeOut.cursor());
                    if (relativeTarget == (short)relativeTarget) break;
                    opcode = 42;
                    break;
                }
            }
        }
        this.currOpcode = opcode;
        this.currIndex = index;
        this.currTarget = target;
        this.currLiteral = literal;
        this.currRegisterCount = 0;
        this.currRegA = 0;
        this.currRegB = 0;
        this.currRegC = 0;
        this.currRegD = 0;
        this.currRegE = 0;
        this.currRegF = 0;
        this.currRegG = 0;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitOneRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a) {
        if (this.hasPromoter) {
            target = this.insnPromoter.getPromotedAddress(target);
        }
        if (opcode == 26) {
            if (this.hasPromoter) {
                if (index > 65535) {
                    opcode = 27;
                }
            } else if (index > 65535) {
                throw new DexException("string index out of bound: " + Hex.u4(index) + ", perhaps you need to enable force jumbo mode.");
            }
        }
        this.currOpcode = opcode;
        this.currIndex = index;
        this.currTarget = target;
        this.currLiteral = literal;
        this.currRegisterCount = 1;
        this.currRegA = a;
        this.currRegB = 0;
        this.currRegC = 0;
        this.currRegD = 0;
        this.currRegE = 0;
        this.currRegF = 0;
        this.currRegG = 0;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitTwoRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b) {
        if (this.hasPromoter) {
            target = this.insnPromoter.getPromotedAddress(target);
        }
        this.currOpcode = opcode;
        this.currIndex = index;
        this.currTarget = target;
        this.currLiteral = literal;
        this.currRegisterCount = 2;
        this.currRegA = a;
        this.currRegB = b;
        this.currRegC = 0;
        this.currRegD = 0;
        this.currRegE = 0;
        this.currRegF = 0;
        this.currRegG = 0;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitThreeRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c) {
        this.currOpcode = opcode;
        this.currIndex = index;
        this.currTarget = target;
        this.currLiteral = literal;
        this.currRegisterCount = 3;
        this.currRegA = a;
        this.currRegB = b;
        this.currRegC = c;
        this.currRegD = 0;
        this.currRegE = 0;
        this.currRegF = 0;
        this.currRegG = 0;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitFourRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d) {
        this.currOpcode = opcode;
        this.currIndex = index;
        this.currTarget = target;
        this.currLiteral = literal;
        this.currRegisterCount = 4;
        this.currRegA = a;
        this.currRegB = b;
        this.currRegC = c;
        this.currRegD = d;
        this.currRegE = 0;
        this.currRegF = 0;
        this.currRegG = 0;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitFiveRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d, int e) {
        this.currOpcode = opcode;
        this.currIndex = index;
        this.currTarget = target;
        this.currLiteral = literal;
        this.currRegisterCount = 5;
        this.currRegA = a;
        this.currRegB = b;
        this.currRegC = c;
        this.currRegD = d;
        this.currRegE = e;
        this.currRegF = 0;
        this.currRegG = 0;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitRegisterRangeInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int registerCount) {
        this.currOpcode = opcode;
        this.currIndex = index;
        this.currTarget = target;
        this.currLiteral = literal;
        this.currRegisterCount = registerCount;
        this.currRegA = a;
        this.currRegB = 0;
        this.currRegC = 0;
        this.currRegD = 0;
        this.currRegE = 0;
        this.currRegF = 0;
        this.currRegG = 0;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitInvokePolymorphicInstruction(int currentAddress, int opcode, int methodIndex, int indexType, int protoIndex, int[] registers) {
        this.currOpcode = opcode;
        this.currIndex = methodIndex;
        this.currProtoIndex = protoIndex;
        this.currRegisterCount = registers.length;
        this.currRegA = 0;
        this.currRegB = 0;
        this.currRegC = registers.length > 0 ? registers[0] : 0;
        this.currRegD = registers.length > 1 ? registers[1] : 0;
        this.currRegE = registers.length > 2 ? registers[2] : 0;
        this.currRegF = registers.length > 3 ? registers[3] : 0;
        this.currRegG = registers.length > 4 ? registers[4] : 0;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitInvokePolymorphicRangeInstruction(int currentAddress, int opcode, int methodIndex, int indexType, int c, int registerCount, int protoIndex) {
        this.currOpcode = opcode;
        this.currIndex = methodIndex;
        this.currRegisterCount = registerCount;
        this.currRegA = 0;
        this.currRegB = 0;
        this.currRegC = c;
        this.currRegD = 0;
        this.currRegE = 0;
        this.currRegF = 0;
        this.currRegG = 0;
        this.currProtoIndex = protoIndex;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitSparseSwitchPayloadInsn(int currentAddress, int opcode, int[] keys, int[] targets) {
        this.currOpcode = opcode;
        this.currKeys = keys;
        if (this.hasPromoter) {
            this.currTargets = new int[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                this.currTargets[i] = this.insnPromoter.getPromotedAddress(targets[i]);
            }
        } else {
            this.currTargets = targets;
        }
        this.currRegisterCount = 0;
        this.currRegA = 0;
        this.currRegB = 0;
        this.currRegC = 0;
        this.currRegD = 0;
        this.currRegE = 0;
        this.currRegF = 0;
        this.currRegG = 0;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitPackedSwitchPayloadInsn(int currentAddress, int opcode, int firstKey, int[] targets) {
        this.currOpcode = opcode;
        this.currFirstKey = firstKey;
        if (this.hasPromoter) {
            this.currTargets = new int[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                this.currTargets[i] = this.insnPromoter.getPromotedAddress(targets[i]);
            }
        } else {
            this.currTargets = targets;
        }
        this.currRegisterCount = 0;
        this.currRegA = 0;
        this.currRegB = 0;
        this.currRegC = 0;
        this.currRegD = 0;
        this.currRegE = 0;
        this.currRegF = 0;
        this.currRegG = 0;
        InstructionCodec.encode(this.codeOut, this);
    }

    @Override
    public void visitFillArrayDataPayloadInsn(int currentAddress, int opcode, Object data, int size, int elementWidth) {
        this.currOpcode = opcode;
        this.currData = data;
        this.currSize = size;
        this.currElementWidth = elementWidth;
        this.currRegisterCount = 0;
        this.currRegA = 0;
        this.currRegB = 0;
        this.currRegC = 0;
        this.currRegD = 0;
        this.currRegE = 0;
        this.currRegF = 0;
        this.currRegG = 0;
        InstructionCodec.encode(this.codeOut, this);
    }
}

