/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.patch.BsDiffPatchInternal;
import com.tencent.tinker.lib.patch.DexDiffPatchInternal;
import com.tencent.tinker.lib.patch.ResDiffPatchInternal;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;

public class RepairPatch
extends AbstractPatch {
    private static final String TAG = "Tinker.RepairPatch";

    @Override
    public boolean tryPatch(Context context, String tempPatchPath, PatchResult patchResult) {
        String patchMd5;
        Tinker manager = Tinker.with(context);
        File patchFile = new File(tempPatchPath);
        if (!manager.isTinkerEnabled() || !ShareTinkerInternals.isTinkerEnableWithSharedPreferences((Context)context)) {
            TinkerLog.e(TAG, "RepairPatch tryPatch:patch is disabled, just return", new Object[0]);
            return false;
        }
        if (!patchFile.isFile() || !patchFile.exists()) {
            TinkerLog.e(TAG, "RepairPatch tryPatch:patch file is not found, just return", new Object[0]);
            return false;
        }
        ShareSecurityCheck signatureCheck = new ShareSecurityCheck(context);
        int returnCode = ShareTinkerInternals.checkSignatureAndTinkerID((Context)context, (File)patchFile, (ShareSecurityCheck)signatureCheck);
        if (returnCode != 0) {
            TinkerLog.e(TAG, "RepairPatch tryPatch:onPatchPackageCheckFail", new Object[0]);
            manager.getPatchReporter().onPatchPackageCheckFail(patchFile, false, returnCode);
            return false;
        }
        patchResult.patchTinkerID = signatureCheck.getNewTinkerID();
        patchResult.baseTinkerID = signatureCheck.getTinkerID();
        SharePatchInfo oldInfo = manager.getTinkerLoadResultIfPresent().patchInfo;
        patchResult.patchVersion = patchMd5 = SharePatchFileUtil.getMD5((File)patchFile);
        if (oldInfo == null) {
            TinkerLog.e(TAG, "OldPatchProcessor tryPatch:onPatchVersionCheckFail, oldInfo is null", new Object[0]);
            manager.getPatchReporter().onPatchVersionCheckFail(patchFile, oldInfo, patchMd5, false);
            return false;
        }
        if (oldInfo.oldVersion == null || oldInfo.newVersion == null) {
            TinkerLog.e(TAG, "RepairPatch tryPatch:onPatchInfoCorrupted", new Object[0]);
            manager.getPatchReporter().onPatchInfoCorrupted(patchFile, oldInfo.oldVersion, oldInfo.newVersion, false);
            return false;
        }
        if (!oldInfo.oldVersion.equals(patchMd5) || !oldInfo.newVersion.equals(patchMd5)) {
            TinkerLog.e(TAG, "RepairPatch tryPatch:onPatchVersionCheckFail", new Object[0]);
            manager.getPatchReporter().onPatchVersionCheckFail(patchFile, oldInfo, patchMd5, false);
            return false;
        }
        String patchDirectory = manager.getPatchDirectory().getAbsolutePath();
        String patchName = SharePatchFileUtil.getPatchVersionDirectory((String)patchMd5);
        String patchVersionDirectory = patchDirectory + "/" + patchName;
        if (!DexDiffPatchInternal.tryRecoverDexFiles(manager, signatureCheck, context, patchVersionDirectory, patchFile, false)) {
            TinkerLog.e(TAG, "RepairPatch tryPatch:try patch dex failed", new Object[0]);
            return false;
        }
        if (!BsDiffPatchInternal.tryRecoverLibraryFiles(manager, signatureCheck, context, patchVersionDirectory, patchFile, false)) {
            TinkerLog.e(TAG, "RepairPatch tryPatch:try patch library failed", new Object[0]);
            return false;
        }
        if (!ResDiffPatchInternal.tryRecoverResourceFiles(manager, signatureCheck, context, patchVersionDirectory, patchFile, false)) {
            TinkerLog.e(TAG, "RepairPatch tryPatch:try patch resource failed", new Object[0]);
            return false;
        }
        return true;
    }
}

