/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.reporter;

import android.content.Context;
import com.tencent.tinker.lib.reporter.LoadReporter;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerInstaller;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;

public class DefaultLoadReporter
implements LoadReporter {
    private static final String TAG = "Tinker.DefaultLoadReporter";
    protected final Context context;

    public DefaultLoadReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onLoadPatchListenerReceiveFail(File patchFile, int errorCode, boolean isUpgrade) {
        TinkerLog.i(TAG, "patch load Reporter: patch receive fail:%s, code:%d, isUpgrade:%b", patchFile.getAbsolutePath(), errorCode, isUpgrade);
    }

    @Override
    public void onLoadPatchVersionChanged(String oldVersion, String newVersion, File patchDirectoryFile, String currentPatchName) {
        TinkerLog.i(TAG, "patch version change from " + oldVersion + " to " + newVersion, new Object[0]);
        if (oldVersion == null || newVersion == null) {
            return;
        }
        if (oldVersion.equals(newVersion)) {
            return;
        }
        if (!Tinker.with(this.context).isMainProcess()) {
            return;
        }
        TinkerLog.i(TAG, "try kill all other process", new Object[0]);
        ShareTinkerInternals.killAllOtherProcess((Context)this.context);
        File[] files = patchDirectoryFile.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!file.isDirectory() || name.equals(currentPatchName)) continue;
                SharePatchFileUtil.deleteDir((File)file);
            }
        }
    }

    @Override
    public void onLoadFileNotFound(File file, int fileType, boolean isDirectory) {
        TinkerLog.i(TAG, "patch file not found: %s, fileType:%d, isDirectory:%b", file.getAbsolutePath(), fileType, isDirectory);
        if (fileType == 3 || fileType == 5 || fileType == 6 || fileType == 7) {
            File patchVersionFile;
            Tinker tinker = Tinker.with(this.context);
            if (!tinker.isPatchProcess() && (patchVersionFile = tinker.getTinkerLoadResultIfPresent().patchVersionFile) != null) {
                TinkerInstaller.onReceiveRepairPatch(this.context, patchVersionFile.getAbsolutePath());
            }
        } else if (fileType == 1 || fileType == 2) {
            Tinker.with(this.context).cleanPatch();
        }
    }

    @Override
    public void onLoadFileMd5Mismatch(File file, int fileType) {
        TinkerLog.i(TAG, "patch file md5 mismatch file: %s, fileType:%d", file.getAbsolutePath(), fileType);
        Tinker.with(this.context).cleanPatch();
    }

    @Override
    public void onLoadPatchInfoCorrupted(String oldVersion, String newVersion, File patchInfoFile) {
        TinkerLog.i(TAG, "patch info file damage: %s", patchInfoFile.getAbsolutePath());
        TinkerLog.i(TAG, "patch info file damage from version: %s to version: %s", oldVersion, newVersion);
        Tinker.with(this.context).cleanPatch();
    }

    @Override
    public void onLoadResult(File patchDirectory, int loadCode, long cost) {
        TinkerLog.i(TAG, "patch load result, path:%s, code:%d, cost:%d", patchDirectory.getAbsolutePath(), loadCode, cost);
    }

    @Override
    public void onLoadException(Throwable e, int errorCode) {
        switch (errorCode) {
            case -2: {
                if (e.getMessage().contains("checkDexInstall failed")) {
                    TinkerLog.e(TAG, "tinker dex check fail:" + e.getMessage(), new Object[0]);
                } else {
                    TinkerLog.i(TAG, "patch load dex exception: %s", e);
                }
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences((Context)this.context);
                TinkerLog.i(TAG, "dex exception disable tinker forever with sp", new Object[0]);
                break;
            }
            case -3: {
                TinkerLog.i(TAG, "patch load resource exception: %s", e);
                break;
            }
            case -4: {
                TinkerLog.i(TAG, "patch load unCatch exception: %s", e);
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences((Context)this.context);
                TinkerLog.i(TAG, "unCaught exception disable tinker forever with sp", new Object[0]);
                break;
            }
            case -1: {
                TinkerLog.i(TAG, "patch load unknown exception: %s", e);
            }
        }
        TinkerLog.printErrStackTrace(TAG, e, "tinker load exception", new Object[0]);
        Tinker.with(this.context).setTinkerDisable();
        Tinker.with(this.context).cleanPatch();
    }

    @Override
    public void onLoadPackageCheckFail(File patchFile, int errorCode) {
        TinkerLog.i(TAG, "load patch package check fail file path:%s, errorCode:%d", patchFile.getAbsolutePath(), errorCode);
        Tinker.with(this.context).cleanPatch();
    }
}

