/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.util;

import android.app.ActivityManager;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Process;
import android.util.Log;
import com.tencent.tinker.lib.service.TinkerPatchService;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.util.List;

public class TinkerServiceInternals
extends ShareTinkerInternals {
    private static final String TAG = "Tinker.ServiceInternals";
    private static String patchServiceProcessName = null;

    public static void killTinkerPatchServiceProcess(Context context) {
        String serverProcessName = TinkerServiceInternals.getTinkerPatchServiceName(context);
        if (serverProcessName == null) {
            return;
        }
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : am.getRunningAppProcesses()) {
            String processName = appProcess.processName;
            if (!processName.equals(serverProcessName)) continue;
            Process.killProcess((int)appProcess.pid);
        }
    }

    public static boolean isTinkerPatchServiceRunning(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        String serverName = TinkerServiceInternals.getTinkerPatchServiceName(context);
        if (serverName == null) {
            return false;
        }
        try {
            List appProcessList = am.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcessList) {
                String processName = appProcess.processName;
                if (!processName.equals(serverName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("isTinkerPatchServiceRunning Exception: " + e.toString()));
            return false;
        }
        catch (Error e) {
            Log.e((String)TAG, (String)("isTinkerPatchServiceRunning Error: " + e.toString()));
            return false;
        }
        return false;
    }

    public static String getTinkerPatchServiceName(Context context) {
        if (patchServiceProcessName != null) {
            return patchServiceProcessName;
        }
        String serviceName = TinkerServiceInternals.getServiceProcessName(context, TinkerPatchService.class);
        if (serviceName == null) {
            return null;
        }
        patchServiceProcessName = serviceName;
        return patchServiceProcessName;
    }

    public static boolean isInTinkerPatchServiceProcess(Context context) {
        String process = TinkerServiceInternals.getProcessName((Context)context);
        String service = TinkerServiceInternals.getTinkerPatchServiceName(context);
        if (service == null || service.length() == 0) {
            return false;
        }
        return process.equals(service);
    }

    private static String getServiceProcessName(Context context, Class<? extends Service> serviceClass) {
        ServiceInfo serviceInfo;
        PackageManager packageManager = context.getPackageManager();
        ComponentName component = new ComponentName(context, serviceClass);
        try {
            serviceInfo = packageManager.getServiceInfo(component, 0);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return null;
        }
        return serviceInfo.processName;
    }
}

