/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import java.io.Serializable;

public abstract class AbstractResultService
extends IntentService {
    private static final String TAG = "Tinker.AbstractResultService";
    private static final String RESULT_EXTRA = "result_extra";
    private static Class<? extends AbstractResultService> resultServiceClass = null;

    public AbstractResultService() {
        super(AbstractResultService.class.getSimpleName());
    }

    public static void runResultService(Context context, PatchResult result) {
        if (resultServiceClass == null) {
            throw new TinkerRuntimeException("resultServiceClass is null.");
        }
        Intent intent = new Intent(context, resultServiceClass);
        intent.putExtra(RESULT_EXTRA, (Serializable)result);
        context.startService(intent);
    }

    public static void setResultServiceClass(Class<? extends AbstractResultService> serviceClass) {
        resultServiceClass = serviceClass;
        try {
            Class.forName(serviceClass.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            TinkerLog.e(TAG, "AbstractResultService received a null intent, ignoring.", new Object[0]);
            return;
        }
        PatchResult result = (PatchResult)ShareIntentUtil.getSerializableExtra((Intent)intent, (String)RESULT_EXTRA);
        this.onPatchResult(result);
    }

    public abstract void onPatchResult(PatchResult var1);
}

