/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.service;

import android.app.IntentService;
import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.SystemClock;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.service.AbstractResultService;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import java.io.File;

public class TinkerPatchService
extends IntentService {
    private static final String TAG = "Tinker.TinkerPatchService";
    private static final String PATCH_PATH_EXTRA = "patch_path_extra";
    private static final String PATCH_NEW_EXTRA = "patch_new_extra";
    private static AbstractPatch upgradePatchProcessor = null;
    private static AbstractPatch repairPatchProcessor = null;
    private static int notificationId = -1119860829;

    public TinkerPatchService() {
        super(TinkerPatchService.class.getSimpleName());
    }

    public static void runPatchService(Context context, String path, boolean isUpgradePatch) {
        Intent intent = new Intent(context, TinkerPatchService.class);
        intent.putExtra(PATCH_PATH_EXTRA, path);
        intent.putExtra(PATCH_NEW_EXTRA, isUpgradePatch);
        context.startService(intent);
    }

    public static void setPatchProcessor(AbstractPatch upgradePatch, AbstractPatch repairPatch) {
        upgradePatchProcessor = upgradePatch;
        repairPatchProcessor = repairPatch;
    }

    public static String getPatchPathExtra(Intent intent) {
        if (intent == null) {
            throw new TinkerRuntimeException("getPatchPathExtra, but intent is null");
        }
        return ShareIntentUtil.getStringExtra((Intent)intent, (String)PATCH_PATH_EXTRA);
    }

    public static boolean getPatchUpgradeExtra(Intent intent) {
        if (intent == null) {
            throw new TinkerRuntimeException("getPatchUpgradeExtra, but intent is null");
        }
        return ShareIntentUtil.getBooleanExtra((Intent)intent, (String)PATCH_NEW_EXTRA, (boolean)false);
    }

    public static void setTinkerNotificationId(int id) {
        notificationId = id;
    }

    protected void onHandleIntent(Intent intent) {
        boolean result;
        Context context = this.getApplicationContext();
        Tinker tinker = Tinker.with(context);
        tinker.getPatchReporter().onPatchServiceStart(intent);
        if (intent == null) {
            TinkerLog.e(TAG, "TinkerPatchService received a null intent, ignoring.", new Object[0]);
            return;
        }
        String path = TinkerPatchService.getPatchPathExtra(intent);
        if (path == null) {
            TinkerLog.e(TAG, "TinkerPatchService can't get the path extra, ignoring.", new Object[0]);
            return;
        }
        File patchFile = new File(path);
        boolean isUpgradePatch = TinkerPatchService.getPatchUpgradeExtra(intent);
        long begin = SystemClock.elapsedRealtime();
        Throwable e = null;
        this.increasingPriority();
        PatchResult patchResult = new PatchResult();
        try {
            if (isUpgradePatch) {
                if (upgradePatchProcessor == null) {
                    throw new TinkerRuntimeException("upgradePatchProcessor is null.");
                }
                result = upgradePatchProcessor.tryPatch(context, path, patchResult);
            } else {
                if (repairPatchProcessor == null) {
                    throw new TinkerRuntimeException("upgradePatchProcessor is null.");
                }
                result = repairPatchProcessor.tryPatch(context, path, patchResult);
            }
        }
        catch (Throwable throwable) {
            e = throwable;
            result = false;
            tinker.getPatchReporter().onPatchException(patchFile, e, isUpgradePatch);
        }
        long cost = SystemClock.elapsedRealtime() - begin;
        tinker.getPatchReporter().onPatchResult(patchFile, result, cost, isUpgradePatch);
        patchResult.isSuccess = result;
        patchResult.isUpgradePatch = isUpgradePatch;
        patchResult.rawPatchFilePath = path;
        patchResult.costTime = cost;
        patchResult.e = e;
        AbstractResultService.runResultService(context, patchResult);
    }

    private void increasingPriority() {
        if (Build.VERSION.SDK_INT > 24) {
            TinkerLog.i(TAG, "for Android 7.1, we just ignore increasingPriority job", new Object[0]);
            return;
        }
        TinkerLog.i(TAG, "try to increase patch process priority", new Object[0]);
        try {
            Notification notification = new Notification();
            if (Build.VERSION.SDK_INT < 18) {
                this.startForeground(notificationId, notification);
            } else {
                this.startForeground(notificationId, notification);
                this.startService(new Intent((Context)this, InnerService.class));
            }
        }
        catch (Throwable e) {
            TinkerLog.i(TAG, "try to increase patch process priority error:" + e, new Object[0]);
        }
    }

    public static class InnerService
    extends Service {
        public void onCreate() {
            super.onCreate();
            try {
                this.startForeground(notificationId, new Notification());
            }
            catch (Throwable e) {
                TinkerLog.e(TinkerPatchService.TAG, "InnerService set service for push exception:%s.", e);
            }
            this.stopSelf();
        }

        public void onDestroy() {
            this.stopForeground(true);
            super.onDestroy();
        }

        public IBinder onBind(Intent intent) {
            return null;
        }
    }
}

