/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.SystemClock;
import com.tencent.tinker.commons.dexpatcher.DexPatchApplier;
import com.tencent.tinker.lib.patch.BasePatchInternal;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerParallelDexOptimizer;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareDexDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import dalvik.system.DexFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DexDiffPatchInternal
extends BasePatchInternal {
    protected static final String TAG = "Tinker.DexDiffPatchInternal";

    protected static boolean tryRecoverDexFiles(Tinker manager, ShareSecurityCheck checker, Context context, String patchVersionDirectory, File patchFile) {
        if (!manager.isEnabledForDex()) {
            TinkerLog.w(TAG, "patch recover, dex is not enabled", new Object[0]);
            return true;
        }
        String dexMeta = (String)checker.getMetaContentMap().get("assets/dex_meta.txt");
        if (dexMeta == null) {
            TinkerLog.w(TAG, "patch recover, dex is not contained", new Object[0]);
            return true;
        }
        long begin = SystemClock.elapsedRealtime();
        boolean result = DexDiffPatchInternal.patchDexExtractViaDexDiff(context, patchVersionDirectory, dexMeta, patchFile);
        long cost = SystemClock.elapsedRealtime() - begin;
        TinkerLog.i(TAG, "recover dex result:%b, cost:%d", result, cost);
        return result;
    }

    private static boolean patchDexExtractViaDexDiff(Context context, String patchVersionDirectory, String meta, final File patchFile) {
        String dir = patchVersionDirectory + "/" + "dex" + "/";
        if (!DexDiffPatchInternal.extractDexDiffInternals(context, dir, meta, patchFile, 3)) {
            TinkerLog.w(TAG, "patch recover, extractDiffInternals fail", new Object[0]);
            return false;
        }
        final Tinker manager = Tinker.with(context);
        File dexFiles = new File(dir);
        File[] files = dexFiles.listFiles();
        if (files != null) {
            final String optimizeDexDirectory = patchVersionDirectory + "/" + "odex" + "/";
            File optimizeDexDirectoryFile = new File(optimizeDexDirectory);
            if (!optimizeDexDirectoryFile.exists() && !optimizeDexDirectoryFile.mkdirs()) {
                TinkerLog.w(TAG, "patch recover, make optimizeDexDirectoryFile fail", new Object[0]);
                return false;
            }
            TinkerLog.w(TAG, "patch recover, try to optimize dex file count:%d", files.length);
            boolean isSuccess = TinkerParallelDexOptimizer.optimizeAll((File[])files, (File)optimizeDexDirectoryFile, (TinkerParallelDexOptimizer.ResultCallback)new TinkerParallelDexOptimizer.ResultCallback(){
                long startTime;

                public void onStart(File dexFile, File optimizedDir) {
                    this.startTime = System.currentTimeMillis();
                    TinkerLog.i(DexDiffPatchInternal.TAG, "start to optimize dex %s", dexFile.getPath());
                }

                public void onSuccess(File dexFile, File optimizedDir) {
                    TinkerLog.i(DexDiffPatchInternal.TAG, "success to optimize dex %s use time %d", dexFile.getPath(), System.currentTimeMillis() - this.startTime);
                }

                public void onFailed(File dexFile, File optimizedDir, Throwable thr) {
                    TinkerLog.i(DexDiffPatchInternal.TAG, "fail to optimize dex %s use time %d", dexFile.getPath(), System.currentTimeMillis() - this.startTime);
                    SharePatchFileUtil.safeDeleteFile((File)dexFile);
                    manager.getPatchReporter().onPatchDexOptFail(patchFile, dexFile, optimizeDexDirectory, dexFile.getName(), thr);
                }
            });
            if (isSuccess) {
                for (File file : files) {
                    try {
                        if (!SharePatchFileUtil.isLegalFile((File)file)) {
                            TinkerLog.e(TAG, "single dex optimizer file %s is not exist, just return false", file);
                            return false;
                        }
                        String outputPathName = SharePatchFileUtil.optimizedPathFor((File)file, (File)optimizeDexDirectoryFile);
                        File outputFile = new File(outputPathName);
                        if (SharePatchFileUtil.isLegalFile((File)outputFile)) continue;
                        TinkerLog.e(TAG, "parallel dex optimizer file %s fail, optimize again", outputPathName);
                        long start = System.currentTimeMillis();
                        DexFile.loadDex((String)file.getAbsolutePath(), (String)outputPathName, (int)0);
                        TinkerLog.i(TAG, "success single dex optimize file, path: %s, use time: %d", file.getPath(), System.currentTimeMillis() - start);
                        if (SharePatchFileUtil.isLegalFile((File)outputFile)) continue;
                        manager.getPatchReporter().onPatchDexOptFail(patchFile, file, optimizeDexDirectory, file.getName(), (Throwable)new TinkerRuntimeException("dexOpt file:" + outputPathName + " is not exist"));
                        return false;
                    }
                    catch (Throwable e) {
                        TinkerLog.e(TAG, "dex optimize or load failed, path:" + file.getPath(), new Object[0]);
                        SharePatchFileUtil.safeDeleteFile((File)file);
                        manager.getPatchReporter().onPatchDexOptFail(patchFile, file, optimizeDexDirectory, file.getName(), e);
                        return false;
                    }
                }
            }
            return isSuccess;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private static boolean extractDexDiffInternals(Context context, String dir, String meta, File patchFile, int type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractDexToJar(ZipFile zipFile, ZipEntry entryFile, File extractTo, String targetMd5) throws IOException {
        int numAttempts = 0;
        boolean isExtractionSuccessful = false;
        while (numAttempts < 2 && !isExtractionSuccessful) {
            ++numAttempts;
            FileOutputStream fos = new FileOutputStream(extractTo);
            InputStream in = zipFile.getInputStream(entryFile);
            ZipOutputStream zos = null;
            BufferedInputStream bis = null;
            TinkerLog.i(TAG, "try Extracting " + extractTo.getPath(), new Object[0]);
            try {
                zos = new ZipOutputStream(new BufferedOutputStream(fos));
                bis = new BufferedInputStream(in);
                byte[] buffer = new byte[16384];
                ZipEntry entry = new ZipEntry("classes.dex");
                zos.putNextEntry(entry);
                int length = bis.read(buffer);
                while (length != -1) {
                    zos.write(buffer, 0, length);
                    length = bis.read(buffer);
                }
                zos.closeEntry();
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(bis);
                SharePatchFileUtil.closeQuietly(zos);
                throw throwable;
            }
            SharePatchFileUtil.closeQuietly((Closeable)bis);
            SharePatchFileUtil.closeQuietly((Closeable)zos);
            isExtractionSuccessful = SharePatchFileUtil.verifyDexFileMd5((File)extractTo, (String)targetMd5);
            TinkerLog.i(TAG, "isExtractionSuccessful: %b", isExtractionSuccessful);
            if (isExtractionSuccessful) continue;
            extractTo.delete();
            if (!extractTo.exists()) continue;
            TinkerLog.e(TAG, "Failed to delete corrupted dex " + extractTo.getPath(), new Object[0]);
        }
        return isExtractionSuccessful;
    }

    private static boolean extractDexFile(ZipFile zipFile, ZipEntry entryFile, File extractTo, ShareDexDiffPatchInfo dexInfo) throws IOException {
        String fileMd5 = ShareTinkerInternals.isVmArt() ? dexInfo.destMd5InArt : dexInfo.destMd5InDvm;
        String rawName = dexInfo.rawName;
        boolean isJarMode = dexInfo.isJarMode;
        if (SharePatchFileUtil.isRawDexFile((String)rawName) && isJarMode) {
            return DexDiffPatchInternal.extractDexToJar(zipFile, entryFile, extractTo, fileMd5);
        }
        return DexDiffPatchInternal.extract(zipFile, entryFile, extractTo, fileMd5, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void patchDexFile(ZipFile baseApk, ZipFile patchPkg, ZipEntry oldDexEntry, ZipEntry patchFileEntry, ShareDexDiffPatchInfo patchInfo, File patchedDexFile) throws IOException {
        BufferedInputStream patchFileStream;
        BufferedInputStream oldDexStream;
        block8: {
            oldDexStream = null;
            patchFileStream = null;
            try {
                block9: {
                    oldDexStream = new BufferedInputStream(baseApk.getInputStream(oldDexEntry));
                    patchFileStream = patchFileEntry != null ? new BufferedInputStream(patchPkg.getInputStream(patchFileEntry)) : null;
                    boolean isRawDexFile = SharePatchFileUtil.isRawDexFile((String)patchInfo.rawName);
                    if (isRawDexFile && !patchInfo.isJarMode) break block9;
                    ZipOutputStream zos = null;
                    try {
                        block11: {
                            block10: {
                                zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(patchedDexFile)));
                                zos.putNextEntry(new ZipEntry("classes.dex"));
                                if (isRawDexFile) break block10;
                                ZipInputStream zis = null;
                                try {
                                    ZipEntry entry;
                                    zis = new ZipInputStream(oldDexStream);
                                    while ((entry = zis.getNextEntry()) != null && !"classes.dex".equals(entry.getName())) {
                                    }
                                    if (entry == null) {
                                        throw new TinkerRuntimeException("can't recognize zip dex format file:" + patchedDexFile.getAbsolutePath());
                                    }
                                    new DexPatchApplier((InputStream)zis, (int)entry.getSize(), (InputStream)patchFileStream).executeAndSaveTo((OutputStream)zos);
                                }
                                catch (Throwable throwable) {
                                    SharePatchFileUtil.closeQuietly(zis);
                                    throw throwable;
                                }
                                SharePatchFileUtil.closeQuietly((Closeable)zis);
                                break block11;
                            }
                            new DexPatchApplier((InputStream)oldDexStream, (int)oldDexEntry.getSize(), (InputStream)patchFileStream).executeAndSaveTo((OutputStream)zos);
                        }
                        zos.closeEntry();
                    }
                    catch (Throwable throwable) {
                        SharePatchFileUtil.closeQuietly(zos);
                        throw throwable;
                    }
                    SharePatchFileUtil.closeQuietly((Closeable)zos);
                    break block8;
                }
                new DexPatchApplier((InputStream)oldDexStream, (int)oldDexEntry.getSize(), (InputStream)patchFileStream).executeAndSaveTo(patchedDexFile);
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(oldDexStream);
                SharePatchFileUtil.closeQuietly(patchFileStream);
                throw throwable;
            }
        }
        SharePatchFileUtil.closeQuietly((Closeable)oldDexStream);
        SharePatchFileUtil.closeQuietly((Closeable)patchFileStream);
    }
}

