/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.tinker;

import android.content.Context;
import com.tencent.tinker.lib.listener.PatchListener;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.reporter.LoadReporter;
import com.tencent.tinker.lib.reporter.PatchReporter;
import com.tencent.tinker.lib.service.AbstractResultService;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.app.ApplicationLike;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import java.io.File;

public class TinkerInstaller {
    private static final String TAG = "Tinker.TinkerInstaller";

    public static Tinker install(ApplicationLike applicationLike) {
        Tinker tinker = new Tinker.Builder((Context)applicationLike.getApplication()).build();
        Tinker.create(tinker);
        tinker.install(applicationLike.getTinkerResultIntent());
        return tinker;
    }

    public static Tinker install(ApplicationLike applicationLike, LoadReporter loadReporter, PatchReporter patchReporter, PatchListener listener, Class<? extends AbstractResultService> resultServiceClass, AbstractPatch upgradePatchProcessor) {
        Tinker tinker = new Tinker.Builder((Context)applicationLike.getApplication()).tinkerFlags(applicationLike.getTinkerFlags()).loadReport(loadReporter).listener(listener).patchReporter(patchReporter).tinkerLoadVerifyFlag(applicationLike.getTinkerLoadVerifyFlag()).build();
        Tinker.create(tinker);
        tinker.install(applicationLike.getTinkerResultIntent(), resultServiceClass, upgradePatchProcessor);
        return tinker;
    }

    public static void cleanPatch(Context context) {
        Tinker.with(context).cleanPatch();
    }

    public static void onReceiveUpgradePatch(Context context, String patchLocation) {
        Tinker.with(context).getPatchListener().onPatchReceived(patchLocation);
    }

    public static void setLogIml(TinkerLog.TinkerLogImp imp) {
        TinkerLog.setTinkerLogImp(imp);
    }

    public static boolean loadLibraryFromTinker(Context context, String relativePath, String libname) throws UnsatisfiedLinkError {
        Tinker tinker = Tinker.with(context);
        libname = libname.startsWith("lib") ? libname : "lib" + libname;
        libname = libname.endsWith(".so") ? libname : libname + ".so";
        String relativeLibPath = relativePath + "/" + libname;
        if (tinker.isEnabledForNativeLib() && tinker.isTinkerLoaded()) {
            TinkerLoadResult loadResult = tinker.getTinkerLoadResultIfPresent();
            if (loadResult.libs != null) {
                for (String name : loadResult.libs.keySet()) {
                    String patchLibraryPath;
                    File library;
                    if (!name.equals(relativeLibPath) || !(library = new File(patchLibraryPath = loadResult.libraryDirectory + "/" + name)).exists()) continue;
                    boolean verifyMd5 = tinker.isTinkerLoadVerify();
                    if (verifyMd5 && !SharePatchFileUtil.verifyFileMd5((File)library, (String)loadResult.libs.get(name))) {
                        tinker.getLoadReporter().onLoadFileMd5Mismatch(library, 5);
                        continue;
                    }
                    System.load(patchLibraryPath);
                    TinkerLog.i(TAG, "loadLibraryFromTinker success:" + patchLibraryPath, new Object[0]);
                    return true;
                }
            }
        }
        return false;
    }

    public static void loadArmLibrary(Context context, String libName) {
        if (libName == null || libName.isEmpty() || context == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        Tinker tinker = Tinker.with(context);
        if (tinker.isEnabledForNativeLib() && TinkerInstaller.loadLibraryFromTinker(context, "lib/armeabi", libName)) {
            return;
        }
        System.loadLibrary(libName);
    }

    public static void loadArmV7Library(Context context, String libName) {
        if (libName == null || libName.isEmpty() || context == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        Tinker tinker = Tinker.with(context);
        if (tinker.isEnabledForNativeLib() && TinkerInstaller.loadLibraryFromTinker(context, "lib/armeabi-v7a", libName)) {
            return;
        }
        System.loadLibrary(libName);
    }
}

