/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.reporter;

import android.content.Context;
import android.content.Intent;
import com.tencent.tinker.lib.reporter.PatchReporter;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;

public class DefaultPatchReporter
implements PatchReporter {
    private static final String TAG = "Tinker.DefaultPatchReporter";
    protected final Context context;

    public DefaultPatchReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onPatchServiceStart(Intent intent) {
        TinkerLog.i(TAG, "patchReporter onPatchServiceStart: patch service start", new Object[0]);
    }

    @Override
    public void onPatchPackageCheckFail(File patchFile, int errorCode) {
        TinkerLog.i(TAG, "patchReporter onPatchPackageCheckFail: package check failed. path:%s, code:%d", patchFile.getAbsolutePath(), errorCode);
        if (errorCode == -3 || errorCode == -4 || errorCode == -8) {
            Tinker.with(this.context).cleanPatchByVersion(patchFile);
        }
    }

    @Override
    public void onPatchVersionCheckFail(File patchFile, SharePatchInfo oldPatchInfo, String patchFileVersion) {
        TinkerLog.i(TAG, "patchReporter onPatchVersionCheckFail: patch version exist. path:%s, version:%s", patchFile.getAbsolutePath(), patchFileVersion);
    }

    @Override
    public void onPatchTypeExtractFail(File patchFile, File extractTo, String filename, int fileType) {
        TinkerLog.i(TAG, "patchReporter onPatchTypeExtractFail: file extract fail type:%s, path:%s, extractTo:%s, filename:%s", ShareTinkerInternals.getTypeString((int)fileType), patchFile.getPath(), extractTo.getPath(), filename);
        Tinker.with(this.context).cleanPatchByVersion(patchFile);
    }

    @Override
    public void onPatchDexOptFail(File patchFile, File dexFile, String optDirectory, String dexName, Throwable t) {
        TinkerLog.i(TAG, "patchReporter onPatchDexOptFail: dex opt fail path:%s, dexPath:%s, optDir:%s, dexName:%s", patchFile.getAbsolutePath(), dexFile.getPath(), optDirectory, dexName);
        TinkerLog.printErrStackTrace(TAG, t, "onPatchDexOptFail:", new Object[0]);
        Tinker.with(this.context).cleanPatchByVersion(patchFile);
    }

    @Override
    public void onPatchResult(File patchFile, boolean success, long cost) {
        TinkerLog.i(TAG, "patchReporter onPatchResult: patch all result path:%s, success:%b, cost:%d", patchFile.getAbsolutePath(), success, cost);
    }

    @Override
    public void onPatchInfoCorrupted(File patchFile, String oldVersion, String newVersion) {
        TinkerLog.i(TAG, "patchReporter onPatchInfoCorrupted: patch info is corrupted. old:%s, new:%s", oldVersion, newVersion);
        Tinker.with(this.context).cleanPatch();
    }

    @Override
    public void onPatchException(File patchFile, Throwable e) {
        TinkerLog.i(TAG, "patchReporter onPatchException: patch exception path:%s, throwable:%s", patchFile.getAbsolutePath(), e.getMessage());
        TinkerLog.e(TAG, "tinker patch exception, welcome to submit issue to us: https://github.com/Tencent/tinker/issues", new Object[0]);
        TinkerLog.printErrStackTrace(TAG, e, "tinker patch exception", new Object[0]);
        Tinker.with(this.context).setTinkerDisable();
        Tinker.with(this.context).cleanPatchByVersion(patchFile);
    }
}

