/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.tinker;

import android.content.Context;
import android.content.Intent;
import com.tencent.tinker.lib.listener.DefaultPatchListener;
import com.tencent.tinker.lib.listener.PatchListener;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.patch.UpgradePatch;
import com.tencent.tinker.lib.reporter.DefaultLoadReporter;
import com.tencent.tinker.lib.reporter.DefaultPatchReporter;
import com.tencent.tinker.lib.reporter.LoadReporter;
import com.tencent.tinker.lib.reporter.PatchReporter;
import com.tencent.tinker.lib.service.AbstractResultService;
import com.tencent.tinker.lib.service.DefaultTinkerResultService;
import com.tencent.tinker.lib.service.TinkerPatchService;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;

public class Tinker {
    private static final String TAG = "Tinker.Tinker";
    private static Tinker sInstance;
    private static boolean sInstalled;
    final Context context;
    final File patchDirectory;
    final PatchListener listener;
    final LoadReporter loadReporter;
    final PatchReporter patchReporter;
    final File patchInfoFile;
    final File patchInfoLockFile;
    final boolean isMainProcess;
    final boolean isPatchProcess;
    final boolean tinkerLoadVerifyFlag;
    int tinkerFlags;
    TinkerLoadResult tinkerLoadResult;
    private boolean loaded = false;

    private Tinker(Context context, int tinkerFlags, LoadReporter loadReporter, PatchReporter patchReporter, PatchListener listener, File patchDirectory, File patchInfoFile, File patchInfoLockFile, boolean isInMainProc, boolean isPatchProcess, boolean tinkerLoadVerifyFlag) {
        this.context = context;
        this.listener = listener;
        this.loadReporter = loadReporter;
        this.patchReporter = patchReporter;
        this.tinkerFlags = tinkerFlags;
        this.patchDirectory = patchDirectory;
        this.patchInfoFile = patchInfoFile;
        this.patchInfoLockFile = patchInfoLockFile;
        this.isMainProcess = isInMainProc;
        this.tinkerLoadVerifyFlag = tinkerLoadVerifyFlag;
        this.isPatchProcess = isPatchProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tinker with(Context context) {
        if (!sInstalled) {
            throw new TinkerRuntimeException("you must install tinker before get tinker sInstance");
        }
        if (sInstance != null) return sInstance;
        Class<Tinker> clazz = Tinker.class;
        synchronized (Tinker.class) {
            if (sInstance != null) return sInstance;
            sInstance = new Builder(context).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public static void create(Tinker tinker) {
        if (sInstance != null) {
            throw new TinkerRuntimeException("Tinker instance is already set.");
        }
        sInstance = tinker;
    }

    public static boolean isTinkerInstalled() {
        return sInstalled;
    }

    public void install(Intent intentResult, Class<? extends AbstractResultService> serviceClass, AbstractPatch upgradePatch) {
        sInstalled = true;
        TinkerPatchService.setPatchProcessor(upgradePatch, serviceClass);
        TinkerLog.i(TAG, "try to install tinker, isEnable: %b, version: %s", this.isTinkerEnabled(), "1.7.7");
        if (!this.isTinkerEnabled()) {
            TinkerLog.e(TAG, "tinker is disabled", new Object[0]);
            return;
        }
        if (intentResult == null) {
            throw new TinkerRuntimeException("intentResult must not be null.");
        }
        this.tinkerLoadResult = new TinkerLoadResult();
        this.tinkerLoadResult.parseTinkerResult(this.getContext(), intentResult);
        this.loadReporter.onLoadResult(this.patchDirectory, this.tinkerLoadResult.loadCode, this.tinkerLoadResult.costTime);
        if (!this.loaded) {
            TinkerLog.w(TAG, "tinker load fail!", new Object[0]);
        }
    }

    public void setPatchServiceNotificationId(int id) {
        TinkerPatchService.setTinkerNotificationId(id);
    }

    public TinkerLoadResult getTinkerLoadResultIfPresent() {
        return this.tinkerLoadResult;
    }

    public void install(Intent intentResult) {
        this.install(intentResult, DefaultTinkerResultService.class, new UpgradePatch());
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isMainProcess() {
        return this.isMainProcess;
    }

    public boolean isPatchProcess() {
        return this.isPatchProcess;
    }

    public void setTinkerDisable() {
        this.tinkerFlags = 0;
    }

    public LoadReporter getLoadReporter() {
        return this.loadReporter;
    }

    public PatchReporter getPatchReporter() {
        return this.patchReporter;
    }

    public boolean isTinkerEnabled() {
        return ShareTinkerInternals.isTinkerEnabled((int)this.tinkerFlags);
    }

    public boolean isTinkerLoaded() {
        return this.loaded;
    }

    public void setTinkerLoaded(boolean isLoaded) {
        this.loaded = isLoaded;
    }

    public boolean isTinkerLoadVerify() {
        return this.tinkerLoadVerifyFlag;
    }

    public boolean isEnabledForDex() {
        return ShareTinkerInternals.isTinkerEnabledForDex((int)this.tinkerFlags);
    }

    public boolean isEnabledForNativeLib() {
        return ShareTinkerInternals.isTinkerEnabledForNativeLib((int)this.tinkerFlags);
    }

    public boolean isEnabledForResource() {
        return ShareTinkerInternals.isTinkerEnabledForResource((int)this.tinkerFlags);
    }

    public File getPatchDirectory() {
        return this.patchDirectory;
    }

    public File getPatchInfoFile() {
        return this.patchInfoFile;
    }

    public File getPatchInfoLockFile() {
        return this.patchInfoLockFile;
    }

    public PatchListener getPatchListener() {
        return this.listener;
    }

    public int getTinkerFlags() {
        return this.tinkerFlags;
    }

    public void cleanPatch() {
        if (this.patchDirectory == null) {
            return;
        }
        if (this.isTinkerLoaded()) {
            TinkerLog.e(TAG, "it is not safety to clean patch when tinker is loaded, you should kill all your process after clean!", new Object[0]);
        }
        SharePatchFileUtil.deleteDir((File)this.patchDirectory);
    }

    public void cleanPatchByVersion(String versionName) {
        if (this.patchDirectory == null || versionName == null) {
            return;
        }
        String path = this.patchDirectory.getAbsolutePath() + "/" + versionName;
        SharePatchFileUtil.deleteDir((String)path);
    }

    public long getTinkerRomSpace() {
        if (this.patchDirectory == null) {
            return 0L;
        }
        return SharePatchFileUtil.getFileOrDirectorySize((File)this.patchDirectory) / 1024L;
    }

    public void cleanPatchByVersion(File patchFile) {
        if (this.patchDirectory == null || patchFile == null || !patchFile.exists()) {
            return;
        }
        String versionName = SharePatchFileUtil.getPatchVersionDirectory((String)SharePatchFileUtil.getMD5((File)patchFile));
        this.cleanPatchByVersion(versionName);
    }

    static {
        sInstalled = false;
    }

    public static class Builder {
        private final Context context;
        private final boolean mainProcess;
        private final boolean patchProcess;
        private int status = -1;
        private LoadReporter loadReporter;
        private PatchReporter patchReporter;
        private PatchListener listener;
        private File patchDirectory;
        private File patchInfoFile;
        private File patchInfoLockFile;
        private Boolean tinkerLoadVerifyFlag;

        public Builder(Context context) {
            if (context == null) {
                throw new TinkerRuntimeException("Context must not be null.");
            }
            this.context = context;
            this.mainProcess = TinkerServiceInternals.isInMainProcess((Context)context);
            this.patchProcess = TinkerServiceInternals.isInTinkerPatchServiceProcess(context);
            this.patchDirectory = SharePatchFileUtil.getPatchDirectory((Context)context);
            if (this.patchDirectory == null) {
                TinkerLog.e(Tinker.TAG, "patchDirectory is null!", new Object[0]);
                return;
            }
            this.patchInfoFile = SharePatchFileUtil.getPatchInfoFile((String)this.patchDirectory.getAbsolutePath());
            this.patchInfoLockFile = SharePatchFileUtil.getPatchInfoLockFile((String)this.patchDirectory.getAbsolutePath());
            TinkerLog.w(Tinker.TAG, "tinker patch directory: %s", this.patchDirectory);
        }

        public Builder tinkerFlags(int tinkerFlags) {
            if (this.status != -1) {
                throw new TinkerRuntimeException("tinkerFlag is already set.");
            }
            this.status = tinkerFlags;
            return this;
        }

        public Builder tinkerLoadVerifyFlag(Boolean verifyMd5WhenLoad) {
            if (verifyMd5WhenLoad == null) {
                throw new TinkerRuntimeException("tinkerLoadVerifyFlag must not be null.");
            }
            if (this.tinkerLoadVerifyFlag != null) {
                throw new TinkerRuntimeException("tinkerLoadVerifyFlag is already set.");
            }
            this.tinkerLoadVerifyFlag = verifyMd5WhenLoad;
            return this;
        }

        public Builder loadReport(LoadReporter loadReporter) {
            if (loadReporter == null) {
                throw new TinkerRuntimeException("loadReporter must not be null.");
            }
            if (this.loadReporter != null) {
                throw new TinkerRuntimeException("loadReporter is already set.");
            }
            this.loadReporter = loadReporter;
            return this;
        }

        public Builder patchReporter(PatchReporter patchReporter) {
            if (patchReporter == null) {
                throw new TinkerRuntimeException("patchReporter must not be null.");
            }
            if (this.patchReporter != null) {
                throw new TinkerRuntimeException("patchReporter is already set.");
            }
            this.patchReporter = patchReporter;
            return this;
        }

        public Builder listener(PatchListener listener) {
            if (listener == null) {
                throw new TinkerRuntimeException("listener must not be null.");
            }
            if (this.listener != null) {
                throw new TinkerRuntimeException("listener is already set.");
            }
            this.listener = listener;
            return this;
        }

        public Tinker build() {
            if (this.status == -1) {
                this.status = 7;
            }
            if (this.loadReporter == null) {
                this.loadReporter = new DefaultLoadReporter(this.context);
            }
            if (this.patchReporter == null) {
                this.patchReporter = new DefaultPatchReporter(this.context);
            }
            if (this.listener == null) {
                this.listener = new DefaultPatchListener(this.context);
            }
            if (this.tinkerLoadVerifyFlag == null) {
                this.tinkerLoadVerifyFlag = false;
            }
            return new Tinker(this.context, this.status, this.loadReporter, this.patchReporter, this.listener, this.patchDirectory, this.patchInfoFile, this.patchInfoLockFile, this.mainProcess, this.patchProcess, this.tinkerLoadVerifyFlag);
        }
    }
}

