/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BasePatchInternal {
    protected static final String TAG = "Tinker.BasePatchInternal";
    protected static final String DEX_PATH = "dex";
    protected static final String SO_PATH = "lib";
    protected static final String DEX_OPTIMIZE_PATH = "odex";
    protected static final int MAX_EXTRACT_ATTEMPTS = 2;
    protected static final String DEX_META_FILE = "assets/dex_meta.txt";
    protected static final String SO_META_FILE = "assets/so_meta.txt";
    protected static final String RES_META_FILE = "assets/res_meta.txt";
    protected static final int TYPE_DEX = 3;
    protected static final int TYPE_Library = 5;
    protected static final int TYPE_RESOURCE = 6;
    protected static final int TYPE_CLASS_N_DEX = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extract(ZipFile zipFile, ZipEntry entryFile, File extractTo, String targetMd5, boolean isDex) throws IOException {
        int numAttempts = 0;
        boolean isExtractionSuccessful = false;
        while (numAttempts < 2 && !isExtractionSuccessful) {
            ++numAttempts;
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entryFile));
            FileOutputStream fos = new FileOutputStream(extractTo);
            BufferedOutputStream out = new BufferedOutputStream(fos);
            TinkerLog.i(TAG, "try Extracting " + extractTo.getPath(), new Object[0]);
            try {
                byte[] buffer = new byte[16384];
                int length = bis.read(buffer);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = bis.read(buffer);
                }
            }
            finally {
                SharePatchFileUtil.closeQuietly((Closeable)out);
                SharePatchFileUtil.closeQuietly((Closeable)bis);
            }
            isExtractionSuccessful = isDex ? SharePatchFileUtil.verifyDexFileMd5((File)extractTo, (String)targetMd5) : SharePatchFileUtil.verifyFileMd5((File)extractTo, (String)targetMd5);
            TinkerLog.i(TAG, "isExtractionSuccessful: %b", isExtractionSuccessful);
            if (isExtractionSuccessful) continue;
            extractTo.delete();
            if (!extractTo.exists()) continue;
            TinkerLog.e(TAG, "Failed to delete corrupted dex " + extractTo.getPath(), new Object[0]);
        }
        return isExtractionSuccessful;
    }

    public static int getMetaCorruptedCode(int type) {
        if (type == 3) {
            return -3;
        }
        if (type == 5) {
            return -4;
        }
        if (type == 6) {
            return -8;
        }
        return 0;
    }
}

