/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.SystemClock;
import com.tencent.tinker.lib.patch.BasePatchInternal;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareResPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.ziputils.ziputil.TinkerZipEntry;
import com.tencent.tinker.ziputils.ziputil.TinkerZipFile;
import com.tencent.tinker.ziputils.ziputil.TinkerZipOutputStream;
import com.tencent.tinker.ziputils.ziputil.TinkerZipUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;

public class ResDiffPatchInternal
extends BasePatchInternal {
    protected static final String TAG = "Tinker.ResDiffPatchInternal";

    protected static boolean tryRecoverResourceFiles(Tinker manager, ShareSecurityCheck checker, Context context, String patchVersionDirectory, File patchFile) {
        if (!manager.isEnabledForResource()) {
            TinkerLog.w(TAG, "patch recover, resource is not enabled", new Object[0]);
            return true;
        }
        String resourceMeta = (String)checker.getMetaContentMap().get("assets/res_meta.txt");
        if (resourceMeta == null || resourceMeta.length() == 0) {
            TinkerLog.w(TAG, "patch recover, resource is not contained", new Object[0]);
            return true;
        }
        long begin = SystemClock.elapsedRealtime();
        boolean result = ResDiffPatchInternal.patchResourceExtractViaResourceDiff(context, patchVersionDirectory, resourceMeta, patchFile);
        long cost = SystemClock.elapsedRealtime() - begin;
        TinkerLog.i(TAG, "recover resource result:%b, cost:%d", result, cost);
        return result;
    }

    private static boolean patchResourceExtractViaResourceDiff(Context context, String patchVersionDirectory, String meta, File patchFile) {
        String dir = patchVersionDirectory + "/" + "res" + "/";
        if (!ResDiffPatchInternal.extractResourceDiffInternals(context, dir, meta, patchFile, 6)) {
            TinkerLog.w(TAG, "patch recover, extractDiffInternals fail", new Object[0]);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean extractResourceDiffInternals(Context context, String dir, String meta, File patchFile, int type) {
        ShareResPatchInfo resPatchInfo = new ShareResPatchInfo();
        ShareResPatchInfo.parseAllResPatchInfo((String)meta, (ShareResPatchInfo)resPatchInfo);
        TinkerLog.i(TAG, "res dir: %s, meta: %s", dir, resPatchInfo.toString());
        Tinker manager = Tinker.with(context);
        if (!SharePatchFileUtil.checkIfMd5Valid((String)resPatchInfo.resArscMd5)) {
            TinkerLog.w(TAG, "resource meta file md5 mismatch, type:%s, md5: %s", ShareTinkerInternals.getTypeString((int)type), resPatchInfo.resArscMd5);
            manager.getPatchReporter().onPatchPackageCheckFail(patchFile, BasePatchInternal.getMetaCorruptedCode(type));
            return false;
        }
        File directory = new File(dir);
        File tempResFileDirectory = new File(directory, "res_temp");
        File resOutput = new File(directory, "resources.apk");
        if (resOutput.exists()) {
            if (SharePatchFileUtil.checkResourceArscMd5((File)resOutput, (String)resPatchInfo.resArscMd5)) {
                TinkerLog.w(TAG, "resource file %s is already exist, and md5 match, just return true", resOutput.getPath());
                return true;
            }
            TinkerLog.w(TAG, "have a mismatch corrupted resource " + resOutput.getPath(), new Object[0]);
            resOutput.delete();
        } else {
            resOutput.getParentFile().mkdirs();
        }
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            if (applicationInfo == null) {
                TinkerLog.w(TAG, "applicationInfo == null!!!!", new Object[0]);
                return false;
            }
            String apkPath = applicationInfo.sourceDir;
            if (!ResDiffPatchInternal.checkAndExtractResourceLargeFile(context, apkPath, directory, tempResFileDirectory, patchFile, resPatchInfo, type)) {
                return false;
            }
            TinkerZipOutputStream out = null;
            TinkerZipFile oldApk = null;
            TinkerZipFile newApk = null;
            int totalEntryCount = 0;
            try {
                File storeFile2;
                out = new TinkerZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(resOutput)));
                oldApk = new TinkerZipFile(apkPath);
                newApk = new TinkerZipFile(patchFile);
                Enumeration entries = oldApk.entries();
                while (entries.hasMoreElements()) {
                    TinkerZipEntry zipEntry = (TinkerZipEntry)entries.nextElement();
                    if (zipEntry == null) {
                        throw new TinkerRuntimeException("zipEntry is null when get from oldApk");
                    }
                    String name = zipEntry.getName();
                    if (name.contains("../") || !ShareResPatchInfo.checkFileInPattern((HashSet)resPatchInfo.patterns, (String)name) || resPatchInfo.deleteRes.contains(name) || resPatchInfo.modRes.contains(name) || resPatchInfo.largeModRes.contains(name) || name.equals("AndroidManifest.xml")) continue;
                    TinkerZipUtil.extractTinkerEntry((TinkerZipFile)oldApk, (TinkerZipEntry)zipEntry, (TinkerZipOutputStream)out);
                    ++totalEntryCount;
                }
                TinkerZipEntry manifestZipEntry = oldApk.getEntry("AndroidManifest.xml");
                if (manifestZipEntry == null) {
                    TinkerLog.w(TAG, "manifest patch entry is null. path:AndroidManifest.xml", new Object[0]);
                    manager.getPatchReporter().onPatchTypeExtractFail(patchFile, resOutput, "AndroidManifest.xml", type);
                    boolean bl = false;
                    return bl;
                }
                TinkerZipUtil.extractTinkerEntry((TinkerZipFile)oldApk, (TinkerZipEntry)manifestZipEntry, (TinkerZipOutputStream)out);
                ++totalEntryCount;
                for (String name : resPatchInfo.largeModRes) {
                    TinkerZipEntry largeZipEntry = oldApk.getEntry(name);
                    if (largeZipEntry == null) {
                        TinkerLog.w(TAG, "large patch entry is null. path:" + name, new Object[0]);
                        manager.getPatchReporter().onPatchTypeExtractFail(patchFile, resOutput, name, type);
                        boolean bl = false;
                        return bl;
                    }
                    ShareResPatchInfo.LargeModeInfo largeModeInfo = (ShareResPatchInfo.LargeModeInfo)resPatchInfo.largeModMap.get(name);
                    TinkerZipUtil.extractLargeModifyFile((TinkerZipEntry)largeZipEntry, (File)largeModeInfo.file, (long)largeModeInfo.crc, (TinkerZipOutputStream)out);
                    ++totalEntryCount;
                }
                for (String name : resPatchInfo.addRes) {
                    TinkerZipEntry addZipEntry = newApk.getEntry(name);
                    if (addZipEntry == null) {
                        TinkerLog.w(TAG, "add patch entry is null. path:" + name, new Object[0]);
                        manager.getPatchReporter().onPatchTypeExtractFail(patchFile, resOutput, name, type);
                        boolean largeModeInfo = false;
                        return largeModeInfo;
                    }
                    if (resPatchInfo.storeRes.containsKey(name)) {
                        storeFile2 = (File)resPatchInfo.storeRes.get(name);
                        TinkerZipUtil.extractLargeModifyFile((TinkerZipEntry)addZipEntry, (File)storeFile2, (long)addZipEntry.getCrc(), (TinkerZipOutputStream)out);
                    } else {
                        TinkerZipUtil.extractTinkerEntry((TinkerZipFile)newApk, (TinkerZipEntry)addZipEntry, (TinkerZipOutputStream)out);
                    }
                    ++totalEntryCount;
                }
                for (String name : resPatchInfo.modRes) {
                    TinkerZipEntry modZipEntry = newApk.getEntry(name);
                    if (modZipEntry == null) {
                        TinkerLog.w(TAG, "mod patch entry is null. path:" + name, new Object[0]);
                        manager.getPatchReporter().onPatchTypeExtractFail(patchFile, resOutput, name, type);
                        boolean storeFile2 = false;
                        return storeFile2;
                    }
                    if (resPatchInfo.storeRes.containsKey(name)) {
                        storeFile2 = (File)resPatchInfo.storeRes.get(name);
                        TinkerZipUtil.extractLargeModifyFile((TinkerZipEntry)modZipEntry, (File)storeFile2, (long)modZipEntry.getCrc(), (TinkerZipOutputStream)out);
                    } else {
                        TinkerZipUtil.extractTinkerEntry((TinkerZipFile)newApk, (TinkerZipEntry)modZipEntry, (TinkerZipOutputStream)out);
                    }
                    ++totalEntryCount;
                }
                out.setComment(oldApk.getComment());
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (oldApk != null) {
                    oldApk.close();
                }
                if (newApk != null) {
                    newApk.close();
                }
                SharePatchFileUtil.deleteDir((File)tempResFileDirectory);
            }
            boolean result = SharePatchFileUtil.checkResourceArscMd5((File)resOutput, (String)resPatchInfo.resArscMd5);
            if (!result) {
                TinkerLog.i(TAG, "check final new resource file fail path:%s, entry count:%d, size:%d", resOutput.getAbsolutePath(), totalEntryCount, resOutput.length());
                SharePatchFileUtil.safeDeleteFile((File)resOutput);
                manager.getPatchReporter().onPatchTypeExtractFail(patchFile, resOutput, "resources.apk", type);
                return false;
            }
            TinkerLog.i(TAG, "final new resource file:%s, entry count:%d, size:%d", resOutput.getAbsolutePath(), totalEntryCount, resOutput.length());
            return true;
        }
        catch (Throwable e) {
            throw new TinkerRuntimeException("patch " + ShareTinkerInternals.getTypeString((int)type) + " extract failed (" + e.getMessage() + ").", e);
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean checkAndExtractResourceLargeFile(Context context, String apkPath, File directory, File tempFileDirtory, File patchFile, ShareResPatchInfo resPatchInfo, int type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

