/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.tinker;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.util.HashMap;

public class TinkerLoadResult {
    private static final String TAG = "Tinker.TinkerLoadResult";
    public SharePatchInfo patchInfo;
    public String currentVersion;
    public String oatDir;
    public boolean versionChanged;
    public boolean useInterpretMode;
    public boolean systemOTA;
    public File patchVersionDirectory;
    public File patchVersionFile;
    public File dexDirectory;
    public File libraryDirectory;
    public File resourceDirectory;
    public File resourceFile;
    public HashMap<String, String> dexes;
    public HashMap<String, String> libs;
    public HashMap<String, String> packageConfig;
    public int loadCode;
    public long costTime;

    public boolean parseTinkerResult(Context context, Intent intentResult) {
        Throwable exception;
        Tinker tinker = Tinker.with(context);
        this.loadCode = ShareIntentUtil.getIntentReturnCode((Intent)intentResult);
        this.costTime = ShareIntentUtil.getIntentPatchCostTime((Intent)intentResult);
        this.systemOTA = ShareIntentUtil.getBooleanExtra((Intent)intentResult, (String)"intent_patch_system_ota", (boolean)false);
        this.oatDir = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_oat_dir");
        this.useInterpretMode = "interpet".equals(this.oatDir);
        boolean isMainProcess = tinker.isMainProcess();
        TinkerLog.i(TAG, "parseTinkerResult loadCode:%d, process name:%s, main process:%b, systemOTA:%b, fingerPrint:%s, oatDir:%s, useInterpretMode:%b", this.loadCode, ShareTinkerInternals.getProcessName((Context)context), isMainProcess, this.systemOTA, Build.FINGERPRINT, this.oatDir, this.useInterpretMode);
        String oldVersion = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_old_version");
        String newVersion = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_new_version");
        File patchDirectory = tinker.getPatchDirectory();
        File patchInfoFile = tinker.getPatchInfoFile();
        if (oldVersion != null && newVersion != null) {
            this.currentVersion = isMainProcess ? newVersion : oldVersion;
            TinkerLog.i(TAG, "parseTinkerResult oldVersion:%s, newVersion:%s, current:%s", oldVersion, newVersion, this.currentVersion);
            String patchName = SharePatchFileUtil.getPatchVersionDirectory((String)this.currentVersion);
            if (!ShareTinkerInternals.isNullOrNil((String)patchName)) {
                this.patchVersionDirectory = new File(patchDirectory.getAbsolutePath() + "/" + patchName);
                this.patchVersionFile = new File(this.patchVersionDirectory.getAbsolutePath(), SharePatchFileUtil.getPatchVersionFile((String)this.currentVersion));
                this.dexDirectory = new File(this.patchVersionDirectory, "dex");
                this.libraryDirectory = new File(this.patchVersionDirectory, "lib");
                this.resourceDirectory = new File(this.patchVersionDirectory, "res");
                this.resourceFile = new File(this.resourceDirectory, "resources.apk");
            }
            this.patchInfo = new SharePatchInfo(oldVersion, newVersion, false, Build.FINGERPRINT, this.oatDir);
            boolean bl = this.versionChanged = !oldVersion.equals(newVersion);
        }
        if ((exception = ShareIntentUtil.getIntentPatchException((Intent)intentResult)) != null) {
            TinkerLog.i(TAG, "Tinker load have exception loadCode:%d", this.loadCode);
            int errorCode = -1;
            switch (this.loadCode) {
                case -20: {
                    errorCode = -1;
                    break;
                }
                case -14: {
                    errorCode = -2;
                    break;
                }
                case -23: {
                    errorCode = -3;
                    break;
                }
                case -25: {
                    errorCode = -4;
                }
            }
            tinker.getLoadReporter().onLoadException(exception, errorCode);
            return false;
        }
        switch (this.loadCode) {
            case -10000: {
                TinkerLog.e(TAG, "can't get the right intent return code", new Object[0]);
                throw new TinkerRuntimeException("can't get the right intent return code");
            }
            case -1: {
                TinkerLog.w(TAG, "tinker is disable, just return", new Object[0]);
                break;
            }
            case -3: 
            case -2: {
                TinkerLog.w(TAG, "can't find patch file, is ok, just return", new Object[0]);
                break;
            }
            case -4: {
                TinkerLog.e(TAG, "path info corrupted", new Object[0]);
                tinker.getLoadReporter().onLoadPatchInfoCorrupted(oldVersion, newVersion, patchInfoFile);
                break;
            }
            case -5: {
                TinkerLog.e(TAG, "path info blank, wait main process to restart", new Object[0]);
                break;
            }
            case -6: {
                TinkerLog.e(TAG, "patch version directory not found, current version:%s", this.currentVersion);
                tinker.getLoadReporter().onLoadFileNotFound(this.patchVersionDirectory, 1, true);
                break;
            }
            case -7: {
                TinkerLog.e(TAG, "patch version file not found, current version:%s", this.currentVersion);
                if (this.patchVersionFile == null) {
                    throw new TinkerRuntimeException("error load patch version file not exist, but file is null");
                }
                tinker.getLoadReporter().onLoadFileNotFound(this.patchVersionFile, 1, false);
                break;
            }
            case -8: {
                TinkerLog.i(TAG, "patch package check fail", new Object[0]);
                if (this.patchVersionFile == null) {
                    throw new TinkerRuntimeException("error patch package check fail , but file is null");
                }
                int errorCode = intentResult.getIntExtra("intent_patch_package_patch_check", -10000);
                tinker.getLoadReporter().onLoadPackageCheckFail(this.patchVersionFile, errorCode);
                break;
            }
            case -9: {
                if (this.dexDirectory != null) {
                    TinkerLog.e(TAG, "patch dex file directory not found:%s", this.dexDirectory.getAbsolutePath());
                    tinker.getLoadReporter().onLoadFileNotFound(this.dexDirectory, 3, true);
                    break;
                }
                TinkerLog.e(TAG, "patch dex file directory not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch dex file directory not found, warning why the path is null!!!!");
            }
            case -10: {
                String dexPath = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_missing_dex_path");
                if (dexPath != null) {
                    TinkerLog.e(TAG, "patch dex file not found:%s", dexPath);
                    tinker.getLoadReporter().onLoadFileNotFound(new File(dexPath), 3, false);
                    break;
                }
                TinkerLog.e(TAG, "patch dex file not found, but path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch dex file not found, but path is null!!!!");
            }
            case -11: {
                String dexOptPath = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_missing_dex_path");
                if (dexOptPath != null) {
                    TinkerLog.e(TAG, "patch dex opt file not found:%s", dexOptPath);
                    tinker.getLoadReporter().onLoadFileNotFound(new File(dexOptPath), 4, false);
                    break;
                }
                TinkerLog.e(TAG, "patch dex opt file not found, but path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch dex opt file not found, but path is null!!!!");
            }
            case -17: {
                if (this.patchVersionDirectory != null) {
                    TinkerLog.e(TAG, "patch lib file directory not found:%s", this.libraryDirectory.getAbsolutePath());
                    tinker.getLoadReporter().onLoadFileNotFound(this.libraryDirectory, 5, true);
                    break;
                }
                TinkerLog.e(TAG, "patch lib file directory not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch lib file directory not found, warning why the path is null!!!!");
            }
            case -18: {
                String libPath = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_missing_lib_path");
                if (libPath != null) {
                    TinkerLog.e(TAG, "patch lib file not found:%s", libPath);
                    tinker.getLoadReporter().onLoadFileNotFound(new File(libPath), 5, false);
                    break;
                }
                TinkerLog.e(TAG, "patch lib file not found, but path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch lib file not found, but path is null!!!!");
            }
            case -12: {
                TinkerLog.e(TAG, "patch dex load fail, classloader is null", new Object[0]);
                break;
            }
            case -13: {
                String mismatchPath = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_mismatch_dex_path");
                if (mismatchPath == null) {
                    TinkerLog.e(TAG, "patch dex file md5 is mismatch, but path is null!!!!", new Object[0]);
                    throw new TinkerRuntimeException("patch dex file md5 is mismatch, but path is null!!!!");
                }
                TinkerLog.e(TAG, "patch dex file md5 is mismatch: %s", mismatchPath);
                tinker.getLoadReporter().onLoadFileMd5Mismatch(new File(mismatchPath), 3);
                break;
            }
            case -19: {
                TinkerLog.i(TAG, "rewrite patch info file corrupted", new Object[0]);
                tinker.getLoadReporter().onLoadPatchInfoCorrupted(oldVersion, newVersion, patchInfoFile);
                break;
            }
            case -21: {
                if (this.patchVersionDirectory != null) {
                    TinkerLog.e(TAG, "patch resource file directory not found:%s", this.resourceDirectory.getAbsolutePath());
                    tinker.getLoadReporter().onLoadFileNotFound(this.resourceDirectory, 6, true);
                    break;
                }
                TinkerLog.e(TAG, "patch resource file directory not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch resource file directory not found, warning why the path is null!!!!");
            }
            case -22: {
                if (this.patchVersionDirectory != null) {
                    TinkerLog.e(TAG, "patch resource file not found:%s", this.resourceFile.getAbsolutePath());
                    tinker.getLoadReporter().onLoadFileNotFound(this.resourceFile, 6, false);
                    break;
                }
                TinkerLog.e(TAG, "patch resource file not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch resource file not found, warning why the path is null!!!!");
            }
            case -24: {
                if (this.resourceFile == null) {
                    TinkerLog.e(TAG, "resource file md5 mismatch, but patch resource file not found!", new Object[0]);
                    throw new TinkerRuntimeException("resource file md5 mismatch, but patch resource file not found!");
                }
                TinkerLog.e(TAG, "patch resource file md5 is mismatch: %s", this.resourceFile.getAbsolutePath());
                tinker.getLoadReporter().onLoadFileMd5Mismatch(this.resourceFile, 6);
                break;
            }
            case -15: {
                tinker.getLoadReporter().onLoadInterpret(1, ShareIntentUtil.getIntentInterpretException((Intent)intentResult));
                break;
            }
            case -16: {
                tinker.getLoadReporter().onLoadInterpret(2, ShareIntentUtil.getIntentInterpretException((Intent)intentResult));
                break;
            }
            case 0: {
                TinkerLog.i(TAG, "oh yeah, tinker load all success", new Object[0]);
                tinker.setTinkerLoaded(true);
                this.dexes = ShareIntentUtil.getIntentPatchDexPaths((Intent)intentResult);
                this.libs = ShareIntentUtil.getIntentPatchLibsPaths((Intent)intentResult);
                this.packageConfig = ShareIntentUtil.getIntentPackageConfig((Intent)intentResult);
                if (this.useInterpretMode) {
                    tinker.getLoadReporter().onLoadInterpret(0, null);
                }
                if (isMainProcess && this.versionChanged) {
                    tinker.getLoadReporter().onLoadPatchVersionChanged(oldVersion, newVersion, patchDirectory, this.patchVersionDirectory.getName());
                }
                return true;
            }
        }
        return false;
    }

    public String getPackageConfigByName(String name) {
        if (this.packageConfig != null) {
            return this.packageConfig.get(name);
        }
        return null;
    }
}

