/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.util.TinkerJobIntentService;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import java.io.Serializable;

public abstract class AbstractResultService
extends TinkerJobIntentService {
    private static final String TAG = "Tinker.AbstractResultService";
    private static final String RESULT_EXTRA = "result_extra";

    public static void runResultService(Context context, PatchResult result, String resultServiceClass) {
        if (resultServiceClass == null) {
            throw new TinkerRuntimeException("resultServiceClass is null.");
        }
        try {
            if (!TinkerJobIntentService.class.isAssignableFrom(Class.forName(resultServiceClass))) {
                throw new TinkerRuntimeException("on tinker version 1.9.13 result service class must inherit from TinkerJobIntentService.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new TinkerRuntimeException("cannot find result service class: " + resultServiceClass, (Throwable)e);
        }
        try {
            Intent intent = new Intent();
            intent.setClassName(context, resultServiceClass);
            intent.putExtra(RESULT_EXTRA, (Serializable)result);
            int jobId = 0xA3A4A5A6 ^ ("tinker_" + context.getPackageName()).hashCode();
            TinkerLog.i(TAG, "jobId of result service is: %s", jobId);
            AbstractResultService.enqueueWork(context, new ComponentName(context, resultServiceClass), jobId, intent);
        }
        catch (Throwable throwable) {
            TinkerLog.e(TAG, "run result service fail, exception:" + throwable, new Object[0]);
        }
    }

    @Override
    public boolean onStopCurrentWork() {
        return false;
    }

    @Override
    protected void onHandleWork(@NonNull Intent intent) {
        this.onHandleIntent(intent);
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            TinkerLog.e(TAG, "AbstractResultService received a null intent, ignoring.", new Object[0]);
            return;
        }
        PatchResult result = (PatchResult)ShareIntentUtil.getSerializableExtra((Intent)intent, (String)RESULT_EXTRA);
        this.onPatchResult(result);
    }

    public abstract void onPatchResult(PatchResult var1);
}

