/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.service;

import android.app.IntentService;
import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.SystemClock;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.service.AbstractResultService;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class TinkerPatchService
extends IntentService {
    private static final String TAG = "Tinker.TinkerPatchService";
    private static final String PATCH_PATH_EXTRA = "patch_path_extra";
    private static final String RESULT_CLASS_EXTRA = "patch_result_class";
    private static AbstractPatch upgradePatchProcessor = null;
    private static int notificationId = -1119860829;
    private static Class<? extends AbstractResultService> resultServiceClass = null;
    private static AtomicBoolean sIsPatchApplying = new AtomicBoolean(false);

    public TinkerPatchService() {
        super("TinkerPatchService");
    }

    public static void runPatchService(Context context, String path) {
        ShareTinkerLog.i((String)TAG, (String)"run patch service...", (Object[])new Object[0]);
        Intent intent = new Intent(context, TinkerPatchService.class);
        intent.putExtra(PATCH_PATH_EXTRA, path);
        intent.putExtra(RESULT_CLASS_EXTRA, resultServiceClass.getName());
        try {
            context.startService(intent);
        }
        catch (Throwable thr) {
            ShareTinkerLog.e((String)TAG, (String)("run patch service fail, exception:" + thr), (Object[])new Object[0]);
        }
    }

    public static void setPatchProcessor(AbstractPatch upgradePatch, Class<? extends AbstractResultService> serviceClass) {
        upgradePatchProcessor = upgradePatch;
        resultServiceClass = serviceClass;
        try {
            Class.forName(serviceClass.getName());
        }
        catch (ClassNotFoundException e) {
            ShareTinkerLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"patch processor class not found.", (Object[])new Object[0]);
        }
    }

    public static String getPatchPathExtra(Intent intent) {
        if (intent == null) {
            throw new TinkerRuntimeException("getPatchPathExtra, but intent is null");
        }
        return ShareIntentUtil.getStringExtra((Intent)intent, (String)PATCH_PATH_EXTRA);
    }

    public static String getPatchResultExtra(Intent intent) {
        if (intent == null) {
            throw new TinkerRuntimeException("getPatchResultExtra, but intent is null");
        }
        return ShareIntentUtil.getStringExtra((Intent)intent, (String)RESULT_CLASS_EXTRA);
    }

    protected void onHandleIntent(Intent intent) {
        this.increasingPriority();
        TinkerPatchService.doApplyPatch((Context)this, intent);
    }

    public static void setTinkerNotificationId(int id) {
        notificationId = id;
    }

    private static void doApplyPatch(Context context, Intent intent) {
        boolean result;
        if (!sIsPatchApplying.compareAndSet(false, true)) {
            ShareTinkerLog.w((String)TAG, (String)"TinkerPatchService doApplyPatch is running by another runner.", (Object[])new Object[0]);
            return;
        }
        Tinker tinker = Tinker.with(context);
        tinker.getPatchReporter().onPatchServiceStart(intent);
        if (intent == null) {
            ShareTinkerLog.e((String)TAG, (String)"TinkerPatchService received a null intent, ignoring.", (Object[])new Object[0]);
            return;
        }
        String path = TinkerPatchService.getPatchPathExtra(intent);
        if (path == null) {
            ShareTinkerLog.e((String)TAG, (String)"TinkerPatchService can't get the path extra, ignoring.", (Object[])new Object[0]);
            return;
        }
        File patchFile = new File(path);
        long begin = SystemClock.elapsedRealtime();
        Throwable e = null;
        PatchResult patchResult = new PatchResult();
        try {
            if (upgradePatchProcessor == null) {
                throw new TinkerRuntimeException("upgradePatchProcessor is null.");
            }
            result = upgradePatchProcessor.tryPatch(context, path, patchResult);
        }
        catch (Throwable throwable) {
            e = throwable;
            result = false;
            tinker.getPatchReporter().onPatchException(patchFile, e);
        }
        long cost = SystemClock.elapsedRealtime() - begin;
        tinker.getPatchReporter().onPatchResult(patchFile, result, cost);
        patchResult.isSuccess = result;
        patchResult.rawPatchFilePath = path;
        patchResult.costTime = cost;
        patchResult.e = e;
        AbstractResultService.runResultService(context, patchResult, TinkerPatchService.getPatchResultExtra(intent));
        sIsPatchApplying.set(false);
    }

    private void increasingPriority() {
        if (Build.VERSION.SDK_INT >= 26) {
            ShareTinkerLog.i((String)TAG, (String)"for system version >= Android O, we just ignore increasingPriority job to avoid crash or toasts.", (Object[])new Object[0]);
            return;
        }
        if ("ZUK".equals(Build.MANUFACTURER)) {
            ShareTinkerLog.i((String)TAG, (String)"for ZUK device, we just ignore increasingPriority job to avoid crash.", (Object[])new Object[0]);
            return;
        }
        ShareTinkerLog.i((String)TAG, (String)"try to increase patch process priority", (Object[])new Object[0]);
        try {
            Notification notification = new Notification();
            if (Build.VERSION.SDK_INT < 18) {
                this.startForeground(notificationId, notification);
            } else {
                this.startForeground(notificationId, notification);
                this.startService(new Intent((Context)this, InnerService.class));
            }
        }
        catch (Throwable e) {
            ShareTinkerLog.i((String)TAG, (String)("try to increase patch process priority error:" + e), (Object[])new Object[0]);
        }
    }

    public static class InnerService
    extends Service {
        public void onCreate() {
            super.onCreate();
            try {
                this.startForeground(notificationId, new Notification());
            }
            catch (Throwable e) {
                ShareTinkerLog.e((String)TinkerPatchService.TAG, (String)"InnerService set service for push exception:%s.", (Object[])new Object[]{e});
            }
            this.stopSelf();
        }

        public void onDestroy() {
            this.stopForeground(true);
            super.onDestroy();
        }

        public IBinder onBind(Intent intent) {
            return null;
        }
    }
}

