/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.library;

import android.content.Context;
import android.os.Build;
import com.tencent.tinker.entry.ApplicationLike;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerApplicationHelper;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TinkerLoadLibrary {
    private static final String TAG = "Tinker.LoadLibrary";

    public static void loadArmLibrary(Context context, String libName) {
        if (libName == null || libName.isEmpty() || context == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        Tinker tinker = Tinker.with(context);
        if (tinker.isEnabledForNativeLib() && TinkerLoadLibrary.loadLibraryFromTinker(context, "lib/armeabi", libName)) {
            return;
        }
        System.loadLibrary(libName);
    }

    public static void loadArmLibraryWithoutTinkerInstalled(ApplicationLike appLike, String libName) {
        if (libName == null || libName.isEmpty() || appLike == null) {
            throw new TinkerRuntimeException("libName or appLike is null!");
        }
        if (TinkerApplicationHelper.isTinkerEnableForNativeLib(appLike) && TinkerApplicationHelper.loadLibraryFromTinker(appLike, "lib/armeabi", libName)) {
            return;
        }
        System.loadLibrary(libName);
    }

    public static void loadArmV7Library(Context context, String libName) {
        if (libName == null || libName.isEmpty() || context == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        Tinker tinker = Tinker.with(context);
        if (tinker.isEnabledForNativeLib() && TinkerLoadLibrary.loadLibraryFromTinker(context, "lib/armeabi-v7a", libName)) {
            return;
        }
        System.loadLibrary(libName);
    }

    public static void loadArmV7LibraryWithoutTinkerInstalled(ApplicationLike appLike, String libName) {
        if (libName == null || libName.isEmpty() || appLike == null) {
            throw new TinkerRuntimeException("libName or appLike is null!");
        }
        if (TinkerApplicationHelper.isTinkerEnableForNativeLib(appLike) && TinkerApplicationHelper.loadLibraryFromTinker(appLike, "lib/armeabi-v7a", libName)) {
            return;
        }
        System.loadLibrary(libName);
    }

    public static boolean loadLibraryFromTinker(Context context, String relativePath, String libName) throws UnsatisfiedLinkError {
        Tinker tinker = Tinker.with(context);
        libName = libName.startsWith("lib") ? libName : "lib" + libName;
        libName = libName.endsWith(".so") ? libName : libName + ".so";
        String relativeLibPath = relativePath + "/" + libName;
        if (tinker.isEnabledForNativeLib() && tinker.isTinkerLoaded()) {
            TinkerLoadResult loadResult = tinker.getTinkerLoadResultIfPresent();
            if (loadResult.libs == null) {
                return false;
            }
            for (String name : loadResult.libs.keySet()) {
                String patchLibraryPath;
                File library;
                if (!name.equals(relativeLibPath) || !(library = new File(patchLibraryPath = loadResult.libraryDirectory + "/" + name)).exists()) continue;
                boolean verifyMd5 = tinker.isTinkerLoadVerify();
                if (verifyMd5 && !SharePatchFileUtil.verifyFileMd5((File)library, (String)loadResult.libs.get(name))) {
                    tinker.getLoadReporter().onLoadFileMd5Mismatch(library, 5);
                    continue;
                }
                System.load(patchLibraryPath);
                ShareTinkerLog.i((String)TAG, (String)("loadLibraryFromTinker success:" + patchLibraryPath), (Object[])new Object[0]);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installNavitveLibraryABI(Context context, String currentABI) {
        Tinker tinker = Tinker.with(context);
        if (!tinker.isTinkerLoaded()) {
            ShareTinkerLog.i((String)TAG, (String)"tinker is not loaded, just return", (Object[])new Object[0]);
            return false;
        }
        TinkerLoadResult loadResult = tinker.getTinkerLoadResultIfPresent();
        if (loadResult.libs == null) {
            ShareTinkerLog.i((String)TAG, (String)"tinker libs is null, just return", (Object[])new Object[0]);
            return false;
        }
        File soDir = new File(loadResult.libraryDirectory, "lib/" + currentABI);
        if (!soDir.exists()) {
            ShareTinkerLog.e((String)TAG, (String)"current libraryABI folder is not exist, path: %s", (Object[])new Object[]{soDir.getPath()});
            return false;
        }
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader == null) {
            ShareTinkerLog.e((String)TAG, (String)"classloader is null", (Object[])new Object[0]);
            return false;
        }
        ShareTinkerLog.i((String)TAG, (String)("before hack classloader:" + classLoader.toString()), (Object[])new Object[0]);
        try {
            TinkerLoadLibrary.installNativeLibraryPath(classLoader, soDir);
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            ShareTinkerLog.e((String)TAG, (String)("installNativeLibraryPath fail:" + throwable), (Object[])new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            ShareTinkerLog.i((String)TAG, (String)("after hack classloader:" + classLoader.toString()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installNativeLibraryABIWithoutTinkerInstalled(ApplicationLike appLike, String currentABI) {
        String currentVersion = TinkerApplicationHelper.getCurrentVersion(appLike);
        if (ShareTinkerInternals.isNullOrNil((String)currentVersion)) {
            ShareTinkerLog.e((String)TAG, (String)"failed to get current patch version.", (Object[])new Object[0]);
            return false;
        }
        File patchDirectory = SharePatchFileUtil.getPatchDirectory((Context)appLike.getApplication());
        if (patchDirectory == null) {
            ShareTinkerLog.e((String)TAG, (String)"failed to get current patch directory.", (Object[])new Object[0]);
            return false;
        }
        File patchVersionDirectory = new File(patchDirectory.getAbsolutePath() + "/" + SharePatchFileUtil.getPatchVersionDirectory((String)currentVersion));
        File libPath = new File(patchVersionDirectory.getAbsolutePath() + "/lib/lib/" + currentABI);
        if (!libPath.exists()) {
            ShareTinkerLog.e((String)TAG, (String)"tinker lib path [%s] is not exists.", (Object[])new Object[]{libPath});
            return false;
        }
        ClassLoader classLoader = appLike.getApplication().getClassLoader();
        if (classLoader == null) {
            ShareTinkerLog.e((String)TAG, (String)"classloader is null", (Object[])new Object[0]);
            return false;
        }
        ShareTinkerLog.i((String)TAG, (String)("before hack classloader:" + classLoader.toString()), (Object[])new Object[0]);
        try {
            Method installNativeLibraryPathMethod = TinkerLoadLibrary.class.getDeclaredMethod("installNativeLibraryPath", ClassLoader.class, File.class);
            installNativeLibraryPathMethod.setAccessible(true);
            installNativeLibraryPathMethod.invoke(null, classLoader, libPath);
            boolean bl = true;
            return bl;
        }
        catch (Throwable thr) {
            ShareTinkerLog.e((String)TAG, (String)("installNativeLibraryPath fail:" + libPath + ", thr: " + thr), (Object[])new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            ShareTinkerLog.i((String)TAG, (String)("after hack classloader:" + classLoader.toString()), (Object[])new Object[0]);
        }
    }

    private static void installNativeLibraryPath(ClassLoader classLoader, File folder) throws Throwable {
        if (folder == null || !folder.exists()) {
            ShareTinkerLog.e((String)TAG, (String)"installNativeLibraryPath, folder %s is illegal", (Object[])new Object[]{folder});
            return;
        }
        if (Build.VERSION.SDK_INT == 25 && Build.VERSION.PREVIEW_SDK_INT != 0 || Build.VERSION.SDK_INT > 25) {
            try {
                V25.install(classLoader, folder);
            }
            catch (Throwable throwable) {
                ShareTinkerLog.e((String)TAG, (String)"installNativeLibraryPath, v25 fail, sdk: %d, error: %s, try to fallback to V23", (Object[])new Object[]{Build.VERSION.SDK_INT, throwable.getMessage()});
                V23.install(classLoader, folder);
            }
        } else if (Build.VERSION.SDK_INT >= 23) {
            try {
                V23.install(classLoader, folder);
            }
            catch (Throwable throwable) {
                ShareTinkerLog.e((String)TAG, (String)"installNativeLibraryPath, v23 fail, sdk: %d, error: %s, try to fallback to V14", (Object[])new Object[]{Build.VERSION.SDK_INT, throwable.getMessage()});
                V14.install(classLoader, folder);
            }
        } else if (Build.VERSION.SDK_INT >= 14) {
            V14.install(classLoader, folder);
        } else {
            V4.install(classLoader, folder);
        }
    }

    private static final class V25 {
        private V25() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = ShareReflectUtil.findField((Object)classLoader, (String)"pathList");
            Object dexPathList = pathListField.get(classLoader);
            Field nativeLibraryDirectories = ShareReflectUtil.findField((Object)dexPathList, (String)"nativeLibraryDirectories");
            ArrayList<File> origLibDirs = (ArrayList<File>)nativeLibraryDirectories.get(dexPathList);
            if (origLibDirs == null) {
                origLibDirs = new ArrayList<File>(2);
            }
            Iterator libDirIt = origLibDirs.iterator();
            while (libDirIt.hasNext()) {
                File libDir = (File)libDirIt.next();
                if (!folder.equals(libDir)) continue;
                libDirIt.remove();
                break;
            }
            origLibDirs.add(0, folder);
            Field systemNativeLibraryDirectories = ShareReflectUtil.findField((Object)dexPathList, (String)"systemNativeLibraryDirectories");
            ArrayList origSystemLibDirs = (ArrayList)systemNativeLibraryDirectories.get(dexPathList);
            if (origSystemLibDirs == null) {
                origSystemLibDirs = new ArrayList(2);
            }
            ArrayList<File> newLibDirs = new ArrayList<File>(origLibDirs.size() + origSystemLibDirs.size() + 1);
            newLibDirs.addAll(origLibDirs);
            newLibDirs.addAll(origSystemLibDirs);
            Method makeElements = ShareReflectUtil.findMethod((Object)dexPathList, (String)"makePathElements", (Class[])new Class[]{List.class});
            Object[] elements = (Object[])makeElements.invoke(dexPathList, newLibDirs);
            Field nativeLibraryPathElements = ShareReflectUtil.findField((Object)dexPathList, (String)"nativeLibraryPathElements");
            nativeLibraryPathElements.set(dexPathList, elements);
        }
    }

    private static final class V23 {
        private V23() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = ShareReflectUtil.findField((Object)classLoader, (String)"pathList");
            Object dexPathList = pathListField.get(classLoader);
            Field nativeLibraryDirectories = ShareReflectUtil.findField((Object)dexPathList, (String)"nativeLibraryDirectories");
            ArrayList<File> origLibDirs = (ArrayList<File>)nativeLibraryDirectories.get(dexPathList);
            if (origLibDirs == null) {
                origLibDirs = new ArrayList<File>(2);
            }
            Iterator libDirIt = origLibDirs.iterator();
            while (libDirIt.hasNext()) {
                File libDir = (File)libDirIt.next();
                if (!folder.equals(libDir)) continue;
                libDirIt.remove();
                break;
            }
            origLibDirs.add(0, folder);
            Field systemNativeLibraryDirectories = ShareReflectUtil.findField((Object)dexPathList, (String)"systemNativeLibraryDirectories");
            ArrayList origSystemLibDirs = (ArrayList)systemNativeLibraryDirectories.get(dexPathList);
            if (origSystemLibDirs == null) {
                origSystemLibDirs = new ArrayList(2);
            }
            ArrayList<File> newLibDirs = new ArrayList<File>(origLibDirs.size() + origSystemLibDirs.size() + 1);
            newLibDirs.addAll(origLibDirs);
            newLibDirs.addAll(origSystemLibDirs);
            Method makeElements = ShareReflectUtil.findMethod((Object)dexPathList, (String)"makePathElements", (Class[])new Class[]{List.class, File.class, List.class});
            ArrayList suppressedExceptions = new ArrayList();
            Object[] elements = (Object[])makeElements.invoke(dexPathList, newLibDirs, null, suppressedExceptions);
            Field nativeLibraryPathElements = ShareReflectUtil.findField((Object)dexPathList, (String)"nativeLibraryPathElements");
            nativeLibraryPathElements.set(dexPathList, elements);
        }
    }

    private static final class V14 {
        private V14() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = ShareReflectUtil.findField((Object)classLoader, (String)"pathList");
            Object dexPathList = pathListField.get(classLoader);
            Field nativeLibDirField = ShareReflectUtil.findField((Object)dexPathList, (String)"nativeLibraryDirectories");
            File[] origNativeLibDirs = (File[])nativeLibDirField.get(dexPathList);
            ArrayList<File> newNativeLibDirList = new ArrayList<File>(origNativeLibDirs.length + 1);
            newNativeLibDirList.add(folder);
            for (File origNativeLibDir : origNativeLibDirs) {
                if (folder.equals(origNativeLibDir)) continue;
                newNativeLibDirList.add(origNativeLibDir);
            }
            nativeLibDirField.set(dexPathList, newNativeLibDirList.toArray(new File[0]));
        }
    }

    private static final class V4 {
        private V4() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            String addPath = folder.getPath();
            Field pathField = ShareReflectUtil.findField((Object)classLoader, (String)"libPath");
            String origLibPaths = (String)pathField.get(classLoader);
            String[] origLibPathSplit = origLibPaths.split(":");
            StringBuilder newLibPaths = new StringBuilder(addPath);
            for (String origLibPath : origLibPathSplit) {
                if (origLibPath == null || addPath.equals(origLibPath)) continue;
                newLibPaths.append(':').append(origLibPath);
            }
            pathField.set(classLoader, newLibPaths.toString());
            Field libraryPathElementsFiled = ShareReflectUtil.findField((Object)classLoader, (String)"libraryPathElements");
            List libraryPathElements = (List)libraryPathElementsFiled.get(classLoader);
            Iterator libPathElementIt = libraryPathElements.iterator();
            while (libPathElementIt.hasNext()) {
                String libPath = (String)libPathElementIt.next();
                if (!addPath.equals(libPath)) continue;
                libPathElementIt.remove();
                break;
            }
            libraryPathElements.add(0, addPath);
            libraryPathElementsFiled.set(classLoader, libraryPathElements);
        }
    }
}

