/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.reporter;

import android.content.Context;
import com.tencent.tinker.lib.reporter.LoadReporter;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerInstaller;
import com.tencent.tinker.lib.util.UpgradePatchRetry;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;

public class DefaultLoadReporter
implements LoadReporter {
    private static final String TAG = "Tinker.DefaultLoadReporter";
    protected final Context context;

    public DefaultLoadReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onLoadPatchListenerReceiveFail(File patchFile, int errorCode) {
        ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadPatchListenerReceiveFail: patch receive fail: %s, code: %d", (Object[])new Object[]{patchFile.getAbsolutePath(), errorCode});
    }

    @Override
    public void onLoadPatchVersionChanged(String oldVersion, String newVersion, File patchDirectoryFile, String currentPatchName) {
        ShareTinkerLog.i((String)TAG, (String)("patch loadReporter onLoadPatchVersionChanged: patch version change from " + oldVersion + " to " + newVersion), (Object[])new Object[0]);
        if (oldVersion == null || newVersion == null) {
            return;
        }
        if (oldVersion.equals(newVersion)) {
            return;
        }
        if (!Tinker.with(this.context).isMainProcess()) {
            return;
        }
        UpgradePatchRetry.getInstance(this.context).onPatchResetMaxCheck(newVersion);
        File[] files = patchDirectoryFile.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!file.isDirectory() || name.equals(currentPatchName)) continue;
                SharePatchFileUtil.deleteDir((File)file);
            }
        }
    }

    @Override
    public void onLoadInterpret(int type, Throwable e) {
        ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadInterpret: type: %d, throwable: %s", (Object[])new Object[]{type, e});
        switch (type) {
            case 1: {
                ShareTinkerLog.e((String)TAG, (String)"patch loadReporter onLoadInterpret fail, can get instruction set from existed oat file", (Object[])new Object[0]);
                break;
            }
            case 2: {
                ShareTinkerLog.e((String)TAG, (String)"patch loadReporter onLoadInterpret fail, command line to interpret return error", (Object[])new Object[0]);
                break;
            }
            case 0: {
                ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadInterpret ok", (Object[])new Object[0]);
                break;
            }
        }
        this.retryPatch();
    }

    @Override
    public void onLoadFileNotFound(File file, int fileType, boolean isDirectory) {
        ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadFileNotFound: patch file not found: %s, fileType: %d, isDirectory: %b", (Object[])new Object[]{file.getAbsolutePath(), fileType, isDirectory});
        if (fileType == 4) {
            this.retryPatch();
        } else {
            this.checkAndCleanPatch();
        }
    }

    @Override
    public void onLoadFileMd5Mismatch(File file, int fileType) {
        ShareTinkerLog.i((String)TAG, (String)"patch load Reporter onLoadFileMd5Mismatch: patch file md5 mismatch file: %s, fileType: %d", (Object[])new Object[]{file.getAbsolutePath(), fileType});
        this.checkAndCleanPatch();
    }

    @Override
    public void onLoadPatchInfoCorrupted(String oldVersion, String newVersion, File patchInfoFile) {
        ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadPatchInfoCorrupted: patch info file damage: %s, from version: %s to version: %s", (Object[])new Object[]{patchInfoFile.getAbsolutePath(), oldVersion, newVersion});
        this.checkAndCleanPatch();
    }

    @Override
    public void onLoadResult(File patchDirectory, int loadCode, long cost) {
        ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadResult: patch load result, path:%s, code: %d, cost: %dms", (Object[])new Object[]{patchDirectory.getAbsolutePath(), loadCode, cost});
    }

    @Override
    public void onLoadException(Throwable e, int errorCode) {
        switch (errorCode) {
            case -2: {
                if (e.getMessage().contains("checkDexInstall failed")) {
                    ShareTinkerLog.e((String)TAG, (String)("patch loadReporter onLoadException: tinker dex check fail:" + e.getMessage()), (Object[])new Object[0]);
                } else {
                    ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadException: patch load dex exception: %s", (Object[])new Object[]{e});
                }
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences((Context)this.context);
                ShareTinkerLog.i((String)TAG, (String)"dex exception disable tinker forever with sp", (Object[])new Object[0]);
                break;
            }
            case -3: {
                if (e.getMessage().contains("checkResInstall failed")) {
                    ShareTinkerLog.e((String)TAG, (String)("patch loadReporter onLoadException: tinker res check fail:" + e.getMessage()), (Object[])new Object[0]);
                } else {
                    ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadException: patch load resource exception: %s", (Object[])new Object[]{e});
                }
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences((Context)this.context);
                ShareTinkerLog.i((String)TAG, (String)"res exception disable tinker forever with sp", (Object[])new Object[0]);
                break;
            }
            case -4: {
                ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadException: patch load unCatch exception: %s", (Object[])new Object[]{e});
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences((Context)this.context);
                ShareTinkerLog.i((String)TAG, (String)"unCaught exception disable tinker forever with sp", (Object[])new Object[0]);
                String uncaughtString = SharePatchFileUtil.checkTinkerLastUncaughtCrash((Context)this.context);
                if (ShareTinkerInternals.isNullOrNil((String)uncaughtString)) break;
                File laseCrashFile = SharePatchFileUtil.getPatchLastCrashFile((Context)this.context);
                SharePatchFileUtil.safeDeleteFile((File)laseCrashFile);
                ShareTinkerLog.e((String)TAG, (String)("tinker uncaught real exception:" + uncaughtString), (Object[])new Object[0]);
                break;
            }
            case -1: {
                ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadException: patch load unknown exception: %s", (Object[])new Object[]{e});
                break;
            }
        }
        ShareTinkerLog.e((String)TAG, (String)"tinker load exception, welcome to submit issue to us: https://github.com/Tencent/tinker/issues", (Object[])new Object[0]);
        ShareTinkerLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"tinker load exception", (Object[])new Object[0]);
        Tinker.with(this.context).setTinkerDisable();
        this.checkAndCleanPatch();
    }

    @Override
    public void onLoadPackageCheckFail(File patchFile, int errorCode) {
        ShareTinkerLog.i((String)TAG, (String)"patch loadReporter onLoadPackageCheckFail: load patch package check fail file path: %s, errorCode: %d", (Object[])new Object[]{patchFile.getAbsolutePath(), errorCode});
        this.checkAndCleanPatch();
    }

    public void checkAndCleanPatch() {
        Tinker tinker = Tinker.with(this.context);
        tinker.cleanPatch();
    }

    public boolean retryPatch() {
        Tinker tinker = Tinker.with(this.context);
        if (!tinker.isMainProcess()) {
            return false;
        }
        File patchVersionFile = tinker.getTinkerLoadResultIfPresent().patchVersionFile;
        if (patchVersionFile != null && UpgradePatchRetry.getInstance(this.context).onPatchListenerCheck(SharePatchFileUtil.getMD5((File)patchVersionFile))) {
            ShareTinkerLog.i((String)TAG, (String)"try to repair oat file on patch process", (Object[])new Object[0]);
            TinkerInstaller.onReceiveUpgradePatch(this.context, patchVersionFile.getAbsolutePath());
            return true;
        }
        return false;
    }
}

