/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import com.tencent.tinker.commons.util.IOHelper;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BasePatchInternal {
    protected static final String TAG = "Tinker.BasePatchInternal";
    protected static final String DEX_PATH = "dex";
    protected static final String SO_PATH = "lib";
    protected static final String DEX_OPTIMIZE_PATH = "odex";
    protected static final int MAX_EXTRACT_ATTEMPTS = 2;
    protected static final String DEX_META_FILE = "assets/dex_meta.txt";
    protected static final String SO_META_FILE = "assets/so_meta.txt";
    protected static final String RES_META_FILE = "assets/res_meta.txt";
    protected static final String ARKHOT_META_FILE = "assets/arkHot_meta.txt";
    protected static final int TYPE_DEX = 3;
    protected static final int TYPE_LIBRARY = 5;
    protected static final int TYPE_RESOURCE = 6;
    protected static final int TYPE_CLASS_N_DEX = 7;
    protected static final int TYPE_ARKHOT_SO = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extract(ZipFile zipFile, ZipEntry entryFile, File extractTo, String targetMd5, boolean isDex) throws IOException {
        int numAttempts = 0;
        boolean isExtractionSuccessful = false;
        while (numAttempts < 2 && !isExtractionSuccessful) {
            boolean succ;
            ++numAttempts;
            BufferedInputStream is = null;
            BufferedOutputStream os = null;
            ShareTinkerLog.i((String)TAG, (String)("try Extracting " + extractTo.getPath()), (Object[])new Object[0]);
            try {
                is = new BufferedInputStream(zipFile.getInputStream(entryFile));
                os = new BufferedOutputStream(new FileOutputStream(extractTo));
                extractTo.setReadOnly();
                byte[] buffer = new byte[4096];
                int length = 0;
                while ((length = ((InputStream)is).read(buffer)) > 0) {
                    ((OutputStream)os).write(buffer, 0, length);
                }
            }
            catch (Throwable throwable) {
                IOHelper.closeQuietly(os);
                IOHelper.closeQuietly(is);
                throw throwable;
            }
            IOHelper.closeQuietly((Object)os);
            IOHelper.closeQuietly((Object)is);
            isExtractionSuccessful = targetMd5 != null ? (isDex ? SharePatchFileUtil.verifyDexFileMd5((File)extractTo, (String)targetMd5) : SharePatchFileUtil.verifyFileMd5((File)extractTo, (String)targetMd5)) : true;
            ShareTinkerLog.i((String)TAG, (String)"isExtractionSuccessful: %b", (Object[])new Object[]{isExtractionSuccessful});
            if (isExtractionSuccessful || (succ = extractTo.delete()) && !extractTo.exists()) continue;
            ShareTinkerLog.e((String)TAG, (String)("Failed to delete corrupted dex " + extractTo.getPath()), (Object[])new Object[0]);
        }
        return isExtractionSuccessful;
    }

    public static int getMetaCorruptedCode(int type) {
        if (type == 3) {
            return -3;
        }
        if (type == 5) {
            return -4;
        }
        if (type == 6) {
            return -8;
        }
        return 0;
    }
}

