/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.SystemClock;
import com.tencent.tinker.commons.util.IOHelper;
import com.tencent.tinker.lib.filepatch.FilePatchFactory;
import com.tencent.tinker.lib.patch.BasePatchInternal;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareBsDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.util.ArrayList;
import java.util.zip.ZipFile;

public class SoDiffPatchInternal
extends BasePatchInternal {
    private static final String TAG = "Tinker.BsDiffPatchInternal";

    protected static boolean tryRecoverLibraryFiles(Tinker manager, ShareSecurityCheck checker, Context context, String patchVersionDirectory, File patchFile, boolean useCustomPatcher, PatchResult patchResult) {
        long cost;
        if (!manager.isEnabledForNativeLib()) {
            ShareTinkerLog.w((String)TAG, (String)"patch recover, library is not enabled", (Object[])new Object[0]);
            return true;
        }
        String libMeta = (String)checker.getMetaContentMap().get("assets/so_meta.txt");
        if (libMeta == null) {
            ShareTinkerLog.w((String)TAG, (String)"patch recover, library is not contained", (Object[])new Object[0]);
            return true;
        }
        long begin = SystemClock.elapsedRealtime();
        boolean result = SoDiffPatchInternal.patchLibraryExtractViaBsDiff(context, patchVersionDirectory, libMeta, patchFile, useCustomPatcher);
        patchResult.soCostTime = cost = SystemClock.elapsedRealtime() - begin;
        ShareTinkerLog.i((String)TAG, (String)"recover lib result:%b, cost:%d", (Object[])new Object[]{result, cost});
        return result;
    }

    private static boolean patchLibraryExtractViaBsDiff(Context context, String patchVersionDirectory, String meta, File patchFile, boolean useCustomPatcher) {
        String dir = patchVersionDirectory + "/" + "lib" + "/";
        return SoDiffPatchInternal.extractBsDiffInternals(context, dir, meta, patchFile, 5, useCustomPatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean extractBsDiffInternals(Context context, String dir, String meta, File patchFile, int type, boolean useCustomPatcher) {
        block19: {
            block18: {
                patchList = new ArrayList<E>();
                ShareBsDiffPatchInfo.parseDiffPatchInfo((String)meta, patchList);
                if (patchList.isEmpty()) {
                    ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)"extract patch list is empty! type:%s:", (Object[])new Object[]{ShareTinkerInternals.getTypeString((int)type)});
                    return true;
                }
                directory = new File(dir);
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                manager = Tinker.with(context);
                applicationInfo = context.getApplicationInfo();
                if (applicationInfo == null) {
                    ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)"applicationInfo == null!!!!", (Object[])new Object[0]);
                    return false;
                }
                apk = null;
                patch = null;
                try {
                    apkPath = applicationInfo.sourceDir;
                    apk = new ZipFile(apkPath);
                    patch = new ZipFile(patchFile);
lbl21:
                    // 4 sources

                    for (ShareBsDiffPatchInfo info : patchList) {
                        start = System.currentTimeMillis();
                        infoPath = info.path;
                        patchRealPath = infoPath.equals("") != false ? info.name : info.path + "/" + info.name;
                        fileMd5 = info.md5;
                        if (!SharePatchFileUtil.checkIfMd5Valid((String)fileMd5)) {
                            ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)"meta file md5 mismatch, type:%s, name: %s, md5: %s", (Object[])new Object[]{ShareTinkerInternals.getTypeString((int)type), info.name, info.md5});
                            manager.getPatchReporter().onPatchPackageCheckFail(patchFile, BasePatchInternal.getMetaCorruptedCode(type));
                            var20_21 = false;
                            break block18;
                        }
                        ** GOTO lbl-1000
                    }
                    break block19;
                }
                catch (Throwable e) {
                    try {
                        throw new TinkerRuntimeException("patch " + ShareTinkerInternals.getTypeString((int)type) + " extract failed (" + e.getMessage() + ").", e);
                    }
                    catch (Throwable var30_37) {
                        SharePatchFileUtil.closeZip(apk);
                        SharePatchFileUtil.closeZip(patch);
                        throw var30_37;
                    }
                }
            }
            SharePatchFileUtil.closeZip((ZipFile)apk);
            SharePatchFileUtil.closeZip((ZipFile)patch);
            return var20_21;
lbl-1000:
            // 1 sources

            {
                block22: {
                    block20: {
                        block21: {
                            middle = info.path + "/" + info.name;
                            extractedFile = new File(dir + middle);
                            if (!extractedFile.exists()) break block20;
                            if (!fileMd5.equals(SharePatchFileUtil.getMD5((File)extractedFile))) break block21;
                            ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)"bsdiff file %s is already exist, and md5 match, just continue", (Object[])new Object[]{extractedFile.getPath()});
                            ** GOTO lbl21
                        }
                        ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)("have a mismatch corrupted dex " + extractedFile.getPath()), (Object[])new Object[0]);
                        extractedFile.delete();
                        break block22;
                    }
                    extractedFile.getParentFile().mkdirs();
                }
                patchFileMd5 = info.patchMd5;
                patchFileEntry = patch.getEntry(patchRealPath);
                if (patchFileEntry != null) ** GOTO lbl-1000
                ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)("patch entry is null. path:" + patchRealPath), (Object[])new Object[0]);
                manager.getPatchReporter().onPatchTypeExtractFail(patchFile, extractedFile, info.name, type);
                var24_26 = false;
            }
            SharePatchFileUtil.closeZip((ZipFile)apk);
            SharePatchFileUtil.closeZip((ZipFile)patch);
            return var24_26;
lbl-1000:
            // 1 sources

            {
                if (!patchFileMd5.equals("0")) ** GOTO lbl-1000
                if (SoDiffPatchInternal.extract(patch, patchFileEntry, extractedFile, fileMd5, false)) ** GOTO lbl21
                ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)("Failed to extract file " + extractedFile.getPath()), (Object[])new Object[0]);
                manager.getPatchReporter().onPatchTypeExtractFail(patchFile, extractedFile, info.name, type);
                var24_27 = false;
            }
            SharePatchFileUtil.closeZip((ZipFile)apk);
            SharePatchFileUtil.closeZip((ZipFile)patch);
            return var24_27;
lbl-1000:
            // 1 sources

            {
                if (SharePatchFileUtil.checkIfMd5Valid((String)patchFileMd5)) ** GOTO lbl-1000
                ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)"meta file md5 mismatch, type:%s, name: %s, md5: %s", (Object[])new Object[]{ShareTinkerInternals.getTypeString((int)type), info.name, patchFileMd5});
                manager.getPatchReporter().onPatchPackageCheckFail(patchFile, BasePatchInternal.getMetaCorruptedCode(type));
                var24_28 = false;
            }
            SharePatchFileUtil.closeZip((ZipFile)apk);
            SharePatchFileUtil.closeZip((ZipFile)patch);
            return var24_28;
lbl-1000:
            // 1 sources

            {
                rawApkFileEntry = apk.getEntry(patchRealPath);
                if (rawApkFileEntry != null) ** GOTO lbl-1000
                ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)("apk entry is null. path:" + patchRealPath), (Object[])new Object[0]);
                manager.getPatchReporter().onPatchTypeExtractFail(patchFile, extractedFile, info.name, type);
                var25_30 = false;
            }
            SharePatchFileUtil.closeZip((ZipFile)apk);
            SharePatchFileUtil.closeZip((ZipFile)patch);
            return var25_30;
lbl-1000:
            // 1 sources

            {
                rawApkCrc = info.rawCrc;
                rawEntryCrc = String.valueOf(rawApkFileEntry.getCrc());
                if (rawEntryCrc.equals(rawApkCrc)) ** GOTO lbl-1000
                ShareTinkerLog.e((String)"Tinker.BsDiffPatchInternal", (String)"apk entry %s crc is not equal, expect crc: %s, got crc: %s", (Object[])new Object[]{patchRealPath, rawApkCrc, rawEntryCrc});
                manager.getPatchReporter().onPatchTypeExtractFail(patchFile, extractedFile, info.name, type);
                var27_33 = false;
            }
            SharePatchFileUtil.closeZip((ZipFile)apk);
            SharePatchFileUtil.closeZip((ZipFile)patch);
            return var27_33;
lbl-1000:
            // 1 sources

            {
                oldStream = null;
                newStream = null;
                try {
                    oldStream = apk.getInputStream(rawApkFileEntry);
                    newStream = patch.getInputStream(patchFileEntry);
                    FilePatchFactory.getFilePatcher(context, useCustomPatcher).patchFast(oldStream, newStream, extractedFile);
                }
                catch (Throwable var29_35) {
                    IOHelper.closeQuietly((Object)oldStream);
                    IOHelper.closeQuietly(newStream);
                    throw var29_35;
                }
                IOHelper.closeQuietly((Object)oldStream);
                IOHelper.closeQuietly((Object)newStream);
                if (SharePatchFileUtil.verifyFileMd5((File)extractedFile, (String)fileMd5)) ** GOTO lbl-1000
                ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)("Failed to recover diff file " + extractedFile.getPath()), (Object[])new Object[0]);
                manager.getPatchReporter().onPatchTypeExtractFail(patchFile, extractedFile, info.name, type);
                SharePatchFileUtil.safeDeleteFile((File)extractedFile);
                var29_36 = false;
            }
            SharePatchFileUtil.closeZip((ZipFile)apk);
            SharePatchFileUtil.closeZip((ZipFile)patch);
            return var29_36;
lbl-1000:
            // 1 sources

            {
                ShareTinkerLog.w((String)"Tinker.BsDiffPatchInternal", (String)"success recover bsdiff file: %s, use time: %d", (Object[])new Object[]{extractedFile.getPath(), System.currentTimeMillis() - start});
                ** GOTO lbl21
            }
        }
        SharePatchFileUtil.closeZip((ZipFile)apk);
        SharePatchFileUtil.closeZip((ZipFile)patch);
        return true;
    }
}

