/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.listener;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.text.TextUtils;
import com.tencent.tinker.lib.listener.PatchListener;
import com.tencent.tinker.lib.service.TinkerPatchForeService;
import com.tencent.tinker.lib.service.TinkerPatchService;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.lib.util.UpgradePatchRetry;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;

public class DefaultPatchListener
implements PatchListener {
    protected final Context context;
    private ServiceConnection connection;

    public DefaultPatchListener(Context context) {
        this.context = context;
    }

    @Override
    public int onPatchReceived(String path) {
        File patchFile = new File(path);
        String patchMD5 = SharePatchFileUtil.getMD5((File)patchFile);
        int returnCode = this.patchCheck(path, patchMD5);
        if (returnCode == 0) {
            this.runForgService();
            TinkerPatchService.runPatchService(this.context, path);
        } else {
            Tinker.with(this.context).getLoadReporter().onLoadPatchListenerReceiveFail(new File(path), returnCode);
        }
        return returnCode;
    }

    private void runForgService() {
        try {
            this.connection = new ServiceConnection(){

                public void onServiceConnected(ComponentName name, IBinder service) {
                }

                public void onServiceDisconnected(ComponentName name) {
                    if (DefaultPatchListener.this.context != null && DefaultPatchListener.this.connection != null) {
                        try {
                            DefaultPatchListener.this.context.unbindService(DefaultPatchListener.this.connection);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }

                public void onBindingDied(ComponentName name) {
                }
            };
            Intent innerForgIntent = new Intent(this.context, TinkerPatchForeService.class);
            this.context.bindService(innerForgIntent, this.connection, 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected int patchCheck(String path, String patchMd5) {
        String currentVersion;
        TinkerLoadResult tinkerLoadResult;
        Tinker manager = Tinker.with(this.context);
        if (!manager.isTinkerEnabled() || !ShareTinkerInternals.isTinkerEnableWithSharedPreferences((Context)this.context)) {
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)patchMd5)) {
            return -2;
        }
        File file = new File(path);
        if (!SharePatchFileUtil.isLegalFile((File)file)) {
            return -2;
        }
        if (manager.isPatchProcess()) {
            return -4;
        }
        if (TinkerServiceInternals.isTinkerPatchServiceRunning(this.context)) {
            return -3;
        }
        if (ShareTinkerInternals.isVmJit()) {
            return -5;
        }
        Tinker tinker = Tinker.with(this.context);
        if (tinker.isTinkerLoaded() && (tinkerLoadResult = tinker.getTinkerLoadResultIfPresent()) != null && !tinkerLoadResult.useInterpretMode && patchMd5.equals(currentVersion = tinkerLoadResult.currentVersion)) {
            return -6;
        }
        String patchDirectory = manager.getPatchDirectory().getAbsolutePath();
        File patchInfoLockFile = SharePatchFileUtil.getPatchInfoLockFile((String)patchDirectory);
        File patchInfoFile = SharePatchFileUtil.getPatchInfoFile((String)patchDirectory);
        try {
            SharePatchInfo currInfo = SharePatchInfo.readAndCheckPropertyWithLock((File)patchInfoFile, (File)patchInfoLockFile);
            if (currInfo != null && !ShareTinkerInternals.isNullOrNil((String)currInfo.newVersion) && !currInfo.isRemoveNewVersion && patchMd5.equals(currInfo.newVersion)) {
                return -6;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!UpgradePatchRetry.getInstance(this.context).onPatchListenerCheck(patchMd5)) {
            return -7;
        }
        return 0;
    }
}

