/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.Build;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.patch.ArkHotDiffPatchInternal;
import com.tencent.tinker.lib.patch.BsDiffPatchInternal;
import com.tencent.tinker.lib.patch.DexDiffPatchInternal;
import com.tencent.tinker.lib.patch.ResDiffPatchInternal;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.UpgradePatchRetry;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class UpgradePatch
extends AbstractPatch {
    private static final String TAG = "Tinker.UpgradePatch";

    @Override
    public boolean tryPatch(Context context, String tempPatchPath, PatchResult patchResult) {
        SharePatchInfo newInfo;
        Tinker manager = Tinker.with(context);
        File patchFile = new File(tempPatchPath);
        if (!manager.isTinkerEnabled() || !ShareTinkerInternals.isTinkerEnableWithSharedPreferences((Context)context)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch is disabled, just return", new Object[0]);
            return false;
        }
        if (!SharePatchFileUtil.isLegalFile((File)patchFile)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch file is not found, just return", new Object[0]);
            return false;
        }
        ShareSecurityCheck signatureCheck = new ShareSecurityCheck(context);
        int returnCode = ShareTinkerInternals.checkTinkerPackage((Context)context, (int)manager.getTinkerFlags(), (File)patchFile, (ShareSecurityCheck)signatureCheck);
        if (returnCode != 0) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchPackageCheckFail", new Object[0]);
            manager.getPatchReporter().onPatchPackageCheckFail(patchFile, returnCode);
            return false;
        }
        String patchMd5 = SharePatchFileUtil.getMD5((File)patchFile);
        if (patchMd5 == null) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch md5 is null, just return", new Object[0]);
            return false;
        }
        patchResult.patchVersion = patchMd5;
        TinkerLog.i(TAG, "UpgradePatch tryPatch:patchMd5:%s", patchMd5);
        String patchDirectory = manager.getPatchDirectory().getAbsolutePath();
        File patchInfoLockFile = SharePatchFileUtil.getPatchInfoLockFile((String)patchDirectory);
        File patchInfoFile = SharePatchFileUtil.getPatchInfoFile((String)patchDirectory);
        HashMap pkgProps = signatureCheck.getPackagePropertiesIfPresent();
        if (pkgProps == null) {
            TinkerLog.e(TAG, "UpgradePatch packageProperties is null, do we process a valid patch apk ?", new Object[0]);
            return false;
        }
        String isProtectedAppStr = (String)pkgProps.get("is_protected_app");
        boolean isProtectedApp = isProtectedAppStr != null && !isProtectedAppStr.isEmpty() && !"0".equals(isProtectedAppStr);
        SharePatchInfo oldInfo = SharePatchInfo.readAndCheckPropertyWithLock((File)patchInfoFile, (File)patchInfoLockFile);
        if (oldInfo != null) {
            if (oldInfo.oldVersion == null || oldInfo.newVersion == null || oldInfo.oatDir == null) {
                TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchInfoCorrupted", new Object[0]);
                manager.getPatchReporter().onPatchInfoCorrupted(patchFile, oldInfo.oldVersion, oldInfo.newVersion);
                return false;
            }
            if (!SharePatchFileUtil.checkIfMd5Valid((String)patchMd5)) {
                TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchVersionCheckFail md5 %s is valid", patchMd5);
                manager.getPatchReporter().onPatchVersionCheckFail(patchFile, oldInfo, patchMd5);
                return false;
            }
            boolean usingInterpret = oldInfo.oatDir.equals("interpet");
            if (!usingInterpret && !ShareTinkerInternals.isNullOrNil((String)oldInfo.newVersion) && oldInfo.newVersion.equals(patchMd5) && !oldInfo.isRemoveNewVersion) {
                TinkerLog.e(TAG, "patch already applied, md5: %s", patchMd5);
                UpgradePatchRetry.getInstance(context).onPatchResetMaxCheck(patchMd5);
                return true;
            }
            String finalOatDir = usingInterpret ? "changing" : oldInfo.oatDir;
            newInfo = new SharePatchInfo(oldInfo.oldVersion, patchMd5, isProtectedApp, false, Build.FINGERPRINT, finalOatDir);
        } else {
            newInfo = new SharePatchInfo("", patchMd5, isProtectedApp, false, Build.FINGERPRINT, "odex");
        }
        String patchName = SharePatchFileUtil.getPatchVersionDirectory((String)patchMd5);
        String patchVersionDirectory = patchDirectory + "/" + patchName;
        TinkerLog.i(TAG, "UpgradePatch tryPatch:patchVersionDirectory:%s", patchVersionDirectory);
        File destPatchFile = new File(patchVersionDirectory + "/" + SharePatchFileUtil.getPatchVersionFile((String)patchMd5));
        try {
            if (!patchMd5.equals(SharePatchFileUtil.getMD5((File)destPatchFile))) {
                SharePatchFileUtil.copyFileUsingStream((File)patchFile, (File)destPatchFile);
                TinkerLog.w(TAG, "UpgradePatch copy patch file, src file: %s size: %d, dest file: %s size:%d", patchFile.getAbsolutePath(), patchFile.length(), destPatchFile.getAbsolutePath(), destPatchFile.length());
            }
        }
        catch (IOException e) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:copy patch file fail from %s to %s", patchFile.getPath(), destPatchFile.getPath());
            manager.getPatchReporter().onPatchTypeExtractFail(patchFile, destPatchFile, patchFile.getName(), 1);
            return false;
        }
        if (!DexDiffPatchInternal.tryRecoverDexFiles(manager, signatureCheck, context, patchVersionDirectory, destPatchFile)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch dex failed", new Object[0]);
            return false;
        }
        if (!ArkHotDiffPatchInternal.tryRecoverArkHotLibrary(manager, signatureCheck, context, patchVersionDirectory, destPatchFile)) {
            return false;
        }
        if (!BsDiffPatchInternal.tryRecoverLibraryFiles(manager, signatureCheck, context, patchVersionDirectory, destPatchFile)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch library failed", new Object[0]);
            return false;
        }
        if (!ResDiffPatchInternal.tryRecoverResourceFiles(manager, signatureCheck, context, patchVersionDirectory, destPatchFile)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch resource failed", new Object[0]);
            return false;
        }
        if (!DexDiffPatchInternal.waitAndCheckDexOptFile(patchFile, manager)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, check dex opt file failed", new Object[0]);
            return false;
        }
        if (!SharePatchInfo.rewritePatchInfoFileWithLock((File)patchInfoFile, (SharePatchInfo)newInfo, (File)patchInfoLockFile)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, rewrite patch info failed", new Object[0]);
            manager.getPatchReporter().onPatchInfoCorrupted(patchFile, newInfo.oldVersion, newInfo.newVersion);
            return false;
        }
        UpgradePatchRetry.getInstance(context).onPatchResetMaxCheck(patchMd5);
        TinkerLog.w(TAG, "UpgradePatch tryPatch: done, it is ok", new Object[0]);
        return true;
    }
}

