/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.util;

import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class TinkerLog {
    private static final String TAG = "Tinker.TinkerLog";
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
    private static final List<Object[]> sPendingLogs = Collections.synchronizedList(new ArrayList());
    private static final TinkerLogImp debugLog = new TinkerLogImp(){

        @Override
        public void v(String tag, String format, Object ... params) {
            String log = params == null || params.length == 0 ? format : String.format(format, params);
            Log.v((String)tag, (String)log);
        }

        @Override
        public void i(String tag, String format, Object ... params) {
            String log = params == null || params.length == 0 ? format : String.format(format, params);
            Log.i((String)tag, (String)log);
        }

        @Override
        public void d(String tag, String format, Object ... params) {
            String log = params == null || params.length == 0 ? format : String.format(format, params);
            Log.d((String)tag, (String)log);
        }

        @Override
        public void w(String tag, String format, Object ... params) {
            String log = params == null || params.length == 0 ? format : String.format(format, params);
            Log.w((String)tag, (String)log);
        }

        @Override
        public void e(String tag, String format, Object ... params) {
            String log = params == null || params.length == 0 ? format : String.format(format, params);
            Log.e((String)tag, (String)log);
        }

        @Override
        public void printErrStackTrace(String tag, Throwable tr, String format, Object ... params) {
            String log;
            String string = log = params == null || params.length == 0 ? format : String.format(format, params);
            if (log == null) {
                log = "";
            }
            log = log + "  " + Log.getStackTraceString((Throwable)tr);
            Log.e((String)tag, (String)log);
        }
    };
    private static final TinkerLogImp[] tinkerLogImpRef = new TinkerLogImp[]{debugLog};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTinkerLogImp(TinkerLogImp imp) {
        TinkerLogImp[] tinkerLogImpArray = tinkerLogImpRef;
        synchronized (tinkerLogImpRef) {
            TinkerLog.tinkerLogImpRef[0] = imp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TinkerLogImp getImpl() {
        TinkerLogImp[] tinkerLogImpArray = tinkerLogImpRef;
        synchronized (tinkerLogImpRef) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return tinkerLogImpRef[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printPendingLogs() {
        TinkerLogImp[] tinkerLogImpArray = tinkerLogImpRef;
        synchronized (tinkerLogImpRef) {
            TinkerLogImp imp = tinkerLogImpRef[0];
            // ** MonitorExit[var1] (shouldn't be in output)
            if (sPendingLogs.isEmpty()) {
                return;
            }
            if (imp == null) {
                return;
            }
            for (Object[] log : sPendingLogs) {
                int level = (Integer)log[0];
                String tag = (String)log[1];
                String msg = (String)log[2];
                switch (level) {
                    case 2: {
                        imp.v(tag, msg, new Object[0]);
                        break;
                    }
                    case 3: {
                        imp.d(tag, msg, new Object[0]);
                        break;
                    }
                    case 4: {
                        imp.i(tag, msg, new Object[0]);
                        break;
                    }
                    case 5: {
                        imp.w(tag, msg, new Object[0]);
                        break;
                    }
                    case 6: {
                        imp.e(tag, msg, new Object[0]);
                        break;
                    }
                }
            }
            sPendingLogs.clear();
            return;
        }
    }

    public static void v(String tag, String fmt, Object ... obj) {
        TinkerLogImp imp = TinkerLog.getImpl();
        if (imp != null) {
            imp.v(tag, fmt, obj);
        } else {
            String msg = obj != null && obj.length > 0 ? String.format(fmt, obj) : fmt;
            String prefix = "[PendingLog@" + SIMPLE_DATE_FORMAT.format(new Date()) + "] ";
            sPendingLogs.add(new Object[]{2, tag, prefix + msg});
        }
    }

    public static void e(String tag, String fmt, Object ... obj) {
        TinkerLogImp imp = TinkerLog.getImpl();
        if (imp != null) {
            imp.e(tag, fmt, obj);
        } else {
            String msg = obj != null && obj.length > 0 ? String.format(fmt, obj) : fmt;
            String prefix = "[PendingLog@" + SIMPLE_DATE_FORMAT.format(new Date()) + "] ";
            sPendingLogs.add(new Object[]{6, tag, prefix + msg});
        }
    }

    public static void w(String tag, String fmt, Object ... obj) {
        TinkerLogImp imp = TinkerLog.getImpl();
        if (imp != null) {
            imp.w(tag, fmt, obj);
        } else {
            String msg = obj != null && obj.length > 0 ? String.format(fmt, obj) : fmt;
            String prefix = "[PendingLog@" + SIMPLE_DATE_FORMAT.format(new Date()) + "] ";
            sPendingLogs.add(new Object[]{5, tag, prefix + msg});
        }
    }

    public static void i(String tag, String fmt, Object ... obj) {
        TinkerLogImp imp = TinkerLog.getImpl();
        if (imp != null) {
            imp.i(tag, fmt, obj);
        } else {
            String msg = obj != null && obj.length > 0 ? String.format(fmt, obj) : fmt;
            String prefix = "[PendingLog@" + SIMPLE_DATE_FORMAT.format(new Date()) + "] ";
            sPendingLogs.add(new Object[]{4, tag, prefix + msg});
        }
    }

    public static void d(String tag, String fmt, Object ... obj) {
        TinkerLogImp imp = TinkerLog.getImpl();
        if (imp != null) {
            imp.d(tag, fmt, obj);
        } else {
            String msg = obj != null && obj.length > 0 ? String.format(fmt, obj) : fmt;
            String prefix = "[PendingLog@" + SIMPLE_DATE_FORMAT.format(new Date()) + "] ";
            sPendingLogs.add(new Object[]{3, tag, prefix + msg});
        }
    }

    public static void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
        TinkerLogImp imp = TinkerLog.getImpl();
        if (imp != null) {
            imp.printErrStackTrace(tag, tr, format, obj);
        } else {
            String msg = obj == null || obj.length == 0 ? format : String.format(format, obj);
            msg = msg + "  " + Log.getStackTraceString((Throwable)tr);
            String prefix = "[PendingLog@" + SIMPLE_DATE_FORMAT.format(new Date()) + "] ";
            sPendingLogs.add(new Object[]{6, tag, prefix + msg});
        }
    }

    public static interface TinkerLogImp {
        public void v(String var1, String var2, Object ... var3);

        public void i(String var1, String var2, Object ... var3);

        public void w(String var1, String var2, Object ... var3);

        public void d(String var1, String var2, Object ... var3);

        public void e(String var1, String var2, Object ... var3);

        public void printErrStackTrace(String var1, Throwable var2, String var3, Object ... var4);
    }
}

