/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.util;

import android.content.Context;
import android.content.Intent;
import com.tencent.tinker.commons.util.StreamUtil;
import com.tencent.tinker.lib.service.TinkerPatchService;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerInstaller;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class UpgradePatchRetry {
    private static final String TAG = "Tinker.UpgradePatchRetry";
    private static final String RETRY_INFO_NAME = "patch.retry";
    private static final String TEMP_PATCH_NAME = "temp.apk";
    private static final String RETRY_FILE_MD5_PROPERTY = "md5";
    private static final String RETRY_COUNT_PROPERTY = "times";
    private static final int RETRY_MAX_COUNT = 20;
    private static UpgradePatchRetry sInstance;
    private boolean isRetryEnable = true;
    private File retryInfoFile = null;
    private File tempPatchFile = null;
    private Context context = null;
    private int maxRetryCount = 20;

    public UpgradePatchRetry(Context context) {
        this.context = context;
        this.retryInfoFile = new File(SharePatchFileUtil.getPatchTempDirectory((Context)context), RETRY_INFO_NAME);
        this.tempPatchFile = new File(SharePatchFileUtil.getPatchTempDirectory((Context)context), TEMP_PATCH_NAME);
    }

    public static UpgradePatchRetry getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new UpgradePatchRetry(context);
        }
        return sInstance;
    }

    public void setRetryEnable(boolean enable) {
        this.isRetryEnable = enable;
    }

    public void setMaxRetryCount(int count) {
        if (count <= 0) {
            TinkerLog.e(TAG, "max count must large than 0", new Object[0]);
            return;
        }
        this.maxRetryCount = count;
    }

    public boolean onPatchRetryLoad() {
        if (!this.isRetryEnable) {
            TinkerLog.w(TAG, "onPatchRetryLoad retry disabled, just return", new Object[0]);
            return false;
        }
        Tinker tinker = Tinker.with(this.context);
        if (!tinker.isMainProcess()) {
            TinkerLog.w(TAG, "onPatchRetryLoad retry is not main process, just return", new Object[0]);
            return false;
        }
        if (!this.retryInfoFile.exists()) {
            TinkerLog.w(TAG, "onPatchRetryLoad retry info not exist, just return", new Object[0]);
            return false;
        }
        if (TinkerServiceInternals.isTinkerPatchServiceRunning(this.context)) {
            TinkerLog.w(TAG, "onPatchRetryLoad tinker service is running, just return", new Object[0]);
            return false;
        }
        String path = this.tempPatchFile.getAbsolutePath();
        if (path == null || !new File(path).exists()) {
            TinkerLog.w(TAG, "onPatchRetryLoad patch file: %s is not exist, just return", path);
            return false;
        }
        TinkerLog.w(TAG, "onPatchRetryLoad patch file: %s is exist, retry to patch", path);
        TinkerInstaller.onReceiveUpgradePatch(this.context, path);
        return true;
    }

    public void onPatchServiceStart(Intent intent) {
        RetryInfo retryInfo;
        if (!this.isRetryEnable) {
            TinkerLog.w(TAG, "onPatchServiceStart retry disabled, just return", new Object[0]);
            return;
        }
        if (intent == null) {
            TinkerLog.e(TAG, "onPatchServiceStart intent is null, just return", new Object[0]);
            return;
        }
        String path = TinkerPatchService.getPatchPathExtra(intent);
        if (path == null) {
            TinkerLog.w(TAG, "onPatchServiceStart patch path is null, just return", new Object[0]);
            return;
        }
        File patchFile = new File(path);
        String patchMd5 = SharePatchFileUtil.getMD5((File)patchFile);
        if (patchMd5 == null) {
            TinkerLog.w(TAG, "onPatchServiceStart patch md5 is null, just return", new Object[0]);
            return;
        }
        if (this.retryInfoFile.exists()) {
            retryInfo = RetryInfo.readRetryProperty(this.retryInfoFile);
            if (retryInfo.md5 == null || retryInfo.times == null || !patchMd5.equals(retryInfo.md5)) {
                this.copyToTempFile(patchFile);
                retryInfo.md5 = patchMd5;
                retryInfo.times = "1";
            } else {
                int nowTimes = Integer.parseInt(retryInfo.times);
                if (nowTimes >= this.maxRetryCount) {
                    SharePatchFileUtil.safeDeleteFile((File)this.tempPatchFile);
                    TinkerLog.w(TAG, "onPatchServiceStart retry more than max count, delete retry info file!", new Object[0]);
                    return;
                }
                retryInfo.times = String.valueOf(nowTimes + 1);
            }
        } else {
            this.copyToTempFile(patchFile);
            retryInfo = new RetryInfo(patchMd5, "1");
        }
        RetryInfo.writeRetryProperty(this.retryInfoFile, retryInfo);
    }

    public boolean onPatchListenerCheck(String md5) {
        int nowTimes;
        if (!this.isRetryEnable) {
            TinkerLog.w(TAG, "onPatchListenerCheck retry disabled, just return", new Object[0]);
            return true;
        }
        if (!this.retryInfoFile.exists()) {
            TinkerLog.w(TAG, "onPatchListenerCheck retry file is not exist, just return", new Object[0]);
            return true;
        }
        if (md5 == null) {
            TinkerLog.w(TAG, "onPatchListenerCheck md5 is null, just return", new Object[0]);
            return true;
        }
        RetryInfo retryInfo = RetryInfo.readRetryProperty(this.retryInfoFile);
        if (md5.equals(retryInfo.md5) && (nowTimes = Integer.parseInt(retryInfo.times)) >= this.maxRetryCount) {
            TinkerLog.w(TAG, "onPatchListenerCheck, retry count %d must exceed than max retry count", nowTimes);
            SharePatchFileUtil.safeDeleteFile((File)this.tempPatchFile);
            return false;
        }
        return true;
    }

    public boolean onPatchResetMaxCheck(String md5) {
        if (!this.isRetryEnable) {
            TinkerLog.w(TAG, "onPatchResetMaxCheck retry disabled, just return", new Object[0]);
            return true;
        }
        if (!this.retryInfoFile.exists()) {
            TinkerLog.w(TAG, "onPatchResetMaxCheck retry file is not exist, just return", new Object[0]);
            return true;
        }
        if (md5 == null) {
            TinkerLog.w(TAG, "onPatchResetMaxCheck md5 is null, just return", new Object[0]);
            return true;
        }
        RetryInfo retryInfo = RetryInfo.readRetryProperty(this.retryInfoFile);
        if (md5.equals(retryInfo.md5)) {
            TinkerLog.i(TAG, "onPatchResetMaxCheck, reset max check to 1", new Object[0]);
            retryInfo.times = "1";
            RetryInfo.writeRetryProperty(this.retryInfoFile, retryInfo);
        }
        return true;
    }

    public void onPatchServiceResult() {
        if (!this.isRetryEnable) {
            TinkerLog.w(TAG, "onPatchServiceResult retry disabled, just return", new Object[0]);
            return;
        }
        if (this.tempPatchFile.exists()) {
            SharePatchFileUtil.safeDeleteFile((File)this.tempPatchFile);
        }
    }

    private void copyToTempFile(File patchFile) {
        if (patchFile.getAbsolutePath().equals(this.tempPatchFile.getAbsolutePath())) {
            return;
        }
        TinkerLog.w(TAG, "try copy file: %s to %s", patchFile.getAbsolutePath(), this.tempPatchFile.getAbsolutePath());
        try {
            SharePatchFileUtil.copyFileUsingStream((File)patchFile, (File)this.tempPatchFile);
        }
        catch (IOException e) {
            TinkerLog.e(TAG, "fail to copy file: %s to %s", patchFile.getAbsolutePath(), this.tempPatchFile.getAbsolutePath());
        }
    }

    static class RetryInfo {
        String md5;
        String times;

        RetryInfo(String md5, String times) {
            this.md5 = md5;
            this.times = times;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RetryInfo readRetryProperty(File infoFile) {
            String md5 = null;
            String times = null;
            Properties properties = new Properties();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(infoFile);
                properties.load(inputStream);
                md5 = properties.getProperty(UpgradePatchRetry.RETRY_FILE_MD5_PROPERTY);
                times = properties.getProperty(UpgradePatchRetry.RETRY_COUNT_PROPERTY);
            }
            catch (IOException e) {
                try {
                    TinkerLog.e(UpgradePatchRetry.TAG, "fail to readRetryProperty:" + e, new Object[0]);
                }
                catch (Throwable throwable) {
                    StreamUtil.closeQuietly(inputStream);
                    throw throwable;
                }
                StreamUtil.closeQuietly((Object)inputStream);
            }
            StreamUtil.closeQuietly((Object)inputStream);
            return new RetryInfo(md5, times);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void writeRetryProperty(File infoFile, RetryInfo info) {
            if (info == null) {
                return;
            }
            File parentFile = infoFile.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            Properties newProperties = new Properties();
            newProperties.put(UpgradePatchRetry.RETRY_FILE_MD5_PROPERTY, info.md5);
            newProperties.put(UpgradePatchRetry.RETRY_COUNT_PROPERTY, info.times);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(infoFile, false);
                newProperties.store(outputStream, null);
            }
            catch (Exception e) {
                try {
                    TinkerLog.printErrStackTrace(UpgradePatchRetry.TAG, e, "retry write property fail", new Object[0]);
                }
                catch (Throwable throwable) {
                    StreamUtil.closeQuietly(outputStream);
                    throw throwable;
                }
                StreamUtil.closeQuietly((Object)outputStream);
            }
            StreamUtil.closeQuietly((Object)outputStream);
        }
    }
}

