/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.service;

import android.app.ActivityManager;
import android.app.IntentService;
import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemClock;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.service.AbstractResultService;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class TinkerPatchService
extends IntentService {
    private static final String TAG = "Tinker.TinkerPatchService";
    private static final String PATCH_PATH_EXTRA = "patch_path_extra";
    private static final String PATCH_USE_EMERGENCY_MODE = "patch_use_emergency_mode";
    private static final String RESULT_CLASS_EXTRA = "patch_result_class";
    private static AbstractPatch upgradePatchProcessor = null;
    private static int notificationId = -1119860829;
    private static Class<? extends AbstractResultService> resultServiceClass = null;
    private static final String RUNNING_MARKER_FILE_RELPATH_PREFIX = "patch_service_status/running_";
    private static AtomicBoolean sIsPatchApplying = new AtomicBoolean(false);

    public TinkerPatchService() {
        super("TinkerPatchService");
        this.setIntentRedelivery(true);
    }

    public static void runPatchService(Context context, String path) {
        TinkerPatchService.runPatchService(context, path, false);
    }

    public static void runPatchService(Context context, String path, boolean useEmergencyMode) {
        ShareTinkerLog.i((String)TAG, (String)"run patch service...", (Object[])new Object[0]);
        Intent intent = new Intent(context, TinkerPatchService.class);
        intent.putExtra(PATCH_PATH_EXTRA, path);
        intent.putExtra(PATCH_USE_EMERGENCY_MODE, useEmergencyMode);
        intent.putExtra(RESULT_CLASS_EXTRA, resultServiceClass.getName());
        try {
            context.startService(intent);
        }
        catch (Throwable thr) {
            ShareTinkerLog.e((String)TAG, (String)("run patch service fail, exception:" + thr), (Object[])new Object[0]);
        }
    }

    public static void setPatchProcessor(AbstractPatch upgradePatch, Class<? extends AbstractResultService> serviceClass) {
        upgradePatchProcessor = upgradePatch;
        resultServiceClass = serviceClass;
        try {
            Class.forName(serviceClass.getName());
        }
        catch (ClassNotFoundException e) {
            ShareTinkerLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"patch processor class not found.", (Object[])new Object[0]);
        }
    }

    public static String getPatchPathExtra(Intent intent) {
        if (intent == null) {
            throw new TinkerRuntimeException("getPatchPathExtra, but intent is null");
        }
        return ShareIntentUtil.getStringExtra((Intent)intent, (String)PATCH_PATH_EXTRA);
    }

    public static boolean getPatchUseEmergencyMode(Intent intent) {
        if (intent == null) {
            throw new TinkerRuntimeException("getPatchUseEmergencyMode, but intent is null");
        }
        return ShareIntentUtil.getBooleanExtra((Intent)intent, (String)PATCH_USE_EMERGENCY_MODE, (boolean)false);
    }

    public static String getPatchResultExtra(Intent intent) {
        if (intent == null) {
            throw new TinkerRuntimeException("getPatchResultExtra, but intent is null");
        }
        return ShareIntentUtil.getStringExtra((Intent)intent, (String)RESULT_CLASS_EXTRA);
    }

    protected void onHandleIntent(Intent intent) {
        this.increasingPriority();
        TinkerPatchService.doApplyPatch((Context)this, intent);
    }

    public static void setTinkerNotificationId(int id) {
        notificationId = id;
    }

    public static boolean isRunning(Context context) {
        try {
            String serviceName = TinkerServiceInternals.getTinkerPatchServiceName(context);
            if (serviceName == null) {
                return false;
            }
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            if (am == null) {
                return false;
            }
            List runningProcInfos = am.getRunningAppProcesses();
            if (runningProcInfos == null || runningProcInfos.size() == 0) {
                return false;
            }
            int targetPid = 0;
            for (ActivityManager.RunningAppProcessInfo procInfo : runningProcInfos) {
                if (!procInfo.processName.equals(serviceName)) continue;
                targetPid = procInfo.pid;
                break;
            }
            if (targetPid == 0) {
                return false;
            }
            File tinkerBaseDir = SharePatchFileUtil.getPatchDirectory((Context)context);
            File runningMarkerFile = new File(tinkerBaseDir, RUNNING_MARKER_FILE_RELPATH_PREFIX + targetPid);
            return runningMarkerFile.exists();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    static void markRunning(Context context) {
        File tinkerBaseDir = SharePatchFileUtil.getPatchDirectory((Context)context);
        File runningMarkerFile = new File(tinkerBaseDir, RUNNING_MARKER_FILE_RELPATH_PREFIX + Process.myPid());
        if (runningMarkerFile.exists()) {
            return;
        }
        File runningMarkerDir = runningMarkerFile.getParentFile();
        if (runningMarkerDir.exists()) {
            File[] markerFiles = runningMarkerDir.listFiles();
            if (markerFiles != null) {
                for (File markerFile : markerFiles) {
                    markerFile.delete();
                }
            }
        } else {
            runningMarkerDir.mkdirs();
        }
        try {
            if (!runningMarkerFile.createNewFile()) {
                throw new IllegalStateException();
            }
        }
        catch (Throwable thr) {
            ShareTinkerLog.printErrStackTrace((String)TAG, (Throwable)thr, (String)"Fail to create running marker file.", (Object[])new Object[0]);
        }
    }

    static void unmarkRunning(Context context) {
        File tinkerBaseDir = SharePatchFileUtil.getPatchDirectory((Context)context);
        File runningMarkerFile = new File(tinkerBaseDir, RUNNING_MARKER_FILE_RELPATH_PREFIX + Process.myPid());
        if (runningMarkerFile.exists()) {
            runningMarkerFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doApplyPatch(Context context, Intent intent) {
        if (!sIsPatchApplying.compareAndSet(false, true)) {
            ShareTinkerLog.w((String)TAG, (String)"TinkerPatchService doApplyPatch is running by another runner.", (Object[])new Object[0]);
            return;
        }
        try {
            boolean result;
            TinkerPatchService.markRunning(context);
            Tinker tinker = Tinker.with(context);
            tinker.getPatchReporter().onPatchServiceStart(intent);
            if (intent == null) {
                ShareTinkerLog.e((String)TAG, (String)"TinkerPatchService received a null intent, ignoring.", (Object[])new Object[0]);
                return;
            }
            String path = TinkerPatchService.getPatchPathExtra(intent);
            if (path == null) {
                ShareTinkerLog.e((String)TAG, (String)"TinkerPatchService can't get the path extra, ignoring.", (Object[])new Object[0]);
                return;
            }
            File patchFile = new File(path);
            boolean useEmergencyMode = TinkerPatchService.getPatchUseEmergencyMode(intent);
            long begin = SystemClock.elapsedRealtime();
            Throwable e = null;
            PatchResult patchResult = new PatchResult();
            try {
                if (upgradePatchProcessor == null) {
                    throw new TinkerRuntimeException("upgradePatchProcessor is null.");
                }
                result = upgradePatchProcessor.tryPatch(context, path, useEmergencyMode, patchResult);
            }
            catch (Throwable throwable) {
                e = throwable;
                result = false;
                tinker.getPatchReporter().onPatchException(patchFile, e);
            }
            long cost = SystemClock.elapsedRealtime() - begin;
            tinker.getPatchReporter().onPatchResult(patchFile, result, cost);
            patchResult.isSuccess = result;
            patchResult.rawPatchFilePath = path;
            patchResult.useEmergencyMode = useEmergencyMode;
            patchResult.totalCostTime = cost;
            patchResult.type = tinker.getCustomPatcher() == null ? 0 : 1;
            patchResult.e = e;
            TinkerPatchService.unmarkRunning(context);
            sIsPatchApplying.set(false);
            AbstractResultService.runResultService(context, patchResult, TinkerPatchService.getPatchResultExtra(intent));
        }
        finally {
            TinkerPatchService.unmarkRunning(context);
        }
    }

    private void increasingPriority() {
        if (Build.VERSION.SDK_INT >= 26) {
            ShareTinkerLog.i((String)TAG, (String)"for system version >= Android O, we just ignore increasingPriority job to avoid crash or toasts.", (Object[])new Object[0]);
            return;
        }
        if ("ZUK".equals(Build.MANUFACTURER)) {
            ShareTinkerLog.i((String)TAG, (String)"for ZUK device, we just ignore increasingPriority job to avoid crash.", (Object[])new Object[0]);
            return;
        }
        ShareTinkerLog.i((String)TAG, (String)"try to increase patch process priority", (Object[])new Object[0]);
        try {
            Notification notification = new Notification();
            if (Build.VERSION.SDK_INT < 18) {
                this.startForeground(notificationId, notification);
            } else {
                this.startForeground(notificationId, notification);
                this.startService(new Intent((Context)this, InnerService.class));
            }
        }
        catch (Throwable e) {
            ShareTinkerLog.i((String)TAG, (String)("try to increase patch process priority error:" + e), (Object[])new Object[0]);
        }
    }

    public static class InnerService
    extends Service {
        public void onCreate() {
            super.onCreate();
            try {
                this.startForeground(notificationId, new Notification());
            }
            catch (Throwable e) {
                ShareTinkerLog.e((String)TinkerPatchService.TAG, (String)"InnerService set service for push exception:%s.", (Object[])new Object[]{e});
            }
            this.stopSelf();
        }

        public int onStartCommand(Intent intent, int flags, int startId) {
            super.onStartCommand(intent, flags, startId);
            return 2;
        }

        public void onDestroy() {
            this.stopForeground(true);
            super.onDestroy();
        }

        public IBinder onBind(Intent intent) {
            return null;
        }
    }
}

