/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.Build;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.patch.ArkHotDiffPatchInternal;
import com.tencent.tinker.lib.patch.DexDiffPatchInternal;
import com.tencent.tinker.lib.patch.ResDiffPatchInternal;
import com.tencent.tinker.lib.patch.SoDiffPatchInternal;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.UpgradePatchRetry;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class UpgradePatch
extends AbstractPatch {
    private static final String TAG = "Tinker.UpgradePatch";

    @Override
    public boolean tryPatch(Context context, String tempPatchPath, boolean useEmergencyMode, PatchResult patchResult) {
        SharePatchInfo newInfo;
        Tinker manager = Tinker.with(context);
        File patchFile = new File(tempPatchPath);
        if (!manager.isTinkerEnabled() || !ShareTinkerInternals.isTinkerEnableWithSharedPreferences((Context)context)) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:patch is disabled, just return", (Object[])new Object[0]);
            return false;
        }
        if (!SharePatchFileUtil.isLegalFile((File)patchFile)) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:patch file is not found, just return", (Object[])new Object[0]);
            return false;
        }
        ShareSecurityCheck signatureCheck = new ShareSecurityCheck(context);
        int returnCode = ShareTinkerInternals.checkTinkerPackage((Context)context, (int)manager.getTinkerFlags(), (File)patchFile, (ShareSecurityCheck)signatureCheck);
        if (returnCode != 0) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:onPatchPackageCheckFail", (Object[])new Object[0]);
            manager.getPatchReporter().onPatchPackageCheckFail(patchFile, returnCode);
            return false;
        }
        String patchMd5 = SharePatchFileUtil.getMD5((File)patchFile);
        if (patchMd5 == null) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:patch md5 is null, just return", (Object[])new Object[0]);
            return false;
        }
        patchResult.patchVersion = patchMd5;
        ShareTinkerLog.i((String)TAG, (String)"UpgradePatch tryPatch:patchMd5:%s", (Object[])new Object[]{patchMd5});
        String patchDirectory = manager.getPatchDirectory().getAbsolutePath();
        File patchInfoLockFile = SharePatchFileUtil.getPatchInfoLockFile((String)patchDirectory);
        File patchInfoFile = SharePatchFileUtil.getPatchInfoFile((String)patchDirectory);
        HashMap pkgProps = signatureCheck.getPackagePropertiesIfPresent();
        if (pkgProps == null) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch packageProperties is null, do we process a valid patch apk ?", (Object[])new Object[0]);
            return false;
        }
        String isProtectedAppStr = (String)pkgProps.get("is_protected_app");
        boolean isProtectedApp = isProtectedAppStr != null && !isProtectedAppStr.isEmpty() && !"0".equals(isProtectedAppStr);
        String useCustomPatchStr = (String)pkgProps.get("use_custom_file_patch");
        boolean useCustomPatch = useCustomPatchStr != null && !useCustomPatchStr.isEmpty() && !"0".equals(useCustomPatchStr);
        SharePatchInfo oldInfo = SharePatchInfo.readAndCheckPropertyWithLock((File)patchInfoFile, (File)patchInfoLockFile);
        if (oldInfo != null) {
            String finalOatDir;
            if (oldInfo.oldVersion == null || oldInfo.newVersion == null || oldInfo.oatDir == null) {
                ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:onPatchInfoCorrupted", (Object[])new Object[0]);
                manager.getPatchReporter().onPatchInfoCorrupted(patchFile, oldInfo.oldVersion, oldInfo.newVersion);
                return false;
            }
            if (!SharePatchFileUtil.checkIfMd5Valid((String)patchMd5)) {
                ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:onPatchVersionCheckFail md5 %s is valid", (Object[])new Object[]{patchMd5});
                manager.getPatchReporter().onPatchVersionCheckFail(patchFile, oldInfo, patchMd5);
                return false;
            }
            boolean usingInterpret = oldInfo.oatDir.equals("interpet");
            if (!usingInterpret && !ShareTinkerInternals.isNullOrNil((String)oldInfo.newVersion) && oldInfo.newVersion.equals(patchMd5) && !oldInfo.newVersion.equals(oldInfo.versionToRemove)) {
                ShareTinkerLog.e((String)TAG, (String)"patch already applied, md5: %s", (Object[])new Object[]{patchMd5});
                UpgradePatchRetry.getInstance(context).onPatchResetMaxCheck(patchMd5);
                return true;
            }
            String string = finalOatDir = usingInterpret ? "changing" : oldInfo.oatDir;
            if (!patchMd5.equals(oldInfo.newVersion) && !oldInfo.newVersion.equals(oldInfo.oldVersion)) {
                String lastNewVersion = oldInfo.newVersion;
                oldInfo.newVersion = oldInfo.oldVersion;
                SharePatchInfo.rewritePatchInfoFileWithLock((File)patchInfoFile, (SharePatchInfo)oldInfo, (File)patchInfoLockFile);
                String patchName = SharePatchFileUtil.getPatchVersionDirectory((String)lastNewVersion);
                SharePatchFileUtil.deleteDir((File)new File(patchDirectory, patchName));
            }
            String versionToRemove = patchMd5.equals(oldInfo.versionToRemove) ? "" : oldInfo.versionToRemove;
            newInfo = new SharePatchInfo(oldInfo.oldVersion, patchMd5, isProtectedApp, useCustomPatch, versionToRemove, Build.FINGERPRINT, finalOatDir, false);
        } else {
            newInfo = new SharePatchInfo("", patchMd5, isProtectedApp, useCustomPatch, "", Build.FINGERPRINT, "odex", false);
        }
        String patchName = SharePatchFileUtil.getPatchVersionDirectory((String)patchMd5);
        String patchVersionDirectory = patchDirectory + "/" + patchName;
        ShareTinkerLog.i((String)TAG, (String)"UpgradePatch tryPatch:patchVersionDirectory:%s", (Object[])new Object[]{patchVersionDirectory});
        File destPatchFile = new File(patchVersionDirectory + "/" + SharePatchFileUtil.getPatchVersionFile((String)patchMd5));
        try {
            if (!patchMd5.equals(SharePatchFileUtil.getMD5((File)destPatchFile))) {
                SharePatchFileUtil.copyFileUsingStream((File)patchFile, (File)destPatchFile);
                ShareTinkerLog.w((String)TAG, (String)"UpgradePatch copy patch file, src file: %s size: %d, dest file: %s size:%d", (Object[])new Object[]{patchFile.getAbsolutePath(), patchFile.length(), destPatchFile.getAbsolutePath(), destPatchFile.length()});
            }
        }
        catch (IOException e) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:copy patch file fail from %s to %s", (Object[])new Object[]{patchFile.getPath(), destPatchFile.getPath()});
            manager.getPatchReporter().onPatchTypeExtractFail(patchFile, destPatchFile, patchFile.getName(), 1);
            return false;
        }
        if (!DexDiffPatchInternal.tryRecoverDexFiles(manager, signatureCheck, context, patchVersionDirectory, destPatchFile, useEmergencyMode, patchResult)) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:new patch recover, try patch dex failed", (Object[])new Object[0]);
            return false;
        }
        if (!ArkHotDiffPatchInternal.tryRecoverArkHotLibrary(manager, signatureCheck, context, patchVersionDirectory, destPatchFile)) {
            return false;
        }
        if (!SoDiffPatchInternal.tryRecoverLibraryFiles(manager, signatureCheck, context, patchVersionDirectory, destPatchFile, useCustomPatch, patchResult)) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:new patch recover, try patch library failed", (Object[])new Object[0]);
            return false;
        }
        if (!ResDiffPatchInternal.tryRecoverResourceFiles(manager, signatureCheck, context, patchVersionDirectory, destPatchFile, useCustomPatch, patchResult)) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:new patch recover, try patch resource failed", (Object[])new Object[0]);
            return false;
        }
        if (!DexDiffPatchInternal.waitAndCheckDexOptFile(patchFile, manager)) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:new patch recover, check dex opt file failed", (Object[])new Object[0]);
            return false;
        }
        if (!SharePatchInfo.rewritePatchInfoFileWithLock((File)patchInfoFile, (SharePatchInfo)newInfo, (File)patchInfoLockFile)) {
            ShareTinkerLog.e((String)TAG, (String)"UpgradePatch tryPatch:new patch recover, rewrite patch info failed", (Object[])new Object[0]);
            manager.getPatchReporter().onPatchInfoCorrupted(patchFile, newInfo.oldVersion, newInfo.newVersion);
            return false;
        }
        UpgradePatchRetry.getInstance(context).onPatchResetMaxCheck(patchMd5);
        ShareTinkerLog.w((String)TAG, (String)"UpgradePatch tryPatch: done, it is ok", (Object[])new Object[0]);
        return true;
    }
}

