/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.tinker;

import android.content.Context;
import android.content.Intent;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.app.ApplicationLike;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class TinkerApplicationHelper {
    private static final String TAG = "Tinker.TinkerApplicationHelper";

    public static boolean isTinkerEnableAll(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        int tinkerFlags = applicationLike.getTinkerFlags();
        return ShareTinkerInternals.isTinkerEnabledAll((int)tinkerFlags);
    }

    public static boolean isTinkerEnableForDex(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        int tinkerFlags = applicationLike.getTinkerFlags();
        return ShareTinkerInternals.isTinkerEnabledForDex((int)tinkerFlags);
    }

    public static boolean isTinkerEnableForNativeLib(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        int tinkerFlags = applicationLike.getTinkerFlags();
        return ShareTinkerInternals.isTinkerEnabledForNativeLib((int)tinkerFlags);
    }

    public static boolean isTinkerEnableForResource(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        int tinkerFlags = applicationLike.getTinkerFlags();
        return ShareTinkerInternals.isTinkerEnabledForResource((int)tinkerFlags);
    }

    public static File getTinkerPatchDirectory(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        return SharePatchFileUtil.getPatchDirectory((Context)applicationLike.getApplication());
    }

    public static boolean isTinkerLoadSuccess(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        Intent tinkerResultIntent = applicationLike.getTinkerResultIntent();
        if (tinkerResultIntent == null) {
            return false;
        }
        int loadCode = ShareIntentUtil.getIntentReturnCode((Intent)tinkerResultIntent);
        return loadCode == 0;
    }

    public static HashMap<String, String> getLoadDexesAndMd5(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        Intent tinkerResultIntent = applicationLike.getTinkerResultIntent();
        if (tinkerResultIntent == null) {
            return null;
        }
        int loadCode = ShareIntentUtil.getIntentReturnCode((Intent)tinkerResultIntent);
        if (loadCode == 0) {
            return ShareIntentUtil.getIntentPatchDexPaths((Intent)tinkerResultIntent);
        }
        return null;
    }

    public static HashMap<String, String> getLoadLibraryAndMd5(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        Intent tinkerResultIntent = applicationLike.getTinkerResultIntent();
        if (tinkerResultIntent == null) {
            return null;
        }
        int loadCode = ShareIntentUtil.getIntentReturnCode((Intent)tinkerResultIntent);
        if (loadCode == 0) {
            return ShareIntentUtil.getIntentPatchLibsPaths((Intent)tinkerResultIntent);
        }
        return null;
    }

    public static HashMap<String, String> getPackageConfigs(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        Intent tinkerResultIntent = applicationLike.getTinkerResultIntent();
        if (tinkerResultIntent == null) {
            return null;
        }
        int loadCode = ShareIntentUtil.getIntentReturnCode((Intent)tinkerResultIntent);
        if (loadCode == 0) {
            return ShareIntentUtil.getIntentPackageConfig((Intent)tinkerResultIntent);
        }
        return null;
    }

    public static String getCurrentVersion(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        Intent tinkerResultIntent = applicationLike.getTinkerResultIntent();
        if (tinkerResultIntent == null) {
            return null;
        }
        String oldVersion = ShareIntentUtil.getStringExtra((Intent)tinkerResultIntent, (String)"intent_patch_old_version");
        String newVersion = ShareIntentUtil.getStringExtra((Intent)tinkerResultIntent, (String)"intent_patch_new_version");
        boolean isMainProcess = ShareTinkerInternals.isInMainProcess((Context)applicationLike.getApplication());
        if (oldVersion != null && newVersion != null) {
            if (isMainProcess) {
                return newVersion;
            }
            return oldVersion;
        }
        return null;
    }

    public static void cleanPatch(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        if (TinkerApplicationHelper.isTinkerLoadSuccess(applicationLike)) {
            TinkerLog.e(TAG, "it is not safety to clean patch when tinker is loaded, you should kill all your process after clean!", new Object[0]);
        }
        SharePatchFileUtil.deleteDir((File)SharePatchFileUtil.getPatchDirectory((Context)applicationLike.getApplication()));
    }

    public static void loadArmV7aLibrary(ApplicationLike applicationLike, String libName) {
        if (libName == null || libName.isEmpty() || applicationLike == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        if (TinkerApplicationHelper.isTinkerEnableForNativeLib(applicationLike) && TinkerApplicationHelper.loadLibraryFromTinker(applicationLike, "lib/armeabi-v7a", libName)) {
            return;
        }
        System.loadLibrary(libName);
    }

    public static void loadArmLibrary(ApplicationLike applicationLike, String libName) {
        if (libName == null || libName.isEmpty() || applicationLike == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        if (TinkerApplicationHelper.isTinkerEnableForNativeLib(applicationLike) && TinkerApplicationHelper.loadLibraryFromTinker(applicationLike, "lib/armeabi", libName)) {
            return;
        }
        System.loadLibrary(libName);
    }

    public static boolean loadLibraryFromTinker(ApplicationLike applicationLike, String relativePath, String libname) throws UnsatisfiedLinkError {
        libname = libname.startsWith("lib") ? libname : "lib" + libname;
        libname = libname.endsWith(".so") ? libname : libname + ".so";
        String relativeLibPath = relativePath + "/" + libname;
        if (!TinkerApplicationHelper.isTinkerEnableForNativeLib(applicationLike)) {
            return false;
        }
        if (!TinkerApplicationHelper.isTinkerEnableForNativeLib(applicationLike)) {
            return false;
        }
        HashMap<String, String> loadLibraries = TinkerApplicationHelper.getLoadLibraryAndMd5(applicationLike);
        if (loadLibraries == null) {
            return false;
        }
        String currentVersion = TinkerApplicationHelper.getCurrentVersion(applicationLike);
        if (ShareTinkerInternals.isNullOrNil((String)currentVersion)) {
            return false;
        }
        File patchDirectory = SharePatchFileUtil.getPatchDirectory((Context)applicationLike.getApplication());
        if (patchDirectory == null) {
            return false;
        }
        File patchVersionDirectory = new File(patchDirectory.getAbsolutePath() + "/" + SharePatchFileUtil.getPatchVersionDirectory((String)currentVersion));
        String libPrePath = patchVersionDirectory.getAbsolutePath() + "/" + "lib";
        for (Map.Entry<String, String> libEntry : loadLibraries.entrySet()) {
            String patchLibraryPath;
            File library;
            String name = libEntry.getKey();
            if (!name.equals(relativeLibPath) || !(library = new File(patchLibraryPath = libPrePath + "/" + name)).exists()) continue;
            boolean verifyMd5 = applicationLike.getTinkerLoadVerifyFlag();
            if (verifyMd5 && !SharePatchFileUtil.verifyFileMd5((File)library, (String)loadLibraries.get(name))) {
                TinkerLog.i(TAG, "loadLibraryFromTinker md5mismatch fail:" + patchLibraryPath, new Object[0]);
                continue;
            }
            System.load(patchLibraryPath);
            TinkerLog.i(TAG, "loadLibraryFromTinker success:" + patchLibraryPath, new Object[0]);
            return true;
        }
        return false;
    }
}

