/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.reporter;

import android.content.Context;
import com.tencent.tinker.lib.reporter.LoadReporter;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerInstaller;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.UpgradePatchRetry;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;

public class DefaultLoadReporter
implements LoadReporter {
    private static final String TAG = "Tinker.DefaultLoadReporter";
    protected final Context context;

    public DefaultLoadReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onLoadPatchListenerReceiveFail(File patchFile, int errorCode) {
        TinkerLog.i(TAG, "patch loadReporter onLoadPatchListenerReceiveFail: patch receive fail: %s, code: %d", patchFile.getAbsolutePath(), errorCode);
    }

    @Override
    public void onLoadPatchVersionChanged(String oldVersion, String newVersion, File patchDirectoryFile, String currentPatchName) {
        TinkerLog.i(TAG, "patch loadReporter onLoadPatchVersionChanged: patch version change from " + oldVersion + " to " + newVersion, new Object[0]);
        if (oldVersion == null || newVersion == null) {
            return;
        }
        if (oldVersion.equals(newVersion)) {
            return;
        }
        if (!Tinker.with(this.context).isMainProcess()) {
            return;
        }
        UpgradePatchRetry.getInstance(this.context).onPatchResetMaxCheck(newVersion);
        File[] files = patchDirectoryFile.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!file.isDirectory() || name.equals(currentPatchName)) continue;
                SharePatchFileUtil.deleteDir((File)file);
            }
        }
    }

    @Override
    public void onLoadInterpret(int type, Throwable e) {
        TinkerLog.i(TAG, "patch loadReporter onLoadInterpret: type: %d, throwable: %s", type, e);
        switch (type) {
            case 1: {
                TinkerLog.e(TAG, "patch loadReporter onLoadInterpret fail, can get instruction set from existed oat file", new Object[0]);
                break;
            }
            case 2: {
                TinkerLog.e(TAG, "patch loadReporter onLoadInterpret fail, command line to interpret return error", new Object[0]);
                break;
            }
            case 0: {
                TinkerLog.i(TAG, "patch loadReporter onLoadInterpret ok", new Object[0]);
            }
        }
        this.retryPatch();
    }

    @Override
    public void onLoadFileNotFound(File file, int fileType, boolean isDirectory) {
        TinkerLog.i(TAG, "patch loadReporter onLoadFileNotFound: patch file not found: %s, fileType: %d, isDirectory: %b", file.getAbsolutePath(), fileType, isDirectory);
        if (fileType == 4) {
            this.retryPatch();
        } else {
            this.checkAndCleanPatch();
        }
    }

    @Override
    public void onLoadFileMd5Mismatch(File file, int fileType) {
        TinkerLog.i(TAG, "patch load Reporter onLoadFileMd5Mismatch: patch file md5 mismatch file: %s, fileType: %d", file.getAbsolutePath(), fileType);
        this.checkAndCleanPatch();
    }

    @Override
    public void onLoadPatchInfoCorrupted(String oldVersion, String newVersion, File patchInfoFile) {
        TinkerLog.i(TAG, "patch loadReporter onLoadPatchInfoCorrupted: patch info file damage: %s, from version: %s to version: %s", patchInfoFile.getAbsolutePath(), oldVersion, newVersion);
        this.checkAndCleanPatch();
    }

    @Override
    public void onLoadResult(File patchDirectory, int loadCode, long cost) {
        TinkerLog.i(TAG, "patch loadReporter onLoadResult: patch load result, path:%s, code: %d, cost: %dms", patchDirectory.getAbsolutePath(), loadCode, cost);
    }

    @Override
    public void onLoadException(Throwable e, int errorCode) {
        switch (errorCode) {
            case -2: {
                if (e.getMessage().contains("checkDexInstall failed")) {
                    TinkerLog.e(TAG, "patch loadReporter onLoadException: tinker dex check fail:" + e.getMessage(), new Object[0]);
                } else {
                    TinkerLog.i(TAG, "patch loadReporter onLoadException: patch load dex exception: %s", e);
                }
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences((Context)this.context);
                TinkerLog.i(TAG, "dex exception disable tinker forever with sp", new Object[0]);
                break;
            }
            case -3: {
                if (e.getMessage().contains("checkResInstall failed")) {
                    TinkerLog.e(TAG, "patch loadReporter onLoadException: tinker res check fail:" + e.getMessage(), new Object[0]);
                } else {
                    TinkerLog.i(TAG, "patch loadReporter onLoadException: patch load resource exception: %s", e);
                }
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences((Context)this.context);
                TinkerLog.i(TAG, "res exception disable tinker forever with sp", new Object[0]);
                break;
            }
            case -4: {
                TinkerLog.i(TAG, "patch loadReporter onLoadException: patch load unCatch exception: %s", e);
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences((Context)this.context);
                TinkerLog.i(TAG, "unCaught exception disable tinker forever with sp", new Object[0]);
                String uncaughtString = SharePatchFileUtil.checkTinkerLastUncaughtCrash((Context)this.context);
                if (ShareTinkerInternals.isNullOrNil((String)uncaughtString)) break;
                File laseCrashFile = SharePatchFileUtil.getPatchLastCrashFile((Context)this.context);
                SharePatchFileUtil.safeDeleteFile((File)laseCrashFile);
                TinkerLog.e(TAG, "tinker uncaught real exception:" + uncaughtString, new Object[0]);
                break;
            }
            case -1: {
                TinkerLog.i(TAG, "patch loadReporter onLoadException: patch load unknown exception: %s", e);
            }
        }
        TinkerLog.e(TAG, "tinker load exception, welcome to submit issue to us: https://github.com/Tencent/tinker/issues", new Object[0]);
        TinkerLog.printErrStackTrace(TAG, e, "tinker load exception", new Object[0]);
        Tinker.with(this.context).setTinkerDisable();
        this.checkAndCleanPatch();
    }

    @Override
    public void onLoadPackageCheckFail(File patchFile, int errorCode) {
        TinkerLog.i(TAG, "patch loadReporter onLoadPackageCheckFail: load patch package check fail file path: %s, errorCode: %d", patchFile.getAbsolutePath(), errorCode);
        this.checkAndCleanPatch();
    }

    public void checkAndCleanPatch() {
        Tinker tinker = Tinker.with(this.context);
        if (tinker.isMainProcess()) {
            SharePatchInfo sharePatchInfo;
            TinkerLoadResult tinkerLoadResult = tinker.getTinkerLoadResultIfPresent();
            if (tinkerLoadResult.versionChanged && (sharePatchInfo = tinkerLoadResult.patchInfo) != null && !ShareTinkerInternals.isNullOrNil((String)sharePatchInfo.oldVersion)) {
                TinkerLog.w(TAG, "checkAndCleanPatch, oldVersion %s is not null, try kill all other process", sharePatchInfo.oldVersion);
                ShareTinkerInternals.killAllOtherProcess((Context)this.context);
            }
        }
        tinker.cleanPatch();
    }

    public boolean retryPatch() {
        Tinker tinker = Tinker.with(this.context);
        if (!tinker.isMainProcess()) {
            return false;
        }
        File patchVersionFile = tinker.getTinkerLoadResultIfPresent().patchVersionFile;
        if (patchVersionFile != null && UpgradePatchRetry.getInstance(this.context).onPatchListenerCheck(SharePatchFileUtil.getMD5((File)patchVersionFile))) {
            TinkerLog.i(TAG, "try to repair oat file on patch process", new Object[0]);
            TinkerInstaller.onReceiveUpgradePatch(this.context, patchVersionFile.getAbsolutePath());
            return true;
        }
        return false;
    }
}

