/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.app;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import com.tencent.tinker.loader.TinkerLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerUncaughtHandler;
import com.tencent.tinker.loader.app.ITinkerInlineFenceBridge;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class TinkerApplication
extends Application {
    private static final String INTENT_PATCH_EXCEPTION = "intent_patch_exception";
    private static final String TINKER_LOADER_METHOD = "tryLoad";
    private final int tinkerFlags;
    private final boolean tinkerLoadVerifyFlag;
    private final String delegateClassName;
    private final String loaderClassName;
    private boolean useSafeMode;
    private Intent tinkerResultIntent;
    private ITinkerInlineFenceBridge mBridge = null;

    protected TinkerApplication(int tinkerFlags) {
        this(tinkerFlags, "com.tencent.tinker.entry.DefaultApplicationLike", TinkerLoader.class.getName(), false);
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName, String loaderClassName, boolean tinkerLoadVerifyFlag) {
        this.tinkerFlags = tinkerFlags;
        this.delegateClassName = delegateClassName;
        this.loaderClassName = loaderClassName;
        this.tinkerLoadVerifyFlag = tinkerLoadVerifyFlag;
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName) {
        this(tinkerFlags, delegateClassName, TinkerLoader.class.getName(), false);
    }

    private void loadTinker() {
        try {
            Class<?> tinkerLoadClass = Class.forName(this.loaderClassName, false, TinkerApplication.class.getClassLoader());
            Method loadMethod = tinkerLoadClass.getMethod(TINKER_LOADER_METHOD, TinkerApplication.class);
            Constructor<?> constructor = tinkerLoadClass.getConstructor(new Class[0]);
            this.tinkerResultIntent = (Intent)loadMethod.invoke(constructor.newInstance(new Object[0]), new Object[]{this});
        }
        catch (Throwable e) {
            this.tinkerResultIntent = new Intent();
            ShareIntentUtil.setIntentReturnCode(this.tinkerResultIntent, -20);
            this.tinkerResultIntent.putExtra(INTENT_PATCH_EXCEPTION, (Serializable)e);
        }
    }

    private ITinkerInlineFenceBridge createInlineFence(int tinkerFlags, String delegateClassName, boolean tinkerLoadVerifyFlag, long applicationStartElapsedTime, long applicationStartMillisTime, Intent resultIntent) {
        try {
            Class<?> inlineFenceClazz = Class.forName("com.tencent.tinker.entry.TinkerApplicationInlineFence", true, super.getClassLoader());
            Constructor<?> ctor = inlineFenceClazz.getConstructor(Integer.TYPE, String.class, Boolean.TYPE, Long.TYPE, Long.TYPE, Intent.class);
            ctor.setAccessible(true);
            return (ITinkerInlineFenceBridge)ctor.newInstance(tinkerFlags, delegateClassName, tinkerLoadVerifyFlag, applicationStartElapsedTime, applicationStartMillisTime, resultIntent);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("fail to create inline fence instance.", thr);
        }
    }

    private void onBaseContextAttached(Context base) {
        try {
            long applicationStartElapsedTime = SystemClock.elapsedRealtime();
            long applicationStartMillisTime = System.currentTimeMillis();
            this.loadTinker();
            this.mBridge = this.createInlineFence(this.tinkerFlags, this.delegateClassName, this.tinkerLoadVerifyFlag, applicationStartElapsedTime, applicationStartMillisTime, this.tinkerResultIntent);
            this.mBridge.attachBaseContext(this, base);
            if (this.useSafeMode) {
                ShareTinkerInternals.setSafeModeCount((Context)this, 0);
            }
        }
        catch (TinkerRuntimeException e) {
            throw e;
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException(thr.getMessage(), thr);
        }
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        Thread.setDefaultUncaughtExceptionHandler(new TinkerUncaughtHandler((Context)this));
        this.onBaseContextAttached(base);
    }

    public void onCreate() {
        super.onCreate();
        if (this.mBridge != null) {
            this.mBridge.onCreate(this);
        }
    }

    public void onTerminate() {
        super.onTerminate();
        if (this.mBridge != null) {
            this.mBridge.onTerminate();
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.mBridge != null) {
            this.mBridge.onLowMemory();
        }
    }

    @TargetApi(value=14)
    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (this.mBridge != null) {
            this.mBridge.onTrimMemory(level);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mBridge != null) {
            this.mBridge.onConfigurationChanged(newConfig);
        }
    }

    public Resources getResources() {
        Resources resources = super.getResources();
        return this.mBridge != null ? this.mBridge.getResources(resources) : resources;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = super.getClassLoader();
        return this.mBridge != null ? this.mBridge.getClassLoader(classLoader) : classLoader;
    }

    public AssetManager getAssets() {
        AssetManager assetManager = super.getAssets();
        return this.mBridge != null ? this.mBridge.getAssets(assetManager) : assetManager;
    }

    public Object getSystemService(String name) {
        Object service = super.getSystemService(name);
        return this.mBridge != null ? this.mBridge.getSystemService(name, service) : service;
    }

    public Context getBaseContext() {
        Context base = super.getBaseContext();
        return this.mBridge != null ? this.mBridge.getBaseContext(base) : base;
    }

    public void setUseSafeMode(boolean useSafeMode) {
        this.useSafeMode = useSafeMode;
    }

    public boolean isTinkerLoadVerifyFlag() {
        return this.tinkerLoadVerifyFlag;
    }

    public int getTinkerFlags() {
        return this.tinkerFlags;
    }
}

