/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.algorithms.patch;

import com.tencent.tinker.android.dex.CallSiteId;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.commons.dexpatcher.algorithms.patch.DexSectionPatchAlgorithm;
import com.tencent.tinker.commons.dexpatcher.struct.DexPatchFile;
import com.tencent.tinker.commons.dexpatcher.util.AbstractIndexMap;
import com.tencent.tinker.commons.dexpatcher.util.SparseIndexMap;

public class CallSiteIdSectionPatchAlgorithm
extends DexSectionPatchAlgorithm<CallSiteId> {
    private TableOfContents.Section patchedCallSiteIdTocSec = null;
    private Dex.Section patchedCallSiteIdSec = null;

    public CallSiteIdSectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, Dex patchedDex, SparseIndexMap oldToPatchedIndexMap) {
        super(patchFile, oldDex, oldToPatchedIndexMap);
        this.patchedCallSiteIdTocSec = patchedDex.getTableOfContents().callSiteIds;
        this.patchedCallSiteIdSec = patchedDex.openSection(this.patchedCallSiteIdTocSec);
    }

    @Override
    protected TableOfContents.Section getTocSection(Dex dex) {
        return dex.getTableOfContents().callSiteIds;
    }

    @Override
    protected CallSiteId nextItem(DexDataBuffer section) {
        return section.readCallSiteId();
    }

    @Override
    protected int getItemSize(CallSiteId item) {
        return item.byteCountInDex();
    }

    @Override
    protected CallSiteId adjustItem(AbstractIndexMap indexMap, CallSiteId item) {
        return indexMap.adjust(item);
    }

    @Override
    protected int writePatchedItem(CallSiteId patchedItem) {
        ++this.patchedCallSiteIdTocSec.size;
        return this.patchedCallSiteIdSec.writeCallSiteId(patchedItem);
    }

    @Override
    protected void updateIndexOrOffset(SparseIndexMap sparseIndexMap, int oldIndex, int oldOffset, int newIndex, int newOffset) {
        if (oldIndex != newIndex) {
            sparseIndexMap.mapCallsiteIds(oldIndex, newIndex);
        }
    }

    @Override
    protected void markDeletedIndexOrOffset(SparseIndexMap sparseIndexMap, int deletedIndex, int deletedOffset) {
        sparseIndexMap.markCallsiteDeleted(deletedIndex);
    }
}

