/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.algorithms.patch;

import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.android.utils.SparseIntArray;
import com.tencent.tinker.commons.dexpatcher.algorithms.patch.DexSectionPatchAlgorithm;
import com.tencent.tinker.commons.dexpatcher.struct.DexPatchFile;
import com.tencent.tinker.commons.dexpatcher.util.AbstractIndexMap;
import com.tencent.tinker.commons.dexpatcher.util.SparseIndexMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ClassDefSectionPatchAlgorithm
extends DexSectionPatchAlgorithm<ClassDef> {
    private Dex patchedDex = null;
    private TableOfContents.Section patchedClassDefTocSec = null;
    private Dex.Section patchedClassDefSec = null;
    private List<ClassDef> patchedClassDefs = null;

    public ClassDefSectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, Dex patchedDex, SparseIndexMap oldToPatchedIndexMap) {
        super(patchFile, oldDex, oldToPatchedIndexMap);
        if (patchedDex != null) {
            this.patchedDex = patchedDex;
            this.patchedClassDefTocSec = patchedDex.getTableOfContents().classDefs;
            this.patchedClassDefSec = patchedDex.openSection(this.patchedClassDefTocSec);
            this.patchedClassDefs = new ArrayList<ClassDef>(512);
        }
    }

    @Override
    protected TableOfContents.Section getTocSection(Dex dex) {
        return dex.getTableOfContents().classDefs;
    }

    @Override
    protected ClassDef nextItem(DexDataBuffer section) {
        return section.readClassDef();
    }

    @Override
    protected int getItemSize(ClassDef item) {
        return item.byteCountInDex();
    }

    @Override
    protected ClassDef adjustItem(AbstractIndexMap indexMap, ClassDef item) {
        return indexMap.adjust(item);
    }

    @Override
    protected int writePatchedItem(ClassDef patchedItem) {
        ++this.patchedClassDefTocSec.size;
        this.patchedClassDefs.add(patchedItem);
        return 0;
    }

    @Override
    protected void onPatchAlgorithmEnd() {
        this.patchedClassDefs = this.topologicalSort(this.patchedClassDefs);
        for (ClassDef patchedItem : this.patchedClassDefs) {
            this.patchedClassDefSec.writeClassDef(patchedItem);
        }
    }

    private List<ClassDef> topologicalSort(List<ClassDef> elements) {
        HashMap<Integer, ClassDef> typeIdToClassDefMap = new HashMap<Integer, ClassDef>(elements.size() + 8);
        HashMap typeGraph = new HashMap(elements.size() + 8);
        SparseIntArray inDegrees = new SparseIntArray(elements.size() + 8);
        for (ClassDef elem : elements) {
            typeIdToClassDefMap.put(elem.typeIndex, elem);
            typeGraph.put(elem.typeIndex, new ArrayList(8));
            inDegrees.put(elem.typeIndex, 0);
        }
        for (ClassDef elem : elements) {
            if (typeIdToClassDefMap.containsKey(elem.supertypeIndex)) {
                ((List)typeGraph.get(elem.supertypeIndex)).add(elem.typeIndex);
                inDegrees.put(elem.typeIndex, inDegrees.get(elem.typeIndex) + 1);
            }
            for (short implTypeId : this.patchedDex.interfaceTypeIndicesFromClassDef(elem)) {
                if (!typeIdToClassDefMap.containsKey(implTypeId)) continue;
                ((List)typeGraph.get(implTypeId)).add(elem.typeIndex);
                inDegrees.put(elem.typeIndex, inDegrees.get(elem.typeIndex) + 1);
            }
        }
        ArrayDeque<Integer> typeIdWithZeroInDegrees = new ArrayDeque<Integer>(64);
        for (int i = 0; i < inDegrees.size(); ++i) {
            int typeId = inDegrees.keyAt(i);
            int inDegree = inDegrees.valueAt(i);
            if (inDegree != 0) continue;
            typeIdWithZeroInDegrees.offer(typeId);
        }
        ArrayList<ClassDef> result = new ArrayList<ClassDef>();
        while (!typeIdWithZeroInDegrees.isEmpty()) {
            int currentTypeId = (Integer)typeIdWithZeroInDegrees.poll();
            result.add((ClassDef)typeIdToClassDefMap.get(currentTypeId));
            Iterator iterator = ((List)typeGraph.get(currentTypeId)).iterator();
            while (iterator.hasNext()) {
                int nextTypeId = (Integer)iterator.next();
                int newInDegree = inDegrees.get(nextTypeId) - 1;
                inDegrees.put(nextTypeId, newInDegree);
                if (newInDegree != 0) continue;
                typeIdWithZeroInDegrees.offer(nextTypeId);
            }
        }
        if (result.size() != elements.size()) {
            throw new IllegalStateException("Illegal dex format, there's at least one loop in class inheritance graph.");
        }
        return result;
    }
}

