/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.algorithms.patch;

import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.MethodHandle;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.commons.dexpatcher.algorithms.patch.DexSectionPatchAlgorithm;
import com.tencent.tinker.commons.dexpatcher.struct.DexPatchFile;
import com.tencent.tinker.commons.dexpatcher.util.AbstractIndexMap;
import com.tencent.tinker.commons.dexpatcher.util.SparseIndexMap;

public class MethodHandleSectionPatchAlgorithm
extends DexSectionPatchAlgorithm<MethodHandle> {
    private TableOfContents.Section patchedMethodHandleTocSec = null;
    private Dex.Section patchedMethodHandleSec = null;

    public MethodHandleSectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, Dex patchedDex, SparseIndexMap oldToPatchedIndexMap) {
        super(patchFile, oldDex, oldToPatchedIndexMap);
        this.patchedMethodHandleTocSec = patchedDex.getTableOfContents().methodHandles;
        this.patchedMethodHandleSec = patchedDex.openSection(this.patchedMethodHandleTocSec);
    }

    @Override
    protected TableOfContents.Section getTocSection(Dex dex) {
        return dex.getTableOfContents().methodHandles;
    }

    @Override
    protected MethodHandle nextItem(DexDataBuffer section) {
        return section.readMethodHandle();
    }

    @Override
    protected int getItemSize(MethodHandle item) {
        return item.byteCountInDex();
    }

    @Override
    protected MethodHandle adjustItem(AbstractIndexMap indexMap, MethodHandle item) {
        return indexMap.adjust(item);
    }

    @Override
    protected int writePatchedItem(MethodHandle patchedItem) {
        ++this.patchedMethodHandleTocSec.size;
        return this.patchedMethodHandleSec.writeMethodHandle(patchedItem);
    }

    @Override
    protected void updateIndexOrOffset(SparseIndexMap sparseIndexMap, int oldIndex, int oldOffset, int newIndex, int newOffset) {
        if (oldIndex != newIndex) {
            sparseIndexMap.mapMethodHandleIds(oldIndex, newIndex);
        }
    }

    @Override
    protected void markDeletedIndexOrOffset(SparseIndexMap sparseIndexMap, int deletedIndex, int deletedOffset) {
        sparseIndexMap.markMethodHandleDeleted(deletedIndex);
    }
}

