/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.util;

import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dx.instruction.InstructionPromoter;
import com.tencent.tinker.android.dx.instruction.InstructionReader;
import com.tencent.tinker.android.dx.instruction.InstructionVisitor;
import com.tencent.tinker.android.dx.instruction.InstructionWriter;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeInput;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeOutput;
import com.tencent.tinker.commons.dexpatcher.util.AbstractIndexMap;
import java.io.EOFException;

public final class InstructionTransformer {
    private final AbstractIndexMap indexMap;

    public InstructionTransformer(AbstractIndexMap indexMap) {
        this.indexMap = indexMap;
    }

    public short[] transform(short[] encodedInstructions) throws DexException {
        ShortArrayCodeOutput out = new ShortArrayCodeOutput(encodedInstructions.length);
        InstructionPromoter ipmo = new InstructionPromoter();
        InstructionWriter iw = new InstructionWriter(out, ipmo);
        InstructionReader ir = new InstructionReader(new ShortArrayCodeInput(encodedInstructions));
        try {
            ir.accept((InstructionVisitor)new InstructionTransformVisitor((InstructionVisitor)ipmo));
            ir.accept((InstructionVisitor)new InstructionTransformVisitor((InstructionVisitor)iw));
        }
        catch (EOFException e) {
            throw new DexException((Throwable)e);
        }
        return out.getArray();
    }

    private final class InstructionTransformVisitor
    extends InstructionVisitor {
        InstructionTransformVisitor(InstructionVisitor iv) {
            super(iv);
        }

        public void visitZeroRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal) {
            int mappedIndex = this.transformIndexIfNeeded(index, indexType);
            super.visitZeroRegisterInsn(currentAddress, opcode, mappedIndex, indexType, target, literal);
        }

        public void visitOneRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a) {
            int mappedIndex = this.transformIndexIfNeeded(index, indexType);
            super.visitOneRegisterInsn(currentAddress, opcode, mappedIndex, indexType, target, literal, a);
        }

        public void visitTwoRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b) {
            int mappedIndex = this.transformIndexIfNeeded(index, indexType);
            super.visitTwoRegisterInsn(currentAddress, opcode, mappedIndex, indexType, target, literal, a, b);
        }

        public void visitThreeRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c) {
            int mappedIndex = this.transformIndexIfNeeded(index, indexType);
            super.visitThreeRegisterInsn(currentAddress, opcode, mappedIndex, indexType, target, literal, a, b, c);
        }

        public void visitFourRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d) {
            int mappedIndex = this.transformIndexIfNeeded(index, indexType);
            super.visitFourRegisterInsn(currentAddress, opcode, mappedIndex, indexType, target, literal, a, b, c, d);
        }

        public void visitFiveRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d, int e) {
            int mappedIndex = this.transformIndexIfNeeded(index, indexType);
            super.visitFiveRegisterInsn(currentAddress, opcode, mappedIndex, indexType, target, literal, a, b, c, d, e);
        }

        public void visitRegisterRangeInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int registerCount) {
            int mappedIndex = this.transformIndexIfNeeded(index, indexType);
            super.visitRegisterRangeInsn(currentAddress, opcode, mappedIndex, indexType, target, literal, a, registerCount);
        }

        public void visitInvokePolymorphicInstruction(int currentAddress, int opcode, int methodIndex, int indexType, int protoIndex, int[] registers) {
            methodIndex = InstructionTransformer.this.indexMap.adjustMethodIdIndex(methodIndex);
            protoIndex = InstructionTransformer.this.indexMap.adjustProtoIdIndex(protoIndex);
            super.visitInvokePolymorphicInstruction(currentAddress, opcode, methodIndex, indexType, protoIndex, registers);
        }

        public void visitInvokePolymorphicRangeInstruction(int currentAddress, int opcode, int methodIndex, int indexType, int c, int registerCount, int protoIndex) {
            methodIndex = InstructionTransformer.this.indexMap.adjustMethodIdIndex(methodIndex);
            protoIndex = InstructionTransformer.this.indexMap.adjustProtoIdIndex(protoIndex);
            super.visitInvokePolymorphicRangeInstruction(currentAddress, opcode, methodIndex, indexType, c, registerCount, protoIndex);
        }

        private int transformIndexIfNeeded(int index, int indexType) {
            switch (indexType) {
                case 3: {
                    return InstructionTransformer.this.indexMap.adjustStringIndex(index);
                }
                case 2: {
                    return InstructionTransformer.this.indexMap.adjustTypeIdIndex(index);
                }
                case 5: {
                    return InstructionTransformer.this.indexMap.adjustFieldIdIndex(index);
                }
                case 9: {
                    return InstructionTransformer.this.indexMap.adjustProtoIdIndex(index);
                }
                case 4: {
                    return InstructionTransformer.this.indexMap.adjustMethodIdIndex(index);
                }
                case 8: {
                    return InstructionTransformer.this.indexMap.adjustMethodHandleIndex(index);
                }
                case 7: {
                    return InstructionTransformer.this.indexMap.adjustCallSiteIdIndex(index);
                }
                case 6: {
                    throw new IllegalArgumentException("METHOD_AND_PROTO_REF should not use this method to do transform.");
                }
            }
            return index;
        }
    }
}

