/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.util;

import com.tencent.tinker.android.utils.SparseBoolArray;
import com.tencent.tinker.android.utils.SparseIntArray;
import com.tencent.tinker.commons.dexpatcher.util.AbstractIndexMap;

public class SparseIndexMap
extends AbstractIndexMap {
    private final SparseIntArray stringIdsMap = new SparseIntArray();
    private final SparseIntArray typeIdsMap = new SparseIntArray();
    private final SparseIntArray protoIdsMap = new SparseIntArray();
    private final SparseIntArray fieldIdsMap = new SparseIntArray();
    private final SparseIntArray methodIdsMap = new SparseIntArray();
    private final SparseIntArray callSiteIdsMap = new SparseIntArray();
    public final SparseIntArray methodHandleIdsMap = new SparseIntArray();
    private final SparseIntArray typeListOffsetsMap = new SparseIntArray();
    private final SparseIntArray annotationOffsetsMap = new SparseIntArray();
    private final SparseIntArray annotationSetOffsetsMap = new SparseIntArray();
    private final SparseIntArray annotationSetRefListOffsetsMap = new SparseIntArray();
    private final SparseIntArray annotationsDirectoryOffsetsMap = new SparseIntArray();
    private final SparseIntArray staticValuesOffsetsMap = new SparseIntArray();
    private final SparseIntArray classDataOffsetsMap = new SparseIntArray();
    private final SparseIntArray debugInfoItemOffsetsMap = new SparseIntArray();
    private final SparseIntArray codeOffsetsMap = new SparseIntArray();
    private final SparseBoolArray deletedStringIds = new SparseBoolArray();
    private final SparseBoolArray deletedTypeIds = new SparseBoolArray();
    private final SparseBoolArray deletedProtoIds = new SparseBoolArray();
    private final SparseBoolArray deletedFieldIds = new SparseBoolArray();
    private final SparseBoolArray deletedMethodIds = new SparseBoolArray();
    private final SparseBoolArray deletedCallSiteIds = new SparseBoolArray();
    private final SparseBoolArray deletedMethodHandleIds = new SparseBoolArray();
    private final SparseBoolArray deletedTypeListOffsets = new SparseBoolArray();
    private final SparseBoolArray deletedAnnotationOffsets = new SparseBoolArray();
    private final SparseBoolArray deletedAnnotationSetOffsets = new SparseBoolArray();
    private final SparseBoolArray deletedAnnotationSetRefListOffsets = new SparseBoolArray();
    private final SparseBoolArray deletedAnnotationsDirectoryOffsets = new SparseBoolArray();
    private final SparseBoolArray deletedStaticValuesOffsets = new SparseBoolArray();
    private final SparseBoolArray deletedClassDataOffsets = new SparseBoolArray();
    private final SparseBoolArray deletedDebugInfoItemOffsets = new SparseBoolArray();
    private final SparseBoolArray deletedCodeOffsets = new SparseBoolArray();

    public void mapStringIds(int oldIndex, int newIndex) {
        this.stringIdsMap.put(oldIndex, newIndex);
    }

    public void markStringIdDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedStringIds.put(index, true);
    }

    public void mapTypeIds(int oldIndex, int newIndex) {
        this.typeIdsMap.put(oldIndex, newIndex);
    }

    public void markTypeIdDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedTypeIds.put(index, true);
    }

    public void mapProtoIds(int oldIndex, int newIndex) {
        this.protoIdsMap.put(oldIndex, newIndex);
    }

    public void markProtoIdDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedProtoIds.put(index, true);
    }

    public void mapFieldIds(int oldIndex, int newIndex) {
        this.fieldIdsMap.put(oldIndex, newIndex);
    }

    public void markFieldIdDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedFieldIds.put(index, true);
    }

    public void mapMethodIds(int oldIndex, int newIndex) {
        this.methodIdsMap.put(oldIndex, newIndex);
    }

    public void markMethodIdDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedMethodIds.put(index, true);
    }

    public void mapCallsiteIds(int oldIndex, int newIndex) {
        this.callSiteIdsMap.put(oldIndex, newIndex);
    }

    public void markCallsiteDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedCallSiteIds.put(index, true);
    }

    public void mapMethodHandleIds(int oldIndex, int newIndex) {
        this.methodHandleIdsMap.put(oldIndex, newIndex);
    }

    public void markMethodHandleDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedMethodHandleIds.put(index, true);
    }

    public void mapTypeListOffset(int oldOffset, int newOffset) {
        this.typeListOffsetsMap.put(oldOffset, newOffset);
    }

    public void markTypeListDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedTypeListOffsets.put(offset, true);
    }

    public void mapAnnotationOffset(int oldOffset, int newOffset) {
        this.annotationOffsetsMap.put(oldOffset, newOffset);
    }

    public void markAnnotationDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedAnnotationOffsets.put(offset, true);
    }

    public void mapAnnotationSetOffset(int oldOffset, int newOffset) {
        this.annotationSetOffsetsMap.put(oldOffset, newOffset);
    }

    public void markAnnotationSetDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedAnnotationSetOffsets.put(offset, true);
    }

    public void mapAnnotationSetRefListOffset(int oldOffset, int newOffset) {
        this.annotationSetRefListOffsetsMap.put(oldOffset, newOffset);
    }

    public void markAnnotationSetRefListDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedAnnotationSetRefListOffsets.put(offset, true);
    }

    public void mapAnnotationsDirectoryOffset(int oldOffset, int newOffset) {
        this.annotationsDirectoryOffsetsMap.put(oldOffset, newOffset);
    }

    public void markAnnotationsDirectoryDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedAnnotationsDirectoryOffsets.put(offset, true);
    }

    public void mapStaticValuesOffset(int oldOffset, int newOffset) {
        this.staticValuesOffsetsMap.put(oldOffset, newOffset);
    }

    public void markStaticValuesDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedStaticValuesOffsets.put(offset, true);
    }

    public void mapClassDataOffset(int oldOffset, int newOffset) {
        this.classDataOffsetsMap.put(oldOffset, newOffset);
    }

    public void markClassDataDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedClassDataOffsets.put(offset, true);
    }

    public void mapDebugInfoItemOffset(int oldOffset, int newOffset) {
        this.debugInfoItemOffsetsMap.put(oldOffset, newOffset);
    }

    public void markDebugInfoItemDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedDebugInfoItemOffsets.put(offset, true);
    }

    public void mapCodeOffset(int oldOffset, int newOffset) {
        this.codeOffsetsMap.put(oldOffset, newOffset);
    }

    public void markCodeDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedCodeOffsets.put(offset, true);
    }

    @Override
    public int adjustStringIndex(int stringIndex) {
        int index = this.stringIdsMap.indexOfKey(stringIndex);
        if (index < 0) {
            return stringIndex >= 0 && this.deletedStringIds.containsKey(stringIndex) ? -1 : stringIndex;
        }
        return this.stringIdsMap.valueAt(index);
    }

    @Override
    public int adjustTypeIdIndex(int typeIdIndex) {
        int index = this.typeIdsMap.indexOfKey(typeIdIndex);
        if (index < 0) {
            return typeIdIndex >= 0 && this.deletedTypeIds.containsKey(typeIdIndex) ? -1 : typeIdIndex;
        }
        return this.typeIdsMap.valueAt(index);
    }

    @Override
    public int adjustProtoIdIndex(int protoIndex) {
        int index = this.protoIdsMap.indexOfKey(protoIndex);
        if (index < 0) {
            return protoIndex >= 0 && this.deletedProtoIds.containsKey(protoIndex) ? -1 : protoIndex;
        }
        return this.protoIdsMap.valueAt(index);
    }

    @Override
    public int adjustFieldIdIndex(int fieldIndex) {
        int index = this.fieldIdsMap.indexOfKey(fieldIndex);
        if (index < 0) {
            return fieldIndex >= 0 && this.deletedFieldIds.containsKey(fieldIndex) ? -1 : fieldIndex;
        }
        return this.fieldIdsMap.valueAt(index);
    }

    @Override
    public int adjustMethodIdIndex(int methodIndex) {
        int index = this.methodIdsMap.indexOfKey(methodIndex);
        if (index < 0) {
            return methodIndex >= 0 && this.deletedMethodIds.containsKey(methodIndex) ? -1 : methodIndex;
        }
        return this.methodIdsMap.valueAt(index);
    }

    @Override
    public int adjustCallSiteIdIndex(int callsiteIdIndex) {
        int index = this.callSiteIdsMap.indexOfKey(callsiteIdIndex);
        if (index < 0) {
            return callsiteIdIndex >= 0 && this.deletedCallSiteIds.containsKey(callsiteIdIndex) ? -1 : callsiteIdIndex;
        }
        return this.callSiteIdsMap.valueAt(index);
    }

    @Override
    public int adjustMethodHandleIndex(int methodHandleIndex) {
        int index = this.methodHandleIdsMap.indexOfKey(methodHandleIndex);
        if (index < 0) {
            return methodHandleIndex >= 0 && this.deletedMethodHandleIds.containsKey(methodHandleIndex) ? -1 : methodHandleIndex;
        }
        return this.methodHandleIdsMap.valueAt(index);
    }

    @Override
    public int adjustTypeListOffset(int typeListOffset) {
        int index = this.typeListOffsetsMap.indexOfKey(typeListOffset);
        if (index < 0) {
            return typeListOffset >= 0 && this.deletedTypeListOffsets.containsKey(typeListOffset) ? -1 : typeListOffset;
        }
        return this.typeListOffsetsMap.valueAt(index);
    }

    @Override
    public int adjustAnnotationOffset(int annotationOffset) {
        int index = this.annotationOffsetsMap.indexOfKey(annotationOffset);
        if (index < 0) {
            return annotationOffset >= 0 && this.deletedAnnotationOffsets.containsKey(annotationOffset) ? -1 : annotationOffset;
        }
        return this.annotationOffsetsMap.valueAt(index);
    }

    @Override
    public int adjustAnnotationSetOffset(int annotationSetOffset) {
        int index = this.annotationSetOffsetsMap.indexOfKey(annotationSetOffset);
        if (index < 0) {
            return annotationSetOffset >= 0 && this.deletedAnnotationSetOffsets.containsKey(annotationSetOffset) ? -1 : annotationSetOffset;
        }
        return this.annotationSetOffsetsMap.valueAt(index);
    }

    @Override
    public int adjustAnnotationSetRefListOffset(int annotationSetRefListOffset) {
        int index = this.annotationSetRefListOffsetsMap.indexOfKey(annotationSetRefListOffset);
        if (index < 0) {
            return annotationSetRefListOffset >= 0 && this.deletedAnnotationSetRefListOffsets.containsKey(annotationSetRefListOffset) ? -1 : annotationSetRefListOffset;
        }
        return this.annotationSetRefListOffsetsMap.valueAt(index);
    }

    @Override
    public int adjustAnnotationsDirectoryOffset(int annotationsDirectoryOffset) {
        int index = this.annotationsDirectoryOffsetsMap.indexOfKey(annotationsDirectoryOffset);
        if (index < 0) {
            return annotationsDirectoryOffset >= 0 && this.deletedAnnotationsDirectoryOffsets.containsKey(annotationsDirectoryOffset) ? -1 : annotationsDirectoryOffset;
        }
        return this.annotationsDirectoryOffsetsMap.valueAt(index);
    }

    @Override
    public int adjustStaticValuesOffset(int staticValuesOffset) {
        int index = this.staticValuesOffsetsMap.indexOfKey(staticValuesOffset);
        if (index < 0) {
            return staticValuesOffset >= 0 && this.deletedStaticValuesOffsets.containsKey(staticValuesOffset) ? -1 : staticValuesOffset;
        }
        return this.staticValuesOffsetsMap.valueAt(index);
    }

    @Override
    public int adjustClassDataOffset(int classDataOffset) {
        int index = this.classDataOffsetsMap.indexOfKey(classDataOffset);
        if (index < 0) {
            return classDataOffset >= 0 && this.deletedClassDataOffsets.containsKey(classDataOffset) ? -1 : classDataOffset;
        }
        return this.classDataOffsetsMap.valueAt(index);
    }

    @Override
    public int adjustDebugInfoItemOffset(int debugInfoItemOffset) {
        int index = this.debugInfoItemOffsetsMap.indexOfKey(debugInfoItemOffset);
        if (index < 0) {
            return debugInfoItemOffset >= 0 && this.deletedDebugInfoItemOffsets.containsKey(debugInfoItemOffset) ? -1 : debugInfoItemOffset;
        }
        return this.debugInfoItemOffsetsMap.valueAt(index);
    }

    @Override
    public int adjustCodeOffset(int codeOffset) {
        int index = this.codeOffsetsMap.indexOfKey(codeOffset);
        if (index < 0) {
            return codeOffset >= 0 && this.deletedCodeOffsets.containsKey(codeOffset) ? -1 : codeOffset;
        }
        return this.codeOffsetsMap.valueAt(index);
    }
}

