/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.build.apkparser.AndroidParser;
import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class ManifestDecoder
extends BaseDecoder {
    private static final String XML_NODENAME_APPLICATION = "application";
    private static final String XML_NODENAME_USES_SDK = "uses-sdk";
    private static final String XML_NODEATTR_MIN_SDK_VERSION = "minSdkVersion";
    private static final String XML_NODEATTR_TARGET_SDK_VERSION = "targetSdkVersion";
    private static final String XML_NODEATTR_PACKAGE = "package";
    private static final String XML_NODENAME_ACTIVITY = "activity";
    private static final String XML_NODENAME_SERVICE = "service";
    private static final String XML_NODENAME_RECEIVER = "receiver";
    private static final String XML_NODENAME_PROVIDER = "provider";
    private static final String XML_NODEATTR_NAME = "name";
    private static final String XML_NODEATTR_EXPORTED = "exported";
    private static final String XML_NODEATTR_PROCESS = "process";
    private static final String XML_NODENAME_INTENTFILTER = "intent-filter";

    public ManifestDecoder(Configuration config) throws IOException {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean patch(File oldFile, File newFile) throws IOException, TinkerPatchException {
        try {
            boolean hasIncComponent;
            String newXml;
            String oldXml;
            boolean isManifestChanged;
            AndroidParser oldAndroidManifest = AndroidParser.getAndroidManifest(oldFile);
            AndroidParser newAndroidManifest = AndroidParser.getAndroidManifest(newFile);
            int minSdkVersion = Integer.parseInt(oldAndroidManifest.apkMeta.getMinSdkVersion());
            if (minSdkVersion < 14 && this.config.mDexRaw) {
                StringBuilder sb = new StringBuilder();
                sb.append("your old apk's minSdkVersion ").append(minSdkVersion).append(" is below 14, you should set the dexMode to 'jar', ").append("otherwise, it will crash at some time");
                this.announceWarningOrException(sb.toString());
            }
            boolean bl = isManifestChanged = !(oldXml = oldAndroidManifest.xml.trim()).equals(newXml = newAndroidManifest.xml.trim());
            if (!this.config.mSupportHotplugComponent && isManifestChanged) {
                this.announceWarningOrException("manifest was changed, while hot plug component support mode is disabled. Such changes will not take effect.");
            }
            if (!isManifestChanged) {
                Logger.d("\nManifest has no changes, skip rest decode works.");
                return false;
            }
            Set<String> incActivities = this.getIncrementActivities(oldAndroidManifest.activities, newAndroidManifest.activities);
            Set<String> incServices = this.getIncrementServices(oldAndroidManifest.services, newAndroidManifest.services);
            Set<String> incReceivers = this.getIncrementReceivers(oldAndroidManifest.receivers, newAndroidManifest.receivers);
            Set<String> incProviders = this.getIncrementProviders(oldAndroidManifest.providers, newAndroidManifest.providers);
            boolean bl2 = hasIncComponent = !incActivities.isEmpty() || !incServices.isEmpty() || !incProviders.isEmpty() || !incReceivers.isEmpty();
            if (hasIncComponent) {
                File incXmlOutput;
                Document newXmlDoc = DocumentHelper.parseText((String)newAndroidManifest.xml);
                Document incXmlDoc = DocumentHelper.createDocument();
                Element newRootNode = newXmlDoc.getRootElement();
                String packageName = newRootNode.attributeValue(XML_NODEATTR_PACKAGE);
                if (Utils.isNullOrNil(packageName)) {
                    throw new TinkerPatchException("Unable to find package name from manifest: " + newFile.getAbsolutePath());
                }
                Element newAppNode = newRootNode.element(XML_NODENAME_APPLICATION);
                Element incAppNode = incXmlDoc.addElement(newAppNode.getQName());
                this.copyAttributes(newAppNode, incAppNode);
                if (!incActivities.isEmpty()) {
                    List newActivityNodes = newAppNode.elements(XML_NODENAME_ACTIVITY);
                    List<Element> incActivityNodes = this.getIncrementActivityNodes(packageName, newActivityNodes, incActivities);
                    for (Element node : incActivityNodes) {
                        incAppNode.add(node.detach());
                    }
                }
                if (!incServices.isEmpty()) {
                    List newServiceNodes = newAppNode.elements(XML_NODENAME_SERVICE);
                    List<Element> incServiceNodes = this.getIncrementServiceNodes(packageName, newServiceNodes, incServices);
                    for (Element node : incServiceNodes) {
                        incAppNode.add(node.detach());
                    }
                }
                if (!incReceivers.isEmpty()) {
                    List newReceiverNodes = newAppNode.elements(XML_NODENAME_RECEIVER);
                    List<Element> incReceiverNodes = this.getIncrementReceiverNodes(packageName, newReceiverNodes, incReceivers);
                    for (Element node : incReceiverNodes) {
                        incAppNode.add(node.detach());
                    }
                }
                if (!incProviders.isEmpty()) {
                    List newProviderNodes = newAppNode.elements(XML_NODENAME_PROVIDER);
                    List<Element> incProviderNodes = this.getIncrementProviderNodes(packageName, newProviderNodes, incProviders);
                    for (Element node : incProviderNodes) {
                        incAppNode.add(node.detach());
                    }
                }
                if (!(incXmlOutput = new File(this.config.mTempResultDir, "assets/inc_component_meta.txt")).exists()) {
                    incXmlOutput.getParentFile().mkdirs();
                }
                BufferedOutputStream os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(incXmlOutput));
                    XMLWriter docWriter = new XMLWriter((OutputStream)os);
                    docWriter.write(incXmlDoc);
                    docWriter.close();
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(os);
                    throw throwable;
                }
                Utils.closeQuietly(os);
            }
            if (isManifestChanged && !hasIncComponent) {
                Logger.d("\nManifest was changed, while there's no any new components added. Make sure if such changes were all you expected.\n");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new TinkerPatchException("Parse android manifest error!");
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new TinkerPatchException("Parse android manifest by dom4j error!");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TinkerPatchException("Failed to generate increment manifest.", e);
        }
        return false;
    }

    private Set<String> getIncrementActivities(Collection<String> oldActivities, Collection<String> newActivities) {
        HashSet<String> incNames = new HashSet<String>(newActivities);
        incNames.removeAll(oldActivities);
        return incNames;
    }

    private Set<String> getIncrementServices(Collection<String> oldServices, Collection<String> newServices) {
        HashSet<String> incNames = new HashSet<String>(newServices);
        incNames.removeAll(oldServices);
        if (!incNames.isEmpty()) {
            this.announceWarningOrException("found added services: " + ((Object)incNames).toString() + "\n currently tinker does not support increase new services, such these changes would not take effect.");
        }
        return incNames;
    }

    private Set<String> getIncrementReceivers(Collection<String> oldReceivers, Collection<String> newReceivers) {
        HashSet<String> incNames = new HashSet<String>(newReceivers);
        incNames.removeAll(oldReceivers);
        if (!incNames.isEmpty()) {
            this.announceWarningOrException("found added receivers: " + ((Object)incNames).toString() + "\n currently tinker does not support increase new receivers, such these changes would not take effect.");
        }
        return incNames;
    }

    private Set<String> getIncrementProviders(Collection<String> oldProviders, Collection<String> newProviders) {
        HashSet<String> incNames = new HashSet<String>(newProviders);
        incNames.removeAll(oldProviders);
        if (!incNames.isEmpty()) {
            this.announceWarningOrException("found added providers: " + ((Object)incNames).toString() + "\n currently tinker does not support increase new providers, such these changes would not take effect.");
        }
        return incNames;
    }

    private List<Element> getIncrementActivityNodes(String packageName, List<Element> newActivityNodes, Collection<String> incActivities) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element newActivityNode : newActivityNodes) {
            String processVal;
            String activityClazzName = newActivityNode.attributeValue(XML_NODEATTR_NAME);
            if (activityClazzName.charAt(0) == '.') {
                activityClazzName = packageName + activityClazzName;
            }
            if (!incActivities.contains(activityClazzName)) continue;
            String exportedVal = newActivityNode.attributeValue(XML_NODEATTR_EXPORTED, Utils.isNullOrNil(newActivityNode.elements(XML_NODENAME_INTENTFILTER)) ? "false" : "true");
            if ("true".equalsIgnoreCase(exportedVal)) {
                this.announceWarningOrException(String.format("found a new exported activity %s, tinker does not support increase exported activity.", activityClazzName));
            }
            if ((processVal = newActivityNode.attributeValue(XML_NODEATTR_PROCESS)) != null && processVal.charAt(0) == ':') {
                this.announceWarningOrException(String.format("found a new activity %s which would be run in standalone process, tinker does not support increase such kind of activities.", activityClazzName));
            }
            Logger.d("Found increment activity: " + activityClazzName);
            result.add(newActivityNode);
        }
        return result;
    }

    private List<Element> getIncrementServiceNodes(String packageName, List<Element> newServiceNodes, Collection<String> incServices) {
        this.announceWarningOrException("currently tinker does not support increase new services.");
        return Collections.emptyList();
    }

    private List<Element> getIncrementReceiverNodes(String packageName, List<Element> newReceiverNodes, Collection<String> incReceivers) {
        this.announceWarningOrException("currently tinker does not support increase new receivers.");
        return Collections.emptyList();
    }

    private List<Element> getIncrementProviderNodes(String packageName, List<Element> newProviderNodes, Collection<String> incProviders) {
        this.announceWarningOrException("currently tinker does not support increase new providers.");
        return Collections.emptyList();
    }

    private void copyAttributes(Element srcNode, Element destNode) {
        for (Object attrObj : srcNode.attributes()) {
            Attribute attr = (Attribute)attrObj;
            destNode.addAttribute(attr.getQName(), attr.getValue());
        }
    }

    private void announceWarningOrException(String message) {
        if (!this.config.mIgnoreWarning) {
            String msg = "Warning:ignoreWarning is false, " + message;
            Logger.e(msg);
            throw new TinkerPatchException(msg);
        }
        String msg = "Warning:ignoreWarning is true, but " + message;
        Logger.e(msg);
    }

    @Override
    public void onAllPatchesStart() throws IOException, TinkerPatchException {
    }

    @Override
    public void onAllPatchesEnd() throws IOException, TinkerPatchException {
    }
}

