/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.util;

import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.build.dexpatcher.util.PatternUtils;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.DexClassesComparator;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class ExcludedClassModifiedChecker {
    private static final int STMCODE_START = 0;
    private static final int STMCODE_ERROR_PRIMARY_OLD_DEX_IS_MISSING = 1;
    private static final int STMCODE_ERROR_PRIMARY_NEW_DEX_IS_MISSING = 2;
    private static final int STMCODE_ERROR_LOADER_CLASS_NOT_IN_PRIMARY_OLD_DEX = 3;
    private static final int STMCODE_ERROR_LOADER_CLASS_IN_PRIMARY_DEX_MISMATCH = 4;
    private static final int STMCODE_ERROR_LOADER_CLASS_FOUND_IN_SECONDARY_OLD_DEX = 5;
    private static final int STMCODE_ERROR_LOADER_CLASS_FOUND_IN_SECONDARY_NEW_DEX = 6;
    private static final int STMCODE_ERROR_LOADER_CLASS_CHANGED = 7;
    private static final int STMCODE_END = 8;
    private final Configuration config;
    private final DexClassesComparator dexCmptor;
    private Dex oldDex = null;
    private Dex newDex = null;
    private List<DexClassesComparator.DexClassInfo> deletedClassInfos = null;
    private List<DexClassesComparator.DexClassInfo> addedClassInfos = null;
    private Map<String, DexClassesComparator.DexClassInfo[]> changedClassInfosMap = null;
    private Set<String> oldClassesDescToCheck = new HashSet<String>();
    private Set<String> newClassesDescToCheck = new HashSet<String>();
    private HashSet<Pattern> ignoreChangeWarning = new HashSet();

    public ExcludedClassModifiedChecker(Configuration config) {
        this.config = config;
        this.dexCmptor = new DexClassesComparator(config.mDexLoaderPattern);
        for (String classname : config.mDexIgnoreWarningLoaderPattern) {
            this.ignoreChangeWarning.add(Pattern.compile(PatternUtils.dotClassNamePatternToDescriptorRegEx(classname)));
        }
    }

    public void checkIfExcludedClassWasModifiedInNewDex(File oldFile, File newFile) throws IOException, TinkerPatchException {
        if (oldFile == null && newFile == null) {
            throw new TinkerPatchException("both oldFile and newFile are null.");
        }
        this.oldDex = oldFile != null ? new Dex(oldFile) : null;
        this.newDex = newFile != null ? new Dex(newFile) : null;
        int stmCode = 0;
        block10: while (stmCode != 8) {
            switch (stmCode) {
                case 0: {
                    String desc;
                    boolean isPrimaryDex = this.isPrimaryDex(oldFile == null ? newFile : oldFile);
                    if (isPrimaryDex) {
                        if (oldFile == null) {
                            stmCode = 1;
                            continue block10;
                        }
                        if (newFile == null) {
                            stmCode = 2;
                            continue block10;
                        }
                        this.dexCmptor.startCheck(this.oldDex, this.newDex);
                        this.deletedClassInfos = this.dexCmptor.getDeletedClassInfos();
                        this.addedClassInfos = this.dexCmptor.getAddedClassInfos();
                        this.changedClassInfosMap = new HashMap<String, DexClassesComparator.DexClassInfo[]>(this.dexCmptor.getChangedClassDescToInfosMap());
                        if (this.deletedClassInfos.isEmpty() && this.changedClassInfosMap.isEmpty() && !this.addedClassInfos.isEmpty()) {
                            stmCode = 3;
                            continue block10;
                        }
                        if (this.deletedClassInfos.isEmpty() && this.addedClassInfos.isEmpty()) {
                            ArrayList<String> removeClasses = new ArrayList<String>();
                            for (String classname : this.changedClassInfosMap.keySet()) {
                                if (!Utils.checkFileInPattern(this.ignoreChangeWarning, classname)) continue;
                                Logger.e("loader class pattern: " + classname + " has changed, but it match ignore change pattern, just ignore!");
                                removeClasses.add(classname);
                            }
                            this.changedClassInfosMap.keySet().removeAll(removeClasses);
                            if (this.changedClassInfosMap.isEmpty()) {
                                stmCode = 8;
                                continue block10;
                            }
                            stmCode = 7;
                            continue block10;
                        }
                        stmCode = 4;
                        continue block10;
                    }
                    HashSet<Pattern> patternsOfClassDescToCheck = new HashSet<Pattern>();
                    for (String patternStr : this.config.mDexLoaderPattern) {
                        patternsOfClassDescToCheck.add(Pattern.compile(PatternUtils.dotClassNamePatternToDescriptorRegEx(patternStr)));
                    }
                    if (this.oldDex != null) {
                        this.oldClassesDescToCheck.clear();
                        for (ClassDef classDef : this.oldDex.classDefs()) {
                            desc = (String)this.oldDex.typeNames().get(classDef.typeIndex);
                            if (!Utils.isStringMatchesPatterns(desc, patternsOfClassDescToCheck)) continue;
                            this.oldClassesDescToCheck.add(desc);
                        }
                        if (!this.oldClassesDescToCheck.isEmpty()) {
                            stmCode = 5;
                            continue block10;
                        }
                    }
                    if (this.newDex != null) {
                        this.newClassesDescToCheck.clear();
                        for (ClassDef classDef : this.newDex.classDefs()) {
                            desc = (String)this.newDex.typeNames().get(classDef.typeIndex);
                            if (!Utils.isStringMatchesPatterns(desc, patternsOfClassDescToCheck)) continue;
                            this.newClassesDescToCheck.add(desc);
                        }
                        if (!this.newClassesDescToCheck.isEmpty()) {
                            stmCode = 6;
                            continue block10;
                        }
                    }
                    stmCode = 8;
                    continue block10;
                }
                case 1: {
                    throw new TinkerPatchException("old primary dex is missing.");
                }
                case 2: {
                    throw new TinkerPatchException("new primary dex is missing.");
                }
                case 3: {
                    throw new TinkerPatchException("all loader classes don't appear in old primary dex.");
                }
                case 4: {
                    throw new TinkerPatchException("loader classes in old primary dex are mismatched to those in new primary dex, \nif deleted classes is not empty, check if your dex division strategy is fine. \nadded classes: " + Utils.collectionToString(this.addedClassInfos) + "\ndeleted classes: " + Utils.collectionToString(this.deletedClassInfos));
                }
                case 5: {
                    throw new TinkerPatchException("loader classes are found in old secondary dex. Found classes: " + Utils.collectionToString(this.oldClassesDescToCheck));
                }
                case 6: {
                    throw new TinkerPatchException("loader classes are found in new secondary dex. Found classes: " + Utils.collectionToString(this.newClassesDescToCheck));
                }
                case 7: {
                    String msg = "some loader class has been changed in new dex. Such these changes will not take effect!! related classes: " + Utils.collectionToString(this.changedClassInfosMap.keySet());
                    throw new TinkerPatchException(msg);
                }
            }
            Logger.e("internal-error: unexpected stmCode.");
            stmCode = 8;
        }
    }

    public boolean isPrimaryDex(File dexFile) {
        Path parentPath;
        Path dexFilePath = dexFile.toPath();
        if (!dexFilePath.startsWith(parentPath = this.config.mTempUnzipOldDir.toPath())) {
            parentPath = this.config.mTempUnzipNewDir.toPath();
        }
        return "classes.dex".equals(parentPath.relativize(dexFilePath).toString().replace('\\', '/'));
    }
}

