/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.util;

import com.tencent.tinker.build.decoder.ResDiffDecoder;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.MD5;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.commons.util.StreamUtil;
import com.tencent.tinker.ziputils.ziputil.TinkerZipEntry;
import com.tencent.tinker.ziputils.ziputil.TinkerZipFile;
import com.tencent.tinker.ziputils.ziputil.TinkerZipOutputStream;
import com.tencent.tinker.ziputils.ziputil.TinkerZipUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;

public class Utils {
    public static boolean isPresent(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isBlank(String str) {
        return !Utils.isPresent(str);
    }

    public static boolean isPresent(Iterator iterator) {
        return iterator != null && iterator.hasNext();
    }

    public static boolean isBlank(Iterator iterator) {
        return !Utils.isPresent(iterator);
    }

    public static String convertToPatternString(String input) {
        if (input.contains(".")) {
            input = input.replaceAll("\\.", "\\\\.");
        }
        if (input.contains("?")) {
            input = input.replaceAll("\\?", "\\.");
        }
        if (input.contains("*")) {
            input = input.replace("*", ".*");
        }
        return input;
    }

    public static boolean isNullOrNil(String object) {
        return object == null || object.length() <= 0;
    }

    public static boolean isNullOrNil(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isStringMatchesPatterns(String str, Collection<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    public static <T> String collectionToString(Collection<T> collection) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean isFirstElement = true;
        for (T element : collection) {
            if (isFirstElement) {
                isFirstElement = false;
            } else {
                sb.append(',');
            }
            sb.append(element);
        }
        sb.append('}');
        return sb.toString();
    }

    public static boolean checkFileInPattern(HashSet<Pattern> patterns, String key) {
        if (!patterns.isEmpty()) {
            for (Pattern p : patterns) {
                if (!p.matcher(key).matches()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genResOutputFile(File output, File newZipFile, Configuration config, ArrayList<String> addedSet, ArrayList<String> modifiedSet, ArrayList<String> deletedSet, ArrayList<String> largeModifiedSet, HashMap<String, ResDiffDecoder.LargeModeInfo> largeModifiedMap) throws IOException {
        TinkerZipFile oldApk = null;
        TinkerZipFile newApk = null;
        TinkerZipOutputStream out = null;
        try {
            oldApk = new TinkerZipFile(config.mOldApkFile);
            newApk = new TinkerZipFile(newZipFile);
            out = new TinkerZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(output)));
            Enumeration entries = oldApk.entries();
            while (entries.hasMoreElements()) {
                TinkerZipEntry zipEntry = (TinkerZipEntry)entries.nextElement();
                if (zipEntry == null) {
                    throw new TinkerPatchException(String.format("zipEntry is null when get from oldApk", new Object[0]));
                }
                String name = zipEntry.getName();
                if (!TinkerZipUtil.validateZipEntryName((File)output.getParentFile(), (String)name)) {
                    throw new IOException("Bad ZipEntry name: " + name);
                }
                if (!Utils.checkFileInPattern(config.mResFilePattern, name) || deletedSet.contains(name) || modifiedSet.contains(name) || largeModifiedSet.contains(name) || name.equals("AndroidManifest.xml")) continue;
                TinkerZipUtil.extractTinkerEntry((TinkerZipFile)oldApk, (TinkerZipEntry)zipEntry, (TinkerZipOutputStream)out);
            }
            TinkerZipEntry manifestZipEntry = oldApk.getEntry("AndroidManifest.xml");
            if (manifestZipEntry == null) {
                throw new TinkerPatchException(String.format("can't found resource file %s from old apk file %s", "AndroidManifest.xml", config.mOldApkFile.getAbsolutePath()));
            }
            TinkerZipUtil.extractTinkerEntry((TinkerZipFile)oldApk, (TinkerZipEntry)manifestZipEntry, (TinkerZipOutputStream)out);
            for (String name : largeModifiedSet) {
                TinkerZipEntry largeZipEntry = oldApk.getEntry(name);
                if (largeZipEntry == null) {
                    throw new TinkerPatchException(String.format("can't found resource file %s from old apk file %s", name, config.mOldApkFile.getAbsolutePath()));
                }
                ResDiffDecoder.LargeModeInfo largeModeInfo = largeModifiedMap.get(name);
                TinkerZipUtil.extractLargeModifyFile((TinkerZipEntry)largeZipEntry, (File)largeModeInfo.path, (long)largeModeInfo.crc, (TinkerZipOutputStream)out);
            }
            for (String name : addedSet) {
                TinkerZipEntry addZipEntry = newApk.getEntry(name);
                if (addZipEntry == null) {
                    throw new TinkerPatchException(String.format("can't found add resource file %s from new apk file %s", name, config.mNewApkFile.getAbsolutePath()));
                }
                TinkerZipUtil.extractTinkerEntry((TinkerZipFile)newApk, (TinkerZipEntry)addZipEntry, (TinkerZipOutputStream)out);
            }
            for (String name : modifiedSet) {
                TinkerZipEntry modZipEntry = newApk.getEntry(name);
                if (modZipEntry == null) {
                    throw new TinkerPatchException(String.format("can't found add resource file %s from new apk file %s", name, config.mNewApkFile.getAbsolutePath()));
                }
                TinkerZipUtil.extractTinkerEntry((TinkerZipFile)newApk, (TinkerZipEntry)modZipEntry, (TinkerZipOutputStream)out);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.closeQuietly(out);
            StreamUtil.closeQuietly((Object)oldApk);
            StreamUtil.closeQuietly(newApk);
            throw throwable;
        }
        StreamUtil.closeQuietly((Object)out);
        StreamUtil.closeQuietly((Object)oldApk);
        StreamUtil.closeQuietly((Object)newApk);
        return MD5.getMD5(output);
    }

    public static String getResourceMeta(String baseCrc, String md5) {
        return "resources_out.zip," + baseCrc + "," + md5;
    }

    public static boolean checkBsDiffFileSize(File bsDiffFile, File newFile) {
        if (!bsDiffFile.exists()) {
            throw new TinkerPatchException("can not find the bsDiff file:" + bsDiffFile.getAbsolutePath());
        }
        double ratio = (double)bsDiffFile.length() / (double)newFile.length();
        if (ratio > 0.8) {
            Logger.e("bsDiff patch file:%s, size:%dk, new file:%s, size:%dk. patch file is too large, treat it as newly file to save patch time!", bsDiffFile.getName(), bsDiffFile.length() / 1024L, newFile.getName(), newFile.length() / 1024L);
            return false;
        }
        return true;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

