/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.dexpatcher.DexPatchGenerator;
import com.tencent.tinker.build.dexpatcher.util.ChangedClassesDexClassInfoCollector;
import com.tencent.tinker.build.dexpatcher.util.PatternUtils;
import com.tencent.tinker.build.info.InfoWriter;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.DexClassesComparator;
import com.tencent.tinker.build.util.ExcludedClassModifiedChecker;
import com.tencent.tinker.build.util.FileOperation;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.MD5;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import com.tencent.tinker.commons.dexpatcher.DexPatchApplier;
import com.tencent.tinker.commons.dexpatcher.DexPatcherLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.builder.BuilderMutableMethodImplementation;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.dexlib2.util.TypeUtils;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.FileDataStore;

public class DexDiffDecoder
extends BaseDecoder {
    private static final String TEST_DEX_NAME = "test.dex";
    private static final String CHANGED_CLASSES_DEX_NAME_PREFIX = "changed_classes";
    private final InfoWriter logWriter;
    private final InfoWriter metaWriter;
    private final ExcludedClassModifiedChecker excludedClassModifiedChecker;
    private final Map<String, String> addedClassDescToDexNameMap;
    private final Map<String, String> deletedClassDescToDexNameMap;
    private final List<AbstractMap.SimpleEntry<File, File>> oldAndNewDexFilePairList;
    private final Map<String, RelatedInfo> dexNameToRelatedInfoMap;
    private boolean hasDexChanged = false;
    private DexPatcherLoggerBridge dexPatcherLoggerBridge = null;
    private final Set<Pattern> loaderClassPatterns;
    private final Set<String> descOfClassesInApk;
    private final List<File> oldDexFiles;

    public DexDiffDecoder(Configuration config, String metaPath, String logPath) throws IOException {
        super(config);
        this.metaWriter = metaPath != null ? new InfoWriter(config, config.mTempResultDir + File.separator + metaPath) : null;
        this.logWriter = logPath != null ? new InfoWriter(config, config.mOutFolder + File.separator + logPath) : null;
        if (this.logWriter != null) {
            this.dexPatcherLoggerBridge = new DexPatcherLoggerBridge(this.logWriter);
        }
        this.excludedClassModifiedChecker = new ExcludedClassModifiedChecker(config);
        this.addedClassDescToDexNameMap = new HashMap<String, String>();
        this.deletedClassDescToDexNameMap = new HashMap<String, String>();
        this.oldAndNewDexFilePairList = new ArrayList<AbstractMap.SimpleEntry<File, File>>();
        this.dexNameToRelatedInfoMap = new HashMap<String, RelatedInfo>();
        this.loaderClassPatterns = new HashSet<Pattern>();
        for (String patternStr : config.mDexLoaderPattern) {
            this.loaderClassPatterns.add(Pattern.compile(PatternUtils.dotClassNamePatternToDescriptorRegEx(patternStr)));
        }
        this.descOfClassesInApk = new HashSet<String>();
        this.oldDexFiles = new ArrayList<File>();
    }

    @Override
    public void onAllPatchesStart() throws IOException, TinkerPatchException {
        this.descOfClassesInApk.clear();
        this.oldDexFiles.clear();
    }

    protected String getRelativeDexName(File oldDexFile, File newDexFile) {
        return oldDexFile != null ? this.getRelativePathStringToOldFile(oldDexFile) : this.getRelativePathStringToNewFile(newDexFile);
    }

    private void collectClassesInDex(File dexFile) throws IOException {
        Logger.d("Collect class descriptors in " + dexFile.getName());
        DexBackedDexFile dex = DexFileFactory.loadDexFile((File)dexFile, (Opcodes)Opcodes.forApi((int)29));
        for (org.jf.dexlib2.iface.ClassDef classDef : dex.getClasses()) {
            this.descOfClassesInApk.add(classDef.getType());
        }
    }

    @Override
    public boolean patch(File oldFile, File newFile) throws IOException, TinkerPatchException {
        String dexName = this.getRelativeDexName(oldFile, newFile);
        Logger.d("Check for loader classes in dex: %s", dexName);
        try {
            this.excludedClassModifiedChecker.checkIfExcludedClassWasModifiedInNewDex(oldFile, newFile);
        }
        catch (IOException e) {
            throw new TinkerPatchException(e);
        }
        catch (TinkerPatchException e) {
            if (this.config.mIgnoreWarning) {
                Logger.e("Warning:ignoreWarning is true, but we found %s", e.getMessage());
            }
            Logger.e("Warning:ignoreWarning is false, but we found %s", e.getMessage());
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (newFile == null || !newFile.exists() || newFile.length() == 0L) {
            return false;
        }
        File dexDiffOut = this.getOutputPath(newFile).toFile();
        String newMd5 = this.getRawOrWrappedDexMD5(newFile);
        if (oldFile == null || !oldFile.exists() || oldFile.length() == 0L) {
            this.hasDexChanged = true;
            this.copyNewDexAndLogToDexMeta(newFile, newMd5, dexDiffOut);
            return true;
        }
        this.collectClassesInDex(oldFile);
        this.oldDexFiles.add(oldFile);
        String oldMd5 = this.getRawOrWrappedDexMD5(oldFile);
        if (oldMd5 != null && !oldMd5.equals(newMd5) || oldMd5 == null && newMd5 != null) {
            this.hasDexChanged = true;
            if (oldMd5 != null) {
                this.collectAddedOrDeletedClasses(oldFile, newFile);
            }
        }
        RelatedInfo relatedInfo = new RelatedInfo();
        relatedInfo.oldMd5 = oldMd5;
        relatedInfo.newMd5 = newMd5;
        this.oldAndNewDexFilePairList.add(new AbstractMap.SimpleEntry<File, File>(oldFile, newFile));
        this.dexNameToRelatedInfoMap.put(dexName, relatedInfo);
        return true;
    }

    @Override
    public void onAllPatchesEnd() throws Exception {
        if (!this.hasDexChanged) {
            Logger.d("No dexes were changed, nothing needs to be done next.");
            return;
        }
        this.checkIfLoaderClassesReferToNonLoaderClasses();
        if (this.config.mIsProtectedApp) {
            this.generateChangedClassesDexFile();
        } else {
            this.generatePatchInfoFile();
        }
        this.addTestDex();
    }

    private boolean isReferenceFromLoaderClassValid(String refereeTypeDesc) {
        if (TypeUtils.isPrimitiveType((String)refereeTypeDesc)) {
            return true;
        }
        if (!this.descOfClassesInApk.contains(refereeTypeDesc)) {
            return true;
        }
        return Utils.isStringMatchesPatterns(refereeTypeDesc, this.loaderClassPatterns);
    }

    private void checkIfLoaderClassesReferToNonLoaderClasses() throws IOException, TinkerPatchException {
        boolean hasInvalidCases = false;
        for (File dexFile : this.oldDexFiles) {
            Logger.d("Check if loader classes in " + dexFile.getName() + " refer to any classes that is not in loader class patterns.");
            DexBackedDexFile dex = DexFileFactory.loadDexFile((File)dexFile, (Opcodes)Opcodes.forApi((int)29));
            for (org.jf.dexlib2.iface.ClassDef classDef : dex.getClasses()) {
                String currClassDesc = classDef.getType();
                if (!Utils.isStringMatchesPatterns(currClassDesc, this.loaderClassPatterns)) continue;
                for (Field field : classDef.getFields()) {
                    String currFieldTypeDesc = field.getType();
                    if (this.isReferenceFromLoaderClassValid(currFieldTypeDesc)) continue;
                    Logger.e("FATAL: field '%s' in loader class '%s' refers to class '%s' which is not loader class, this may cause crash when patch is loaded.", field.getName(), currClassDesc, currFieldTypeDesc);
                    hasInvalidCases = true;
                }
                for (Method method : classDef.getMethods()) {
                    Iterable insns;
                    boolean isCurrentMethodInvalid = false;
                    String currMethodRetTypeDesc = method.getReturnType();
                    if (!this.isReferenceFromLoaderClassValid(currMethodRetTypeDesc)) {
                        Logger.e("FATAL: method '%s:%s' in loader class '%s' refers to class '%s' which is not loader class, this may cause crash when patch is loaded.", method.getName(), MethodUtil.getShorty((Collection)method.getParameterTypes(), (String)currMethodRetTypeDesc), currClassDesc, currMethodRetTypeDesc);
                        isCurrentMethodInvalid = true;
                    } else {
                        for (CharSequence paramTypeDesc : method.getParameterTypes()) {
                            if (this.isReferenceFromLoaderClassValid(paramTypeDesc.toString())) continue;
                            Logger.e("FATAL: method '%s:%s' in loader class '%s' refers to class '%s' which is not loader class, this may cause crash when patch is loaded.", method.getName(), MethodUtil.getShorty((Collection)method.getParameterTypes(), (String)currMethodRetTypeDesc), currClassDesc, paramTypeDesc);
                            isCurrentMethodInvalid = true;
                            break;
                        }
                    }
                    MethodImplementation methodImpl = method.getImplementation();
                    if (methodImpl != null && (insns = methodImpl.getInstructions()).iterator().hasNext()) {
                        for (Instruction insn : insns) {
                            if (!(insn instanceof ReferenceInstruction)) continue;
                            ReferenceInstruction refInsn = (ReferenceInstruction)insn;
                            switch (refInsn.getReferenceType()) {
                                case 1: {
                                    TypeReference typeRefInsn = (TypeReference)refInsn.getReference();
                                    String refereeTypeDesc = typeRefInsn.getType();
                                    if (this.isReferenceFromLoaderClassValid(refereeTypeDesc)) break;
                                    Logger.e("FATAL: method '%s:%s' in loader class '%s' refers to class '%s' which is not loader class, this may cause crash when patch is loaded.", method.getName(), MethodUtil.getShorty((Collection)method.getParameterTypes(), (String)currMethodRetTypeDesc), currClassDesc, refereeTypeDesc);
                                    isCurrentMethodInvalid = true;
                                    break;
                                }
                                case 2: {
                                    FieldReference fieldRefInsn = (FieldReference)refInsn.getReference();
                                    String refereeFieldName = fieldRefInsn.getName();
                                    String refereeFieldDefTypeDesc = fieldRefInsn.getDefiningClass();
                                    if (this.isReferenceFromLoaderClassValid(refereeFieldDefTypeDesc)) break;
                                    Logger.e("FATAL: method '%s:%s' in loader class '%s' refers to field '%s' in class '%s' which is not in loader class, this may cause crash when patch is loaded.", method.getName(), MethodUtil.getShorty((Collection)method.getParameterTypes(), (String)currMethodRetTypeDesc), currClassDesc, refereeFieldName, refereeFieldDefTypeDesc);
                                    isCurrentMethodInvalid = true;
                                    break;
                                }
                                case 3: {
                                    MethodReference methodRefInsn = (MethodReference)refInsn.getReference();
                                    String refereeMethodName = methodRefInsn.getName();
                                    List refereeMethodParamTypes = methodRefInsn.getParameterTypes();
                                    String refereeMethodRetType = methodRefInsn.getReturnType();
                                    String refereeMethodDefClassDesc = methodRefInsn.getDefiningClass();
                                    if (this.isReferenceFromLoaderClassValid(refereeMethodDefClassDesc)) break;
                                    Logger.e("FATAL: method '%s:%s' in loader class '%s' refers to method '%s:%s' in class '%s' which is not in loader class, this may cause crash when patch is loaded.", method.getName(), MethodUtil.getShorty((Collection)method.getParameterTypes(), (String)currMethodRetTypeDesc), currClassDesc, refereeMethodName, MethodUtil.getShorty((Collection)refereeMethodParamTypes, (String)refereeMethodRetType), refereeMethodDefClassDesc);
                                    isCurrentMethodInvalid = true;
                                    break;
                                }
                            }
                        }
                    }
                    if (!isCurrentMethodInvalid) continue;
                    hasInvalidCases = true;
                }
            }
        }
        if (hasInvalidCases) {
            throw new TinkerPatchException("There are fatal reasons that cause Tinker interrupt patch generating procedure, see logs above.");
        }
    }

    private void generateChangedClassesDexFile() throws IOException {
        String dexMode = this.config.mDexRaw ? "raw" : "jar";
        ArrayList<File> oldDexList = new ArrayList<File>();
        ArrayList<File> newDexList = new ArrayList<File>();
        for (AbstractMap.SimpleEntry<File, File> oldAndNewDexFilePair : this.oldAndNewDexFilePairList) {
            File oldDexFile = oldAndNewDexFilePair.getKey();
            File newDexFile = oldAndNewDexFilePair.getValue();
            if (oldDexFile != null) {
                oldDexList.add(oldDexFile);
            }
            if (newDexFile == null) continue;
            newDexList.add(newDexFile);
        }
        DexClassesComparator.DexGroup oldDexGroup = DexClassesComparator.DexGroup.wrap(oldDexList);
        DexClassesComparator.DexGroup newDexGroup = DexClassesComparator.DexGroup.wrap(newDexList);
        ChangedClassesDexClassInfoCollector collector = new ChangedClassesDexClassInfoCollector();
        collector.setExcludedClassPatterns(this.config.mDexLoaderPattern);
        collector.setLogger(this.dexPatcherLoggerBridge);
        collector.setIncludeRefererToRefererAffectedClasses(true);
        Set<DexClassesComparator.DexClassInfo> classInfosInChangedClassesDex = collector.doCollect(oldDexGroup, newDexGroup);
        HashSet<Dex> owners = new HashSet<Dex>();
        HashMap<Dex, HashSet<String>> ownerToDescOfChangedClassesMap = new HashMap<Dex, HashSet<String>>();
        for (DexClassesComparator.DexClassInfo classInfo : classInfosInChangedClassesDex) {
            owners.add(classInfo.owner);
            HashSet<String> descOfChangedClasses = (Set)ownerToDescOfChangedClassesMap.get(classInfo.owner);
            if (descOfChangedClasses == null) {
                descOfChangedClasses = new HashSet<String>();
                ownerToDescOfChangedClassesMap.put(classInfo.owner, descOfChangedClasses);
            }
            descOfChangedClasses.add(classInfo.classDesc);
        }
        StringBuilder metaBuilder = new StringBuilder();
        int changedDexId = 1;
        for (Dex dex : owners) {
            Object classDef2;
            Set descOfChangedClassesInCurrDex = (Set)ownerToDescOfChangedClassesMap.get(dex);
            DexBackedDexFile dexFile = new DexBackedDexFile(Opcodes.forApi((int)20), dex.getBytes());
            boolean isCurrentDexHasChangedClass = false;
            for (Object classDef2 : dexFile.getClasses()) {
                if (!descOfChangedClassesInCurrDex.contains(classDef2.getType())) continue;
                isCurrentDexHasChangedClass = true;
                break;
            }
            if (!isCurrentDexHasChangedClass) continue;
            DexBuilder dexBuilder = new DexBuilder(Opcodes.forApi((int)23));
            classDef2 = dexFile.getClasses().iterator();
            while (classDef2.hasNext()) {
                org.jf.dexlib2.iface.ClassDef classDef3 = (org.jf.dexlib2.iface.ClassDef)classDef2.next();
                if (!descOfChangedClassesInCurrDex.contains(classDef3.getType())) continue;
                Logger.d("Class %s will be added into changed classes dex ...", classDef3.getType());
                ArrayList<BuilderField> builderFields = new ArrayList<BuilderField>();
                for (Field field : classDef3.getFields()) {
                    BuilderField builderField = dexBuilder.internField(field.getDefiningClass(), field.getName(), field.getType(), field.getAccessFlags(), field.getInitialValue(), field.getAnnotations());
                    builderFields.add(builderField);
                }
                ArrayList<BuilderMethod> builderMethods = new ArrayList<BuilderMethod>();
                for (Method method : classDef3.getMethods()) {
                    MethodImplementation methodImpl = method.getImplementation();
                    if (methodImpl != null) {
                        methodImpl = new BuilderMutableMethodImplementation(dexBuilder, methodImpl);
                    }
                    BuilderMethod builderMethod = dexBuilder.internMethod(method.getDefiningClass(), method.getName(), method.getParameters(), method.getReturnType(), method.getAccessFlags(), method.getAnnotations(), methodImpl);
                    builderMethods.add(builderMethod);
                }
                dexBuilder.internClassDef(classDef3.getType(), classDef3.getAccessFlags(), classDef3.getSuperclass(), classDef3.getInterfaces(), classDef3.getSourceFile(), classDef3.getAnnotations(), builderFields, builderMethods);
            }
            String changedDexName = null;
            changedDexName = changedDexId == 1 ? "classes.dex" : "classes" + changedDexId + ".dex";
            File dest = new File(this.config.mTempResultDir + "/" + changedDexName);
            FileDataStore fileDataStore = new FileDataStore(dest);
            dexBuilder.writeTo((DexDataStore)fileDataStore);
            String md5 = MD5.getMD5(dest);
            this.appendMetaLine(metaBuilder, changedDexName, "", md5, md5, 0, 0, 0, dexMode);
            ++changedDexId;
        }
        String meta = metaBuilder.toString();
        Logger.d("\nDexDecoder:write changed classes dex meta file data:\n%s", meta);
        this.metaWriter.writeLineToInfoFile(meta);
    }

    private void appendMetaLine(StringBuilder sb, Object ... vals) {
        if (vals == null || vals.length == 0) {
            return;
        }
        boolean isFirstItem = true;
        for (Object val : vals) {
            if (isFirstItem) {
                isFirstItem = false;
            } else {
                sb.append(',');
            }
            sb.append(val);
        }
        sb.append('\n');
    }

    private void generatePatchInfoFile() throws IOException {
        this.generatePatchedDexInfoFile();
        this.logDexesToDexMeta();
        this.checkCrossDexMovingClasses();
    }

    private void logDexesToDexMeta() throws IOException {
        File oldDexFile;
        HashMap<String, File> dexNameToClassNOldDexFileMap = new HashMap<String, File>();
        HashSet<File> realClassNDexFiles = new HashSet<File>();
        for (AbstractMap.SimpleEntry<File, File> oldAndNewDexFilePair : this.oldAndNewDexFilePairList) {
            File oldFile = oldAndNewDexFilePair.getKey();
            String dexName = this.getRelativeDexName(oldFile, null);
            if (!this.isDexNameMatchesClassNPattern(dexName)) continue;
            dexNameToClassNOldDexFileMap.put(dexName, oldFile);
        }
        for (int i = 0; i < dexNameToClassNOldDexFileMap.size(); ++i) {
            String expectedDexName;
            String string = expectedDexName = i == 0 ? "classes.dex" : "classes" + (i + 1) + ".dex";
            if (!dexNameToClassNOldDexFileMap.containsKey(expectedDexName)) break;
            oldDexFile = (File)dexNameToClassNOldDexFileMap.get(expectedDexName);
            realClassNDexFiles.add(oldDexFile);
        }
        for (AbstractMap.SimpleEntry<File, File> oldAndNewDexFilePair : this.oldAndNewDexFilePairList) {
            oldDexFile = oldAndNewDexFilePair.getKey();
            File newDexFile = oldAndNewDexFilePair.getValue();
            String dexName = this.getRelativeDexName(oldDexFile, newDexFile);
            RelatedInfo relatedInfo = this.dexNameToRelatedInfoMap.get(dexName);
            if (!relatedInfo.oldMd5.equals(relatedInfo.newMd5)) {
                this.logToDexMeta(newDexFile, oldDexFile, relatedInfo.dexDiffFile, relatedInfo.newOrFullPatchedMd5, relatedInfo.newOrFullPatchedMd5, relatedInfo.dexDiffMd5, relatedInfo.newOrFullPatchedCRC);
                continue;
            }
            if (!realClassNDexFiles.contains(oldDexFile)) continue;
            if (this.config.mRemoveLoaderForAllDex || dexName.equals("classes.dex")) {
                if (this.config.mRemoveLoaderForAllDex) {
                    Logger.d("\nDo additional diff on every dex to remove loader classes in it, because removeLoaderForAllDex = true");
                } else {
                    Logger.d("\nDo additional diff on main dex to remove loader classes in it.");
                }
                this.diffDexPairAndFillRelatedInfo(oldDexFile, newDexFile, relatedInfo);
                this.logToDexMeta(newDexFile, oldDexFile, relatedInfo.dexDiffFile, relatedInfo.newOrFullPatchedMd5, relatedInfo.newOrFullPatchedMd5, relatedInfo.dexDiffMd5, relatedInfo.newOrFullPatchedCRC);
                continue;
            }
            this.logToDexMeta(newDexFile, oldDexFile, null, "0", relatedInfo.oldMd5, "0", relatedInfo.newOrFullPatchedCRC);
        }
    }

    private void generatePatchedDexInfoFile() throws IOException {
        for (AbstractMap.SimpleEntry<File, File> oldAndNewDexFilePair : this.oldAndNewDexFilePairList) {
            File oldFile = oldAndNewDexFilePair.getKey();
            File newFile = oldAndNewDexFilePair.getValue();
            String dexName = this.getRelativeDexName(oldFile, newFile);
            RelatedInfo relatedInfo = this.dexNameToRelatedInfoMap.get(dexName);
            if (!relatedInfo.oldMd5.equals(relatedInfo.newMd5)) {
                this.diffDexPairAndFillRelatedInfo(oldFile, newFile, relatedInfo);
                continue;
            }
            relatedInfo.newOrFullPatchedFile = newFile;
            relatedInfo.newOrFullPatchedMd5 = relatedInfo.newMd5;
            relatedInfo.newOrFullPatchedCRC = FileOperation.getFileCrc32(newFile);
        }
    }

    private void diffDexPairAndFillRelatedInfo(File oldDexFile, File newDexFile, RelatedInfo relatedInfo) {
        File tempFullPatchDexPath = new File(this.config.mOutFolder + File.separator + "tempPatchedDexes");
        String dexName = this.getRelativeDexName(oldDexFile, newDexFile);
        File dexDiffOut = this.getOutputPath(newDexFile).toFile();
        this.ensureDirectoryExist(dexDiffOut.getParentFile());
        try {
            DexPatchGenerator dexPatchGen = new DexPatchGenerator(oldDexFile, newDexFile);
            dexPatchGen.setAdditionalRemovingClassPatterns(this.config.mDexLoaderPattern);
            this.logWriter.writeLineToInfoFile(String.format("Start diff between [%s] as old and [%s] as new:", this.getRelativeStringBy(oldDexFile, this.config.mTempUnzipOldDir), this.getRelativeStringBy(newDexFile, this.config.mTempUnzipNewDir)));
            dexPatchGen.executeAndSaveTo(dexDiffOut);
        }
        catch (Exception e) {
            throw new TinkerPatchException(e);
        }
        if (!dexDiffOut.exists()) {
            throw new TinkerPatchException("can not find the diff file:" + dexDiffOut.getAbsolutePath());
        }
        relatedInfo.dexDiffFile = dexDiffOut;
        relatedInfo.dexDiffMd5 = MD5.getMD5(dexDiffOut);
        Logger.d("\nGen %s patch file:%s, size:%d, md5:%s", dexName, relatedInfo.dexDiffFile.getAbsolutePath(), relatedInfo.dexDiffFile.length(), relatedInfo.dexDiffMd5);
        File tempFullPatchedDexFile = new File(tempFullPatchDexPath, dexName);
        if (!tempFullPatchedDexFile.exists()) {
            this.ensureDirectoryExist(tempFullPatchedDexFile.getParentFile());
        }
        try {
            new DexPatchApplier(oldDexFile, dexDiffOut).executeAndSaveTo(tempFullPatchedDexFile);
            Logger.d(String.format("Verifying if patched new dex is logically the same as original new dex: %s ...", this.getRelativeStringBy(newDexFile, this.config.mTempUnzipNewDir)));
            Dex origNewDex = new Dex(newDexFile);
            Dex patchedNewDex = new Dex(tempFullPatchedDexFile);
            this.checkDexChange(origNewDex, patchedNewDex);
            relatedInfo.newOrFullPatchedFile = tempFullPatchedDexFile;
            relatedInfo.newOrFullPatchedMd5 = MD5.getMD5(tempFullPatchedDexFile);
            relatedInfo.newOrFullPatchedCRC = FileOperation.getFileCrc32(tempFullPatchedDexFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TinkerPatchException("Failed to generate temporary patched dex, which makes MD5 generating procedure of new dex failed, either.", e);
        }
        if (!tempFullPatchedDexFile.exists()) {
            throw new TinkerPatchException("can not find the temporary full patched dex file:" + tempFullPatchedDexFile.getAbsolutePath());
        }
        Logger.d("\nGen %s for dalvik full dex file:%s, size:%d, md5:%s", dexName, tempFullPatchedDexFile.getAbsolutePath(), tempFullPatchedDexFile.length(), relatedInfo.newOrFullPatchedMd5);
    }

    private void addTestDex() throws IOException {
        String dexMode = "jar";
        if (this.config.mDexRaw) {
            dexMode = "raw";
        }
        InputStream is = DexDiffDecoder.class.getResourceAsStream("/test.dex");
        String md5 = MD5.getMD5(is, 1024);
        is.close();
        String meta = "test.dex,," + md5 + "," + md5 + "," + 0 + "," + 0 + "," + 0 + "," + dexMode;
        File dest = new File(this.config.mTempResultDir + "/" + TEST_DEX_NAME);
        FileOperation.copyResourceUsingStream(TEST_DEX_NAME, dest);
        Logger.d("\nAdd test install result dex: %s, size:%d", dest.getAbsolutePath(), dest.length());
        Logger.d("DexDecoder:write test dex meta file data: %s", meta);
        this.metaWriter.writeLineToInfoFile(meta);
    }

    private void checkCrossDexMovingClasses() {
        HashSet<String> deletedClassDescs = new HashSet<String>(this.deletedClassDescToDexNameMap.keySet());
        HashSet<String> addedClassDescs = new HashSet<String>(this.addedClassDescToDexNameMap.keySet());
        deletedClassDescs.retainAll(addedClassDescs);
        HashSet<String> movedCrossFilesClassDescs = deletedClassDescs;
        if (!movedCrossFilesClassDescs.isEmpty()) {
            Logger.e("Warning:Class Moved. Some classes are just moved from one dex to another. This behavior may leads to unnecessary enlargement of patch file. you should try to check them:");
            for (String classDesc : movedCrossFilesClassDescs) {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                sb.append("classDesc:").append(classDesc).append(',');
                sb.append("from:").append(this.deletedClassDescToDexNameMap.get(classDesc)).append(',');
                sb.append("to:").append(this.addedClassDescToDexNameMap.get(classDesc));
                sb.append('}');
                Logger.e(sb.toString());
            }
        }
    }

    private void collectAddedOrDeletedClasses(File oldFile, File newFile) throws IOException {
        Dex oldDex = new Dex(oldFile);
        Dex newDex = new Dex(newFile);
        HashSet oldClassDescs = new HashSet();
        for (Object oldClassDef : oldDex.classDefs()) {
            oldClassDescs.add(oldDex.typeNames().get(((ClassDef)oldClassDef).typeIndex));
        }
        HashSet newClassDescs = new HashSet();
        for (ClassDef newClassDef : newDex.classDefs()) {
            newClassDescs.add(newDex.typeNames().get(newClassDef.typeIndex));
        }
        HashSet addedClassDescs = new HashSet(newClassDescs);
        addedClassDescs.removeAll(oldClassDescs);
        HashSet deletedClassDescs = new HashSet(oldClassDescs);
        deletedClassDescs.removeAll(newClassDescs);
        for (String addedClassDesc : addedClassDescs) {
            if (this.addedClassDescToDexNameMap.containsKey(addedClassDesc)) {
                throw new TinkerPatchException(String.format("Class Duplicate. Class [%s] is added in both new dex: [%s] and [%s]. Please check your newly apk.", addedClassDesc, this.addedClassDescToDexNameMap.get(addedClassDesc), newFile.toString()));
            }
            this.addedClassDescToDexNameMap.put(addedClassDesc, newFile.toString());
        }
        for (String deletedClassDesc : deletedClassDescs) {
            if (this.deletedClassDescToDexNameMap.containsKey(deletedClassDesc)) {
                throw new TinkerPatchException(String.format("Class Duplicate. Class [%s] is deleted in both old dex: [%s] and [%s]. Please check your base apk.", deletedClassDesc, this.addedClassDescToDexNameMap.get(deletedClassDesc), oldFile.toString()));
            }
            this.deletedClassDescToDexNameMap.put(deletedClassDesc, newFile.toString());
        }
    }

    private boolean isDexNameMatchesClassNPattern(String dexName) {
        return dexName.matches("^classes[0-9]*\\.dex$");
    }

    private void copyNewDexAndLogToDexMeta(File newFile, String newMd5, File output) throws IOException {
        FileOperation.copyFileUsingStream(newFile, output);
        long newFileCrc = FileOperation.getFileCrc32(newFile);
        this.logToDexMeta(newFile, null, null, newMd5, newMd5, "0", newFileCrc);
    }

    private void checkDexChange(Dex originDex, Dex newDex) {
        DexClassesComparator classesCmptor = new DexClassesComparator("*");
        classesCmptor.setIgnoredRemovedClassDescPattern(this.config.mDexLoaderPattern);
        classesCmptor.startCheck(originDex, newDex);
        List<DexClassesComparator.DexClassInfo> addedClassInfos = classesCmptor.getAddedClassInfos();
        boolean isNoClassesAdded = addedClassInfos.isEmpty();
        if (!isNoClassesAdded) {
            throw new TinkerPatchException("some classes was unexpectedly added in patched new dex, check if there's any bugs in patch algorithm. Related classes: " + Utils.collectionToString(addedClassInfos));
        }
        Map<String, DexClassesComparator.DexClassInfo[]> changedClassDescToClassInfosMap = classesCmptor.getChangedClassDescToInfosMap();
        boolean isNoClassesChanged = changedClassDescToClassInfosMap.isEmpty();
        if (isNoClassesChanged) {
            List<DexClassesComparator.DexClassInfo> deletedClassInfos = classesCmptor.getDeletedClassInfos();
            if (!deletedClassInfos.isEmpty()) {
                throw new TinkerPatchException("some classes that are not matched to loader class pattern was unexpectedly deleted in patched new dex, check if there's any bugs in patch algorithm. Related classes: " + Utils.collectionToString(deletedClassInfos));
            }
        } else {
            throw new TinkerPatchException("some classes was unexpectedly changed in patched new dex, check if there's any bugs in patch algorithm. Related classes: " + Utils.collectionToString(changedClassDescToClassInfosMap.keySet()));
        }
    }

    protected void logToDexMeta(File newFile, File oldFile, File dexDiffFile, String destMd5InDvm, String destMd5InArt, String dexDiffMd5, long newOrFullPatchedCrc) {
        if (this.metaWriter == null && this.logWriter == null) {
            return;
        }
        String parentRelative = this.getParentRelativePathStringToNewFile(newFile);
        String relative = this.getRelativePathStringToNewFile(newFile);
        if (this.metaWriter != null) {
            String oldCrc;
            String fileName = newFile.getName();
            String dexMode = "jar";
            if (this.config.mDexRaw) {
                dexMode = "raw";
            }
            if (oldFile == null) {
                oldCrc = "0";
                Logger.d("DexDecoder:add newly dex file: %s", parentRelative);
            } else {
                oldCrc = FileOperation.getZipEntryCrc(this.config.mOldApkFile, relative);
                if (oldCrc == null || oldCrc.equals("0")) {
                    throw new TinkerPatchException(String.format("can't find zipEntry %s from old apk file %s", relative, this.config.mOldApkFile.getPath()));
                }
            }
            String meta = fileName + "," + parentRelative + "," + destMd5InDvm + "," + destMd5InArt + "," + dexDiffMd5 + "," + oldCrc + "," + newOrFullPatchedCrc + "," + dexMode;
            Logger.d("DexDecoder:write meta file data: %s", meta);
            this.metaWriter.writeLineToInfoFile(meta);
        }
        if (this.logWriter != null) {
            String log = relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newFile) + ", diffSize=" + FileOperation.getFileSizes(dexDiffFile);
            this.logWriter.writeLineToInfoFile(log);
        }
    }

    @Override
    public void clean() {
        this.metaWriter.close();
        this.logWriter.close();
    }

    private String getRawOrWrappedDexMD5(File dexOrJarFile) {
        String name = dexOrJarFile.getName();
        if (name.endsWith(".dex")) {
            return MD5.getMD5(dexOrJarFile);
        }
        JarFile dexJar = null;
        try {
            dexJar = new JarFile(dexOrJarFile);
            ZipEntry classesDex = dexJar.getEntry("classes.dex");
            if (classesDex == null) {
                throw new TinkerPatchException(String.format("Jar file %s do not contain 'classes.dex', it is not a correct dex jar file!", dexOrJarFile.getAbsolutePath()));
            }
            String string = MD5.getMD5(dexJar.getInputStream(classesDex), 102400);
            return string;
        }
        catch (IOException e) {
            throw new TinkerPatchException(String.format("File %s is not end with '.dex', but it is not a correct dex jar file !", dexOrJarFile.getAbsolutePath()), e);
        }
        finally {
            if (dexJar != null) {
                try {
                    dexJar.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getRelativeStringBy(File file, File reference) {
        File actualReference = reference.getParentFile();
        if (actualReference == null) {
            actualReference = reference;
        }
        return actualReference.toPath().relativize(file.toPath()).toString().replace("\\", "/");
    }

    private void ensureDirectoryExist(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new TinkerPatchException("failed to create directory: " + dir);
        }
    }

    private final class DexPatcherLoggerBridge
    implements DexPatcherLogger.IDexPatcherLogger {
        private final InfoWriter logWriter;

        DexPatcherLoggerBridge(InfoWriter logWritter) {
            this.logWriter = logWritter;
        }

        public void v(String msg) {
            this.logWriter.writeLineToInfoFile(msg);
        }

        public void d(String msg) {
            this.logWriter.writeLineToInfoFile(msg);
        }

        public void i(String msg) {
            this.logWriter.writeLineToInfoFile(msg);
        }

        public void w(String msg) {
            this.logWriter.writeLineToInfoFile(msg);
        }

        public void e(String msg) {
            this.logWriter.writeLineToInfoFile(msg);
        }
    }

    private final class RelatedInfo {
        File newOrFullPatchedFile = null;
        File dexDiffFile = null;
        String oldMd5 = "0";
        String newMd5 = "0";
        String dexDiffMd5 = "0";
        String newOrFullPatchedMd5 = "0";
        long newOrFullPatchedCRC = 0L;

        private RelatedInfo() {
        }
    }
}

