/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.patch;

import com.tencent.tinker.build.patch.InputParam;
import com.tencent.tinker.build.util.FileOperation;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import com.tencent.tinker.commons.util.IOHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Configuration {
    protected static final String TAG_ISSUE = "issue";
    protected static final String DEX_ISSUE = "dex";
    protected static final String SO_ISSUE = "lib";
    protected static final String RES_ISSUE = "resource";
    protected static final String ARKHOT_ISSUE = "arkHot";
    protected static final String SIGN_ISSUE = "sign";
    protected static final String PACKAGE_CONFIG_ISSUE = "packageConfig";
    protected static final String PROPERTY_ISSUE = "property";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_IGNORE_WARNING = "ignoreWarning";
    protected static final String ATTR_ALLOW_LOADER_IN_ANY_DEX = "allowLoaderInAnyDex";
    protected static final String ATTR_REMOVE_LOADER_FOR_ALL_DEX = "removeLoaderForAllDex";
    protected static final String ATTR_IS_PROTECTED_APP = "isProtectedApp";
    protected static final String ATTR_SUPPORT_HOTPLUG_COMPONENT = "supportHotplugComponent";
    protected static final String ATTR_USE_SIGN = "useSign";
    protected static final String ATTR_SEVEN_ZIP_PATH = "sevenZipPath";
    protected static final String ATTR_DEX_MODE = "dexMode";
    protected static final String ATTR_PATTERN = "pattern";
    protected static final String ATTR_IGNORE_CHANGE = "ignoreChange";
    protected static final String ATTR_IGNORE_CHANGE_WARNING = "ignoreChangeWarning";
    protected static final String ATTR_RES_LARGE_MOD = "largeModSize";
    protected static final String ATTR_ARKHOT_PATH = "path";
    protected static final String ATTR_ARKHOT_NAME = "name";
    protected static final String ATTR_LOADER = "loader";
    protected static final String ATTR_CONFIG_FIELD = "configField";
    protected static final String ATTR_SIGN_FILE_PATH = "path";
    protected static final String ATTR_SIGN_FILE_KEYPASS = "keypass";
    protected static final String ATTR_SIGN_FILE_STOREPASS = "storepass";
    protected static final String ATTR_SIGN_FILE_ALIAS = "alias";
    public String mOldApkPath;
    public String mNewApkPath;
    public String mOutFolder;
    public File mOldApkFile;
    public File mNewApkFile;
    public boolean mIgnoreWarning;
    public boolean mAllowLoaderInAnyDex;
    public boolean mIsProtectedApp;
    public boolean mRemoveLoaderForAllDex;
    public boolean mSupportHotplugComponent;
    public HashSet<Pattern> mSoFilePattern;
    public HashSet<Pattern> mDexFilePattern;
    public HashSet<String> mDexLoaderPattern;
    public HashSet<String> mDexIgnoreWarningLoaderPattern;
    public boolean mDexRaw;
    public HashSet<Pattern> mResFilePattern;
    public HashSet<Pattern> mResIgnoreChangePattern;
    public HashSet<Pattern> mResIgnoreChangeWarningPattern;
    public HashSet<String> mResRawPattern;
    public int mLargeModSize;
    public boolean mUseApplyResource;
    public HashMap<String, String> mPackageFields;
    public String mSevenZipPath;
    public boolean mUseSignAPk;
    public File mSignatureFile;
    public String mKeyPass;
    public String mStoreAlias;
    public String mStorePass;
    public File mTempResultDir;
    public File mTempUnzipOldDir;
    public File mTempUnzipNewDir;
    public boolean mUsingGradle;
    public String mArkHotPatchPath;
    public String mArkHotPatchName;

    public Configuration(File config, File outputFile, File oldApkFile, File newApkFile) throws IOException, ParserConfigurationException, SAXException, TinkerPatchException {
        this.mUsingGradle = false;
        this.mSoFilePattern = new HashSet();
        this.mDexFilePattern = new HashSet();
        this.mDexLoaderPattern = new HashSet();
        this.mDexIgnoreWarningLoaderPattern = new HashSet();
        this.mResFilePattern = new HashSet();
        this.mResRawPattern = new HashSet();
        this.mResIgnoreChangePattern = new HashSet();
        this.mResIgnoreChangeWarningPattern = new HashSet();
        this.mPackageFields = new HashMap();
        this.mOutFolder = outputFile.getAbsolutePath();
        FileOperation.cleanDir(outputFile);
        this.mOldApkFile = oldApkFile;
        this.mOldApkPath = oldApkFile.getAbsolutePath();
        this.mNewApkFile = newApkFile;
        this.mNewApkPath = newApkFile.getAbsolutePath();
        this.mLargeModSize = 100;
        this.readXmlConfig(config);
        this.createTempDirectory();
        this.checkInputPatternParameter();
    }

    public Configuration(InputParam param) throws IOException, TinkerPatchException {
        this.mUsingGradle = true;
        this.mSoFilePattern = new HashSet();
        this.mDexFilePattern = new HashSet();
        this.mDexLoaderPattern = new HashSet();
        this.mDexIgnoreWarningLoaderPattern = new HashSet();
        this.mResFilePattern = new HashSet();
        this.mResRawPattern = new HashSet();
        this.mResIgnoreChangePattern = new HashSet();
        this.mResIgnoreChangeWarningPattern = new HashSet();
        this.mPackageFields = new HashMap();
        for (String item : param.soFilePattern) {
            this.addToPatterns(item, this.mSoFilePattern);
        }
        for (String item : param.dexFilePattern) {
            this.addToPatterns(item, this.mDexFilePattern);
        }
        for (String item : param.resourceFilePattern) {
            this.mResRawPattern.add(item);
            this.addToPatterns(item, this.mResFilePattern);
        }
        for (String item : param.resourceIgnoreChangePattern) {
            this.addToPatterns(item, this.mResIgnoreChangePattern);
        }
        for (String item : param.resourceIgnoreChangeWarningPattern) {
            this.addToPatterns(item, this.mResIgnoreChangeWarningPattern);
        }
        this.mLargeModSize = param.largeModSize;
        this.mUseApplyResource = param.useApplyResource;
        this.mDexLoaderPattern.addAll(param.dexLoaderPattern);
        this.mDexIgnoreWarningLoaderPattern.addAll(param.dexIgnoreWarningLoaderPattern);
        if (param.dexMode.equals("raw")) {
            this.mDexRaw = true;
        }
        this.mOldApkPath = param.oldApk;
        this.mOldApkFile = new File(this.mOldApkPath);
        this.mNewApkPath = param.newApk;
        this.mNewApkFile = new File(this.mNewApkPath);
        this.mOutFolder = param.outFolder;
        this.mIgnoreWarning = param.ignoreWarning;
        this.mAllowLoaderInAnyDex = param.allowLoaderInAnyDex;
        this.mRemoveLoaderForAllDex = param.removeLoaderForAllDex;
        this.mIsProtectedApp = param.isProtectedApp;
        this.mSupportHotplugComponent = param.supportHotplugComponent;
        this.mSevenZipPath = param.sevenZipPath;
        this.mPackageFields = param.configFields;
        this.mUseSignAPk = param.useSign;
        this.setSignData(param.signFile, param.keypass, param.storealias, param.storepass);
        FileOperation.cleanDir(new File(this.mOutFolder));
        this.createTempDirectory();
        this.checkInputPatternParameter();
        this.mArkHotPatchName = param.arkHotPatchName;
        this.mArkHotPatchPath = param.arkHotPatchPath;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("configuration: \n");
        sb.append("oldApk:" + this.mOldApkPath + "\n");
        sb.append("newApk:" + this.mNewApkPath + "\n");
        sb.append("outputFolder:" + this.mOutFolder + "\n");
        sb.append("isIgnoreWarning:" + this.mIgnoreWarning + "\n");
        sb.append("isAllowLoaderClassInAnyDex:" + this.mAllowLoaderInAnyDex + "\n");
        sb.append("isRemoveLoaderForAllDex:" + this.mRemoveLoaderForAllDex + "\n");
        sb.append("isProtectedApp:" + this.mIsProtectedApp + "\n");
        sb.append("7-ZipPath:" + this.mSevenZipPath + "\n");
        sb.append("useSignAPk:" + this.mUseSignAPk + "\n");
        sb.append("package meta fields: \n");
        for (String string : this.mPackageFields.keySet()) {
            sb.append("filed name:" + string + ", filed value:" + this.mPackageFields.get(string) + "\n");
        }
        sb.append("dex configs: \n");
        if (this.mDexRaw) {
            sb.append("dexMode: raw\n");
        } else {
            sb.append("dexMode: jar\n");
        }
        for (Pattern pattern : this.mDexFilePattern) {
            sb.append("dexPattern:" + pattern.toString() + "\n");
        }
        for (String string : this.mDexLoaderPattern) {
            sb.append("dex loader:" + string + "\n");
        }
        for (String string : this.mDexIgnoreWarningLoaderPattern) {
            sb.append("dex ignore warning loader:" + string.toString() + "\n");
        }
        sb.append("lib configs: \n");
        for (Pattern pattern : this.mSoFilePattern) {
            sb.append("libPattern:" + pattern.toString() + "\n");
        }
        sb.append("resource configs: \n");
        for (Pattern pattern : this.mResFilePattern) {
            sb.append("resPattern:" + pattern.toString() + "\n");
        }
        for (Pattern pattern : this.mResIgnoreChangePattern) {
            sb.append("resIgnore change:" + pattern.toString() + "\n");
        }
        for (Pattern pattern : this.mResIgnoreChangeWarningPattern) {
            sb.append("resIgnore change warning:" + pattern.toString() + "\n");
        }
        sb.append("largeModSize:" + this.mLargeModSize + "kb\n");
        sb.append("useApplyResource:" + this.mUseApplyResource + "\n");
        sb.append("ArkHot: " + this.mArkHotPatchPath + " / " + this.mArkHotPatchName + "\n");
        return sb.toString();
    }

    private void createTempDirectory() throws TinkerPatchException {
        String oldApkName;
        this.mTempResultDir = new File(this.mOutFolder + File.separator + "tinker_result");
        FileOperation.deleteDir(this.mTempResultDir);
        if (!this.mTempResultDir.exists()) {
            this.mTempResultDir.mkdir();
        }
        if (!(oldApkName = this.mOldApkFile.getName()).endsWith(".apk")) {
            throw new TinkerPatchException(String.format("input apk file path must end with .apk, yours %s\n", oldApkName));
        }
        String newApkName = this.mNewApkFile.getName();
        if (!newApkName.endsWith(".apk")) {
            throw new TinkerPatchException(String.format("input apk file path must end with .apk, yours %s\n", newApkName));
        }
        String tempOldName = oldApkName.substring(0, oldApkName.indexOf(".apk"));
        String tempNewName = newApkName.substring(0, newApkName.indexOf(".apk"));
        if (tempNewName.equalsIgnoreCase(tempOldName)) {
            tempOldName = tempOldName + "-old";
            tempNewName = tempNewName + "-new";
        }
        this.mTempUnzipOldDir = new File(this.mOutFolder, tempOldName);
        this.mTempUnzipNewDir = new File(this.mOutFolder, tempNewName);
    }

    public void setSignData(File signatureFile, String keypass, String storealias, String storepass) throws IOException {
        if (this.mUseSignAPk) {
            this.mSignatureFile = signatureFile;
            if (!this.mSignatureFile.exists()) {
                throw new IOException(String.format("the signature file do not exit, raw path= %s\n", this.mSignatureFile.getAbsolutePath()));
            }
            this.mKeyPass = keypass;
            this.mStoreAlias = storealias;
            this.mStorePass = storepass;
        }
    }

    private void checkInputPatternParameter() throws TinkerPatchException {
        if (this.mSoFilePattern.isEmpty() && this.mDexFilePattern.isEmpty() && this.mResFilePattern.isEmpty()) {
            throw new TinkerPatchException("no dex, so or resource pattern are found");
        }
        if (this.mLargeModSize <= 0) {
            throw new TinkerPatchException("largeModSize must be larger than 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readXmlConfig(File xmlConfigFile) throws IOException, ParserConfigurationException, SAXException {
        if (!xmlConfigFile.exists()) {
            return;
        }
        System.out.printf("reading config file, %s\n", xmlConfigFile.getAbsolutePath());
        BufferedInputStream input = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            input = new BufferedInputStream(new FileInputStream(xmlConfigFile));
            InputSource source = new InputSource(input);
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource();
                }
            });
            Document document = builder.parse(source);
            NodeList issues = document.getElementsByTagName(TAG_ISSUE);
            int count = issues.getLength();
            for (int i = 0; i < count; ++i) {
                Node node = issues.item(i);
                Element element = (Element)node;
                String id = element.getAttribute(ATTR_ID);
                if (id.length() == 0) {
                    System.err.println("Invalid config file: Missing required issue id attribute");
                    continue;
                }
                if (id.equals(PROPERTY_ISSUE)) {
                    this.readPropertyFromXml(node);
                    continue;
                }
                if (id.equals(DEX_ISSUE)) {
                    this.readDexPatternsFromXml(node);
                    continue;
                }
                if (id.equals(SO_ISSUE)) {
                    this.readLibPatternsFromXml(node);
                    continue;
                }
                if (id.equals(RES_ISSUE)) {
                    this.readResPatternsFromXml(node);
                    continue;
                }
                if (id.equals(PACKAGE_CONFIG_ISSUE)) {
                    this.readPackageConfigFromXml(node);
                    continue;
                }
                if (id.equals(SIGN_ISSUE)) {
                    if (!this.mUseSignAPk) continue;
                    this.readSignFromXml(node);
                    continue;
                }
                if (id.equals(ARKHOT_ISSUE)) {
                    this.readArkHotPropertyFromXml(node);
                    continue;
                }
                System.err.println("unknown issue " + id);
            }
        }
        catch (Throwable throwable) {
            IOHelper.closeQuietly(input);
            throw throwable;
        }
        IOHelper.closeQuietly((Object)input);
    }

    private void readPropertyFromXml(Node node) throws IOException {
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            int n = childNodes.getLength();
            for (int j = 0; j < n; ++j) {
                Node child = childNodes.item(j);
                if (child.getNodeType() != 1) continue;
                Element check = (Element)child;
                String tagName = check.getTagName();
                String value = check.getAttribute(ATTR_VALUE);
                if (value.length() == 0) {
                    throw new IOException(String.format("Invalid config file: Missing required attribute %s\n", ATTR_VALUE));
                }
                if (tagName.equals(ATTR_IGNORE_WARNING)) {
                    this.mIgnoreWarning = value.equals("true");
                    continue;
                }
                if (tagName.equals(ATTR_ALLOW_LOADER_IN_ANY_DEX)) {
                    this.mAllowLoaderInAnyDex = value.equals("true");
                    continue;
                }
                if (tagName.equals(ATTR_REMOVE_LOADER_FOR_ALL_DEX)) {
                    this.mRemoveLoaderForAllDex = value.equals("true");
                    continue;
                }
                if (tagName.equals(ATTR_IS_PROTECTED_APP)) {
                    this.mIsProtectedApp = value.equals("true");
                    continue;
                }
                if (tagName.equals(ATTR_SUPPORT_HOTPLUG_COMPONENT)) {
                    this.mSupportHotplugComponent = value.equals("true");
                    continue;
                }
                if (tagName.equals(ATTR_USE_SIGN)) {
                    this.mUseSignAPk = value.equals("true");
                    continue;
                }
                if (tagName.equals(ATTR_SEVEN_ZIP_PATH)) {
                    File sevenZipFile = new File(value);
                    if (sevenZipFile.exists()) {
                        this.mSevenZipPath = value;
                        continue;
                    }
                    this.mSevenZipPath = "7za";
                    continue;
                }
                System.err.println("unknown property tag " + tagName);
            }
        }
    }

    private void readArkHotPropertyFromXml(Node node) throws IOException {
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            int n = childNodes.getLength();
            for (int j = 0; j < n; ++j) {
                Node child = childNodes.item(j);
                if (child.getNodeType() != 1) continue;
                Element check = (Element)child;
                String tagName = check.getTagName();
                String value = check.getAttribute(ATTR_VALUE);
                if (tagName.equals("path")) {
                    this.mArkHotPatchPath = value;
                    this.mArkHotPatchPath.trim();
                    continue;
                }
                if (tagName.equals("name")) {
                    this.mArkHotPatchName = value;
                    this.mArkHotPatchName.trim();
                    continue;
                }
                System.err.println("unknown dex tag " + tagName);
            }
        }
    }

    private void readSignFromXml(Node node) throws IOException {
        if (this.mSignatureFile != null) {
            System.err.println("already set the sign info from command line, ignore this");
            return;
        }
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            int n = childNodes.getLength();
            for (int j = 0; j < n; ++j) {
                Node child = childNodes.item(j);
                if (child.getNodeType() != 1) continue;
                Element check = (Element)child;
                String tagName = check.getTagName();
                String value = check.getAttribute(ATTR_VALUE);
                if (value.length() == 0) {
                    throw new IOException(String.format("Invalid config file: Missing required attribute %s\n", ATTR_VALUE));
                }
                if (tagName.equals("path")) {
                    this.mSignatureFile = new File(value);
                    if (this.mSignatureFile.exists()) continue;
                    throw new IOException(String.format("the signature file do not exit, raw path= %s\n", this.mSignatureFile.getAbsolutePath()));
                }
                if (tagName.equals(ATTR_SIGN_FILE_STOREPASS)) {
                    this.mStorePass = value;
                    this.mStorePass = this.mStorePass.trim();
                    continue;
                }
                if (tagName.equals(ATTR_SIGN_FILE_KEYPASS)) {
                    this.mKeyPass = value;
                    this.mKeyPass = this.mKeyPass.trim();
                    continue;
                }
                if (tagName.equals(ATTR_SIGN_FILE_ALIAS)) {
                    this.mStoreAlias = value;
                    this.mStoreAlias = this.mStoreAlias.trim();
                    continue;
                }
                System.err.println("unknown sign tag " + tagName);
            }
        }
    }

    private void readDexPatternsFromXml(Node node) throws IOException {
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            int n = childNodes.getLength();
            for (int j = 0; j < n; ++j) {
                Node child = childNodes.item(j);
                if (child.getNodeType() != 1) continue;
                Element check = (Element)child;
                String tagName = check.getTagName();
                String value = check.getAttribute(ATTR_VALUE);
                if (tagName.equals(ATTR_DEX_MODE)) {
                    if (!value.equals("raw")) continue;
                    this.mDexRaw = true;
                    continue;
                }
                if (tagName.equals(ATTR_PATTERN)) {
                    this.addToPatterns(value, this.mDexFilePattern);
                    continue;
                }
                if (tagName.equals(ATTR_LOADER)) {
                    this.mDexLoaderPattern.add(value);
                    continue;
                }
                if (tagName.equals(ATTR_IGNORE_CHANGE)) {
                    this.mDexIgnoreWarningLoaderPattern.add(value);
                    continue;
                }
                System.err.println("unknown dex tag " + tagName);
            }
        }
    }

    private void readLibPatternsFromXml(Node node) throws IOException {
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            int n = childNodes.getLength();
            for (int j = 0; j < n; ++j) {
                Node child = childNodes.item(j);
                if (child.getNodeType() != 1) continue;
                Element check = (Element)child;
                String tagName = check.getTagName();
                String value = check.getAttribute(ATTR_VALUE);
                if (tagName.equals(ATTR_PATTERN)) {
                    this.addToPatterns(value, this.mSoFilePattern);
                    continue;
                }
                System.err.println("unknown dex tag " + tagName);
            }
        }
    }

    private void readResPatternsFromXml(Node node) throws IOException {
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            int n = childNodes.getLength();
            for (int j = 0; j < n; ++j) {
                Node child = childNodes.item(j);
                if (child.getNodeType() != 1) continue;
                Element check = (Element)child;
                String tagName = check.getTagName();
                String value = check.getAttribute(ATTR_VALUE);
                if (tagName.equals(ATTR_PATTERN)) {
                    this.mResRawPattern.add(value);
                    this.addToPatterns(value, this.mResFilePattern);
                    continue;
                }
                if (tagName.equals(ATTR_IGNORE_CHANGE)) {
                    if (Utils.isBlank(value)) continue;
                    this.addToPatterns(value, this.mResIgnoreChangePattern);
                    continue;
                }
                if (tagName.equals(ATTR_IGNORE_CHANGE_WARNING)) {
                    if (Utils.isBlank(value)) continue;
                    this.addToPatterns(value, this.mResIgnoreChangeWarningPattern);
                    continue;
                }
                if (tagName.equals(ATTR_RES_LARGE_MOD)) {
                    this.mLargeModSize = Integer.valueOf(value);
                    continue;
                }
                System.err.println("unknown dex tag " + tagName);
            }
        }
    }

    private void readPackageConfigFromXml(Node node) throws IOException {
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            int n = childNodes.getLength();
            for (int j = 0; j < n; ++j) {
                Node child = childNodes.item(j);
                if (child.getNodeType() != 1) continue;
                Element check = (Element)child;
                String tagName = check.getTagName();
                String value = check.getAttribute(ATTR_VALUE);
                String name = check.getAttribute("name");
                if (tagName.equals(ATTR_CONFIG_FIELD)) {
                    this.mPackageFields.put(name, value);
                    continue;
                }
                System.err.println("unknown package config tag " + tagName);
            }
        }
    }

    private void addToPatterns(String value, HashSet<Pattern> patterns) throws IOException {
        if (value.length() == 0) {
            throw new IOException(String.format("Invalid config file: Missing required attribute %s\n", ATTR_VALUE));
        }
        value = Utils.convertToPatternString(value);
        Pattern pattern = Pattern.compile(value);
        patterns.add(pattern);
    }
}

