/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.util;

import com.tencent.tinker.android.dex.Annotation;
import com.tencent.tinker.android.dex.AnnotationSet;
import com.tencent.tinker.android.dex.AnnotationSetRefList;
import com.tencent.tinker.android.dex.AnnotationsDirectory;
import com.tencent.tinker.android.dex.ClassData;
import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Code;
import com.tencent.tinker.android.dex.DebugInfoItem;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.EncodedValue;
import com.tencent.tinker.android.dex.EncodedValueReader;
import com.tencent.tinker.android.dex.FieldId;
import com.tencent.tinker.android.dex.MethodId;
import com.tencent.tinker.android.dex.ProtoId;
import com.tencent.tinker.android.dex.TypeList;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.android.dx.instruction.InstructionComparator;
import com.tencent.tinker.build.dexpatcher.util.PatternUtils;
import com.tencent.tinker.build.util.Utils;
import com.tencent.tinker.commons.dexpatcher.DexPatcherLogger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class DexClassesComparator {
    private static final String TAG = "DexClassesComparator";
    public static final int COMPARE_MODE_NORMAL = 0;
    public static final int COMPARE_MODE_REFERRER_AFFECTED_CHANGE_ONLY = 1;
    private static final int DBG_FIRST_SPECIAL = 10;
    private static final int DBG_LINE_BASE = -4;
    private static final int DBG_LINE_RANGE = 15;
    private int compareMode = 0;
    private final List<DexClassInfo> addedClassInfoList = new ArrayList<DexClassInfo>();
    private final List<DexClassInfo> deletedClassInfoList = new ArrayList<DexClassInfo>();
    private final Map<String, DexClassInfo[]> changedClassDescToClassInfosMap = new HashMap<String, DexClassInfo[]>();
    private final Set<Pattern> patternsOfClassDescToCheck = new HashSet<Pattern>();
    private final Set<Pattern> patternsOfIgnoredRemovedClassDesc = new HashSet<Pattern>();
    private final Set<String> oldDescriptorOfClassesToCheck = new HashSet<String>();
    private final Set<String> newDescriptorOfClassesToCheck = new HashSet<String>();
    private final Map<String, DexClassInfo> oldClassDescriptorToClassInfoMap = new HashMap<String, DexClassInfo>();
    private final Map<String, DexClassInfo> newClassDescriptorToClassInfoMap = new HashMap<String, DexClassInfo>();
    private final Set<String> refAffectedClassDescs = new HashSet<String>();
    private final DexPatcherLogger logger = new DexPatcherLogger();

    public DexClassesComparator(String patternStringOfClassDescToCheck) {
        this.patternsOfClassDescToCheck.add(Pattern.compile(PatternUtils.dotClassNamePatternToDescriptorRegEx(patternStringOfClassDescToCheck)));
    }

    public DexClassesComparator(String ... patternStringsOfClassDescToCheck) {
        for (String patternStr : patternStringsOfClassDescToCheck) {
            this.patternsOfClassDescToCheck.add(Pattern.compile(PatternUtils.dotClassNamePatternToDescriptorRegEx(patternStr)));
        }
    }

    public DexClassesComparator(Collection<String> patternStringsOfClassDescToCheck) {
        for (String patternStr : patternStringsOfClassDescToCheck) {
            this.patternsOfClassDescToCheck.add(Pattern.compile(PatternUtils.dotClassNamePatternToDescriptorRegEx(patternStr)));
        }
    }

    public void setIgnoredRemovedClassDescPattern(String ... patternStringsOfLoaderClassDesc) {
        this.patternsOfIgnoredRemovedClassDesc.clear();
        for (String patternStr : patternStringsOfLoaderClassDesc) {
            this.patternsOfIgnoredRemovedClassDesc.add(Pattern.compile(PatternUtils.dotClassNamePatternToDescriptorRegEx(patternStr)));
        }
    }

    public void setIgnoredRemovedClassDescPattern(Collection<String> patternStringsOfLoaderClassDesc) {
        this.patternsOfIgnoredRemovedClassDesc.clear();
        for (String patternStr : patternStringsOfLoaderClassDesc) {
            this.patternsOfIgnoredRemovedClassDesc.add(Pattern.compile(PatternUtils.dotClassNamePatternToDescriptorRegEx(patternStr)));
        }
    }

    public void setCompareMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("bad compare mode: " + mode);
        }
        this.compareMode = mode;
    }

    public void setLogger(DexPatcherLogger.IDexPatcherLogger logger) {
        this.logger.setLoggerImpl(logger);
    }

    public List<DexClassInfo> getAddedClassInfos() {
        return Collections.unmodifiableList(this.addedClassInfoList);
    }

    public List<DexClassInfo> getDeletedClassInfos() {
        return Collections.unmodifiableList(this.deletedClassInfoList);
    }

    public Map<String, DexClassInfo[]> getChangedClassDescToInfosMap() {
        return Collections.unmodifiableMap(this.changedClassDescToClassInfosMap);
    }

    public void startCheck(File oldDexFile, File newDexFile) throws IOException {
        this.startCheck(new Dex(oldDexFile), new Dex(newDexFile));
    }

    public void startCheck(Dex oldDex, Dex newDex) {
        this.startCheck(DexGroup.wrap(oldDex), DexGroup.wrap(newDex));
    }

    public void startCheck(DexGroup oldDexGroup, DexGroup newDexGroup) {
        DexClassInfo classInfo;
        String desc;
        int classDefIndex;
        this.addedClassInfoList.clear();
        this.deletedClassInfoList.clear();
        this.changedClassDescToClassInfosMap.clear();
        this.oldDescriptorOfClassesToCheck.clear();
        this.newDescriptorOfClassesToCheck.clear();
        this.oldClassDescriptorToClassInfoMap.clear();
        this.newClassDescriptorToClassInfoMap.clear();
        this.refAffectedClassDescs.clear();
        for (Dex oldDex : oldDexGroup.dexes) {
            classDefIndex = 0;
            for (ClassDef oldClassDef : oldDex.classDefs()) {
                desc = (String)oldDex.typeNames().get(oldClassDef.typeIndex);
                if (Utils.isStringMatchesPatterns(desc, this.patternsOfClassDescToCheck) && !this.oldDescriptorOfClassesToCheck.add(desc)) {
                    throw new IllegalStateException(String.format("duplicate class descriptor [%s] in different old dexes.", desc));
                }
                classInfo = new DexClassInfo(desc, classDefIndex, oldClassDef, oldDex);
                ++classDefIndex;
                this.oldClassDescriptorToClassInfoMap.put(desc, classInfo);
            }
        }
        for (Dex newDex : newDexGroup.dexes) {
            classDefIndex = 0;
            for (ClassDef newClassDef : newDex.classDefs()) {
                desc = (String)newDex.typeNames().get(newClassDef.typeIndex);
                if (Utils.isStringMatchesPatterns(desc, this.patternsOfClassDescToCheck) && !this.newDescriptorOfClassesToCheck.add(desc)) {
                    throw new IllegalStateException(String.format("duplicate class descriptor [%s] in different new dexes.", desc));
                }
                classInfo = new DexClassInfo(desc, classDefIndex, newClassDef, newDex);
                ++classDefIndex;
                this.newClassDescriptorToClassInfoMap.put(desc, classInfo);
            }
        }
        HashSet<String> deletedClassDescs = new HashSet<String>(this.oldDescriptorOfClassesToCheck);
        deletedClassDescs.removeAll(this.newDescriptorOfClassesToCheck);
        for (String desc2 : deletedClassDescs) {
            if (Utils.isStringMatchesPatterns(desc2, this.patternsOfIgnoredRemovedClassDesc)) {
                this.logger.i(TAG, "Ignored deleted class: %s", new Object[]{desc2});
                continue;
            }
            this.logger.i(TAG, "Deleted class: %s", new Object[]{desc2});
            this.deletedClassInfoList.add(this.oldClassDescriptorToClassInfoMap.get(desc2));
        }
        HashSet<String> addedClassDescs = new HashSet<String>(this.newDescriptorOfClassesToCheck);
        addedClassDescs.removeAll(this.oldDescriptorOfClassesToCheck);
        for (String desc3 : addedClassDescs) {
            if (Utils.isStringMatchesPatterns(desc3, this.patternsOfIgnoredRemovedClassDesc)) {
                this.logger.i(TAG, "Ignored added class: %s", new Object[]{desc3});
                continue;
            }
            this.logger.i(TAG, "Added class: %s", new Object[]{desc3});
            this.addedClassInfoList.add(this.newClassDescriptorToClassInfoMap.get(desc3));
        }
        HashSet<String> mayBeChangedClassDescs = new HashSet<String>(this.oldDescriptorOfClassesToCheck);
        mayBeChangedClassDescs.retainAll(this.newDescriptorOfClassesToCheck);
        for (String desc4 : mayBeChangedClassDescs) {
            DexClassInfo oldClassInfo = this.oldClassDescriptorToClassInfoMap.get(desc4);
            DexClassInfo newClassInfo = this.newClassDescriptorToClassInfoMap.get(desc4);
            switch (this.compareMode) {
                case 0: {
                    if (this.isSameClass(oldClassInfo.owner, newClassInfo.owner, oldClassInfo.classDef, newClassInfo.classDef)) break;
                    if (Utils.isStringMatchesPatterns(desc4, this.patternsOfIgnoredRemovedClassDesc)) {
                        this.logger.i(TAG, "Ignored changed class: %s", new Object[]{desc4});
                        break;
                    }
                    this.logger.i(TAG, "Changed class: %s", new Object[]{desc4});
                    this.changedClassDescToClassInfosMap.put(desc4, new DexClassInfo[]{oldClassInfo, newClassInfo});
                    break;
                }
                case 1: {
                    if (!this.isClassChangeAffectedToReferrer(oldClassInfo.owner, newClassInfo.owner, oldClassInfo.classDef, newClassInfo.classDef)) break;
                    if (Utils.isStringMatchesPatterns(desc4, this.patternsOfIgnoredRemovedClassDesc)) {
                        this.logger.i(TAG, "Ignored referrer-affected changed class: %s", new Object[]{desc4});
                        break;
                    }
                    this.logger.i(TAG, "Referrer-affected change class: %s", new Object[]{desc4});
                    this.changedClassDescToClassInfosMap.put(desc4, new DexClassInfo[]{oldClassInfo, newClassInfo});
                    break;
                }
            }
        }
    }

    private boolean isClassChangeAffectedToReferrer(Dex oldDex, Dex newDex, ClassDef oldClassDef, ClassDef newClassDef) {
        boolean result = false;
        String classDesc = (String)oldDex.typeNames().get(oldClassDef.typeIndex);
        if (this.refAffectedClassDescs.contains(classDesc)) {
            result = true;
            return result;
        }
        if (this.isTypeChangeAffectedToReferrer(oldDex, newDex, oldClassDef.supertypeIndex, newClassDef.supertypeIndex)) {
            result = true;
        } else {
            short[] newInterfaceTypeIds;
            short[] oldInterfaceTypeIds = oldDex.interfaceTypeIndicesFromClassDef(oldClassDef);
            if (this.isTypeIdsChangeAffectedToReferrer(oldDex, newDex, oldInterfaceTypeIds, newInterfaceTypeIds = newDex.interfaceTypeIndicesFromClassDef(newClassDef), false)) {
                result = true;
            } else {
                ClassData newClassData;
                ClassData oldClassData = oldClassDef.classDataOffset != 0 ? oldDex.readClassData(oldClassDef) : null;
                ClassData classData = newClassData = newClassDef.classDataOffset != 0 ? newDex.readClassData(newClassDef) : null;
                if (this.isClassDataChangeAffectedToReferrer(oldDex, newDex, oldClassData, newClassData)) {
                    result = true;
                }
            }
        }
        if (result) {
            this.refAffectedClassDescs.add(classDesc);
        }
        return result;
    }

    private boolean isTypeChangeAffectedToReferrer(Dex oldDex, Dex newDex, int oldTypeId, int newTypeId) {
        if (oldTypeId != -1 && newTypeId != -1) {
            ClassDef newClassDef;
            String newClassDesc;
            String oldClassDesc = (String)oldDex.typeNames().get(oldTypeId);
            if (!oldClassDesc.equals(newClassDesc = (String)newDex.typeNames().get(newTypeId))) {
                return true;
            }
            DexClassInfo oldClassInfo = this.oldClassDescriptorToClassInfoMap.get(oldClassDesc);
            DexClassInfo newClassInfo = this.newClassDescriptorToClassInfoMap.get(newClassDesc);
            ClassDef oldClassDef = oldClassInfo != null ? oldClassInfo.classDef : null;
            ClassDef classDef = newClassDef = newClassInfo != null ? newClassInfo.classDef : null;
            if (oldClassDef != null && newClassDef != null) {
                return this.isClassChangeAffectedToReferrer(oldClassInfo.owner, newClassInfo.owner, oldClassDef, newClassDef);
            }
            if (oldClassDef == null && newClassDef == null) {
                return false;
            }
            return !Utils.isStringMatchesPatterns(oldClassDesc, this.patternsOfIgnoredRemovedClassDesc);
        }
        return oldTypeId != -1 || newTypeId != -1;
    }

    private boolean isTypeIdsChangeAffectedToReferrer(Dex oldDex, Dex newDex, short[] oldTypeIds, short[] newTypeIds, boolean compareNameOnly) {
        if (oldTypeIds.length != newTypeIds.length) {
            return true;
        }
        int typeIdCount = oldTypeIds.length;
        for (int i = 0; i < typeIdCount; ++i) {
            String newTypeName;
            String oldTypeName;
            if (!(compareNameOnly ? !(oldTypeName = (String)oldDex.typeNames().get(oldTypeIds[i])).equals(newTypeName = (String)newDex.typeNames().get(newTypeIds[i])) : this.isTypeChangeAffectedToReferrer(oldDex, newDex, oldTypeIds[i], newTypeIds[i]))) continue;
            return true;
        }
        return false;
    }

    private boolean isClassDataChangeAffectedToReferrer(Dex oldDex, Dex newDex, ClassData oldClassData, ClassData newClassData) {
        if (oldClassData != null && newClassData != null) {
            if (this.isFieldsChangeAffectedToReferrer(oldDex, newDex, oldClassData.instanceFields, newClassData.instanceFields)) {
                return true;
            }
            if (this.isFieldsChangeAffectedToReferrer(oldDex, newDex, oldClassData.staticFields, newClassData.staticFields)) {
                return true;
            }
            if (this.isMethodsChangeAffectedToReferrer(oldDex, newDex, oldClassData.directMethods, newClassData.directMethods)) {
                return true;
            }
            if (this.isMethodsChangeAffectedToReferrer(oldDex, newDex, oldClassData.virtualMethods, newClassData.virtualMethods)) {
                return true;
            }
        } else if (oldClassData != null || newClassData != null) {
            return true;
        }
        return false;
    }

    private boolean isFieldsChangeAffectedToReferrer(Dex oldDex, Dex newDex, ClassData.Field[] oldFields, ClassData.Field[] newFields) {
        if (oldFields.length != newFields.length) {
            return true;
        }
        int fieldCount = oldFields.length;
        for (int i = 0; i < fieldCount; ++i) {
            String newFieldTypeName;
            String newFieldName;
            ClassData.Field oldField = oldFields[i];
            ClassData.Field newField = newFields[i];
            if (oldField.accessFlags != newField.accessFlags) {
                return true;
            }
            FieldId oldFieldId = (FieldId)oldDex.fieldIds().get(oldField.fieldIndex);
            FieldId newFieldId = (FieldId)newDex.fieldIds().get(newField.fieldIndex);
            String oldFieldName = (String)oldDex.strings().get(oldFieldId.nameIndex);
            if (!oldFieldName.equals(newFieldName = (String)newDex.strings().get(newFieldId.nameIndex))) {
                return true;
            }
            String oldFieldTypeName = (String)oldDex.typeNames().get(oldFieldId.typeIndex);
            if (oldFieldTypeName.equals(newFieldTypeName = (String)newDex.typeNames().get(newFieldId.typeIndex))) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodsChangeAffectedToReferrer(Dex oldDex, Dex newDex, ClassData.Method[] oldMethods, ClassData.Method[] newMethods) {
        if (oldMethods.length != newMethods.length) {
            return true;
        }
        int methodCount = oldMethods.length;
        for (int i = 0; i < methodCount; ++i) {
            short[] newParameterIds;
            String newMethodReturnTypeName;
            String newMethodShorty;
            String newMethodName;
            ClassData.Method oldMethod = oldMethods[i];
            ClassData.Method newMethod = newMethods[i];
            if (oldMethod.accessFlags != newMethod.accessFlags) {
                return true;
            }
            MethodId oldMethodId = (MethodId)oldDex.methodIds().get(oldMethod.methodIndex);
            MethodId newMethodId = (MethodId)newDex.methodIds().get(newMethod.methodIndex);
            String oldMethodName = (String)oldDex.strings().get(oldMethodId.nameIndex);
            if (!oldMethodName.equals(newMethodName = (String)newDex.strings().get(newMethodId.nameIndex))) {
                return true;
            }
            ProtoId oldProtoId = (ProtoId)oldDex.protoIds().get(oldMethodId.protoIndex);
            ProtoId newProtoId = (ProtoId)newDex.protoIds().get(newMethodId.protoIndex);
            String oldMethodShorty = (String)oldDex.strings().get(oldProtoId.shortyIndex);
            if (!oldMethodShorty.equals(newMethodShorty = (String)newDex.strings().get(newProtoId.shortyIndex))) {
                return true;
            }
            String oldMethodReturnTypeName = (String)oldDex.typeNames().get(oldProtoId.returnTypeIndex);
            if (!oldMethodReturnTypeName.equals(newMethodReturnTypeName = (String)newDex.typeNames().get(newProtoId.returnTypeIndex))) {
                return true;
            }
            short[] oldParameterIds = oldDex.parameterTypeIndicesFromMethodId(oldMethodId);
            if (!this.isTypeIdsChangeAffectedToReferrer(oldDex, newDex, oldParameterIds, newParameterIds = newDex.parameterTypeIndicesFromMethodId(newMethodId), true)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameClass(Dex oldDex, Dex newDex, ClassDef oldClassDef, ClassDef newClassDef) {
        short[] newInterfaceIndices;
        if (oldClassDef.accessFlags != newClassDef.accessFlags) {
            return false;
        }
        if (!this.isSameClassDesc(oldDex, newDex, oldClassDef.supertypeIndex, newClassDef.supertypeIndex)) {
            return false;
        }
        short[] oldInterfaceIndices = oldDex.interfaceTypeIndicesFromClassDef(oldClassDef);
        if (oldInterfaceIndices.length != (newInterfaceIndices = newDex.interfaceTypeIndicesFromClassDef(newClassDef)).length) {
            return false;
        }
        for (int i = 0; i < oldInterfaceIndices.length; ++i) {
            if (this.isSameClassDesc(oldDex, newDex, oldInterfaceIndices[i], newInterfaceIndices[i])) continue;
            return false;
        }
        if (!this.isSameName(oldDex, newDex, oldClassDef.sourceFileIndex, newClassDef.sourceFileIndex)) {
            return false;
        }
        if (!this.isSameAnnotationDirectory(oldDex, newDex, oldClassDef.annotationsOffset, newClassDef.annotationsOffset)) {
            return false;
        }
        if (!this.isSameClassData(oldDex, newDex, oldClassDef.classDataOffset, newClassDef.classDataOffset)) {
            return false;
        }
        return this.isSameStaticValue(oldDex, newDex, oldClassDef.staticValuesOffset, newClassDef.staticValuesOffset);
    }

    private boolean isSameStaticValue(Dex oldDex, Dex newDex, int oldStaticValueOffset, int newStaticValueOffset) {
        if (oldStaticValueOffset == 0 && newStaticValueOffset == 0) {
            return true;
        }
        if (oldStaticValueOffset == 0 || newStaticValueOffset == 0) {
            return false;
        }
        EncodedValue oldStaticValue = oldDex.openSection(oldStaticValueOffset).readEncodedArray();
        EncodedValue newStaticValue = newDex.openSection(newStaticValueOffset).readEncodedArray();
        EncodedValueReader oldReader = new EncodedValueReader(oldStaticValue, 28);
        EncodedValueReader newReader = new EncodedValueReader(newStaticValue, 28);
        return this.isSameEncodedValue(oldDex, newDex, oldReader, newReader);
    }

    private boolean isSameClassDesc(Dex oldDex, Dex newDex, int oldTypeId, int newTypeId) {
        String oldClassDesc = (String)oldDex.typeNames().get(oldTypeId);
        String newClassDesc = (String)newDex.typeNames().get(newTypeId);
        return oldClassDesc.equals(newClassDesc);
    }

    private boolean isSameName(Dex oldDex, Dex newDex, int oldStringId, int newStringId) {
        if (oldStringId == -1 && newStringId == -1) {
            return true;
        }
        if (oldStringId == -1 || newStringId == -1) {
            return false;
        }
        return ((String)oldDex.strings().get(oldStringId)).equals(newDex.strings().get(newStringId));
    }

    private boolean isSameAnnotationDirectory(Dex oldDex, Dex newDex, int oldAnnotationDirectoryOffset, int newAnnotationDirectoryOffset) {
        if (oldAnnotationDirectoryOffset == 0 && newAnnotationDirectoryOffset == 0) {
            return true;
        }
        if (oldAnnotationDirectoryOffset == 0 || newAnnotationDirectoryOffset == 0) {
            return false;
        }
        AnnotationsDirectory oldAnnotationsDirectory = oldDex.openSection(oldAnnotationDirectoryOffset).readAnnotationsDirectory();
        AnnotationsDirectory newAnnotationsDirectory = newDex.openSection(newAnnotationDirectoryOffset).readAnnotationsDirectory();
        if (!this.isSameAnnotationSet(oldDex, newDex, oldAnnotationsDirectory.classAnnotationsOffset, newAnnotationsDirectory.classAnnotationsOffset)) {
            return false;
        }
        int[][] oldFieldAnnotations = oldAnnotationsDirectory.fieldAnnotations;
        int[][] newFieldAnnotations = newAnnotationsDirectory.fieldAnnotations;
        if (oldFieldAnnotations.length != newFieldAnnotations.length) {
            return false;
        }
        for (int i = 0; i < oldFieldAnnotations.length; ++i) {
            if (!this.isSameFieldId(oldDex, newDex, oldFieldAnnotations[i][0], newFieldAnnotations[i][0])) {
                return false;
            }
            if (this.isSameAnnotationSet(oldDex, newDex, oldFieldAnnotations[i][1], newFieldAnnotations[i][1])) continue;
            return false;
        }
        int[][] oldMethodAnnotations = oldAnnotationsDirectory.methodAnnotations;
        int[][] newMethodAnnotations = newAnnotationsDirectory.methodAnnotations;
        if (oldMethodAnnotations.length != newMethodAnnotations.length) {
            return false;
        }
        for (int i = 0; i < oldMethodAnnotations.length; ++i) {
            if (!this.isSameMethodId(oldDex, newDex, oldMethodAnnotations[i][0], newMethodAnnotations[i][0])) {
                return false;
            }
            if (this.isSameAnnotationSet(oldDex, newDex, oldMethodAnnotations[i][1], newMethodAnnotations[i][1])) continue;
            return false;
        }
        int[][] oldParameterAnnotations = oldAnnotationsDirectory.parameterAnnotations;
        int[][] newParameterAnnotations = newAnnotationsDirectory.parameterAnnotations;
        if (oldParameterAnnotations.length != newParameterAnnotations.length) {
            return false;
        }
        for (int i = 0; i < oldParameterAnnotations.length; ++i) {
            if (!this.isSameMethodId(oldDex, newDex, oldParameterAnnotations[i][0], newParameterAnnotations[i][0])) {
                return false;
            }
            if (this.isSameAnnotationSetRefList(oldDex, newDex, oldParameterAnnotations[i][1], newParameterAnnotations[i][1])) continue;
            return false;
        }
        return true;
    }

    private boolean isSameFieldId(Dex oldDex, Dex newDex, int oldFieldIdIdx, int newFieldIdIdx) {
        FieldId oldFieldId = (FieldId)oldDex.fieldIds().get(oldFieldIdIdx);
        FieldId newFieldId = (FieldId)newDex.fieldIds().get(newFieldIdIdx);
        if (!this.isSameClassDesc(oldDex, newDex, oldFieldId.declaringClassIndex, newFieldId.declaringClassIndex)) {
            return false;
        }
        if (!this.isSameClassDesc(oldDex, newDex, oldFieldId.typeIndex, newFieldId.typeIndex)) {
            return false;
        }
        String oldName = (String)oldDex.strings().get(oldFieldId.nameIndex);
        String newName = (String)newDex.strings().get(newFieldId.nameIndex);
        return oldName.equals(newName);
    }

    private boolean isSameMethodId(Dex oldDex, Dex newDex, int oldMethodIdIdx, int newMethodIdIdx) {
        MethodId oldMethodId = (MethodId)oldDex.methodIds().get(oldMethodIdIdx);
        MethodId newMethodId = (MethodId)newDex.methodIds().get(newMethodIdIdx);
        if (!this.isSameClassDesc(oldDex, newDex, oldMethodId.declaringClassIndex, newMethodId.declaringClassIndex)) {
            return false;
        }
        if (!this.isSameProtoId(oldDex, newDex, oldMethodId.protoIndex, newMethodId.protoIndex)) {
            return false;
        }
        String oldName = (String)oldDex.strings().get(oldMethodId.nameIndex);
        String newName = (String)newDex.strings().get(newMethodId.nameIndex);
        return oldName.equals(newName);
    }

    private boolean isSameProtoId(Dex oldDex, Dex newDex, int oldProtoIdIdx, int newProtoIdIdx) {
        String newShorty;
        ProtoId oldProtoId = (ProtoId)oldDex.protoIds().get(oldProtoIdIdx);
        ProtoId newProtoId = (ProtoId)newDex.protoIds().get(newProtoIdIdx);
        String oldShorty = (String)oldDex.strings().get(oldProtoId.shortyIndex);
        if (!oldShorty.equals(newShorty = (String)newDex.strings().get(newProtoId.shortyIndex))) {
            return false;
        }
        if (!this.isSameClassDesc(oldDex, newDex, oldProtoId.returnTypeIndex, newProtoId.returnTypeIndex)) {
            return false;
        }
        return this.isSameParameters(oldDex, newDex, oldProtoId.parametersOffset, newProtoId.parametersOffset);
    }

    private boolean isSameParameters(Dex oldDex, Dex newDex, int oldParametersOffset, int newParametersOffset) {
        if (oldParametersOffset == 0 && newParametersOffset == 0) {
            return true;
        }
        if (oldParametersOffset == 0 || newParametersOffset == 0) {
            return false;
        }
        TypeList oldParameters = oldDex.openSection(oldParametersOffset).readTypeList();
        TypeList newParameters = newDex.openSection(newParametersOffset).readTypeList();
        if (oldParameters.types.length != newParameters.types.length) {
            return false;
        }
        for (int i = 0; i < oldParameters.types.length; ++i) {
            if (this.isSameClassDesc(oldDex, newDex, oldParameters.types[i], newParameters.types[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isSameAnnotationSetRefList(Dex oldDex, Dex newDex, int oldAnnotationSetRefListOffset, int newAnnotationSetRefListOffset) {
        if (oldAnnotationSetRefListOffset == 0 && newAnnotationSetRefListOffset == 0) {
            return true;
        }
        if (oldAnnotationSetRefListOffset == 0 || newAnnotationSetRefListOffset == 0) {
            return false;
        }
        AnnotationSetRefList oldAnnotationSetRefList = oldDex.openSection(oldAnnotationSetRefListOffset).readAnnotationSetRefList();
        AnnotationSetRefList newAnnotationSetRefList = newDex.openSection(newAnnotationSetRefListOffset).readAnnotationSetRefList();
        int oldAnnotationSetRefListCount = oldAnnotationSetRefList.annotationSetRefItems.length;
        int newAnnotationSetRefListCount = newAnnotationSetRefList.annotationSetRefItems.length;
        if (oldAnnotationSetRefListCount != newAnnotationSetRefListCount) {
            return false;
        }
        for (int i = 0; i < oldAnnotationSetRefListCount; ++i) {
            if (this.isSameAnnotationSet(oldDex, newDex, oldAnnotationSetRefList.annotationSetRefItems[i], newAnnotationSetRefList.annotationSetRefItems[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isSameAnnotationSet(Dex oldDex, Dex newDex, int oldAnnotationSetOffset, int newAnnotationSetOffset) {
        if (oldAnnotationSetOffset == 0 && newAnnotationSetOffset == 0) {
            return true;
        }
        if (oldAnnotationSetOffset == 0 || newAnnotationSetOffset == 0) {
            return false;
        }
        AnnotationSet oldClassAnnotationSet = oldDex.openSection(oldAnnotationSetOffset).readAnnotationSet();
        AnnotationSet newClassAnnotationSet = newDex.openSection(newAnnotationSetOffset).readAnnotationSet();
        int oldAnnotationOffsetCount = oldClassAnnotationSet.annotationOffsets.length;
        int newAnnotationOffsetCount = newClassAnnotationSet.annotationOffsets.length;
        if (oldAnnotationOffsetCount != newAnnotationOffsetCount) {
            return false;
        }
        for (int i = 0; i < oldAnnotationOffsetCount; ++i) {
            if (this.isSameAnnotation(oldDex, newDex, oldClassAnnotationSet.annotationOffsets[i], newClassAnnotationSet.annotationOffsets[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isSameAnnotation(Dex oldDex, Dex newDex, int oldAnnotationOffset, int newAnnotationOffset) {
        Annotation oldAnnotation = oldDex.openSection(oldAnnotationOffset).readAnnotation();
        Annotation newAnnotation = newDex.openSection(newAnnotationOffset).readAnnotation();
        if (oldAnnotation.visibility != newAnnotation.visibility) {
            return false;
        }
        EncodedValueReader oldAnnoReader = oldAnnotation.getReader();
        EncodedValueReader newAnnoReader = newAnnotation.getReader();
        return this.isSameAnnotationByReader(oldDex, newDex, oldAnnoReader, newAnnoReader);
    }

    private boolean isSameAnnotationByReader(Dex oldDex, Dex newDex, EncodedValueReader oldAnnoReader, EncodedValueReader newAnnoReader) {
        int newAnnoType;
        int newFieldCount;
        int oldFieldCount = oldAnnoReader.readAnnotation();
        if (oldFieldCount != (newFieldCount = newAnnoReader.readAnnotation())) {
            return false;
        }
        int oldAnnoType = oldAnnoReader.getAnnotationType();
        if (!this.isSameClassDesc(oldDex, newDex, oldAnnoType, newAnnoType = newAnnoReader.getAnnotationType())) {
            return false;
        }
        for (int i = 0; i < oldFieldCount; ++i) {
            int newAnnoNameIdx;
            int oldAnnoNameIdx = oldAnnoReader.readAnnotationName();
            if (!this.isSameName(oldDex, newDex, oldAnnoNameIdx, newAnnoNameIdx = newAnnoReader.readAnnotationName())) {
                return false;
            }
            if (this.isSameEncodedValue(oldDex, newDex, oldAnnoReader, newAnnoReader)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameEncodedValue(Dex oldDex, Dex newDex, EncodedValueReader oldAnnoReader, EncodedValueReader newAnnoReader) {
        int newAnnoItemType;
        int oldAnnoItemType = oldAnnoReader.peek();
        if (oldAnnoItemType != (newAnnoItemType = newAnnoReader.peek())) {
            return false;
        }
        switch (oldAnnoItemType) {
            case 0: {
                byte oldByte = oldAnnoReader.readByte();
                byte newByte = newAnnoReader.readByte();
                return oldByte == newByte;
            }
            case 2: {
                short oldShort = oldAnnoReader.readShort();
                short newShort = newAnnoReader.readShort();
                return oldShort == newShort;
            }
            case 4: {
                int oldInt = oldAnnoReader.readInt();
                int newInt = newAnnoReader.readInt();
                return oldInt == newInt;
            }
            case 6: {
                long oldLong = oldAnnoReader.readLong();
                long newLong = newAnnoReader.readLong();
                return oldLong == newLong;
            }
            case 3: {
                char oldChar = oldAnnoReader.readChar();
                char newChar = newAnnoReader.readChar();
                return oldChar == newChar;
            }
            case 16: {
                float oldFloat = oldAnnoReader.readFloat();
                float newFloat = newAnnoReader.readFloat();
                return Float.compare(oldFloat, newFloat) == 0;
            }
            case 17: {
                double oldDouble = oldAnnoReader.readDouble();
                double newDouble = newAnnoReader.readDouble();
                return Double.compare(oldDouble, newDouble) == 0;
            }
            case 23: {
                int oldStringIdx = oldAnnoReader.readString();
                int newStringIdx = newAnnoReader.readString();
                return this.isSameName(oldDex, newDex, oldStringIdx, newStringIdx);
            }
            case 24: {
                int oldTypeId = oldAnnoReader.readType();
                int newTypeId = newAnnoReader.readType();
                return this.isSameClassDesc(oldDex, newDex, oldTypeId, newTypeId);
            }
            case 25: {
                int oldFieldId = oldAnnoReader.readField();
                int newFieldId = newAnnoReader.readField();
                return this.isSameFieldId(oldDex, newDex, oldFieldId, newFieldId);
            }
            case 27: {
                int oldFieldId = oldAnnoReader.readEnum();
                int newFieldId = newAnnoReader.readEnum();
                return this.isSameFieldId(oldDex, newDex, oldFieldId, newFieldId);
            }
            case 26: {
                int oldMethodId = oldAnnoReader.readMethod();
                int newMethodId = newAnnoReader.readMethod();
                return this.isSameMethodId(oldDex, newDex, oldMethodId, newMethodId);
            }
            case 28: {
                int oldArrSize = oldAnnoReader.readArray();
                int newArrSize = newAnnoReader.readArray();
                if (oldArrSize != newArrSize) {
                    return false;
                }
                for (int i = 0; i < oldArrSize; ++i) {
                    if (this.isSameEncodedValue(oldDex, newDex, oldAnnoReader, newAnnoReader)) continue;
                    return false;
                }
                return true;
            }
            case 29: {
                return this.isSameAnnotationByReader(oldDex, newDex, oldAnnoReader, newAnnoReader);
            }
            case 30: {
                oldAnnoReader.readNull();
                newAnnoReader.readNull();
                return true;
            }
            case 31: {
                boolean oldBool = oldAnnoReader.readBoolean();
                boolean newBool = newAnnoReader.readBoolean();
                return oldBool == newBool;
            }
        }
        throw new IllegalStateException("Unexpected annotation value type: " + Integer.toHexString(oldAnnoItemType));
    }

    private boolean isSameClassData(Dex oldDex, Dex newDex, int oldClassDataOffset, int newClassDataOffset) {
        if (oldClassDataOffset == 0 && newClassDataOffset == 0) {
            return true;
        }
        if (oldClassDataOffset == 0 || newClassDataOffset == 0) {
            return false;
        }
        ClassData oldClassData = oldDex.openSection(oldClassDataOffset).readClassData();
        ClassData newClassData = newDex.openSection(newClassDataOffset).readClassData();
        ClassData.Field[] oldInstanceFields = oldClassData.instanceFields;
        ClassData.Field[] newInstanceFields = newClassData.instanceFields;
        if (oldInstanceFields.length != newInstanceFields.length) {
            return false;
        }
        for (int i = 0; i < oldInstanceFields.length; ++i) {
            if (this.isSameField(oldDex, newDex, oldInstanceFields[i], newInstanceFields[i])) continue;
            return false;
        }
        ClassData.Field[] oldStaticFields = oldClassData.staticFields;
        ClassData.Field[] newStaticFields = newClassData.staticFields;
        if (oldStaticFields.length != newStaticFields.length) {
            return false;
        }
        for (int i = 0; i < oldStaticFields.length; ++i) {
            if (this.isSameField(oldDex, newDex, oldStaticFields[i], newStaticFields[i])) continue;
            return false;
        }
        ClassData.Method[] oldDirectMethods = oldClassData.directMethods;
        ClassData.Method[] newDirectMethods = newClassData.directMethods;
        if (oldDirectMethods.length != newDirectMethods.length) {
            return false;
        }
        for (int i = 0; i < oldDirectMethods.length; ++i) {
            if (this.isSameMethod(oldDex, newDex, oldDirectMethods[i], newDirectMethods[i])) continue;
            return false;
        }
        ClassData.Method[] oldVirtualMethods = oldClassData.virtualMethods;
        ClassData.Method[] newVirtualMethods = newClassData.virtualMethods;
        if (oldVirtualMethods.length != newVirtualMethods.length) {
            return false;
        }
        for (int i = 0; i < oldVirtualMethods.length; ++i) {
            if (this.isSameMethod(oldDex, newDex, oldVirtualMethods[i], newVirtualMethods[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isSameField(Dex oldDex, Dex newDex, ClassData.Field oldField, ClassData.Field newField) {
        if (oldField.accessFlags != newField.accessFlags) {
            return false;
        }
        return this.isSameFieldId(oldDex, newDex, oldField.fieldIndex, newField.fieldIndex);
    }

    private boolean isSameMethod(Dex oldDex, Dex newDex, ClassData.Method oldMethod, ClassData.Method newMethod) {
        if (oldMethod.accessFlags != newMethod.accessFlags) {
            return false;
        }
        if (!this.isSameMethodId(oldDex, newDex, oldMethod.methodIndex, newMethod.methodIndex)) {
            return false;
        }
        return this.isSameCode(oldDex, newDex, oldMethod.codeOffset, newMethod.codeOffset);
    }

    private boolean isSameCode(final Dex oldDex, final Dex newDex, int oldCodeOffset, int newCodeOffset) {
        if (oldCodeOffset == 0 && newCodeOffset == 0) {
            return true;
        }
        if (oldCodeOffset == 0 || newCodeOffset == 0) {
            return false;
        }
        Code oldCode = oldDex.openSection(oldCodeOffset).readCode();
        Code newCode = newDex.openSection(newCodeOffset).readCode();
        if (oldCode.registersSize != newCode.registersSize) {
            return false;
        }
        if (oldCode.insSize != newCode.insSize) {
            return false;
        }
        InstructionComparator insnComparator = new InstructionComparator(oldCode.instructions, newCode.instructions){

            protected boolean compareString(int stringIndex1, int stringIndex2) {
                return DexClassesComparator.this.isSameName(oldDex, newDex, stringIndex1, stringIndex2);
            }

            protected boolean compareType(int typeIndex1, int typeIndex2) {
                return DexClassesComparator.this.isSameClassDesc(oldDex, newDex, typeIndex1, typeIndex2);
            }

            protected boolean compareField(int fieldIndex1, int fieldIndex2) {
                return DexClassesComparator.this.isSameFieldId(oldDex, newDex, fieldIndex1, fieldIndex2);
            }

            protected boolean compareMethod(int methodIndex1, int methodIndex2) {
                return DexClassesComparator.this.isSameMethodId(oldDex, newDex, methodIndex1, methodIndex2);
            }
        };
        if (!insnComparator.compare()) {
            return false;
        }
        if (!this.isSameDebugInfo(oldDex, newDex, oldCode.debugInfoOffset, newCode.debugInfoOffset, insnComparator)) {
            return false;
        }
        return this.isSameTriesAndCatchHandlers(oldDex, newDex, oldCode.tries, newCode.tries, oldCode.catchHandlers, newCode.catchHandlers, insnComparator);
    }

    private boolean isSameDebugInfo(Dex oldDex, Dex newDex, int oldDebugInfoOffset, int newDebugInfoOffset, InstructionComparator insnComparator) {
        if (oldDebugInfoOffset == 0 && newDebugInfoOffset == 0) {
            return true;
        }
        if (oldDebugInfoOffset == 0 || newDebugInfoOffset == 0) {
            return false;
        }
        DebugInfoItem oldDebugInfoItem = oldDex.openSection(oldDebugInfoOffset).readDebugInfoItem();
        DebugInfoItem newDebugInfoItem = newDex.openSection(newDebugInfoOffset).readDebugInfoItem();
        if (oldDebugInfoItem.lineStart != newDebugInfoItem.lineStart) {
            return false;
        }
        if (oldDebugInfoItem.parameterNames.length != newDebugInfoItem.parameterNames.length) {
            return false;
        }
        for (int i = 0; i < oldDebugInfoItem.parameterNames.length; ++i) {
            int oldNameIdx = oldDebugInfoItem.parameterNames[i];
            int newNameIdx = newDebugInfoItem.parameterNames[i];
            if (this.isSameName(oldDex, newDex, oldNameIdx, newNameIdx)) continue;
            return false;
        }
        DexDataBuffer oldDbgInfoBuffer = new DexDataBuffer(ByteBuffer.wrap(oldDebugInfoItem.infoSTM));
        DexDataBuffer newDbgInfoBuffer = new DexDataBuffer(ByteBuffer.wrap(newDebugInfoItem.infoSTM));
        int oldLine = oldDebugInfoItem.lineStart;
        int oldAddress = 0;
        int newLine = newDebugInfoItem.lineStart;
        int newAddress = 0;
        block10: while (oldDbgInfoBuffer.available() > 0 && newDbgInfoBuffer.available() > 0) {
            int newOpCode;
            int oldOpCode = oldDbgInfoBuffer.readUnsignedByte();
            if (oldOpCode != (newOpCode = newDbgInfoBuffer.readUnsignedByte()) && (oldOpCode < 10 || newOpCode < 10)) {
                return false;
            }
            int currOpCode = oldOpCode;
            switch (currOpCode) {
                case 0: {
                    break;
                }
                case 1: {
                    int newAddrDiff;
                    int oldAddrDiff = oldDbgInfoBuffer.readUleb128();
                    if (insnComparator.isSameInstruction(oldAddress += oldAddrDiff, newAddress += (newAddrDiff = newDbgInfoBuffer.readUleb128()))) continue block10;
                    return false;
                }
                case 2: {
                    int newLineDiff;
                    int oldLineDiff = oldDbgInfoBuffer.readSleb128();
                    if ((oldLine += oldLineDiff) == (newLine += (newLineDiff = newDbgInfoBuffer.readSleb128()))) continue block10;
                    return false;
                }
                case 3: 
                case 4: {
                    int newSigIndex;
                    int oldSigIndex;
                    int newTypeIndex;
                    int newNameIndex;
                    int oldRegisterNum = oldDbgInfoBuffer.readUleb128();
                    int newRegisterNum = newDbgInfoBuffer.readUleb128();
                    if (oldRegisterNum != newRegisterNum) {
                        return false;
                    }
                    int oldNameIndex = oldDbgInfoBuffer.readUleb128p1();
                    if (!this.isSameName(oldDex, newDex, oldNameIndex, newNameIndex = newDbgInfoBuffer.readUleb128p1())) {
                        return false;
                    }
                    int oldTypeIndex = oldDbgInfoBuffer.readUleb128p1();
                    if (!this.isSameClassDesc(oldDex, newDex, oldTypeIndex, newTypeIndex = newDbgInfoBuffer.readUleb128p1())) {
                        return false;
                    }
                    if (currOpCode != 4 || this.isSameName(oldDex, newDex, oldSigIndex = oldDbgInfoBuffer.readUleb128p1(), newSigIndex = newDbgInfoBuffer.readUleb128p1())) continue block10;
                    return false;
                }
                case 5: 
                case 6: {
                    int newRegisterNum;
                    int oldRegisterNum = oldDbgInfoBuffer.readUleb128();
                    if (oldRegisterNum == (newRegisterNum = newDbgInfoBuffer.readUleb128())) continue block10;
                    return false;
                }
                case 9: {
                    int newNameIndex;
                    int oldNameIndex = oldDbgInfoBuffer.readUleb128p1();
                    if (this.isSameName(oldDex, newDex, oldNameIndex, newNameIndex = newDbgInfoBuffer.readUleb128p1())) continue block10;
                    return false;
                }
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    int oldAdjustedOpcode = oldOpCode - 10;
                    oldAddress += oldAdjustedOpcode / 15;
                    int newAdjustedOpcode = newOpCode - 10;
                    newAddress += newAdjustedOpcode / 15;
                    if ((oldLine += -4 + oldAdjustedOpcode % 15) != (newLine += -4 + newAdjustedOpcode % 15)) {
                        return false;
                    }
                    if (insnComparator.isSameInstruction(oldAddress, newAddress)) continue block10;
                    return false;
                }
            }
        }
        return oldDbgInfoBuffer.available() <= 0 && newDbgInfoBuffer.available() <= 0;
    }

    private boolean isSameTriesAndCatchHandlers(Dex oldDex, Dex newDex, Code.Try[] oldTries, Code.Try[] newTries, Code.CatchHandler[] oldHandlers, Code.CatchHandler[] newHandlers, InstructionComparator insnComparator) {
        if (oldTries.length != newTries.length) {
            return false;
        }
        for (int i = 0; i < oldTries.length; ++i) {
            Code.Try oldTry = oldTries[i];
            Code.Try newTry = newTries[i];
            Code.CatchHandler oldCatchHandler = oldHandlers[oldTry.catchHandlerIndex];
            Code.CatchHandler newCatchHandler = newHandlers[newTry.catchHandlerIndex];
            if (!this.isSameCatchHandler(oldDex, newDex, oldCatchHandler, newCatchHandler, insnComparator)) {
                return false;
            }
            if (insnComparator.isSameInstruction(oldTry.startAddress, newTry.startAddress)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameCatchHandler(Dex oldDex, Dex newDex, Code.CatchHandler oldCatchHandler, Code.CatchHandler newCatchHandler, InstructionComparator insnComparator) {
        int oldTypeAddrPairCount = oldCatchHandler.typeIndexes.length;
        int newTypeAddrPairCount = newCatchHandler.typeIndexes.length;
        if (oldTypeAddrPairCount != newTypeAddrPairCount) {
            return false;
        }
        if (oldCatchHandler.catchAllAddress != -1 && newCatchHandler.catchAllAddress != -1) {
            return insnComparator.isSameInstruction(oldCatchHandler.catchAllAddress, newCatchHandler.catchAllAddress);
        }
        if (oldCatchHandler.catchAllAddress != -1 || newCatchHandler.catchAllAddress != -1) {
            return false;
        }
        for (int j = 0; j < oldTypeAddrPairCount; ++j) {
            if (!this.isSameClassDesc(oldDex, newDex, oldCatchHandler.typeIndexes[j], newCatchHandler.typeIndexes[j])) {
                return false;
            }
            if (insnComparator.isSameInstruction(oldCatchHandler.addresses[j], newCatchHandler.addresses[j])) continue;
            return false;
        }
        return true;
    }

    public static final class DexGroup {
        public final Dex[] dexes;

        private DexGroup(Dex ... dexes) {
            if (dexes == null || dexes.length == 0) {
                throw new IllegalArgumentException("dexes is null or empty.");
            }
            this.dexes = new Dex[dexes.length];
            System.arraycopy(dexes, 0, this.dexes, 0, dexes.length);
        }

        private DexGroup(File ... dexFiles) throws IOException {
            if (dexFiles == null || dexFiles.length == 0) {
                throw new IllegalArgumentException("dexFiles is null or empty.");
            }
            this.dexes = new Dex[dexFiles.length];
            for (int i = 0; i < dexFiles.length; ++i) {
                this.dexes[i] = new Dex(dexFiles[i]);
            }
        }

        private DexGroup(List<File> dexFileList) throws IOException {
            if (dexFileList == null || dexFileList.isEmpty()) {
                throw new IllegalArgumentException("dexFileList is null or empty.");
            }
            this.dexes = new Dex[dexFileList.size()];
            for (int i = 0; i < this.dexes.length; ++i) {
                this.dexes[i] = new Dex(dexFileList.get(i));
            }
        }

        private DexGroup() {
            throw new UnsupportedOperationException();
        }

        public static DexGroup wrap(Dex ... dexes) {
            return new DexGroup(dexes);
        }

        public static DexGroup wrap(File ... dexFiles) throws IOException {
            return new DexGroup(dexFiles);
        }

        public static DexGroup wrap(List<File> dexFileList) throws IOException {
            return new DexGroup(dexFileList);
        }

        public Set<DexClassInfo> getClassInfosInDexesWithDuplicateCheck() {
            HashMap<String, DexClassInfo> classDescToInfoMap = new HashMap<String, DexClassInfo>();
            for (Dex dex : this.dexes) {
                int classDefIndex = 0;
                for (ClassDef classDef : dex.classDefs()) {
                    String classDesc = (String)dex.typeNames().get(classDef.typeIndex);
                    if (!classDescToInfoMap.containsKey(classDesc)) {
                        classDescToInfoMap.put(classDesc, new DexClassInfo(classDesc, classDefIndex, classDef, dex));
                        ++classDefIndex;
                        continue;
                    }
                    throw new IllegalStateException(String.format("duplicate class descriptor [%s] in different dexes.", classDesc));
                }
            }
            return new HashSet<DexClassInfo>(classDescToInfoMap.values());
        }
    }

    public static final class DexClassInfo {
        public String classDesc = null;
        public int classDefIndex = -1;
        public ClassDef classDef = null;
        public Dex owner = null;

        private DexClassInfo(String classDesc, int classDefIndex, ClassDef classDef, Dex owner) {
            this.classDesc = classDesc;
            this.classDef = classDef;
            this.classDefIndex = classDefIndex;
            this.owner = owner;
        }

        private DexClassInfo() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.classDesc;
        }

        public boolean equals(Object obj) {
            DexClassInfo other = (DexClassInfo)obj;
            if (!this.classDesc.equals(other.classDesc)) {
                return false;
            }
            return this.owner.computeSignature(false).equals(other.owner.computeSignature(false));
        }

        public int hashCode() {
            return this.owner.computeSignature(false).hashCode();
        }
    }
}

