/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.build.decoder.ArkHotDecoder;
import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.decoder.ManifestDecoder;
import com.tencent.tinker.build.decoder.ResDiffDecoder;
import com.tencent.tinker.build.decoder.SoDiffDecoder;
import com.tencent.tinker.build.decoder.UniqueDexDiffDecoder;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.FileOperation;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.MD5;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.regex.Matcher;

public class ApkDecoder
extends BaseDecoder {
    private final File mOldApkDir;
    private final File mNewApkDir;
    private final ManifestDecoder manifestDecoder;
    private final UniqueDexDiffDecoder dexPatchDecoder;
    private final SoDiffDecoder soPatchDecoder;
    private final ResDiffDecoder resPatchDecoder;
    private final ArkHotDecoder arkHotDecoder;
    ArrayList<File> resDuplicateFiles;

    public ApkDecoder(Configuration config) throws IOException {
        super(config);
        this.mNewApkDir = config.mTempUnzipNewDir;
        this.mOldApkDir = config.mTempUnzipOldDir;
        this.manifestDecoder = new ManifestDecoder(config);
        String prePath = "assets" + File.separator;
        this.dexPatchDecoder = new UniqueDexDiffDecoder(config, prePath + "dex_meta.txt", "dex_log.txt");
        this.soPatchDecoder = new SoDiffDecoder(config, prePath + "so_meta.txt", "so_log.txt");
        this.resPatchDecoder = new ResDiffDecoder(config, prePath + "res_meta.txt", "res_log.txt");
        this.arkHotDecoder = new ArkHotDecoder(config, prePath + "arkHot_meta.txt");
        Logger.d("config: " + config.mArkHotPatchPath + " " + config.mArkHotPatchName + prePath + "arkHot_meta.txt");
        this.resDuplicateFiles = new ArrayList();
    }

    private void unzipApkFile(File file, File destFile) throws TinkerPatchException, IOException {
        String apkName = file.getName();
        if (!apkName.endsWith(".apk")) {
            throw new TinkerPatchException(String.format("input apk file path must end with .apk, yours %s\n", apkName));
        }
        String destPath = destFile.getAbsolutePath();
        Logger.d("UnZipping apk to %s", destPath);
        FileOperation.unZipAPk(file.getAbsoluteFile().getAbsolutePath(), destPath);
    }

    private void unzipApkFiles(File oldFile, File newFile) throws IOException, TinkerPatchException {
        this.unzipApkFile(oldFile, this.mOldApkDir);
        this.unzipApkFile(newFile, this.mNewApkDir);
    }

    private void writeToLogFile(File oldFile, File newFile) throws IOException {
        String line1 = "old apk: " + oldFile.getName() + ", size=" + FileOperation.getFileSizes(oldFile) + ", md5=" + MD5.getMD5(oldFile);
        String line2 = "new apk: " + newFile.getName() + ", size=" + FileOperation.getFileSizes(newFile) + ", md5=" + MD5.getMD5(newFile);
        Logger.d("Analyze old and new apk files1:");
        Logger.d(line1);
        Logger.d(line2);
        Logger.d("");
    }

    @Override
    public void onAllPatchesStart() throws IOException, TinkerPatchException {
        this.manifestDecoder.onAllPatchesStart();
        this.dexPatchDecoder.onAllPatchesStart();
        this.soPatchDecoder.onAllPatchesStart();
        this.resPatchDecoder.onAllPatchesStart();
    }

    @Override
    public boolean patch(File oldFile, File newFile) throws Exception {
        this.writeToLogFile(oldFile, newFile);
        this.manifestDecoder.patch(oldFile, newFile);
        this.unzipApkFiles(oldFile, newFile);
        Files.walkFileTree(this.mNewApkDir.toPath(), new ApkFilesVisitor(this.config, this.mNewApkDir.toPath(), this.mOldApkDir.toPath(), this.dexPatchDecoder, this.soPatchDecoder, this.resPatchDecoder));
        for (File duplicateRes : this.resDuplicateFiles) {
            Logger.e("Warning: res file %s is also match at dex or library pattern, we treat it as unchanged in the new resource_out.zip", this.getRelativePathStringToOldFile(duplicateRes));
        }
        this.soPatchDecoder.onAllPatchesEnd();
        this.dexPatchDecoder.onAllPatchesEnd();
        this.manifestDecoder.onAllPatchesEnd();
        this.resPatchDecoder.onAllPatchesEnd();
        this.arkHotDecoder.onAllPatchesEnd();
        this.dexPatchDecoder.clean();
        this.soPatchDecoder.clean();
        this.resPatchDecoder.clean();
        this.arkHotDecoder.clean();
        return true;
    }

    @Override
    public void onAllPatchesEnd() throws IOException, TinkerPatchException {
    }

    class ApkFilesVisitor
    extends SimpleFileVisitor<Path> {
        BaseDecoder dexDecoder;
        BaseDecoder soDecoder;
        BaseDecoder resDecoder;
        Configuration config;
        Path newApkPath;
        Path oldApkPath;

        ApkFilesVisitor(Configuration config, Path newPath, Path oldPath, BaseDecoder dex, BaseDecoder so, BaseDecoder resDecoder) {
            this.config = config;
            this.dexDecoder = dex;
            this.soDecoder = so;
            this.resDecoder = resDecoder;
            this.newApkPath = newPath;
            this.oldApkPath = oldPath;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String patternKey;
            Path relativePath = this.newApkPath.relativize(file);
            Path oldPath = this.oldApkPath.resolve(relativePath);
            File oldFile = null;
            if (oldPath.toFile().exists()) {
                oldFile = oldPath.toFile();
            }
            if (Utils.checkFileInPattern(this.config.mDexFilePattern, patternKey = relativePath.toString().replace("\\", "/"))) {
                if (Utils.checkFileInPattern(this.config.mResFilePattern, patternKey) && oldFile != null) {
                    ApkDecoder.this.resDuplicateFiles.add(oldFile);
                }
                try {
                    this.dexDecoder.patch(oldFile, file.toFile());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return FileVisitResult.CONTINUE;
            }
            if (Utils.checkFileInPattern(this.config.mSoFilePattern, patternKey)) {
                File oldSoPathWithNewAbi;
                String newAbi;
                if (Utils.checkFileInPattern(this.config.mResFilePattern, patternKey) && oldFile != null) {
                    ApkDecoder.this.resDuplicateFiles.add(oldFile);
                }
                if (file.toFile().exists() && (newAbi = this.getAbiFromPath(file.toFile().getAbsolutePath())) != null && !(oldSoPathWithNewAbi = new File(this.oldApkPath.toFile(), "lib/" + newAbi)).exists()) {
                    throw new UnsupportedOperationException("Tinker does not support to add new ABI: " + newAbi + ", related new so: " + file.toFile().getAbsolutePath());
                }
                try {
                    this.soDecoder.patch(oldFile, file.toFile());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return FileVisitResult.CONTINUE;
            }
            if (Utils.checkFileInPattern(this.config.mResFilePattern, patternKey)) {
                try {
                    this.resDecoder.patch(oldFile, file.toFile());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.CONTINUE;
        }

        private String getAbiFromPath(String path) {
            int prefixPos = (path = path.replaceAll(Matcher.quoteReplacement(File.separator), "/")).indexOf("/lib/");
            if (prefixPos < 0) {
                return null;
            }
            int suffixPos = path.indexOf("/", prefixPos + 5);
            if (suffixPos < 0) {
                return null;
            }
            return path.substring(prefixPos + 5, suffixPos);
        }
    }
}

