/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.info.InfoWriter;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.FileOperation;
import com.tencent.tinker.build.util.MD5;
import com.tencent.tinker.build.util.TinkerPatchException;
import java.io.File;
import java.io.IOException;

public class ArkHotDecoder
extends BaseDecoder {
    private static final String ARKHOT_PATCH_NAME = "patch.apk";
    private static final String ARKHOT_PATCH_PATH = "arkHot";
    private final InfoWriter metaWriter;

    public ArkHotDecoder(Configuration config, String metaPath) throws IOException {
        super(config);
        this.metaWriter = metaPath != null ? new InfoWriter(config, config.mTempResultDir + File.separator + metaPath) : null;
    }

    @Override
    public void clean() {
        this.metaWriter.close();
    }

    @Override
    public void onAllPatchesStart() {
    }

    @Override
    public void onAllPatchesEnd() throws IOException, TinkerPatchException {
        File patchFile = new File(this.config.mArkHotPatchPath + "/" + this.config.mArkHotPatchName);
        if (!patchFile.exists()) {
            return;
        }
        String md5 = MD5.getMD5(patchFile);
        File dest = new File(this.config.mTempResultDir + "/" + ARKHOT_PATCH_PATH + "/" + ARKHOT_PATCH_NAME);
        FileOperation.copyFileUsingStream(patchFile, dest);
        this.writeMetaFile(md5);
    }

    @Override
    public boolean patch(File oldFile, File newFile) {
        return true;
    }

    private void writeMetaFile(String md5) {
        if (this.metaWriter == null) {
            return;
        }
        if (this.metaWriter != null) {
            String path = ARKHOT_PATCH_PATH;
            String fileName = ARKHOT_PATCH_NAME;
            if (md5 == null) {
                return;
            }
            String meta = fileName + "," + path + "," + md5;
            this.metaWriter.writeLineToInfoFile(meta);
        }
    }
}

