/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.dexpatcher;

import com.tencent.tinker.android.dex.Annotation;
import com.tencent.tinker.android.dex.AnnotationSet;
import com.tencent.tinker.android.dex.AnnotationSetRefList;
import com.tencent.tinker.android.dex.AnnotationsDirectory;
import com.tencent.tinker.android.dex.CallSiteId;
import com.tencent.tinker.android.dex.ClassData;
import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Code;
import com.tencent.tinker.android.dex.DebugInfoItem;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.EncodedValue;
import com.tencent.tinker.android.dex.FieldId;
import com.tencent.tinker.android.dex.MethodHandle;
import com.tencent.tinker.android.dex.MethodId;
import com.tencent.tinker.android.dex.ProtoId;
import com.tencent.tinker.android.dex.SizeOf;
import com.tencent.tinker.android.dex.StringData;
import com.tencent.tinker.android.dex.TypeList;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.AnnotationSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.AnnotationSetRefListSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.AnnotationSetSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.AnnotationsDirectorySectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.CallSiteIdSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.ClassDataSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.ClassDefSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.CodeSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.DebugInfoItemSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.DexSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.FieldIdSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.MethodHandleSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.MethodIdSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.ProtoIdSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.StaticValueSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.StringDataSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.TypeIdSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.TypeListSectionDiffAlgorithm;
import com.tencent.tinker.build.dexpatcher.util.PatternUtils;
import com.tencent.tinker.commons.dexpatcher.DexPatcherLogger;
import com.tencent.tinker.commons.dexpatcher.struct.DexPatchFile;
import com.tencent.tinker.commons.dexpatcher.struct.PatchOperation;
import com.tencent.tinker.commons.dexpatcher.util.SparseIndexMap;
import com.tencent.tinker.commons.util.IOHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class DexPatchGenerator {
    private static final String TAG = "DexPatchGenerator";
    private final Dex oldDex;
    private final Dex newDex;
    private final DexPatcherLogger logger = new DexPatcherLogger();
    private DexSectionDiffAlgorithm<StringData> stringDataSectionDiffAlg;
    private DexSectionDiffAlgorithm<Integer> typeIdSectionDiffAlg;
    private DexSectionDiffAlgorithm<ProtoId> protoIdSectionDiffAlg;
    private DexSectionDiffAlgorithm<FieldId> fieldIdSectionDiffAlg;
    private DexSectionDiffAlgorithm<MethodId> methodIdSectionDiffAlg;
    private DexSectionDiffAlgorithm<CallSiteId> callsiteIdSectionDiffAlg;
    private DexSectionDiffAlgorithm<MethodHandle> methodHandleSectionDiffAlg;
    private DexSectionDiffAlgorithm<ClassDef> classDefSectionDiffAlg;
    private DexSectionDiffAlgorithm<TypeList> typeListSectionDiffAlg;
    private DexSectionDiffAlgorithm<AnnotationSetRefList> annotationSetRefListSectionDiffAlg;
    private DexSectionDiffAlgorithm<AnnotationSet> annotationSetSectionDiffAlg;
    private DexSectionDiffAlgorithm<ClassData> classDataSectionDiffAlg;
    private DexSectionDiffAlgorithm<Code> codeSectionDiffAlg;
    private DexSectionDiffAlgorithm<DebugInfoItem> debugInfoSectionDiffAlg;
    private DexSectionDiffAlgorithm<Annotation> annotationSectionDiffAlg;
    private DexSectionDiffAlgorithm<EncodedValue> encodedArraySectionDiffAlg;
    private DexSectionDiffAlgorithm<AnnotationsDirectory> annotationsDirectorySectionDiffAlg;
    private Set<String> additionalRemovingClassPatternSet;
    private int patchedHeaderOffset = 0;
    private int patchedStringIdsOffset = 0;
    private int patchedTypeIdsOffset = 0;
    private int patchedProtoIdsOffset = 0;
    private int patchedFieldIdsOffset = 0;
    private int patchedMethodIdsOffset = 0;
    private int patchedCallSiteIdsOffset = 0;
    private int patchedMethodHandlesOffset = 0;
    private int patchedClassDefsOffset = 0;
    private int patchedTypeListsOffset = 0;
    private int patchedAnnotationItemsOffset = 0;
    private int patchedAnnotationSetItemsOffset = 0;
    private int patchedAnnotationSetRefListItemsOffset = 0;
    private int patchedAnnotationsDirectoryItemsOffset = 0;
    private int patchedDebugInfoItemsOffset = 0;
    private int patchedCodeItemsOffset = 0;
    private int patchedClassDataItemsOffset = 0;
    private int patchedStringDataItemsOffset = 0;
    private int patchedEncodedArrayItemsOffset = 0;
    private int patchedMapListOffset = 0;
    private int patchedDexSize = 0;

    public DexPatchGenerator(File oldDexFile, File newDexFile) throws IOException {
        this(new Dex(oldDexFile), new Dex(newDexFile));
    }

    public DexPatchGenerator(File oldDexFile, InputStream newDexStream) throws IOException {
        this(new Dex(oldDexFile), new Dex(newDexStream));
    }

    public DexPatchGenerator(InputStream oldDexStream, InputStream newDexStream) throws IOException {
        this(new Dex(oldDexStream), new Dex(newDexStream));
    }

    public DexPatchGenerator(Dex oldDex, Dex newDex) {
        this.oldDex = oldDex;
        this.newDex = newDex;
        SparseIndexMap oldToNewIndexMap = new SparseIndexMap();
        SparseIndexMap oldToPatchedIndexMap = new SparseIndexMap();
        SparseIndexMap newToPatchedIndexMap = new SparseIndexMap();
        SparseIndexMap selfIndexMapForSkip = new SparseIndexMap();
        this.additionalRemovingClassPatternSet = new HashSet<String>();
        this.stringDataSectionDiffAlg = new StringDataSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.typeIdSectionDiffAlg = new TypeIdSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.protoIdSectionDiffAlg = new ProtoIdSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.fieldIdSectionDiffAlg = new FieldIdSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.methodIdSectionDiffAlg = new MethodIdSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.callsiteIdSectionDiffAlg = new CallSiteIdSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.methodHandleSectionDiffAlg = new MethodHandleSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.classDefSectionDiffAlg = new ClassDefSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.typeListSectionDiffAlg = new TypeListSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.annotationSetRefListSectionDiffAlg = new AnnotationSetRefListSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.annotationSetSectionDiffAlg = new AnnotationSetSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.classDataSectionDiffAlg = new ClassDataSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.codeSectionDiffAlg = new CodeSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.debugInfoSectionDiffAlg = new DebugInfoItemSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.annotationSectionDiffAlg = new AnnotationSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.encodedArraySectionDiffAlg = new StaticValueSectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
        this.annotationsDirectorySectionDiffAlg = new AnnotationsDirectorySectionDiffAlgorithm(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
    }

    public void addAdditionalRemovingClassPattern(String pattern) {
        this.additionalRemovingClassPatternSet.add(PatternUtils.dotClassNamePatternToDescriptorRegEx(pattern));
    }

    public void setAdditionalRemovingClassPatterns(Collection<String> patterns) {
        for (String pattern : patterns) {
            this.additionalRemovingClassPatternSet.add(PatternUtils.dotClassNamePatternToDescriptorRegEx(pattern));
        }
    }

    public void clearAdditionalRemovingClassPatterns() {
        this.additionalRemovingClassPatternSet.clear();
    }

    public void setLogger(DexPatcherLogger.IDexPatcherLogger logger) {
        this.logger.setLoggerImpl(logger);
    }

    public void executeAndSaveTo(File file) throws IOException {
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            this.executeAndSaveTo(os);
        }
        catch (Throwable throwable) {
            IOHelper.closeQuietly(os);
            throw throwable;
        }
        IOHelper.closeQuietly((Object)os);
    }

    public void executeAndSaveTo(OutputStream out) throws IOException {
        Pattern[] classNamePatterns = new Pattern[this.additionalRemovingClassPatternSet.size()];
        int classNamePatternCount = 0;
        for (String regExStr : this.additionalRemovingClassPatternSet) {
            classNamePatterns[classNamePatternCount++] = Pattern.compile(regExStr);
        }
        ArrayList<Integer> typeIdOfClassDefsToRemove = new ArrayList<Integer>(classNamePatternCount);
        ArrayList<Integer> offsetOfClassDatasToRemove = new ArrayList<Integer>(classNamePatternCount);
        block1: for (ClassDef classDef : this.newDex.classDefs()) {
            String typeName = (String)this.newDex.typeNames().get(classDef.typeIndex);
            for (Pattern pattern : classNamePatterns) {
                if (!pattern.matcher(typeName).matches()) continue;
                typeIdOfClassDefsToRemove.add(classDef.typeIndex);
                offsetOfClassDatasToRemove.add(classDef.classDataOffset);
                continue block1;
            }
        }
        ((ClassDefSectionDiffAlgorithm)this.classDefSectionDiffAlg).setTypeIdOfClassDefsToRemove(typeIdOfClassDefsToRemove);
        ((ClassDataSectionDiffAlgorithm)this.classDataSectionDiffAlg).setOffsetOfClassDatasToRemove(offsetOfClassDatasToRemove);
        int patchedheaderSize = 112;
        int patchedStringIdsSize = this.newDex.getTableOfContents().stringIds.size * 4;
        int patchedTypeIdsSize = this.newDex.getTableOfContents().typeIds.size * 4;
        int patchedProtoIdsSize = this.newDex.getTableOfContents().protoIds.size * 12;
        int patchedFieldIdsSize = this.newDex.getTableOfContents().fieldIds.size * 8;
        int patchedMethodIdsSize = this.newDex.getTableOfContents().methodIds.size * 8;
        int patchedCallSiteIdsSize = this.newDex.getTableOfContents().callSiteIds.size * 4;
        int patchedMethodHandlesSize = this.newDex.getTableOfContents().callSiteIds.size * 8;
        int patchedClassDefsSize = this.newDex.getTableOfContents().classDefs.size * 32;
        int patchedIdSectionSize = patchedStringIdsSize + patchedTypeIdsSize + patchedProtoIdsSize + patchedFieldIdsSize + patchedMethodIdsSize + patchedCallSiteIdsSize + patchedMethodHandlesSize + patchedClassDefsSize;
        this.patchedHeaderOffset = 0;
        this.patchedStringIdsOffset = this.patchedHeaderOffset + patchedheaderSize;
        if (this.oldDex.getTableOfContents().stringIds.isElementFourByteAligned) {
            this.patchedStringIdsOffset = SizeOf.roundToTimesOfFour((int)this.patchedStringIdsOffset);
        }
        this.stringDataSectionDiffAlg.execute();
        this.patchedStringDataItemsOffset = patchedheaderSize + patchedIdSectionSize;
        if (this.oldDex.getTableOfContents().stringDatas.isElementFourByteAligned) {
            this.patchedStringDataItemsOffset = SizeOf.roundToTimesOfFour((int)this.patchedStringDataItemsOffset);
        }
        this.stringDataSectionDiffAlg.simulatePatchOperation(this.patchedStringDataItemsOffset);
        this.typeIdSectionDiffAlg.execute();
        this.patchedTypeIdsOffset = this.patchedStringIdsOffset + patchedStringIdsSize;
        if (this.oldDex.getTableOfContents().typeIds.isElementFourByteAligned) {
            this.patchedTypeIdsOffset = SizeOf.roundToTimesOfFour((int)this.patchedTypeIdsOffset);
        }
        this.typeIdSectionDiffAlg.simulatePatchOperation(this.patchedTypeIdsOffset);
        this.typeListSectionDiffAlg.execute();
        this.patchedTypeListsOffset = patchedheaderSize + patchedIdSectionSize + this.stringDataSectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().typeLists.isElementFourByteAligned) {
            this.patchedTypeListsOffset = SizeOf.roundToTimesOfFour((int)this.patchedTypeListsOffset);
        }
        this.typeListSectionDiffAlg.simulatePatchOperation(this.patchedTypeListsOffset);
        this.protoIdSectionDiffAlg.execute();
        this.patchedProtoIdsOffset = this.patchedTypeIdsOffset + patchedTypeIdsSize;
        if (this.oldDex.getTableOfContents().protoIds.isElementFourByteAligned) {
            this.patchedProtoIdsOffset = SizeOf.roundToTimesOfFour((int)this.patchedProtoIdsOffset);
        }
        this.protoIdSectionDiffAlg.simulatePatchOperation(this.patchedProtoIdsOffset);
        this.fieldIdSectionDiffAlg.execute();
        this.patchedFieldIdsOffset = this.patchedProtoIdsOffset + patchedProtoIdsSize;
        if (this.oldDex.getTableOfContents().fieldIds.isElementFourByteAligned) {
            this.patchedFieldIdsOffset = SizeOf.roundToTimesOfFour((int)this.patchedFieldIdsOffset);
        }
        this.fieldIdSectionDiffAlg.simulatePatchOperation(this.patchedFieldIdsOffset);
        this.methodIdSectionDiffAlg.execute();
        this.patchedMethodIdsOffset = this.patchedFieldIdsOffset + patchedFieldIdsSize;
        if (this.oldDex.getTableOfContents().methodIds.isElementFourByteAligned) {
            this.patchedMethodIdsOffset = SizeOf.roundToTimesOfFour((int)this.patchedMethodIdsOffset);
        }
        this.methodIdSectionDiffAlg.simulatePatchOperation(this.patchedMethodIdsOffset);
        this.methodHandleSectionDiffAlg.execute();
        this.patchedMethodHandlesOffset = this.patchedMethodIdsOffset + patchedMethodIdsSize;
        if (this.oldDex.getTableOfContents().methodHandles.isElementFourByteAligned) {
            this.patchedMethodHandlesOffset = SizeOf.roundToTimesOfFour((int)this.patchedMethodHandlesOffset);
        }
        this.methodHandleSectionDiffAlg.simulatePatchOperation(this.patchedMethodHandlesOffset);
        this.annotationSectionDiffAlg.execute();
        this.patchedAnnotationItemsOffset = this.patchedTypeListsOffset + this.typeListSectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().annotations.isElementFourByteAligned) {
            this.patchedAnnotationItemsOffset = SizeOf.roundToTimesOfFour((int)this.patchedAnnotationItemsOffset);
        }
        this.annotationSectionDiffAlg.simulatePatchOperation(this.patchedAnnotationItemsOffset);
        this.annotationSetSectionDiffAlg.execute();
        this.patchedAnnotationSetItemsOffset = this.patchedAnnotationItemsOffset + this.annotationSectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().annotationSets.isElementFourByteAligned) {
            this.patchedAnnotationSetItemsOffset = SizeOf.roundToTimesOfFour((int)this.patchedAnnotationSetItemsOffset);
        }
        this.annotationSetSectionDiffAlg.simulatePatchOperation(this.patchedAnnotationSetItemsOffset);
        this.annotationSetRefListSectionDiffAlg.execute();
        this.patchedAnnotationSetRefListItemsOffset = this.patchedAnnotationSetItemsOffset + this.annotationSetSectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().annotationSetRefLists.isElementFourByteAligned) {
            this.patchedAnnotationSetRefListItemsOffset = SizeOf.roundToTimesOfFour((int)this.patchedAnnotationSetRefListItemsOffset);
        }
        this.annotationSetRefListSectionDiffAlg.simulatePatchOperation(this.patchedAnnotationSetRefListItemsOffset);
        this.annotationsDirectorySectionDiffAlg.execute();
        this.patchedAnnotationsDirectoryItemsOffset = this.patchedAnnotationSetRefListItemsOffset + this.annotationSetRefListSectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().annotationsDirectories.isElementFourByteAligned) {
            this.patchedAnnotationsDirectoryItemsOffset = SizeOf.roundToTimesOfFour((int)this.patchedAnnotationsDirectoryItemsOffset);
        }
        this.annotationsDirectorySectionDiffAlg.simulatePatchOperation(this.patchedAnnotationsDirectoryItemsOffset);
        this.debugInfoSectionDiffAlg.execute();
        this.patchedDebugInfoItemsOffset = this.patchedAnnotationsDirectoryItemsOffset + this.annotationsDirectorySectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().debugInfos.isElementFourByteAligned) {
            this.patchedDebugInfoItemsOffset = SizeOf.roundToTimesOfFour((int)this.patchedDebugInfoItemsOffset);
        }
        this.debugInfoSectionDiffAlg.simulatePatchOperation(this.patchedDebugInfoItemsOffset);
        this.codeSectionDiffAlg.execute();
        this.patchedCodeItemsOffset = this.patchedDebugInfoItemsOffset + this.debugInfoSectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().codes.isElementFourByteAligned) {
            this.patchedCodeItemsOffset = SizeOf.roundToTimesOfFour((int)this.patchedCodeItemsOffset);
        }
        this.codeSectionDiffAlg.simulatePatchOperation(this.patchedCodeItemsOffset);
        this.classDataSectionDiffAlg.execute();
        this.patchedClassDataItemsOffset = this.patchedCodeItemsOffset + this.codeSectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().classDatas.isElementFourByteAligned) {
            this.patchedClassDataItemsOffset = SizeOf.roundToTimesOfFour((int)this.patchedClassDataItemsOffset);
        }
        this.classDataSectionDiffAlg.simulatePatchOperation(this.patchedClassDataItemsOffset);
        this.encodedArraySectionDiffAlg.execute();
        this.patchedEncodedArrayItemsOffset = this.patchedClassDataItemsOffset + this.classDataSectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().encodedArrays.isElementFourByteAligned) {
            this.patchedEncodedArrayItemsOffset = SizeOf.roundToTimesOfFour((int)this.patchedEncodedArrayItemsOffset);
        }
        this.encodedArraySectionDiffAlg.simulatePatchOperation(this.patchedEncodedArrayItemsOffset);
        this.callsiteIdSectionDiffAlg.execute();
        this.patchedCallSiteIdsOffset = this.patchedEncodedArrayItemsOffset + this.encodedArraySectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().callSiteIds.isElementFourByteAligned) {
            this.patchedCallSiteIdsOffset = SizeOf.roundToTimesOfFour((int)this.patchedCallSiteIdsOffset);
        }
        this.callsiteIdSectionDiffAlg.simulatePatchOperation(this.patchedCallSiteIdsOffset);
        this.classDefSectionDiffAlg.execute();
        this.patchedClassDefsOffset = this.patchedMethodHandlesOffset + patchedMethodHandlesSize;
        if (this.oldDex.getTableOfContents().classDefs.isElementFourByteAligned) {
            this.patchedClassDefsOffset = SizeOf.roundToTimesOfFour((int)this.patchedClassDefsOffset);
        }
        this.patchedMapListOffset = this.patchedEncodedArrayItemsOffset + this.encodedArraySectionDiffAlg.getPatchedSectionSize();
        if (this.oldDex.getTableOfContents().mapList.isElementFourByteAligned) {
            this.patchedMapListOffset = SizeOf.roundToTimesOfFour((int)this.patchedMapListOffset);
        }
        int patchedMapListSize = this.newDex.getTableOfContents().mapList.byteCount;
        this.patchedDexSize = this.patchedMapListOffset + patchedMapListSize;
        this.writeResultToStream(out);
    }

    private void writeResultToStream(OutputStream os) throws IOException {
        DexDataBuffer buffer = new DexDataBuffer();
        buffer.write(DexPatchFile.MAGIC);
        buffer.writeShort((short)3);
        buffer.writeInt(this.oldDex.getTableOfContents().api);
        buffer.writeInt(this.newDex.getTableOfContents().api);
        buffer.writeInt(this.patchedDexSize);
        int posOfFirstChunkOffsetField = buffer.position();
        buffer.writeInt(0);
        buffer.writeInt(this.patchedStringIdsOffset);
        buffer.writeInt(this.patchedTypeIdsOffset);
        buffer.writeInt(this.patchedProtoIdsOffset);
        buffer.writeInt(this.patchedFieldIdsOffset);
        buffer.writeInt(this.patchedMethodIdsOffset);
        buffer.writeInt(this.patchedCallSiteIdsOffset);
        buffer.writeInt(this.patchedMethodHandlesOffset);
        buffer.writeInt(this.patchedClassDefsOffset);
        buffer.writeInt(this.patchedMapListOffset);
        buffer.writeInt(this.patchedTypeListsOffset);
        buffer.writeInt(this.patchedAnnotationSetRefListItemsOffset);
        buffer.writeInt(this.patchedAnnotationSetItemsOffset);
        buffer.writeInt(this.patchedClassDataItemsOffset);
        buffer.writeInt(this.patchedCodeItemsOffset);
        buffer.writeInt(this.patchedStringDataItemsOffset);
        buffer.writeInt(this.patchedDebugInfoItemsOffset);
        buffer.writeInt(this.patchedAnnotationItemsOffset);
        buffer.writeInt(this.patchedEncodedArrayItemsOffset);
        buffer.writeInt(this.patchedAnnotationsDirectoryItemsOffset);
        buffer.write(this.oldDex.computeSignature(false));
        int firstChunkOffset = buffer.position();
        buffer.position(posOfFirstChunkOffsetField);
        buffer.writeInt(firstChunkOffset);
        buffer.position(firstChunkOffset);
        this.writePatchOperations(buffer, this.stringDataSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.typeIdSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.typeListSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.protoIdSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.fieldIdSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.methodIdSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.methodHandleSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.annotationSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.annotationSetSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.annotationSetRefListSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.annotationsDirectorySectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.debugInfoSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.codeSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.classDataSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.encodedArraySectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.callsiteIdSectionDiffAlg.getPatchOperationList());
        this.writePatchOperations(buffer, this.classDefSectionDiffAlg.getPatchOperationList());
        byte[] bufferData = buffer.array();
        os.write(bufferData);
        os.flush();
    }

    private <T extends Comparable<T>> void writePatchOperations(DexDataBuffer buffer, List<PatchOperation<T>> patchOperationList) {
        ArrayList<Integer> delOpIndexList = new ArrayList<Integer>(patchOperationList.size());
        ArrayList<Integer> addOpIndexList = new ArrayList<Integer>(patchOperationList.size());
        ArrayList<Integer> replaceOpIndexList = new ArrayList<Integer>(patchOperationList.size());
        ArrayList<Comparable> newItemList = new ArrayList<Comparable>(patchOperationList.size());
        for (PatchOperation<T> patchOperation : patchOperationList) {
            switch (patchOperation.op) {
                case 0: {
                    delOpIndexList.add(patchOperation.index);
                    break;
                }
                case 1: {
                    addOpIndexList.add(patchOperation.index);
                    newItemList.add((Comparable)patchOperation.newItem);
                    break;
                }
                case 2: {
                    replaceOpIndexList.add(patchOperation.index);
                    newItemList.add((Comparable)patchOperation.newItem);
                    break;
                }
            }
        }
        buffer.writeUleb128(delOpIndexList.size());
        int lastIndex = 0;
        for (Integer index : delOpIndexList) {
            buffer.writeSleb128(index - lastIndex);
            lastIndex = index;
        }
        buffer.writeUleb128(addOpIndexList.size());
        lastIndex = 0;
        for (Integer index : addOpIndexList) {
            buffer.writeSleb128(index - lastIndex);
            lastIndex = index;
        }
        buffer.writeUleb128(replaceOpIndexList.size());
        lastIndex = 0;
        for (Integer index : replaceOpIndexList) {
            buffer.writeSleb128(index - lastIndex);
            lastIndex = index;
        }
        for (Comparable newItem : newItemList) {
            if (newItem instanceof StringData) {
                buffer.writeStringData((StringData)newItem);
                continue;
            }
            if (newItem instanceof Integer) {
                buffer.writeInt(((Integer)newItem).intValue());
                continue;
            }
            if (newItem instanceof TypeList) {
                buffer.writeTypeList((TypeList)newItem);
                continue;
            }
            if (newItem instanceof ProtoId) {
                buffer.writeProtoId((ProtoId)newItem);
                continue;
            }
            if (newItem instanceof FieldId) {
                buffer.writeFieldId((FieldId)newItem);
                continue;
            }
            if (newItem instanceof MethodId) {
                buffer.writeMethodId((MethodId)newItem);
                continue;
            }
            if (newItem instanceof CallSiteId) {
                buffer.writeCallSiteId((CallSiteId)newItem);
                continue;
            }
            if (newItem instanceof MethodHandle) {
                buffer.writeMethodHandle((MethodHandle)newItem);
                continue;
            }
            if (newItem instanceof Annotation) {
                buffer.writeAnnotation((Annotation)newItem);
                continue;
            }
            if (newItem instanceof AnnotationSet) {
                buffer.writeAnnotationSet((AnnotationSet)newItem);
                continue;
            }
            if (newItem instanceof AnnotationSetRefList) {
                buffer.writeAnnotationSetRefList((AnnotationSetRefList)newItem);
                continue;
            }
            if (newItem instanceof AnnotationsDirectory) {
                buffer.writeAnnotationsDirectory((AnnotationsDirectory)newItem);
                continue;
            }
            if (newItem instanceof DebugInfoItem) {
                buffer.writeDebugInfoItem((DebugInfoItem)newItem);
                continue;
            }
            if (newItem instanceof Code) {
                buffer.writeCode((Code)newItem);
                continue;
            }
            if (newItem instanceof ClassData) {
                buffer.writeClassData((ClassData)newItem);
                continue;
            }
            if (newItem instanceof EncodedValue) {
                buffer.writeEncodedArray((EncodedValue)newItem);
                continue;
            }
            if (newItem instanceof ClassDef) {
                buffer.writeClassDef((ClassDef)newItem);
                continue;
            }
            throw new IllegalStateException("Unknown item type: " + newItem.getClass());
        }
    }
}

